/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.Options;
import org.asciidoctor.extension.JavaExtensionRegistry;
import org.owasp.webgoat.container.asciidoc.OperatingSystemMacro;
import org.owasp.webgoat.container.asciidoc.UsernameMacro;
import org.owasp.webgoat.container.asciidoc.WebGoatTmpDirMacro;
import org.owasp.webgoat.container.asciidoc.WebGoatVersionMacro;
import org.owasp.webgoat.container.asciidoc.WebWolfMacro;
import org.owasp.webgoat.container.asciidoc.WebWolfRootMacro;
import org.owasp.webgoat.container.i18n.Language;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.templateresource.StringTemplateResource;

public class AsciiDoctorTemplateResolver
extends FileTemplateResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsciiDoctorTemplateResolver.class);
    private static final Asciidoctor asciidoctor = Asciidoctor.Factory.create();
    private static final String PREFIX = "doc:";
    private final Language language;
    private final ResourceLoader resourceLoader;

    public AsciiDoctorTemplateResolver(Language language, ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.language = language;
        this.setResolvablePatterns(Set.of("doc:*"));
    }

    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, String resourceName, String characterEncoding, Map<String, Object> templateResolutionAttributes) {
        StringTemplateResource stringTemplateResource;
        block8: {
            String templateName = resourceName.substring(PREFIX.length());
            log.debug("template used: {}", (Object)templateName);
            InputStream is = this.getInputStream(templateName);
            try {
                JavaExtensionRegistry extensionRegistry = asciidoctor.javaExtensionRegistry();
                extensionRegistry.inlineMacro("webWolfLink", WebWolfMacro.class);
                extensionRegistry.inlineMacro("webWolfRootLink", WebWolfRootMacro.class);
                extensionRegistry.inlineMacro("webGoatVersion", WebGoatVersionMacro.class);
                extensionRegistry.inlineMacro("webGoatTempDir", WebGoatTmpDirMacro.class);
                extensionRegistry.inlineMacro("operatingSystem", OperatingSystemMacro.class);
                extensionRegistry.inlineMacro("username", UsernameMacro.class);
                StringWriter writer = new StringWriter();
                asciidoctor.convert((Reader)new InputStreamReader(is), (Writer)writer, this.createAttributes());
                stringTemplateResource = new StringTemplateResource(writer.getBuffer().toString());
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new StringTemplateResource("<div>Unable to find documentation for: " + templateName + " </div>");
                }
            }
            is.close();
        }
        return stringTemplateResource;
    }

    private InputStream getInputStream(String templateName) throws IOException {
        log.debug("locale: {}", (Object)this.language.getLocale().getLanguage());
        String computedResourceName = this.computeResourceName(templateName, this.language.getLocale().getLanguage());
        if (this.resourceLoader.getResource("classpath:/" + computedResourceName).isReadable()) {
            log.debug("localized file exists");
            return this.resourceLoader.getResource("classpath:/" + computedResourceName).getInputStream();
        }
        log.debug("using english template");
        return this.resourceLoader.getResource("classpath:/" + templateName).getInputStream();
    }

    private String computeResourceName(String resourceName, String language) {
        String computedResourceName = language.equals("en") ? resourceName : resourceName.replace(".adoc", "_".concat(language).concat(".adoc"));
        log.debug("computed local file name: {}", (Object)computedResourceName);
        log.debug("file exists: {}", (Object)this.resourceLoader.getResource("classpath:/" + computedResourceName).isReadable());
        return computedResourceName;
    }

    private Options createAttributes() {
        return Options.builder().attributes(Attributes.builder().attribute("source-highlighter", (Object)"coderay").attribute("backend", (Object)"xhtml").attribute("lang", (Object)this.determineLanguage()).attribute("icons", (Object)"font").build()).build();
    }

    private String determineLanguage() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        Locale browserLocale = (Locale)request.getSession().getAttribute(SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME);
        if (null != browserLocale) {
            log.debug("browser locale {}", (Object)browserLocale);
            return browserLocale.getLanguage();
        }
        String langHeader = request.getHeader("Accept-Language");
        if (null != langHeader) {
            log.debug("browser locale {}", (Object)langHeader);
            return langHeader.substring(0, 2);
        }
        log.debug("browser default english");
        return "en";
    }
}

