/********************************************************************
    Copyright (c) 2013-2015 - Mogara

    This file is part of QSanguosha-Hegemony.

    This game is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 3.0
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    See the LICENSE file for more details.

    Mogara
    *********************************************************************/

#ifndef TITLE_H
#define TITLE_H

#include <QGraphicsObject>

class Title : public QGraphicsObject
{
    Q_OBJECT

public:
    explicit Title(QGraphicsObject *parent, const QString &text, const QString &font_name, const int &font_size);
    virtual QRectF boundingRect() const;
    void setText(const QString &text)
    {
        this->text = text;
    }

protected:
    virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);

private:

    QString text;
    QString font_name;
    int font_size;
};

#endif // TITLE_H
