#include "jiange-defense-scenario.h"
#include "skill.h"
#include "engine.h"
#include "room.h"
#include "banpair.h"

class JiangeDefenseScenarioRule : public ScenarioRule
{
public:
    JiangeDefenseScenarioRule(Scenario *scenario)
        : ScenarioRule(scenario)
    {
        events << GameStart;
    }

    virtual bool effect(TriggerEvent, Room *room, ServerPlayer *player, QVariant &, ServerPlayer *) const
    {
        if (player == NULL)
            foreach(ServerPlayer *p, room->getPlayers())
            if (p->getActualGeneral1Name().startsWith("jg_"))
                p->showGeneral(true, true, false);
        return false;
    }
};

JiangeDefenseScenario::JiangeDefenseScenario()
    : Scenario("jiange_defense")
{
    rule = new JiangeDefenseScenarioRule(this);
}

void JiangeDefenseScenario::assign(QStringList &generals, QStringList &generals2, QStringList &kingdoms, Room *room) const
{
    QMap<QString, QStringList> roles;
    QStringList wei_roles, shu_roles;
    wei_roles << "ghost" << "machine" << "human" << "human";
    shu_roles << "ghost" << "machine" << "human" << "human";
    roles.insert("wei", wei_roles);
    roles.insert("shu", shu_roles);
    qShuffle(kingdoms);
    QStringList wei_generals, shu_generals;
    foreach (const QString &general, Sanguosha->getLimitedGeneralNames()) {
        if (general.startsWith("lord_")) continue;
        if  (BanPair::isBanned(general)) continue;
        QString kingdom = Sanguosha->getGeneral(general)->getKingdom();
        if (kingdom == "wei")
            wei_generals << general;
        else if (kingdom == "shu")
            shu_generals << general;
    }
    qShuffle(wei_generals);
    qShuffle(shu_generals);
    Q_ASSERT(wei_generals.length() >= 10 && shu_generals.length() >= 10);
    QMap<ServerPlayer *,QString> human_map; // Rara said, human couldn't get ghost or machine as its general.
    QList<ServerPlayer *> players = room->getPlayers();
    for (int i = 0; i < 8; i++) {
        if (players[i]->getState() == "online") {
            QStringList choices;
            foreach(const QString &kingdom, roles.keys())
                if (roles[kingdom].contains("human"))
                    choices << kingdom;
            QString choice = choices.at(qrand() % choices.length());
            QStringList role_list = roles[choice];
            role_list.removeOne("human");
            roles[choice] = role_list;
            if (choice == "wei") {
                //QStringList weijiangs;
                for (int j = 0; j < 5; j++)
                    //weijiangs << wei_generals.takeFirst();
                    players[i]->addToSelected(wei_generals.takeFirst());
//                QStringList answer = room->askForGeneral(players[i], weijiangs, QString(), false).split("+");
//                if (answer.size() < 2) {
//                    weijiangs.removeOne(answer.first());
//                    answer.append(weijiangs.at(qrand() % weijiangs.size()));
//                }
//                human_map.prepend();
//                human_map.insert(players[i], answer);
                human_map.insert(players[i], "wei");
            } else if (choice == "shu") {
                //QStringList shujiangs;
                for (int j = 0; j < 5; j++)
                    //shujiangs << shu_generals.takeFirst();
                    players[i]->addToSelected(shu_generals.takeFirst());
//                QStringList answer = room->askForGeneral(players[i], shujiangs, QString(), false).split("+");
//                if (answer.size() < 2) {
//                    shujiangs.removeOne(answer.first());
//                    answer.append(shujiangs.at(qrand() % shujiangs.size()));
//                }
//                answer.prepend("shu");
//                human_map.insert(players[i], answer);
                human_map.insert(players[i], "shu");
            }
        }
    }

    QList<ServerPlayer *> humans = human_map.keys();
    room->chooseGenerals(humans, true, true);

    for (int i = 0; i < 8; i++) {
        if (human_map.contains(players[i])) {
//            QStringList answer = human_map[players[i]];
//            kingdoms << answer.takeFirst();
            kingdoms << human_map[players[i]];
            generals << players[i]->getGeneralName();
            generals2 << players[i]->getGeneral2Name();
        } else {
            QStringList kingdom_choices;
            foreach(const QString &kingdom, roles.keys())
                if (!roles[kingdom].isEmpty())
                    kingdom_choices << kingdom;
            QString kingdom = kingdom_choices.at(qrand() % kingdom_choices.length());
            kingdoms << kingdom;
            QStringList role_list = roles[kingdom];
            QString role = role_list.at(qrand() % role_list.length());
            role_list.removeOne(role);
            roles[kingdom] = role_list;
            if (role == "ghost") {
                QString name = kingdom == "wei" ? getRandomWeiGhost() : getRandomShuGhost();
                generals << name;
                generals2 << name;
            } else if (role == "machine") {
                QString name = kingdom == "wei" ? getRandomWeiMachine() : getRandomShuMachine();
                generals << name;
                generals2 << name;
            } else if (role == "human") {
                int n = kingdom == "wei" ? 4 : 5;
                QStringList choices;
                for (int j = 0; j < n; j++)
                    choices << ((kingdom == "wei") ? wei_generals.takeFirst() : shu_generals.takeFirst());
                QString answer = room->askForGeneral(players[i], choices, QString(), false);
                generals << answer.split("+").first();
                generals2 << answer.split("+").last();
            }
        }
    }
}

int JiangeDefenseScenario::getPlayerCount() const
{
    return 8;
}

QString JiangeDefenseScenario::getRoles() const
{
    return "ZNNNNNNN";
}


QString JiangeDefenseScenario::getRandomWeiGhost() const
{
    QStringList ghosts;
    ghosts << "jg_xiahoudun" << "jg_zhangliao" << "jg_caozhen" << "jg_xiahou" << "jg_sima" << "jg_zhanghe";
    return ghosts.at(qrand() % ghosts.length());
}

QString JiangeDefenseScenario::getRandomWeiMachine() const
{
    QStringList machines;
    machines << "jg_bian_machine" << "jg_suanni_machine" << "jg_chiwen_machine" << "jg_yazi_machine";
    return machines.at(qrand() % machines.length());
}

QString JiangeDefenseScenario::getRandomShuGhost() const
{
    QStringList ghosts;
    ghosts << "jg_liubei" << "jg_guanyu" << "jg_zhaoyun" << "jg_zhuge" << "jg_yueying" << "jg_pangtong";
    return ghosts.at(qrand() % ghosts.length());
}

QString JiangeDefenseScenario::getRandomShuMachine() const
{
    QStringList machines;
    machines << "jg_qinglong_machine" << "jg_baihu_machine" << "jg_zhuque_machine" << "jg_xuanwu_machine";
    return machines.at(qrand() % machines.length());
}
