/********************************************************************
    Copyright (c) 2013-2015 - Mogara

    This file is part of QSanguosha-Hegemony.

    This game is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 3.0
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    See the LICENSE file for more details.

    Mogara
    *********************************************************************/

#ifndef BANLISTDIALOG_H
#define BANLISTDIALOG_H

#include "flatdialog.h"

#include <QMap>

class QListWidget;

class BanListDialog : public FlatDialog
{
    Q_OBJECT

public:
    BanListDialog(QWidget *parent, bool view = false);

private:
    QList<QListWidget *>lists;
    QListWidget *list;
    int item;
    QStringList ban_list;
    QMap<QString, QStringList> banned_items;

private slots:
    void addGeneral(const QString &name);
    void addPair(const QString &first, const QString &second);
    void doAddButton();
    void doRemoveButton();
    void save();
    void saveAll();
    void switchTo(int item);
};

#endif // BANLISTDIALOG_H
