/*
 * Decompiled with CFR 0.152.
 */
package org.fmod;

import android.media.AudioTrack;
import android.util.Log;
import java.nio.ByteBuffer;

public class FMODAudioDevice
implements Runnable {
    private Thread mThread = null;
    private AudioTrack mTrack = null;
    private boolean mRunning = false;
    private boolean mInitialised = false;
    private static int FMOD_INFO_SAMPLERATE = 0;
    private static int FMOD_INFO_DSPBUFFERLENGTH = 1;
    private static int FMOD_INFO_DSPNUMBUFFERS = 2;
    private static int FMOD_INFO_MIXERRUNNING = 3;
    private static int FMOD_INFO_CHANNELCOUNT = 4;

    public boolean isMixing() {
        return this.mInitialised;
    }

    public void start() {
        if (this.mThread != null) {
            this.stop();
        }
        this.mThread = new Thread(this);
        this.mThread.setPriority(10);
        this.mRunning = true;
        this.mThread.start();
    }

    public void stop() {
        while (this.mThread != null) {
            this.mRunning = false;
            try {
                this.mThread.join();
                this.mThread = null;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void run() {
        ByteBuffer byteBuffer = null;
        byte[] byArray = null;
        int n = 3;
        while (this.mRunning) {
            int n2;
            if (!this.mInitialised) {
                n2 = this.fmodGetInfo(FMOD_INFO_SAMPLERATE);
                int n3 = this.fmodGetInfo(FMOD_INFO_DSPBUFFERLENGTH);
                int n4 = this.fmodGetInfo(FMOD_INFO_DSPNUMBUFFERS);
                int n5 = this.fmodGetInfo(FMOD_INFO_CHANNELCOUNT);
                if (n2 > 0 && n3 > 0 && n4 > 0 && n5 > 0) {
                    int n6 = this.fetchChannelConfigFromCount(n5);
                    int n7 = AudioTrack.getMinBufferSize((int)n2, (int)n6, (int)2);
                    if (n7 < 0) {
                        Log.w((String)"fmod", (String)"FMOD: AudioDevice::run               : Couldn't query minimum buffer size, possibly unsupported sample rate or channel count");
                    } else {
                        Log.i((String)"fmod", (String)("FMOD: AudioDevice::run               : Min buffer size: " + n7 + " bytes"));
                    }
                    int n8 = n3 * n4 * n5 * 2;
                    if (n8 > n7) {
                        n7 = n8;
                    }
                    Log.i((String)"fmod", (String)("FMOD: AudioDevice::run               : Actual buffer size: " + n7 + " bytes"));
                    byteBuffer = ByteBuffer.allocateDirect(n3 * n5 * 2);
                    byArray = new byte[byteBuffer.capacity()];
                    this.mTrack = new AudioTrack(3, n2, n6, 2, n7, 1);
                    if (this.mTrack.getState() == 1) {
                        this.mTrack.play();
                        this.mInitialised = true;
                        continue;
                    }
                    this.mTrack.release();
                    this.mTrack = null;
                    if (--n == 0) {
                        Log.e((String)"fmod", (String)"FMOD: AudioDevice::run               : Couldn't initialize AudioTrack, giving up");
                        this.mRunning = false;
                        continue;
                    }
                    Log.w((String)"fmod", (String)"FMOD: AudioDevice::run               : Couldn't initialize AudioTrack, retrying...");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            n2 = this.fmodGetInfo(FMOD_INFO_MIXERRUNNING);
            if (n2 == 1) {
                this.fmodProcess(byteBuffer);
                byteBuffer.get(byArray);
                byteBuffer.position(0);
                this.mTrack.write(byArray, 0, byteBuffer.capacity());
                continue;
            }
            this.shutDown();
        }
        this.shutDown();
    }

    private void shutDown() {
        if (this.mTrack != null) {
            this.mTrack.stop();
            this.mTrack.release();
            this.mTrack = null;
        }
        this.mInitialised = false;
    }

    private int fetchChannelConfigFromCount(int n) {
        if (n == 1) {
            return 2;
        }
        if (n == 2) {
            return 3;
        }
        if (n == 6) {
            return 252;
        }
        return 0;
    }

    private native int fmodGetInfo(int var1);

    private native int fmodProcess(ByteBuffer var1);
}

