!function(root){"use strict";var block={newline:/^\n+/,code:/^( {4}[^\n]+\n*)+/,fences:noop,hr:/^ {0,3}((?:- *){3,}|(?:_ *){3,}|(?:\* *){3,})(?:\n+|$)/,heading:/^ *(#{1,6}) *([^\n]+?) *(?:#+ *)?(?:\n+|$)/,nptable:noop,blockquote:/^( {0,3}> ?(paragraph|[^\n]*)(?:\n|$))+/,list:/^( {0,3})(bull) [\s\S]+?(?:hr|def|\n{2,}(?! )(?!\1bull )\n*|\s*$)/,html:"^ {0,3}(?:<(script|pre|style)[\\s>][\\s\\S]*?(?:</\\1>[^\\n]*\\n+|$)|comment[^\\n]*(\\n+|$)|<\\?[\\s\\S]*?\\?>\\n*|<![A-Z][\\s\\S]*?>\\n*|<!\\[CDATA\\[[\\s\\S]*?\\]\\]>\\n*|</?(tag)(?: +|\\n|/?>)[\\s\\S]*?(?:\\n{2,}|$)|<(?!script|pre|style)([a-z][\\w-]*)(?:attribute)*? */?>(?=\\h*\\n)[\\s\\S]*?(?:\\n{2,}|$)|</(?!script|pre|style)[a-z][\\w-]*\\s*>(?=\\h*\\n)[\\s\\S]*?(?:\\n{2,}|$))",def:/^ {0,3}\[(label)\]: *\n? *<?([^\s>]+)>?(?:(?: +\n? *| *\n *)(title))? *(?:\n+|$)/,table:noop,lheading:/^([^\n]+)\n *(=|-){2,} *(?:\n+|$)/,paragraph:/^([^\n]+(?:\n(?!hr|heading|lheading| {0,3}>|<\/?(?:tag)(?: +|\n|\/?>)|<(?:script|pre|style|!--))[^\n]+)*)/,text:/^[^\n]+/};function Lexer(options){this.tokens=[],this.tokens.links=Object.create(null),this.options=options||marked.defaults,this.rules=block.normal,this.options.pedantic?this.rules=block.pedantic:this.options.gfm&&(this.options.tables?this.rules=block.tables:this.rules=block.gfm)}block._label=/(?!\s*\])(?:\\[\[\]]|[^\[\]])+/,block._title=/(?:"(?:\\"?|[^"\\])*"|'[^'\n]*(?:\n[^'\n]+)*\n?'|\([^()]*\))/,block.def=edit(block.def).replace("label",block._label).replace("title",block._title).getRegex(),block.bullet=/(?:[*+-]|\d{1,9}\.)/,block.item=/^( *)(bull) ?[^\n]*(?:\n(?!\1bull ?)[^\n]*)*/,block.item=edit(block.item,"gm").replace(/bull/g,block.bullet).getRegex(),block.list=edit(block.list).replace(/bull/g,block.bullet).replace("hr","\\n+(?=\\1?(?:(?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$))").replace("def","\\n+(?="+block.def.source+")").getRegex(),block._tag="address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h[1-6]|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option|p|param|section|source|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul",block._comment=/<!--(?!-?>)[\s\S]*?-->/,block.html=edit(block.html,"i").replace("comment",block._comment).replace("tag",block._tag).replace("attribute",/ +[a-zA-Z:_][\w.:-]*(?: *= *"[^"\n]*"| *= *'[^'\n]*'| *= *[^\s"'=<>`]+)?/).getRegex(),block.paragraph=edit(block.paragraph).replace("hr",block.hr).replace("heading",block.heading).replace("lheading",block.lheading).replace("tag",block._tag).getRegex(),block.blockquote=edit(block.blockquote).replace("paragraph",block.paragraph).getRegex(),block.normal=merge({},block),block.gfm=merge({},block.normal,{fences:/^ {0,3}(`{3,}|~{3,})([^`\n]*)\n(?:|([\s\S]*?)\n)(?: {0,3}\1[~`]* *(?:\n+|$)|$)/,paragraph:/^/,heading:/^ *(#{1,6}) +([^\n]+?) *#* *(?:\n+|$)/}),block.gfm.paragraph=edit(block.paragraph).replace("(?!","(?!"+block.gfm.fences.source.replace("\\1","\\2")+"|"+block.list.source.replace("\\1","\\3")+"|").getRegex(),block.tables=merge({},block.gfm,{nptable:/^ *([^|\n ].*\|.*)\n *([-:]+ *\|[-| :]*)(?:\n((?:.*[^>\n ].*(?:\n|$))*)\n*|$)/,table:/^ *\|(.+)\n *\|?( *[-:]+[-| :]*)(?:\n((?: *[^>\n ].*(?:\n|$))*)\n*|$)/}),block.pedantic=merge({},block.normal,{html:edit("^ *(?:comment *(?:\\n|\\s*$)|<(tag)[\\s\\S]+?</\\1> *(?:\\n{2,}|\\s*$)|<tag(?:\"[^\"]*\"|'[^']*'|\\s[^'\"/>\\s]*)*?/?> *(?:\\n{2,}|\\s*$))").replace("comment",block._comment).replace(/tag/g,"(?!(?:a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)\\b)\\w+(?!:|[^\\w\\s@]*@)\\b").getRegex(),def:/^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +(["(][^\n]+[")]))? *(?:\n+|$)/}),Lexer.rules=block,Lexer.lex=function(src,options){var lexer;return new Lexer(options).lex(src)},Lexer.prototype.lex=function(src){return src=src.replace(/\r\n|\r/g,"\n").replace(/\t/g,"    ").replace(/\u00a0/g," ").replace(/\u2424/g,"\n"),this.token(src,!0)},Lexer.prototype.token=function(src,top){var next,loose,cap,bull,b,item,listStart,listItems,t,space,i,tag,l,isordered,istask,ischecked;for(src=src.replace(/^ +$/gm,"");src;)if((cap=this.rules.newline.exec(src))&&(src=src.substring(cap[0].length),cap[0].length>1&&this.tokens.push({type:"space"})),cap=this.rules.code.exec(src))src=src.substring(cap[0].length),cap=cap[0].replace(/^ {4}/gm,""),this.tokens.push({type:"code",text:this.options.pedantic?cap:rtrim(cap,"\n")});else if(cap=this.rules.fences.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"code",lang:cap[2]?cap[2].trim():cap[2],text:cap[3]||""});else if(cap=this.rules.heading.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"heading",depth:cap[1].length,text:cap[2]});else if(top&&(cap=this.rules.nptable.exec(src))&&(item={type:"table",header:splitCells(cap[1].replace(/^ *| *\| *$/g,"")),align:cap[2].replace(/^ *|\| *$/g,"").split(/ *\| */),cells:cap[3]?cap[3].replace(/\n$/,"").split("\n"):[]}).header.length===item.align.length){for(src=src.substring(cap[0].length),i=0;i<item.align.length;i++)/^ *-+: *$/.test(item.align[i])?item.align[i]="right":/^ *:-+: *$/.test(item.align[i])?item.align[i]="center":/^ *:-+ *$/.test(item.align[i])?item.align[i]="left":item.align[i]=null;for(i=0;i<item.cells.length;i++)item.cells[i]=splitCells(item.cells[i],item.header.length);this.tokens.push(item)}else if(cap=this.rules.hr.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"hr"});else if(cap=this.rules.blockquote.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"blockquote_start"}),cap=cap[0].replace(/^ *> ?/gm,""),this.token(cap,top),this.tokens.push({type:"blockquote_end"});else if(cap=this.rules.list.exec(src)){for(src=src.substring(cap[0].length),listStart={type:"list_start",ordered:isordered=(bull=cap[2]).length>1,start:isordered?+bull:"",loose:!1},this.tokens.push(listStart),listItems=[],next=!1,l=(cap=cap[0].match(this.rules.item)).length,i=0;i<l;i++)space=(item=cap[i]).length,~(item=item.replace(/^ *([*+-]|\d+\.) */,"")).indexOf("\n ")&&(space-=item.length,item=this.options.pedantic?item.replace(/^ {1,4}/gm,""):item.replace(new RegExp("^ {1,"+space+"}","gm"),"")),i!==l-1&&(b=block.bullet.exec(cap[i+1])[0],(bull.length>1?1===b.length:b.length>1||this.options.smartLists&&b!==bull)&&(src=cap.slice(i+1).join("\n")+src,i=l-1)),loose=next||/\n\n(?!\s*$)/.test(item),i!==l-1&&(next="\n"===item.charAt(item.length-1),loose||(loose=next)),loose&&(listStart.loose=!0),ischecked=void 0,(istask=/^\[[ xX]\] /.test(item))&&(ischecked=" "!==item[1],item=item.replace(/^\[[ xX]\] +/,"")),t={type:"list_item_start",task:istask,checked:ischecked,loose:loose},listItems.push(t),this.tokens.push(t),this.token(item,!1),this.tokens.push({type:"list_item_end"});if(listStart.loose)for(l=listItems.length,i=0;i<l;i++)listItems[i].loose=!0;this.tokens.push({type:"list_end"})}else if(cap=this.rules.html.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:this.options.sanitize?"paragraph":"html",pre:!this.options.sanitizer&&("pre"===cap[1]||"script"===cap[1]||"style"===cap[1]),text:cap[0]});else if(top&&(cap=this.rules.def.exec(src)))src=src.substring(cap[0].length),cap[3]&&(cap[3]=cap[3].substring(1,cap[3].length-1)),tag=cap[1].toLowerCase().replace(/\s+/g," "),this.tokens.links[tag]||(this.tokens.links[tag]={href:cap[2],title:cap[3]});else if(top&&(cap=this.rules.table.exec(src))&&(item={type:"table",header:splitCells(cap[1].replace(/^ *| *\| *$/g,"")),align:cap[2].replace(/^ *|\| *$/g,"").split(/ *\| */),cells:cap[3]?cap[3].replace(/(?: *\| *)?\n$/,"").split("\n"):[]}).header.length===item.align.length){for(src=src.substring(cap[0].length),i=0;i<item.align.length;i++)/^ *-+: *$/.test(item.align[i])?item.align[i]="right":/^ *:-+: *$/.test(item.align[i])?item.align[i]="center":/^ *:-+ *$/.test(item.align[i])?item.align[i]="left":item.align[i]=null;for(i=0;i<item.cells.length;i++)item.cells[i]=splitCells(item.cells[i].replace(/^ *\| *| *\| *$/g,""),item.header.length);this.tokens.push(item)}else if(cap=this.rules.lheading.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"heading",depth:"="===cap[2]?1:2,text:cap[1]});else if(top&&(cap=this.rules.paragraph.exec(src)))src=src.substring(cap[0].length),this.tokens.push({type:"paragraph",text:"\n"===cap[1].charAt(cap[1].length-1)?cap[1].slice(0,-1):cap[1]});else if(cap=this.rules.text.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"text",text:cap[0]});else if(src)throw new Error("Infinite loop on byte: "+src.charCodeAt(0));return this.tokens};var inline={escape:/^\\([!"#$%&'()*+,\-.\/:;<=>?@\[\]\\^_`{|}~])/,autolink:/^<(scheme:[^\s\x00-\x1f<>]*|email)>/,url:noop,tag:"^comment|^</[a-zA-Z][\\w:-]*\\s*>|^<[a-zA-Z][\\w-]*(?:attribute)*?\\s*/?>|^<\\?[\\s\\S]*?\\?>|^<![a-zA-Z]+\\s[\\s\\S]*?>|^<!\\[CDATA\\[[\\s\\S]*?\\]\\]>",link:/^[!|%]?\[(label)\]\(href(?:\s+(title))?\s*\)/,reflink:/^!?\[(label)\]\[(?!\s*\])((?:\\[\[\]]?|[^\[\]\\])+)\]/,nolink:/^!?\[(?!\s*\])((?:\[[^\[\]]*\]|\\[\[\]]|[^\[\]])*)\](?:\[\])?/,strong:/^__([^\s_])__(?!_)|^\*\*([^\s*])\*\*(?!\*)|^__([^\s][\s\S]*?[^\s])__(?!_)|^\*\*([^\s][\s\S]*?[^\s])\*\*(?!\*)/,em:/^_([^\s_])_(?!_)|^\*([^\s*"<\[])\*(?!\*)|^_([^\s][\s\S]*?[^\s_])_(?!_|[^\spunctuation])|^_([^\s_][\s\S]*?[^\s])_(?!_|[^\spunctuation])|^\*([^\s"<\[][\s\S]*?[^\s*])\*(?!\*)|^\*([^\s*"<\[][\s\S]*?[^\s])\*(?!\*)/,code:/^(`+)([^`]|[^`][\s\S]*?[^`])\1(?!`)/,br:/^( {2,}|\\)\n(?!\s*$)/,del:noop,text:/^(`+|[^`])[\s\S]*?(?=[\\<!\[`*]|\b_| {2,}\n|$)/};function InlineLexer(links,options){if(this.options=options||marked.defaults,this.links=links,this.rules=inline.normal,this.renderer=this.options.renderer||new Renderer,this.renderer.options=this.options,!this.links)throw new Error("Tokens array requires a `links` property.");this.options.pedantic?this.rules=inline.pedantic:this.options.gfm&&(this.options.breaks?this.rules=inline.breaks:this.rules=inline.gfm)}function Renderer(options){this.options=options||marked.defaults}function TextRenderer(){}function Parser(options){this.tokens=[],this.token=null,this.options=options||marked.defaults,this.options.renderer=this.options.renderer||new Renderer,this.renderer=this.options.renderer,this.renderer.options=this.options,this.slugger=new Slugger}function Slugger(){this.seen={}}function escape(html,encode){if(encode){if(escape.escapeTest.test(html))return html.replace(escape.escapeReplace,function(ch){return escape.replacements[ch]})}else if(escape.escapeTestNoEncode.test(html))return html.replace(escape.escapeReplaceNoEncode,function(ch){return escape.replacements[ch]});return html}function unescape(html){return html.replace(/&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/gi,function(_,n){return"colon"===(n=n.toLowerCase())?":":"#"===n.charAt(0)?"x"===n.charAt(1)?String.fromCharCode(parseInt(n.substring(2),16)):String.fromCharCode(+n.substring(1)):""})}function edit(regex,opt){return regex=regex.source||regex,opt=opt||"",{replace:function(name,val){return val=(val=val.source||val).replace(/(^|[^\[])\^/g,"$1"),regex=regex.replace(name,val),this},getRegex:function(){return new RegExp(regex,opt)}}}function cleanUrl(sanitize,base,href){if(sanitize){try{var prot=decodeURIComponent(unescape(href)).replace(/[^\w:]/g,"").toLowerCase()}catch(e){return null}if(0===prot.indexOf("javascript:")||0===prot.indexOf("vbscript:")||0===prot.indexOf("data:"))return null}base&&!originIndependentUrl.test(href)&&(href=resolveUrl(base,href));try{href=encodeURI(href).replace(/%25/g,"%")}catch(e){return null}return href}function resolveUrl(base,href){return baseUrls[" "+base]||(/^[^:]+:\/*[^\/]*$/.test(base)?baseUrls[" "+base]=base+"/":baseUrls[" "+base]=rtrim(base,"/",!0)),base=baseUrls[" "+base],"//"===href.slice(0,2)?base.replace(/:[\s\S]*/,":")+href:"/"===href.charAt(0)?base.replace(/(:\/*[^\/]*)[\s\S]*/,"$1")+href:base+href}inline._punctuation="!\"#$%&'()*+,\\-./:;<=>?@\\[^_{|}~",inline.em=edit(inline.em).replace(/punctuation/g,inline._punctuation).getRegex(),inline._escapes=/\\([!"#$%&'()*+,\-.\/:;<=>?@\[\]\\^_`{|}~])/g,inline._scheme=/[a-zA-Z][a-zA-Z0-9+.-]{1,31}/,inline._email=/[a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+(@)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+(?![-_])/,inline.autolink=edit(inline.autolink).replace("scheme",inline._scheme).replace("email",inline._email).getRegex(),inline._attribute=/\s+[a-zA-Z:_][\w.:-]*(?:\s*=\s*"[^"]*"|\s*=\s*'[^']*'|\s*=\s*[^\s"'=<>`]+)?/,inline.tag=edit(inline.tag).replace("comment",block._comment).replace("attribute",inline._attribute).getRegex(),inline._label=/(?:\[[^\[\]]*\]|\\[\[\]]?|`[^`]*`|[^\[\]\\])*?/,inline._href=/\s*(<(?:\\[<>]?|[^\s<>\\])*>|(?:\\[()]?|\([^\s\x00-\x1f\\]*\)|[^\s\x00-\x1f()\\])*?)/,inline._title=/"(?:\\"?|[^"\\])*"|'(?:\\'?|[^'\\])*'|\((?:\\\)?|[^)\\])*\)/,inline.link=edit(inline.link).replace("label",inline._label).replace("href",inline._href).replace("title",inline._title).getRegex(),inline.reflink=edit(inline.reflink).replace("label",inline._label).getRegex(),inline.normal=merge({},inline),inline.pedantic=merge({},inline.normal,{strong:/^__(?=\S)([\s\S]*?\S)__(?!_)|^\*\*(?=\S)([\s\S]*?\S)\*\*(?!\*)/,em:/^_(?=\S)([\s\S]*?\S)_(?!_)|^\*(?=\S)([\s\S]*?\S)\*(?!\*)/,link:edit(/^!?\[(label)\]\((.*?)\)/).replace("label",inline._label).getRegex(),reflink:edit(/^!?\[(label)\]\s*\[([^\]]*)\]/).replace("label",inline._label).getRegex()}),inline.gfm=merge({},inline.normal,{escape:edit(inline.escape).replace("])","~|])").getRegex(),_extended_email:/[A-Za-z0-9._+-]+(@)[a-zA-Z0-9-_]+(?:\.[a-zA-Z0-9-_]*[a-zA-Z0-9])+(?![-_])/,url:/^((?:ftp|https?):\/\/|www\.)(?:[a-zA-Z0-9\-]+\.?)+[^\s<"']*|^email/,_backpedal:/(?:[^?!.,:;*_~()&]+|\([^)]*\)|&(?![a-zA-Z0-9]+;$)|[?!.,:;*_~)]+(?!$))+/,del:/^~+(?=\S)([\s\S]*?\S)~+/,text:edit(inline.text).replace("]|","~]|").replace("|$","|https?://|ftp://|www\\.|[a-zA-Z0-9.!#$%&'*+/=?^_`{\\|}~-]+@|$").getRegex()}),inline.gfm.url=edit(inline.gfm.url,"i").replace("email",inline.gfm._extended_email).getRegex(),inline.breaks=merge({},inline.gfm,{br:edit(inline.br).replace("{2,}","*").getRegex(),text:edit(inline.gfm.text).replace("{2,}","*").getRegex()}),InlineLexer.rules=inline,InlineLexer.output=function(src,links,options){var inline;return new InlineLexer(links,options).output(src)},InlineLexer.prototype.output=function(src){for(var out="",link,text,href,title,cap,prevCapZero;src;)if(cap=this.rules.escape.exec(src))src=src.substring(cap[0].length),out+=escape(cap[1]);else if(cap=this.rules.tag.exec(src))!this.inLink&&/^<a /i.test(cap[0])?this.inLink=!0:this.inLink&&/^<\/a>/i.test(cap[0])&&(this.inLink=!1),!this.inRawBlock&&/^<(pre|code|kbd|script)(\s|>)/i.test(cap[0])?this.inRawBlock=!0:this.inRawBlock&&/^<\/(pre|code|kbd|script)(\s|>)/i.test(cap[0])&&(this.inRawBlock=!1),src=src.substring(cap[0].length),out+=this.options.sanitize?this.options.sanitizer?this.options.sanitizer(cap[0]):escape(cap[0]):cap[0];else if(cap=this.rules.link.exec(src))src=src.substring(cap[0].length),this.inLink=!0,href=cap[2],this.options.pedantic?(link=/^([^'"]*[^\s])\s+(['"])(.*)\2/.exec(href))?(href=link[1],title=link[3]):title="":title=cap[3]?cap[3].slice(1,-1):"",href=href.trim().replace(/^<([\s\S]*)>$/,"$1"),out+=this.outputLink(cap,{href:InlineLexer.escapes(href),title:InlineLexer.escapes(title)}),this.inLink=!1;else if((cap=this.rules.reflink.exec(src))||(cap=this.rules.nolink.exec(src))){if(src=src.substring(cap[0].length),link=(cap[2]||cap[1]).replace(/\s+/g," "),!(link=this.links[link.toLowerCase()])||!link.href){out+=cap[0].charAt(0),src=cap[0].substring(1)+src;continue}this.inLink=!0,out+=this.outputLink(cap,link),this.inLink=!1}else if(cap=this.rules.strong.exec(src))src=src.substring(cap[0].length),out+=this.renderer.strong(this.output(cap[4]||cap[3]||cap[2]||cap[1]));else if(cap=this.rules.em.exec(src))src=src.substring(cap[0].length),out+=this.renderer.em(this.output(cap[6]||cap[5]||cap[4]||cap[3]||cap[2]||cap[1]));else if(cap=this.rules.code.exec(src))src=src.substring(cap[0].length),out+=this.renderer.codespan(escape(cap[2].trim(),!0));else if(cap=this.rules.br.exec(src))src=src.substring(cap[0].length),out+=this.renderer.br();else if(cap=this.rules.del.exec(src))src=src.substring(cap[0].length),out+=this.renderer.del(this.output(cap[1]));else if(cap=this.rules.autolink.exec(src))src=src.substring(cap[0].length),href="@"===cap[2]?"mailto:"+(text=escape(this.mangle(cap[1]))):text=escape(cap[1]),out+=this.renderer.link(href,null,text);else if(this.inLink||!(cap=this.rules.url.exec(src))){if(cap=this.rules.text.exec(src))src=src.substring(cap[0].length),this.inRawBlock?out+=this.renderer.text(cap[0]):out+=this.renderer.text(escape(this.smartypants(cap[0])));else if(src)throw new Error("Infinite loop on byte: "+src.charCodeAt(0))}else{if("@"===cap[2])href="mailto:"+(text=escape(cap[0]));else{do{prevCapZero=cap[0],cap[0]=this.rules._backpedal.exec(cap[0])[0]}while(prevCapZero!==cap[0]);text=escape(cap[0]),href="www."===cap[1]?"http://"+text:text}src=src.substring(cap[0].length),out+=this.renderer.link(href,null,text)}return out},InlineLexer.escapes=function(text){return text?text.replace(InlineLexer.rules._escapes,"$1"):text},InlineLexer.prototype.outputLink=function(cap,link){var href=link.href,title=link.title?escape(link.title):null;return"%"==cap[0].charAt(0)?"undefined"!=typeof is_support_html_figure&&is_support_html_figure?this.renderer.figure(href,title,escape(cap[1])):"%"+this.renderer.link(href,title,this.output(cap[1])):"!"!==cap[0].charAt(0)?this.renderer.link(href,title,this.output(cap[1])):this.renderer.image(href,title,escape(cap[1]))},InlineLexer.prototype.smartypants=function(text){return this.options.smartypants?text.replace(/---/g,"—").replace(/--/g,"–").replace(/(^|[-\u2014\/(\[{"\s])'/g,"$1‘").replace(/'/g,"’").replace(/(^|[-\u2014\/(\[{\u2018\s])"/g,"$1“").replace(/"/g,"”").replace(/\.{3}/g,"…"):text},InlineLexer.prototype.mangle=function(text){if(!this.options.mangle)return text;for(var out="",l=text.length,i=0,ch;i<l;i++)ch=text.charCodeAt(i),Math.random()>.5&&(ch="x"+ch.toString(16)),out+="&#"+ch+";";return out},Renderer.prototype.code=function(code,infostring,escaped){var lang=(infostring||"").match(/\S*/)[0];if(this.options.highlight){var out=this.options.highlight(code,lang);null!=out&&out!==code&&(escaped=!0,code=out)}return lang?'<pre><code class="'+this.options.langPrefix+escape(lang,!0)+'">'+(escaped?code:escape(code,!0))+"</code></pre>\n":"<pre><code>"+(escaped?code:escape(code,!0))+"</code></pre>"},Renderer.prototype.blockquote=function(quote){return"<blockquote>\n"+quote+"</blockquote>\n"},Renderer.prototype.html=function(html){return html},Renderer.prototype.heading=function(text,level,raw,slugger){return this.options.headerIds?"<h"+level+' id="'+this.options.headerPrefix+slugger.slug(raw)+'">'+text+"</h"+level+">\n":"<h"+level+">"+text+"</h"+level+">\n"},Renderer.prototype.hr=function(){return this.options.xhtml?"<hr/>\n":"<hr>\n"},Renderer.prototype.list=function(body,ordered,start){var type=ordered?"ol":"ul",startatt;return"<"+type+(ordered&&1!==start?' start="'+start+'"':"")+">\n"+body+"</"+type+">\n"},Renderer.prototype.listitem=function(text){return"<li>"+text+"</li>\n"},Renderer.prototype.checkbox=function(checked){return"<input "+(checked?'checked="" ':"")+'disabled="" type="checkbox"'+(this.options.xhtml?" /":"")+"> "},Renderer.prototype.paragraph=function(text){return"<p>"+text+"</p>\n"},Renderer.prototype.table=function(header,body){return body&&(body="<tbody>"+body+"</tbody>"),"<table>\n<thead>\n"+header+"</thead>\n"+body+"</table>\n"},Renderer.prototype.tablerow=function(content){return"<tr>\n"+content+"</tr>\n"},Renderer.prototype.tablecell=function(content,flags){var type=flags.header?"th":"td",tag;return(flags.align?"<"+type+' align="'+flags.align+'">':"<"+type+">")+content+"</"+type+">\n"},Renderer.prototype.strong=function(text){return"<strong>"+text+"</strong>"},Renderer.prototype.em=function(text){return"<em>"+text+"</em>"},Renderer.prototype.codespan=function(text){var codetext;if("undefined"!=typeof is_support_inline_keyboard_style&&is_support_inline_keyboard_style&&("{"===text.substring(0,1)&&"}"===text.substr(text.length-1)))return'<code class="kb-btn">'+text.substring(1,text.length-1)+"</code>";return"<code>"+text+"</code>"},Renderer.prototype.br=function(){return this.options.xhtml?"<br/>":"<br>"},Renderer.prototype.del=function(text){return"<del>"+text+"</del>"},Renderer.prototype.link=function(href,title,text){if(null===(href=cleanUrl(this.options.sanitize,this.options.baseUrl,href)))return text;var out='<a href="'+escape(href)+'"';return title&&(out+=' title="'+title+'"'),out+=">"+text+"</a>"},Renderer.prototype.image=function(href,title,text){if(null===(href=cleanUrl(this.options.sanitize,this.options.baseUrl,href)))return text;var out='<img src="'+href+'" alt="'+text+'"';return title&&(out+=' title="'+title+'"'),out+=this.options.xhtml?"/>":">"},Renderer.prototype.figure=function(href,title,text){if(null===(href=cleanUrl(this.options.sanitize,this.options.baseUrl,href)))return text;var out="<figure>";return out+='<img src="'+href+'" alt="'+text+'"',title&&(out+="<figcaption>",out+=title,out+="</figcaption>"),out+="</figure>"},Renderer.prototype.text=function(text){return text},TextRenderer.prototype.strong=TextRenderer.prototype.em=TextRenderer.prototype.codespan=TextRenderer.prototype.del=TextRenderer.prototype.text=function(text){return text},TextRenderer.prototype.link=TextRenderer.prototype.figure=TextRenderer.prototype.image=function(href,title,text){return""+text},TextRenderer.prototype.br=function(){return""},Parser.parse=function(src,options){var parser;return new Parser(options).parse(src)},Parser.prototype.parse=function(src){this.inline=new InlineLexer(src.links,this.options),this.inlineText=new InlineLexer(src.links,merge({},this.options,{renderer:new TextRenderer})),this.tokens=src.reverse();for(var out="";this.next();)out+=this.tok();return out},Parser.prototype.next=function(){return this.token=this.tokens.pop()},Parser.prototype.peek=function(){return this.tokens[this.tokens.length-1]||0},Parser.prototype.parseText=function(){for(var body=this.token.text;"text"===this.peek().type;)body+="\n"+this.next().text;return this.inline.output(body)},Parser.prototype.tok=function(){switch(this.token.type){case"space":return"";case"hr":return this.renderer.hr();case"heading":return this.renderer.heading(this.inline.output(this.token.text),this.token.depth,unescape(this.inlineText.output(this.token.text)),this.slugger);case"code":return this.renderer.code(this.token.text,this.token.lang,this.token.escaped);case"table":var header="",body="",i,row,cell,j;for(cell="",i=0;i<this.token.header.length;i++)cell+=this.renderer.tablecell(this.inline.output(this.token.header[i]),{header:!0,align:this.token.align[i]});for(header+=this.renderer.tablerow(cell),i=0;i<this.token.cells.length;i++){for(row=this.token.cells[i],cell="",j=0;j<row.length;j++)cell+=this.renderer.tablecell(this.inline.output(row[j]),{header:!1,align:this.token.align[j]});body+=this.renderer.tablerow(cell)}return this.renderer.table(header,body);case"blockquote_start":for(body="";"blockquote_end"!==this.next().type;)body+=this.tok();return this.renderer.blockquote(body);case"list_start":body="";for(var ordered=this.token.ordered,start=this.token.start;"list_end"!==this.next().type;)body+=this.tok();return this.renderer.list(body,ordered,start);case"list_item_start":body="";var loose=this.token.loose;for(this.token.task&&(body+=this.renderer.checkbox(this.token.checked));"list_item_end"!==this.next().type;)body+=loose||"text"!==this.token.type?this.tok():this.parseText();return this.renderer.listitem(body);case"html":return this.renderer.html(this.token.text);case"paragraph":return this.renderer.paragraph(this.inline.output(this.token.text));case"text":return this.renderer.paragraph(this.parseText());default:var errMsg='Token with "'+this.token.type+'" type was not found.';if(!this.options.silent)throw new Error(errMsg);console.log(errMsg)}},Slugger.prototype.slug=function(value){var slug=value.toLowerCase().trim().replace(/[\u2000-\u206F\u2E00-\u2E7F\\'!"#$%&()*+,.\/:;<=>?@[\]^`{|}~]/g,"").replace(/\s/g,"-");if(this.seen.hasOwnProperty(slug)){var originalSlug=slug;do{this.seen[originalSlug]++,slug=originalSlug+"-"+this.seen[originalSlug]}while(this.seen.hasOwnProperty(slug))}return this.seen[slug]=0,slug},escape.escapeTest=/[&<>"']/,escape.escapeReplace=/[&<>"']/g,escape.replacements={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"},escape.escapeTestNoEncode=/[<>"']|&(?!#?\w+;)/,escape.escapeReplaceNoEncode=/[<>"']|&(?!#?\w+;)/g;var baseUrls={},originIndependentUrl=/^$|^[a-z][a-z0-9+.-]*:|^[?#]/i;function noop(){}function merge(obj){for(var i=1,target,key;i<arguments.length;i++)for(key in target=arguments[i])Object.prototype.hasOwnProperty.call(target,key)&&(obj[key]=target[key]);return obj}function splitCells(tableRow,count){var row,cells=tableRow.replace(/\|/g,function(match,offset,str){for(var escaped=!1,curr=offset;--curr>=0&&"\\"===str[curr];)escaped=!escaped;return escaped?"|":" |"}).split(/ \|/),i=0;if(cells.length>count)cells.splice(count);else for(;cells.length<count;)cells.push("");for(;i<cells.length;i++)cells[i]=cells[i].trim().replace(/\\\|/g,"|");return cells}function rtrim(str,c,invert){if(0===str.length)return"";for(var suffLen=0;suffLen<str.length;){var currChar=str.charAt(str.length-suffLen-1);if(currChar!==c||invert){if(currChar===c||!invert)break;suffLen++}else suffLen++}return str.substr(0,str.length-suffLen)}function marked(src,opt,callback){if(null==src)throw new Error("marked(): input parameter is undefined or null");if("string"!=typeof src)throw new Error("marked(): input parameter is of type "+Object.prototype.toString.call(src)+", string expected");if(callback||"function"==typeof opt){callback||(callback=opt,opt=null);var highlight=(opt=merge({},marked.defaults,opt||{})).highlight,tokens,pending,i=0;try{tokens=Lexer.lex(src,opt)}catch(e){return callback(e)}pending=tokens.length;var done=function(err){if(err)return opt.highlight=highlight,callback(err);var out;try{out=Parser.parse(tokens,opt)}catch(e){err=e}return opt.highlight=highlight,err?callback(err):callback(null,out)};if(!highlight||highlight.length<3)return done();if(delete opt.highlight,!pending)return done();for(;i<tokens.length;i++)!function(token){"code"!==token.type?--pending||done():highlight(token.text,token.lang,function(err,code){return err?done(err):null==code||code===token.text?--pending||done():(token.text=code,token.escaped=!0,void(--pending||done()))})}(tokens[i])}else try{return opt&&(opt=merge({},marked.defaults,opt)),Parser.parse(Lexer.lex(src,opt),opt)}catch(e){if(e.message+="\nPlease report this to https://github.com/markedjs/marked.",(opt||marked.defaults).silent)return"<p>An error occurred:</p><pre>"+escape(e.message+"",!0)+"</pre>";throw e}}noop.exec=noop,marked.options=marked.setOptions=function(opt){return merge(marked.defaults,opt),marked},marked.getDefaults=function(){return{baseUrl:null,breaks:!1,gfm:!0,headerIds:!0,headerPrefix:"",highlight:null,langPrefix:"language-",mangle:!0,pedantic:!1,renderer:new Renderer,sanitize:!1,sanitizer:null,silent:!1,smartLists:!1,smartypants:!1,tables:!0,xhtml:!1}},marked.defaults=marked.getDefaults(),marked.Parser=Parser,marked.parser=Parser.parse,marked.Renderer=Renderer,marked.TextRenderer=TextRenderer,marked.Lexer=Lexer,marked.lexer=Lexer.lex,marked.InlineLexer=InlineLexer,marked.inlineLexer=InlineLexer.output,marked.Slugger=Slugger,marked.parse=marked,"undefined"!=typeof module&&"object"==typeof exports?module.exports=marked:"function"==typeof define&&define.amd?define(function(){return marked}):root.marked=marked}(this||("undefined"!=typeof window?window:global));