/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.meta;

import arc.Core;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.struct.Seq;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.meta.Stats;
import omaloon.world.blocks.liquid.PressureLiquidBridge;
import omaloon.world.blocks.liquid.PressureLiquidConduit;
import omaloon.world.blocks.liquid.PressureLiquidJunction;
import omaloon.world.blocks.liquid.PressureLiquidPump;
import omaloon.world.blocks.liquid.PressureLiquidValve;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.OlStats;

public class PressureConfig {
    public boolean acceptsPressure = true;
    public boolean outputsPressure = true;
    public boolean isWhitelist = false;
    public float overPressureDamage = 0.33f;
    public float underPressureDamage = 0.66f;
    public float maxPressure = 50.0f;
    public float minPressure = -50.0f;
    public Seq<Block> linkList = new Seq();
    private static final Class<?>[] alwaysAllowed = new Class[]{PressureLiquidBridge.class, PressureLiquidConduit.class, PressureLiquidJunction.class, PressureLiquidPump.class, PressureLiquidValve.class};

    public void addStats(Stats stats) {
        stats.add(OlStats.maxPressure, (float)Mathf.round((float)this.maxPressure, (int)2), OlStats.pressureUnits);
        stats.add(OlStats.minPressure, (float)Mathf.round((float)this.minPressure, (int)2), OlStats.pressureUnits);
    }

    public void addBars(Block block) {
        block.removeBar("liquid");
        block.addBar("pressure-liquid", entity -> new Bar(() -> {
            HasPressure build = (HasPressure)entity;
            Liquid current = entity.liquids != null ? entity.liquids.current() : null;
            String liquidName = current == null || entity.liquids.get(current) <= 0.001f ? Core.bundle.get("bar.air") : current.localizedName;
            return Core.bundle.format("bar.pressure-liquid", new Object[]{liquidName, Mathf.round((float)build.getPressure(), (int)1), Mathf.round((float)(build.getPressure() > 0.0f ? build.pressureConfig().maxPressure : build.pressureConfig().minPressure), (int)1)});
        }, () -> {
            Liquid current = entity.liquids != null ? entity.liquids.current() : null;
            return current != null && entity.liquids.get(current) > 0.001f ? current.color : Color.lightGray;
        }, () -> {
            Liquid current = entity.liquids != null ? entity.liquids.current() : null;
            return current != null ? entity.liquids.get(current) / block.liquidCapacity : 0.0f;
        }));
    }

    public boolean isAllowed(Block block) {
        for (Class<?> alwaysAllowedClass : alwaysAllowed) {
            if (!alwaysAllowedClass.isAssignableFrom(block.getClass())) continue;
            return true;
        }
        boolean inList = this.linkList.contains((Object)block);
        return this.isWhitelist == inList;
    }
}

