/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.interfaces;

import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.gen.Building;
import mindustry.gen.Buildingc;
import mindustry.type.Liquid;
import omaloon.world.meta.PressureConfig;
import omaloon.world.modules.PressureModule;

public interface HasPressure
extends Buildingc {
    default public boolean acceptsPressure(HasPressure from, float pressure) {
        return this.getPressure() + pressure <= from.getPressure() - pressure;
    }

    default public boolean canDumpPressure(HasPressure to, float pressure) {
        return to.getPressure() + pressure <= this.getPressure() - pressure;
    }

    default public boolean connected(HasPressure to) {
        return this.connects(to) && to.connects(this);
    }

    default public boolean connects(HasPressure to) {
        return this.pressureConfig().outputsPressure || this.pressureConfig().acceptsPressure;
    }

    default public void dumpPressure() {
        for (HasPressure other : this.nextBuilds(true)) {
            float diff = (this.getPressure() - other.getPressure()) / 2.0f;
            if (other.getPressure() > this.getPressure()) {
                diff *= -1.0f;
            }
            if (!this.canDumpPressure(other, diff)) continue;
            this.transferPressure(other, diff);
        }
    }

    default public void dumpLiquidPressure(Liquid liquid) {
        int dump = this.cdump();
        if (this.liquids().get(liquid) > 1.0E-4f) {
            if (!Vars.net.client() && Vars.state.isCampaign() && this.team() == Vars.state.rules.defaultTeam) {
                liquid.unlock();
            }
            for (int i = 0; i < this.nextBuilds((boolean)true).size; ++i) {
                float fract;
                float ofract;
                this.incrementDump(this.nextBuilds((boolean)true).size);
                HasPressure other = (HasPressure)this.nextBuilds(true).get((i + dump) % this.nextBuilds((boolean)true).size);
                other = (HasPressure)other.getLiquidDestination((Building)this.as(), liquid).as();
                if (other == null || !other.block().hasLiquids || !this.canDumpLiquid((Building)other.as(), liquid) || other.liquids() == null || !((ofract = other.liquids().get(liquid) / other.block().liquidCapacity) < (fract = this.liquids().get(liquid) / this.block().liquidCapacity))) continue;
                this.transferLiquid((Building)other.as(), (fract - ofract) * this.block().liquidCapacity * this.getPressureFlow(other) / (float)this.nextBuilds((boolean)true).size, liquid);
            }
        }
    }

    default public float getPressure() {
        return this.pressure().pressure;
    }

    default public HasPressure getPressureDestination(HasPressure from, float pressure) {
        return this;
    }

    default public float getPressureFlow(HasPressure to) {
        if (to.getPressure() == 0.0f) {
            return 1.0f;
        }
        return Math.max(this.getPressure() / to.getPressure(), 1.0f);
    }

    default public void handlePressure(float pressure) {
        this.pressure().pressure += pressure;
    }

    default public float moveLiquidPressure(HasPressure next, Liquid liquid) {
        if (next != null && (next = (HasPressure)next.getLiquidDestination((Building)this.as(), liquid)).team() == this.team() && next.block().hasLiquids && this.liquids().get(liquid) > 0.0f) {
            float ofract = next.liquids().get(liquid) / next.block().liquidCapacity;
            float fract = this.liquids().get(liquid) / this.block().liquidCapacity;
            float flow = Math.min(Mathf.clamp((float)(fract - ofract)) * this.block().liquidCapacity, this.liquids().get(liquid)) * this.getPressureFlow(next);
            if ((flow = Math.min(flow, next.block().liquidCapacity - next.liquids().get(liquid)) / 2.0f) > 0.0f && ofract <= fract && next.acceptLiquid((Building)this.as(), liquid)) {
                next.handleLiquid((Building)this.as(), liquid, flow);
                this.liquids().remove(liquid, flow);
                return flow;
            }
            if (!next.block().consumesLiquid(liquid) && next.liquids().currentAmount() / next.block().liquidCapacity > 0.1f && fract > 0.1f) {
                float fx = (this.x() + next.x()) / 2.0f;
                float fy = (this.y() + next.y()) / 2.0f;
                Liquid other = next.liquids().current();
                if (other.blockReactive && liquid.blockReactive) {
                    if (!(other.flammability > 0.3f && liquid.temperature > 0.7f || liquid.flammability > 0.3f && other.temperature > 0.7f)) {
                        if (liquid.temperature > 0.7f && other.temperature < 0.55f || other.temperature > 0.7f && liquid.temperature < 0.55f) {
                            this.liquids().remove(liquid, Math.min(this.liquids().get(liquid), 0.7f * Time.delta));
                            if (Mathf.chanceDelta((double)0.2f)) {
                                Fx.steam.at(fx, fy);
                            }
                        }
                    } else {
                        this.damageContinuous(1.0f);
                        next.damageContinuous(1.0f);
                        if (Mathf.chanceDelta((double)0.1)) {
                            Fx.fire.at(fx, fy);
                        }
                    }
                }
            }
        }
        return 0.0f;
    }

    default public Seq<HasPressure> nextBuilds(boolean flow) {
        return this.proximity().select(b -> b instanceof HasPressure).as().map(b -> b.getPressureDestination(this, 0.0f)).removeAll(b -> !this.connected((HasPressure)b) && this.proximity().contains((Object)((Building)b)) || !this.pressureConfig().isAllowed(b.block()));
    }

    public PressureModule pressure();

    public PressureConfig pressureConfig();

    default public void transferPressure(HasPressure to, float pressure) {
        if (to.acceptsPressure(this, pressure)) {
            this.removePressure(pressure);
            to.handlePressure(pressure);
        }
    }

    default public void updatePressure() {
        if ((float)Mathf.round((float)this.getPressure()) <= this.pressureConfig().minPressure) {
            this.damage(this.pressureConfig().underPressureDamage);
        }
        if ((float)Mathf.round((float)this.getPressure()) >= this.pressureConfig().maxPressure) {
            this.damage(this.pressureConfig().overPressureDamage);
        }
    }

    default public void removePressure(float pressure) {
        this.pressure().pressure -= pressure;
    }
}

