/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.draw;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureRegion;
import mindustry.graphics.MultiPacker;
import mindustry.graphics.Pal;

public class Outliner {
    public static void outlineRegion(MultiPacker packer, TextureRegion textureRegion, String outputName) {
        Outliner.outlineRegion(packer, textureRegion, Pal.darkerMetal, outputName, 3);
    }

    public static void outlineRegion(MultiPacker packer, TextureRegion textureRegion, Color outlineColor, String outputName) {
        Outliner.outlineRegion(packer, textureRegion, outlineColor, outputName, 3);
    }

    public static void outlineRegion(MultiPacker packer, TextureRegion[] textures, Color outlineColor, String outputName) {
        Outliner.outlineRegion(packer, textures, outlineColor, outputName, 4);
    }

    public static void outlineRegion(MultiPacker packer, TextureRegion[] textures, Color outlineColor, String outputName, int radius) {
        for (int i = 0; i < textures.length; ++i) {
            Outliner.outlineRegion(packer, textures[i], outlineColor, outputName + "-" + i, radius);
        }
    }

    public static void outlineRegion(MultiPacker packer, TextureRegion textureRegion, Color outlineColor, String outputName, int outlineRadius) {
        if (textureRegion == null) {
            return;
        }
        PixmapRegion region = Core.atlas.getPixmap(textureRegion);
        Pixmap out = Pixmaps.outline((PixmapRegion)region, (Color)outlineColor, (int)outlineRadius);
        if (Core.settings.getBool("linear", true)) {
            Pixmaps.bleed((Pixmap)out);
        }
        packer.add(MultiPacker.PageType.main, outputName, out);
    }
}

