/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.sandbox;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.Strings;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.sandbox.LiquidSource;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.PressureConfig;
import omaloon.world.modules.PressureModule;

public class PressureLiquidSource
extends LiquidSource {
    public static float lastAmount = 0.0f;
    public static boolean wasNegative = false;
    public PressureConfig pressureConfig = new PressureConfig();

    public PressureLiquidSource(String name) {
        super(name);
    }

    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.crossRegion, (float)plan.drawx(), (float)plan.drawy());
        this.drawPlanConfigCenter(plan, plan.config, "center", false);
    }

    public void load() {
        super.load();
        this.bottomRegion = Core.atlas.find(this.name + "-bottom");
        this.crossRegion = Core.atlas.find(this.name + "-cross");
    }

    public void setBars() {
        super.setBars();
        this.pressureConfig.addBars((Block)this);
    }

    public class PressureLiquidSourceBuild
    extends LiquidSource.LiquidSourceBuild
    implements HasPressure {
        PressureModule pressure;
        public float pressureTarget;
        public boolean negative;

        public PressureLiquidSourceBuild() {
            super((LiquidSource)PressureLiquidSource.this);
            this.pressure = new PressureModule();
            this.pressureTarget = lastAmount;
            this.negative = wasNegative;
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            return false;
        }

        @Override
        public boolean acceptsPressure(HasPressure from, float pressure) {
            return false;
        }

        public void buildConfiguration(Table table) {
            super.buildConfiguration(table);
            table.row();
            table.table(Styles.black6, cont -> {
                cont.field(this.pressureTarget + "", TextField.TextFieldFilter.floatsOnly, s -> {
                    this.pressureTarget = Strings.parseFloat((String)s, (float)0.0f);
                }).row();
                cont.check(Core.bundle.get("omaloon-source-negative"), this.negative, b -> {
                    this.negative = b;
                });
            }).growX();
        }

        @Override
        public PressureModule pressure() {
            return this.pressure;
        }

        @Override
        public PressureConfig pressureConfig() {
            return PressureLiquidSource.this.pressureConfig;
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.pressure.read(read);
            this.pressureTarget = read.f();
            this.negative = read.bool();
        }

        public void updateTile() {
            super.updateTile();
            this.pressure.pressure = this.pressureTarget * (this.negative ? -1.0f : 1.0f);
            this.nextBuilds(true).each(b -> {
                b.pressure().pressure = this.pressureTarget * (this.negative ? -1.0f : 1.0f);
            });
            this.dumpPressure();
        }

        public void write(Writes write) {
            super.write(write);
            this.pressure.write(write);
            write.f(this.pressureTarget);
            write.bool(this.negative);
        }
    }
}

