/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.power;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.struct.EnumSet;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.WeatherState;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.type.Weather;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.power.PowerGenerator;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.StatUnit;
import omaloon.graphics.Drawm;
import omaloon.type.weather.EffectWeather;

public class WindGenerator
extends PowerGenerator {
    public int spacing = 9;
    public float boostWeather = 0.25f;
    public float baseRotateSpeed = 4.0f;
    public float rotChangeTime = Mathf.randomSeed((long)this.id, (float)80.0f, (float)300.0f);

    public WindGenerator(String name) {
        super(name);
        this.flags = EnumSet.of((Enum[])new BlockFlag[0]);
        this.envEnabled = -1;
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(this.generationType);
        this.stats.add(this.generationType, this.powerProduction * 60.0f, StatUnit.powerSecond);
    }

    public void drawOverlay(float x, float y, int rotation) {
        if (this.spacing < 1) {
            return;
        }
        float size = ((float)(this.spacing * 2) + (float)this.size / 2.0f) * 8.0f;
        Drawm.dashPoly(size / 8.0f, Pal.accent, x -= size / 2.0f, y -= size / 2.0f, x + size, y, x + size, y + size, x, y + size);
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        if (this.spacing < 1) {
            return true;
        }
        int off = 1 - this.size % 2;
        for (int x = tile.x - this.spacing + off; x <= tile.x + this.spacing; ++x) {
            for (int y = tile.y - this.spacing + off; y <= tile.y + this.spacing; ++y) {
                WindGenerator s;
                Block block;
                Tile t = Vars.world.tile(x, y);
                if (t == null || !((block = t.block()) instanceof WindGenerator) || (s = (WindGenerator)block) != this && !s.intersectsSpacing(t.build.tile, tile)) continue;
                return false;
            }
        }
        return true;
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        super.drawPlanRegion(plan, list);
        Draw.mixcol();
        int off = 1 - this.size % 2;
        Tile tile = plan.tile();
        if (this.spacing < 1 || tile == null) {
            return;
        }
        for (int x = tile.x - this.spacing + off; x <= tile.x + this.spacing; ++x) {
            for (int y = tile.y - this.spacing + off; y <= tile.y + this.spacing; ++y) {
                WindGenerator s;
                Block block;
                Tile t = Vars.world.tile(x, y);
                if (t == null || !((block = t.block()) instanceof WindGenerator) || (s = (WindGenerator)block) != this && !s.intersectsSpacing(t.build.tile, tile)) continue;
                Drawf.selected((Building)t.build, (Color)Pal.remove);
            }
        }
    }

    public boolean intersectsSpacing(int sx, int sy, int ox, int oy, int ext) {
        if (this.spacing < 1) {
            return true;
        }
        int sizeOffset = 1 - (this.size & 1);
        int spacingOffset = this.spacing + ext;
        return ox >= sx + sizeOffset - spacingOffset && ox <= sx + spacingOffset && oy >= sy + sizeOffset - spacingOffset && oy <= sy + spacingOffset;
    }

    public boolean intersectsSpacing(Tile self, Tile other) {
        return this.intersectsSpacing(self.x, self.y, other.x, other.y, 0);
    }

    public void changePlacementPath(Seq<Point2> points, int rotation) {
        if (this.spacing >= 1) {
            Placement.calculateNodes(points, (Block)this, (int)rotation, (point, other) -> this.intersectsSpacing(point.x, point.y, other.x, other.y, 1));
        }
    }

    public class WindGeneratorBuild
    extends PowerGenerator.GeneratorBuild {
        public float boost;
        public float lastRotation;
        public float targetRotation;
        public float rot;
        public float nextChangeTime;
        public float startTime;

        public WindGeneratorBuild() {
            super((PowerGenerator)WindGenerator.this);
            this.baseRotation();
        }

        public void updateTile() {
            if (this.enabled) {
                this.boost = Mathf.lerpDelta((float)this.boost, (float)(!Groups.weather.isEmpty() ? 1.1f : 0.0f), (float)0.05f);
                this.productionEfficiency = 1.0f + WindGenerator.this.boostWeather * this.boost;
            }
        }

        public float baseRotation() {
            float currentTime = Time.time / WindGenerator.this.baseRotateSpeed;
            float progress = (currentTime - this.startTime) / WindGenerator.this.rotChangeTime;
            progress = Mathf.clamp((float)progress, (float)0.0f, (float)1.0f);
            WeatherState w = (WeatherState)Groups.weather.find(ws -> {
                Weather patt4290$temp = ws.weather;
                if (!(patt4290$temp instanceof EffectWeather)) return false;
                EffectWeather e = (EffectWeather)patt4290$temp;
                if (!e.useWindVector) return false;
                return true;
            });
            if (!Groups.weather.isEmpty() && w != null) {
                float windRotation = w.windVector.angle() + 90.0f;
                if (!Mathf.equal((float)this.targetRotation, (float)windRotation, (float)0.001f)) {
                    this.lastRotation = this.rot;
                    this.targetRotation = windRotation;
                    this.startTime = currentTime;
                    this.nextChangeTime = currentTime + WindGenerator.this.rotChangeTime;
                    progress = 0.0f;
                }
            } else if (currentTime > this.nextChangeTime) {
                this.lastRotation = this.rot;
                this.targetRotation = Mathf.random((float)360.0f);
                this.startTime = currentTime;
                this.nextChangeTime = currentTime + WindGenerator.this.rotChangeTime;
                progress = 0.0f;
            }
            this.rot = Mathf.lerp((float)this.lastRotation, (float)this.targetRotation, (float)progress);
            return this.rot;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.boost);
            write.f(this.lastRotation);
            write.f(this.targetRotation);
            write.f(this.rot);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.boost = read.f();
            this.lastRotation = read.f();
            this.targetRotation = read.f();
            this.rot = read.f();
        }
    }
}

