/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.environment;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.content.Fx;
import mindustry.gen.Sounds;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Prop;

public class RotatedProp
extends Prop {
    public RotatedProp(String name) {
        super(name);
        this.breakable = true;
        this.alwaysReplace = true;
        this.instantDeconstruct = true;
        this.breakEffect = Fx.breakProp;
        this.breakSound = Sounds.rockBreak;
    }

    public void drawBase(Tile tile) {
        float rot = Mathf.randomSeed((long)tile.pos(), (int)0, (int)360);
        Draw.z((float)32.0f);
        if (this.customShadowRegion.found()) {
            Draw.z((float)31.0f);
            Draw.rect((TextureRegion)this.customShadowRegion, (float)tile.worldx(), (float)tile.worldy(), (float)rot);
        }
        Draw.rect((TextureRegion)(this.variants > 0 ? this.variantRegions[Mathf.randomSeed((long)tile.pos(), (int)0, (int)Math.max(0, this.variantRegions.length - 1))] : this.region), (float)tile.worldx(), (float)tile.worldy(), (float)rot);
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region};
    }
}

