/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.environment;

import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.async.AsyncProcess;
import mindustry.world.Block;
import mindustry.world.Tile;
import omaloon.world.MultiPropGroup;
import omaloon.world.interfaces.MultiPropI;

public class CustomShapePropProcess
implements AsyncProcess {
    public static CustomShapePropProcess instance;
    public Seq<Tile> multiPropTiles = new Seq();
    public Seq<MultiPropGroup> multiProps = new Seq();

    public void init() {
        this.multiPropTiles.clear();
        this.multiProps.clear();
        for (Tile tile : Vars.world.tiles) {
            Block block = tile.block();
            if (!(block instanceof MultiPropI) || this.multiPropTiles.contains((Object)tile)) continue;
            MultiPropGroup multiProp = this.createMultiProp(tile);
            this.multiProps.add((Object)multiProp);
            this.multiPropTiles.add(multiProp.group);
            multiProp.findCenter();
            multiProp.findShape();
        }
    }

    public MultiPropGroup createMultiProp(Tile from) {
        Seq temp = Seq.with((Object[])new Tile[]{from});
        MultiPropGroup out = new MultiPropGroup(from.block());
        out.group.add((Object)from);
        while (!temp.isEmpty()) {
            Tile tile = (Tile)temp.pop();
            for (Point2 point : Geometry.d4) {
                Tile nearby = tile.nearby(point);
                if (nearby == null || !(nearby.block() instanceof MultiPropI) || out.group.contains((Object)nearby) || nearby.block() != out.type) continue;
                out.group.add((Object)nearby);
                temp.add((Object)nearby);
            }
        }
        return out;
    }

    public void process() {
        this.multiProps.each(multiProp -> {
            multiProp.update();
            if (multiProp.removed) {
                this.multiProps.remove(multiProp);
            }
        });
    }

    public void onRemoveBlock(Tile tile, Block block) {
        this.multiProps.each(multiPropGroup -> {
            if (multiPropGroup.group.contains((Object)tile)) {
                multiPropGroup.remove();
            }
        });
    }
}

