/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.environment;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Prop;
import omaloon.content.OlFx;
import omaloon.struct.BitWordList;
import omaloon.type.customshape.CustomShape;
import omaloon.utils.OlUtils;
import omaloon.world.MultiPropGroup;
import omaloon.world.blocks.environment.CustomShapePropProcess;
import omaloon.world.interfaces.MultiPropI;

public class CustomShapeProp
extends Prop
implements MultiPropI {
    public TextureRegion[] shadows;
    public TextureRegion[] shapeRegions;
    public TextureRegion[] underRegions;
    public Seq<CustomShape> shapes = new Seq();
    public Vec2[] spriteOffsets;
    public Effect deconstructEffect = OlFx.breakShapedProp;
    public boolean drawUnder;
    public boolean canMirror;
    public boolean rotateRegions;
    public float rotateRegionMagnitude = 7.5f;

    public CustomShapeProp(String name) {
        super(name);
        this.customShadow = true;
        this.alwaysReplace = false;
        this.breakEffect = Fx.breakProp;
    }

    public static CustomShape createShape(TextureRegion region) {
        PixmapRegion pixmap = Core.atlas.getPixmap(region);
        BitWordList list = new BitWordList(pixmap.width * pixmap.height, BitWordList.WordLength.two);
        OlUtils.readTexturePixels(pixmap, (color, index) -> {
            switch (color) {
                case 2815: {
                    list.set(index, (byte)3);
                    break;
                }
                case 255: {
                    list.set(index, (byte)2);
                    break;
                }
                default: {
                    list.set(index, (byte)1);
                }
            }
        });
        return new CustomShape(pixmap.width, pixmap.height, list);
    }

    public void drawBase(Tile tile) {
        MultiPropGroup multiProp = (MultiPropGroup)CustomShapePropProcess.instance.multiProps.find(multiPropGroup -> multiPropGroup.center == tile);
        if (multiProp != null) {
            Draw.z((float)this.layer);
            if (this.drawUnder) {
                Draw.rect((TextureRegion)this.underRegions[multiProp.shape], (float)(tile.worldx() + this.spriteOffsets[multiProp.shape].x), (float)(tile.worldy() + this.spriteOffsets[multiProp.shape].y), (float)(this.rotateRegions ? (float)Mathf.randomSeed((long)(tile.pos() + 1), (int)0, (int)4) * 90.0f : 0.0f));
            }
            Draw.rect((TextureRegion)this.variantRegions[multiProp.shape], (float)(tile.worldx() + this.spriteOffsets[multiProp.shape].x), (float)(tile.worldy() + this.spriteOffsets[multiProp.shape].y), (float)(this.rotateRegions ? Mathf.randomSeed((long)tile.pos(), (float)(-this.rotateRegionMagnitude), (float)this.rotateRegionMagnitude) : 0.0f));
        }
    }

    public void drawShadow(Tile tile) {
        MultiPropGroup multiProp = (MultiPropGroup)CustomShapePropProcess.instance.multiProps.find(multiPropGroup -> multiPropGroup.center == tile);
        if (multiProp != null) {
            Draw.rect((TextureRegion)this.shadows[multiProp.shape], (float)(tile.worldx() + this.spriteOffsets[multiProp.shape].x), (float)(tile.worldy() + this.spriteOffsets[multiProp.shape].y));
        }
    }

    public void load() {
        super.load();
        this.shadows = new TextureRegion[this.variants];
        this.shapeRegions = new TextureRegion[this.variants];
        this.underRegions = new TextureRegion[this.variants];
        for (int i = 0; i < this.variants; ++i) {
            this.shadows[i] = Core.atlas.find(this.name + (i + 1) + "-shadow");
            this.shapeRegions[i] = Core.atlas.find(this.name + "-shape" + (i + 1), "omaloon-shape-err");
            this.underRegions[i] = Core.atlas.find(this.name + (i + 1) + "-under");
            this.shapes.addUnique((Object)CustomShapeProp.createShape(this.shapeRegions[i]));
        }
    }

    @Override
    public Runnable removed(MultiPropGroup from) {
        return () -> this.deconstructEffect.at(from.center.worldx() + this.spriteOffsets[from.shape].x, from.center.worldy() + this.spriteOffsets[from.shape].y, 0.0f, this.mapColor, (Object)from);
    }

    @Override
    public Seq<CustomShape> shapes() {
        return this.shapes;
    }
}

