/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.distribution;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.util.Eachable;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.blocks.distribution.Junction;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;

public class TubeJunction
extends Junction {
    public DrawBlock drawer = new DrawDefault();
    public TextureRegion side1;
    public TextureRegion side2;
    protected int tempBlend = 0;

    public TubeJunction(String name) {
        super(name);
    }

    public void load() {
        super.load();
        this.drawer.load((Block)this);
        this.side1 = Core.atlas.find(this.name + "-side1");
        this.side2 = Core.atlas.find(this.name + "-side2");
        this.uiIcon = Core.atlas.find(this.name + "-icon");
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        super.drawPlanRegion(plan, list);
        this.tempBlend = 0;
        list.each(other -> {
            if (other.block != null && other.block.acceptsItems) {
                for (int i = 0; i < 4; ++i) {
                    if (other.x != plan.x + Geometry.d4x((int)i) * this.size || other.y != plan.y + Geometry.d4y((int)i) * this.size) continue;
                    this.tempBlend |= 1 << i;
                }
            }
        });
        int blending = this.tempBlend;
        float x = plan.drawx();
        float y = plan.drawy();
        Draw.rect((TextureRegion)Core.atlas.find(this.name + "-bottom"), (float)x, (float)y);
        Draw.rect((TextureRegion)this.region, (float)x, (float)y);
        for (int i = 0; i < 4; ++i) {
            if ((blending & 1 << i) != 0) continue;
            Draw.rect((TextureRegion)(i >= 2 ? this.side2 : this.side1), (float)x, (float)y, (float)(i * 90));
            if ((blending & 1 << (i + 1) % 4) != 0) {
                Draw.rect((TextureRegion)(i >= 2 ? this.side2 : this.side1), (float)x, (float)y, (float)(i * 90));
            }
            if ((blending & 1 << Mathf.mod((int)(i - 1), (int)4)) == 0) continue;
            Draw.yscl = -1.0f;
            Draw.rect((TextureRegion)(i >= 2 ? this.side2 : this.side1), (float)x, (float)y, (float)(i * 90));
            Draw.yscl = 1.0f;
        }
    }

    public class TubeJunctionBuild
    extends Junction.JunctionBuild {
        public TubeJunctionBuild() {
            super((Junction)TubeJunction.this);
        }

        public Building buildAt(int i) {
            return this.nearby(i);
        }

        public boolean valid(int i) {
            Building b = this.buildAt(i);
            return b != null && b.block.acceptsItems;
        }

        public void draw() {
            super.draw();
            TubeJunction.this.drawer.draw((Building)this);
            for (int i = 0; i < 4; ++i) {
                if (this.valid(i)) continue;
                Draw.rect((TextureRegion)(i >= 2 ? TubeJunction.this.side2 : TubeJunction.this.side1), (float)this.x, (float)this.y, (float)(i * 90));
            }
        }

        public void drawLight() {
            super.drawLight();
            TubeJunction.this.drawer.drawLight((Building)this);
        }
    }
}

