/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.distribution;

import arc.Core;
import arc.func.Boolf;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.input.Placement;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.Autotiler;
import mindustry.world.blocks.distribution.Conveyor;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.blocks.distribution.Junction;
import mindustry.world.blocks.sandbox.ItemSource;
import mindustry.world.blocks.sandbox.ItemVoid;
import mindustry.world.blocks.storage.CoreBlock;
import omaloon.content.blocks.OlDistributionBlocks;
import omaloon.utils.OlUtils;
import omaloon.world.blocks.distribution.TubeDistributor;
import omaloon.world.blocks.distribution.TubeGate;
import omaloon.world.blocks.distribution.TubeItemBridge;
import omaloon.world.blocks.distribution.TubeJunction;
import omaloon.world.blocks.distribution.TubeSorter;

public class TubeConveyor
extends Conveyor {
    private static final float itemSpace = 0.4f;
    private static final int capacity = 3;
    public static final int[][] tiles = new int[][]{new int[0], {0, 2}, {1, 3}, {0, 1}, {0, 2}, {0, 2}, {1, 2}, {0, 1, 2}, {1, 3}, {0, 3}, {1, 3}, {0, 1, 3}, {2, 3}, {0, 2, 3}, {1, 2, 3}, {0, 1, 2, 3}};
    public TextureRegion[][] topRegion;
    public TextureRegion[] capRegion;
    public Block junctionReplacement;
    public Block bridgeReplacement;

    public TubeConveyor(String name) {
        super(name);
    }

    public void init() {
        super.init();
        if (this.junctionReplacement == null) {
            this.junctionReplacement = OlDistributionBlocks.tubeJunction;
        }
        if (this.bridgeReplacement == null) {
            this.bridgeReplacement = OlDistributionBlocks.tubeBridge;
        }
    }

    public boolean validBlock(Block otherblock) {
        return otherblock instanceof TubeConveyor || otherblock instanceof TubeDistributor || otherblock instanceof TubeSorter || otherblock instanceof TubeJunction || otherblock instanceof TubeGate || otherblock instanceof TubeItemBridge || otherblock instanceof CoreBlock || otherblock instanceof ItemSource || otherblock instanceof ItemVoid;
    }

    public boolean blends(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        return otherblock instanceof TubeDistributor || (otherblock.outputsItems() || this.lookingAt(tile, rotation, otherx, othery, otherblock) && otherblock.hasItems) && this.lookingAtEither(tile, rotation, otherx, othery, otherrot, otherblock) && this.validBlock(otherblock);
    }

    public void handlePlacementLine(Seq<BuildPlan> plans) {
        if (this.bridgeReplacement == null) {
            return;
        }
        Placement.calculateBridges(plans, (ItemBridge)((TubeItemBridge)this.bridgeReplacement));
    }

    public Block getReplacement(BuildPlan req, Seq<BuildPlan> plans) {
        if (this.junctionReplacement == null) {
            return this;
        }
        Boolf cont = p -> plans.contains(o -> o.x == req.x + p.x && o.y == req.y + p.y && (req.block instanceof TubeConveyor || req.block instanceof Junction));
        return cont.get((Object)Geometry.d4((int)req.rotation)) && cont.get((Object)Geometry.d4((int)(req.rotation - 2))) && req.tile() != null && req.tile().block() instanceof TubeConveyor && Mathf.mod((int)(req.tile().build.rotation - req.rotation), (int)2) == 1 ? this.junctionReplacement : this;
    }

    public void drawPlanRegion(BuildPlan req, Eachable<BuildPlan> list) {
        super.drawPlanRegion(req, list);
        BuildPlan[] directionals = new BuildPlan[4];
        list.each(other -> {
            if (other.breaking || other == req) {
                return;
            }
            int i = 0;
            for (Point2 point : Geometry.d4) {
                int x = req.x + point.x;
                int y = req.y + point.y;
                if (x >= other.x - (other.block.size - 1) / 2 && x <= other.x + other.block.size / 2 && y >= other.y - (other.block.size - 1) / 2 && y <= other.y + other.block.size / 2 && (other.block instanceof Conveyor ? req.rotation == i || (other.rotation + 2) % 4 == i : req.rotation == i && other.block.acceptsItems || req.rotation != i && other.block.outputsItems()) && this.validBlock(other.block)) {
                    directionals[i] = other;
                }
                ++i;
            }
        });
        int mask = 0;
        for (int i = 0; i < directionals.length; ++i) {
            if (directionals[i] == null) continue;
            mask += 1 << i;
        }
        Draw.rect((TextureRegion)this.topRegion[0][mask |= 1 << req.rotation], (float)req.drawx(), (float)req.drawy(), (float)0.0f);
        for (int i : tiles[mask]) {
            if (directionals[i] != null && !(directionals[i].block instanceof Conveyor ? (directionals[i].rotation + 2) % 4 == req.rotation : req.rotation == i && !directionals[i].block.acceptsItems || req.rotation != i && !directionals[i].block.outputsItems())) continue;
            int id = i == 0 || i == 3 ? 1 : 0;
            Draw.rect((TextureRegion)this.capRegion[id], (float)req.drawx(), (float)req.drawy(), (float)(i == 0 || i == 2 ? 0.0f : -90.0f));
        }
    }

    public void load() {
        super.load();
        this.topRegion = OlUtils.splitLayers(this.name + "-sheet", 32, 2);
        this.capRegion = new TextureRegion[]{this.topRegion[1][0], this.topRegion[1][1]};
        this.uiIcon = Core.atlas.find(this.name + "-icon");
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find(this.name + "-icon-editor")};
    }

    public class TubeConveyorBuild
    extends Conveyor.ConveyorBuild {
        public int tiling;
        public int calls;

        public TubeConveyorBuild() {
            super((Conveyor)TubeConveyor.this);
            this.tiling = 0;
            this.calls = 0;
        }

        public void updateTile() {
            float nextMax;
            this.minitem = 1.0f;
            this.mid = 0;
            if (this.len == 0) {
                this.clogHeat = 0.0f;
                this.sleep();
                return;
            }
            float f = nextMax = this.aligned ? 1.0f - Math.max(0.4f - this.nextc.minitem, 0.0f) : 1.0f;
            if (this.isEnd(this.rotation)) {
                nextMax = Math.min(nextMax, 0.6f);
            }
            if (this.isEnd(OlUtils.reverse(this.rotation)) && this.blendbits == 0) {
                float nextMaxReverse = this.aligned ? (this.items.total() > 2 ? 0.5f - Math.max(0.4f - this.nextc.minitem, 0.0f) : Math.max(0.4f - this.nextc.minitem, 0.0f)) : 0.0f;
                float movedReverse = TubeConveyor.this.speed * this.edelta();
                for (int i = 0; i < this.len; ++i) {
                    float nextposReverse = (i == 0 ? 0.0f : this.ys[i - 1]) + 0.4f;
                    float maxmoveReverse = Mathf.clamp((float)(this.ys[i] - nextposReverse), (float)0.0f, (float)movedReverse);
                    int n = i;
                    this.ys[n] = this.ys[n] + maxmoveReverse;
                    if (this.ys[i] < nextMaxReverse) {
                        this.ys[i] = nextMaxReverse;
                    }
                    if (!(this.ys[i] < this.minitem)) continue;
                    this.minitem = this.ys[i];
                }
            }
            float moved = TubeConveyor.this.speed * this.edelta();
            for (int i = this.len - 1; i >= 0; --i) {
                float nextpos = (i == this.len - 1 ? 100.0f : this.ys[i + 1]) - 0.4f;
                float maxmove = Mathf.clamp((float)(nextpos - this.ys[i]), (float)0.0f, (float)moved);
                int n = i;
                this.ys[n] = this.ys[n] + maxmove;
                if (this.ys[i] > nextMax) {
                    this.ys[i] = nextMax;
                }
                if ((double)this.ys[i] > 0.5 && i > 0) {
                    this.mid = i - 1;
                }
                this.xs[i] = Mathf.approach((float)this.xs[i], (float)0.0f, (float)(moved * 2.0f));
                if (this.isEnd(this.rotation) && this.isEnd(OlUtils.reverse(this.rotation)) && this.items.total() > 1 && this.calls > 0) {
                    this.items.remove(this.ids[i], this.len - i);
                    this.len = Math.min(i, this.len);
                }
                if (this.ys[i] >= 1.0f && this.pass(this.ids[i])) {
                    if (this.aligned) {
                        this.nextc.xs[this.nextc.lastInserted] = this.xs[i];
                    }
                    this.items.remove(this.ids[i], this.len - i);
                    this.len = Math.min(i, this.len);
                    continue;
                }
                if (!(this.ys[i] < this.minitem)) continue;
                this.minitem = this.ys[i];
            }
            this.clogHeat = this.minitem < 0.4f + (this.blendbits == 1 ? 0.3f : 0.0f) || this.isEnd(OlUtils.reverse(this.rotation)) && this.items.total() >= 2 || this.isEnd(OlUtils.reverse(this.rotation)) && this.isEnd(this.rotation) && this.items.total() >= 1 ? Mathf.approachDelta((float)this.clogHeat, (float)1.0f, (float)0.016666668f) : 0.0f;
            this.noSleep();
        }

        public void updateProximity() {
            super.updateProximity();
            ++this.calls;
        }

        public Building buildAt(int i) {
            return this.nearby(i);
        }

        public boolean valid(int i) {
            Building b = this.buildAt(i);
            return b != null && (b instanceof TubeConveyorBuild ? b.front() != null && b.front() == this : b.block.acceptsItems) && (b.block instanceof TubeConveyor || b.block instanceof TubeDistributor || b.block instanceof TubeSorter || b.block instanceof TubeJunction || b.block instanceof TubeGate || b.block instanceof TubeItemBridge || b.block instanceof CoreBlock || b.block instanceof ItemSource || b.block instanceof ItemVoid);
        }

        public boolean isEnd(int i) {
            Building b = this.buildAt(i);
            return !this.valid(i) && (b == null ? null : b.block) != this.block || b instanceof Conveyor.ConveyorBuild && ((b.rotation + 2) % 4 == this.rotation || b.front() != this && this.back() == b);
        }

        public void draw() {
            int[] placementID;
            int frame = this.enabled && this.clogHeat <= 0.5f ? (int)(Time.time * TubeConveyor.this.speed * 8.0f * this.timeScale * this.efficiency % 4.0f) : 0;
            Draw.z((float)29.5f);
            for (int i = 0; i < 4; ++i) {
                if ((this.blending & 1 << i) == 0) continue;
                int dir = this.rotation - i;
                float rot = i == 0 ? (float)(this.rotation * 90) : (float)(dir * 90);
                Draw.rect((TextureRegion)TubeConveyor.this.sliced(TubeConveyor.this.regions[0][frame], i != 0 ? Autotiler.SliceMode.bottom : Autotiler.SliceMode.top), (float)(this.x + (float)(Geometry.d4x((int)dir) * 8) * 0.75f), (float)(this.y + (float)(Geometry.d4y((int)dir) * 8) * 0.75f), (float)rot);
            }
            Draw.z((float)29.75f);
            Draw.rect((TextureRegion)TubeConveyor.this.regions[this.blendbits][frame], (float)this.x, (float)this.y, (float)(8 * this.blendsclx), (float)(8 * this.blendscly), (float)(this.rotation * 90));
            Draw.z((float)29.8f);
            float layer = 29.8f;
            float wwidth = Vars.world.unitWidth();
            float wheight = Vars.world.unitHeight();
            float scaling = 0.01f;
            for (int i = 0; i < this.len; ++i) {
                Item item = this.ids[i];
                Tmp.v1.trns((float)(this.rotation * 90), 8.0f, 0.0f);
                Tmp.v2.trns((float)(this.rotation * 90), -4.0f, this.xs[i] * 8.0f / 2.0f);
                float ix = this.x + Tmp.v1.x * this.ys[i] + Tmp.v2.x;
                float iy = this.y + Tmp.v1.y * this.ys[i] + Tmp.v2.y;
                Draw.z((float)(layer + (ix / wwidth + iy / wheight) * scaling));
                Draw.rect((TextureRegion)item.fullIcon, (float)ix, (float)iy, (float)5.0f, (float)5.0f);
            }
            Draw.z((float)29.85f);
            Draw.rect((TextureRegion)TubeConveyor.this.topRegion[0][this.tiling], (float)this.x, (float)this.y, (float)0.0f);
            for (int i : placementID = tiles[this.tiling]) {
                if (!this.isEnd(i)) continue;
                int id = i == 0 || i == 3 ? 1 : 0;
                Draw.rect((TextureRegion)TubeConveyor.this.capRegion[id], (float)this.x, (float)this.y, (float)(i == 0 || i == 2 ? 0.0f : -90.0f));
            }
        }

        public void drawCracks() {
            Draw.z((float)30.0f);
            super.drawCracks();
        }

        public boolean pass(Item item) {
            if (item != null && this.next != null && this.next.team == this.team && this.next.acceptItem((Building)this, item) && (this.next.block instanceof TubeConveyor || this.next.block instanceof TubeDistributor || this.next.block instanceof TubeSorter || this.next.block instanceof TubeJunction || this.next.block instanceof TubeGate || this.next.block instanceof TubeItemBridge || this.next.block instanceof CoreBlock || this.next.block instanceof ItemSource || this.next.block instanceof ItemVoid)) {
                this.next.handleItem((Building)this, item);
                return true;
            }
            return false;
        }

        public boolean acceptItem(Building source, Item item) {
            if (this.len >= 3) {
                return false;
            }
            Tile facing = Edges.getFacingEdge((Tile)source.tile, (Tile)this.tile);
            if (facing == null) {
                return false;
            }
            int direction = Math.abs(facing.relativeTo((int)this.tile.x, (int)this.tile.y) - this.rotation);
            return (direction == 0 && this.minitem >= 0.4f || direction % 2 == 1 && this.minitem > 0.7f) && (!source.block.rotate || this.next != source) && (source.block instanceof TubeConveyor || source.block instanceof TubeDistributor || source.block instanceof TubeSorter || source.block instanceof TubeJunction || source.block instanceof TubeGate || source.block instanceof TubeItemBridge || source.block instanceof CoreBlock || source.block instanceof ItemSource || source.block instanceof ItemVoid);
        }

        public int acceptStack(Item item, int amount, Teamc source) {
            if (this.isEnd(OlUtils.reverse(this.rotation)) && this.items.total() >= 2) {
                return 0;
            }
            if (this.isEnd(OlUtils.reverse(this.rotation)) && this.isEnd(this.rotation) && this.items.total() >= 1) {
                return 0;
            }
            return Math.min((int)(this.minitem / 0.4f), amount);
        }

        public void unitOn(Unit unit) {
        }

        public void onProximityUpdate() {
            TubeConveyorBuild d;
            super.onProximityUpdate();
            this.noSleep();
            Building building = this.next = this.front();
            this.nextc = building instanceof TubeConveyorBuild ? (d = (TubeConveyorBuild)building) : null;
            this.tiling = 0;
            for (int i = 0; i < 4; ++i) {
                Building otherblock = this.nearby(i);
                if (otherblock == null || !(otherblock.block instanceof Conveyor ? this.rotation == i || (otherblock.rotation + 2) % 4 == i : this.rotation == i && otherblock.block.acceptsItems || this.rotation != i && otherblock.block.outputsItems()) || !TubeConveyor.this.validBlock(otherblock.block)) continue;
                this.tiling |= 1 << i;
            }
            this.tiling |= 1 << this.rotation;
        }
    }
}

