/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.defense;

import arc.Core;
import arc.Events;
import arc.audio.Sound;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.math.Interp;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arclibrary.graphics.EDraw;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import omaloon.OmaloonMod;
import omaloon.content.OlFx;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.PressureConfig;
import omaloon.world.modules.PressureModule;

public class Shelter
extends Block {
    public TextureRegion baseRegion;
    public TextureRegion glowRegion;
    public PressureConfig pressureConfig = new PressureConfig();
    public float configSerrations = 20.0f;
    public float shieldAngle = 120.0f;
    public float shieldHealth = 120.0f;
    public float shieldRange = 80.0f;
    public float rechargeStandard = 0.1f;
    public float rechargeBroken = 1.0f;
    public float warmupTime = 0.1f;
    public boolean useConsumerMultiplier = true;
    public float rotateSpeed = 1.0f;
    public float glowMinAlpha = 0.0f;
    public float glowMaxAlpha = 0.5f;
    public float glowBlinkSpeed = 0.16f;
    public Color deflectColor = Pal.heal;
    public Effect hitEffect = Fx.absorb;
    public Sound hitSound = Sounds.none;
    public float hitSoundVolume = 1.0f;
    public Effect rotateEffect = OlFx.shelterRotate;
    private static final FrameBuffer fieldBuffer = new FrameBuffer();
    public static final Seq<Runnable> runs = new Seq();

    public Shelter(String name) {
        super(name);
        Events.run((Object)EventType.Trigger.draw, () -> {
            fieldBuffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
            Seq buffer = runs.copy();
            runs.clear();
            Draw.draw((float)125.0f, () -> {
                Draw.flush();
                fieldBuffer.begin(Color.clear);
                buffer.each(Runnable::run);
                fieldBuffer.end();
                Draw.color((Color)this.deflectColor, (float)(Vars.renderer.animateShields ? 1.0f : (float)Core.settings.getInt("@setting.omaloon-shield-opacity", 20) / 100.0f));
                EDraw.drawBuffer(fieldBuffer);
                Draw.flush();
                Draw.color();
            });
        });
        this.update = true;
        this.solid = true;
        this.configurable = true;
        this.saveConfig = true;
        this.hasLiquids = true;
        this.group = BlockGroup.projectors;
        this.ambientSound = Sounds.shield;
        this.ambientSoundVolume = 0.08f;
        this.pressureConfig.isWhitelist = true;
        this.config(Float.class, (build, rot) -> {
            ((ShelterBuild)build).rot = rot.floatValue();
        });
        this.configClear(build -> {
            build.rot = 90.0f;
        });
    }

    public void load() {
        super.load();
        this.baseRegion = Core.atlas.find(this.name + "-base", "block-" + this.size);
        this.glowRegion = Core.atlas.find(this.name + "-glow");
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.baseRegion, this.region};
    }

    public void init() {
        super.init();
        this.clipSize = this.shieldRange * 2.0f;
    }

    public void setStats() {
        super.setStats();
        this.pressureConfig.addStats(this.stats);
        this.stats.add(Stat.shieldHealth, this.shieldHealth, StatUnit.none);
        this.stats.add(Stat.cooldownTime, (float)((int)(this.rechargeStandard * 60.0f)), StatUnit.perSecond);
    }

    public void setBars() {
        super.setBars();
        this.pressureConfig.addBars(this);
        this.addBar("shield", entity -> new Bar("stat.shieldhealth", Pal.accent, () -> entity.broken ? 0.0f : 1.0f - entity.shieldDamage / this.shieldHealth).blink(Color.white));
    }

    public void drawOverlay(float x, float y, int rotation) {
        Drawf.dashCircle((float)x, (float)y, (float)this.shieldRange, (Color)Pal.accent);
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.baseRegion, (float)plan.drawx(), (float)plan.drawy());
        float rot = plan.config instanceof Float ? ((Float)plan.config).floatValue() : 0.0f;
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy(), (float)(rot - 90.0f));
    }

    public class ShelterBuild
    extends Building
    implements HasPressure {
        public PressureModule pressure = new PressureModule();
        public float rot = 90.0f;
        public float shieldDamage = 0.0f;
        public float warmup = 0.0f;
        public boolean broken = false;
        public float configureWarmup = 0.0f;

        public Float config() {
            return Float.valueOf(this.rot);
        }

        public void draw() {
            this.configureWarmup = Mathf.approachDelta((float)this.configureWarmup, (float)0.0f, (float)0.014f);
            Draw.rect((TextureRegion)Shelter.this.baseRegion, (float)this.x, (float)this.y, (float)0.0f);
            Draw.rect((TextureRegion)Shelter.this.region, (float)this.x, (float)this.y, (float)(this.rot - 90.0f));
            float z = Draw.z();
            Draw.z((float)31.0f);
            Draw.blend((Blending)Blending.additive);
            Draw.color((Color)Color.valueOf((String)"cbffc2"));
            float cycleAlpha = Shelter.this.glowMinAlpha + (Shelter.this.glowMaxAlpha - Shelter.this.glowMinAlpha) * (0.5f + 0.5f * Mathf.sin((float)(Time.time * Shelter.this.glowBlinkSpeed)));
            Draw.alpha((float)(this.warmup * cycleAlpha));
            Draw.rect((TextureRegion)Shelter.this.glowRegion, (float)this.x, (float)this.y, (float)(this.rot - 90.0f));
            Draw.reset();
            Draw.blend();
            Draw.z((float)z);
            runs.add(() -> {
                Draw.color();
                Fill.circle((float)this.x, (float)this.y, (float)(this.warmup * (this.hitSize() * 1.2f)));
                Fill.arc((float)this.x, (float)this.y, (float)(Shelter.this.shieldRange * this.warmup), (float)(Shelter.this.shieldAngle / 360.0f), (float)(-Shelter.this.shieldAngle / 2.0f + this.rot));
                Draw.color();
            });
            Draw.z((float)35.0f);
            float mousex = Core.input.mouseWorldX();
            float mousey = Core.input.mouseWorldY();
            Draw.color((Color)Pal.accent, (float)(Interp.circle.apply(this.configureWarmup) * (float)Core.settings.getInt("@setting.omaloon-shield-opacity", 20) / 100.0f));
            Fill.arc((float)this.x, (float)this.y, (float)(Shelter.this.shieldRange * Interp.circle.apply(this.configureWarmup)), (float)(Shelter.this.shieldAngle / 360.0f), (float)(-Shelter.this.shieldAngle / 2.0f + Core.input.mouseWorld().angleTo(this.x, this.y) + 180.0f));
            int i = 0;
            while ((float)i < Shelter.this.configSerrations) {
                Tmp.v1.trns(360.0f / Shelter.this.configSerrations * (float)i, (float)Shelter.this.size * 8.0f).nor();
                float dot = Mathf.maxZero((float)Tmp.v1.dot(Tmp.v2.set(mousex - this.x, mousey - this.y).nor()));
                Tmp.v1.trns(360.0f / Shelter.this.configSerrations * (float)i, (float)Shelter.this.size * 8.0f);
                Lines.stroke((float)(2.0f * Interp.circle.apply(this.configureWarmup)), (Color)Pal.accent);
                Lines.lineAngle((float)(Tmp.v1.x + this.x), (float)(Tmp.v1.y + this.y), (float)Tmp.v1.angle(), (float)((0.5f + 3.0f * Interp.circleIn.apply(dot)) * Interp.circle.apply(this.configureWarmup)));
                ++i;
            }
        }

        public void drawConfigure() {
            this.configureWarmup = Mathf.approachDelta((float)this.configureWarmup, (float)1.0f, (float)0.028f);
        }

        public float edelta() {
            return super.edelta() * this.efficiencyMultiplier();
        }

        public float efficiencyMultiplier() {
            float val = 1.0f;
            if (!Shelter.this.useConsumerMultiplier) {
                return val;
            }
            for (Consume consumer : Shelter.this.consumers) {
                val *= consumer.efficiencyMultiplier((Building)this);
            }
            return val;
        }

        public boolean onConfigureTapped(float x, float y) {
            this.configure(Float.valueOf(Tmp.v1.set(this.x, this.y).angleTo(x, y)));
            Shelter.this.rotateEffect.at(this.x, this.y, this.rot, (Object)this.block);
            return false;
        }

        @Override
        public PressureModule pressure() {
            return this.pressure;
        }

        @Override
        public PressureConfig pressureConfig() {
            return Shelter.this.pressureConfig;
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.pressure.read(read);
            this.rot = read.f();
            this.shieldDamage = read.f();
            this.warmup = read.f();
            this.broken = read.bool();
        }

        public void updateTile() {
            this.updatePressure();
            this.dumpPressure();
            if (this.efficiency > 0.0f) {
                if (this.shieldDamage >= 0.0f) {
                    this.shieldDamage -= this.edelta() * (this.broken ? Shelter.this.rechargeBroken : Shelter.this.rechargeStandard);
                } else {
                    this.broken = false;
                }
                if (this.broken) {
                    this.warmup = Mathf.approachDelta((float)this.warmup, (float)0.0f, (float)Shelter.this.warmupTime);
                } else {
                    this.warmup = Mathf.approachDelta((float)this.warmup, (float)this.efficiency, (float)Shelter.this.warmupTime);
                    Groups.bullet.intersect(this.x - Shelter.this.shieldRange - OmaloonMod.shieldBuffer, this.y - Shelter.this.shieldRange - OmaloonMod.shieldBuffer, (Shelter.this.shieldRange + OmaloonMod.shieldBuffer) * 2.0f, (Shelter.this.shieldRange + OmaloonMod.shieldBuffer) * 2.0f, b -> {
                        if (b.team == Team.derelict) {
                            boolean inWarmupRadius;
                            float distance = Mathf.dst((float)this.x, (float)this.y, (float)b.x, (float)b.y);
                            float angle = Math.abs(((b.angleTo(this.x, this.y) - this.rot) % 360.0f + 360.0f) % 360.0f - 180.0f);
                            boolean bl = inWarmupRadius = distance <= this.warmup * (this.hitSize() * 1.4f);
                            if (distance <= Shelter.this.shieldRange * this.warmup + b.type.splashDamageRadius && angle <= Shelter.this.shieldAngle / 2.0f || inWarmupRadius) {
                                b.absorb();
                                Shelter.this.hitEffect.at(b.x, b.y, b.hitSize);
                                Shelter.this.hitSound.at(b.x, b.y, Mathf.random((float)0.9f, (float)1.1f), Shelter.this.hitSoundVolume);
                                this.shieldDamage += b.damage;
                                if (this.shieldDamage >= Shelter.this.shieldHealth) {
                                    this.broken = true;
                                }
                            }
                        }
                    });
                }
            } else {
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)0.0f, (float)Shelter.this.warmupTime);
            }
        }

        public byte version() {
            return 1;
        }

        public void write(Writes write) {
            super.write(write);
            this.pressure.write(write);
            write.f(this.rot);
            write.f(this.shieldDamage);
            write.f(this.warmup);
            write.bool(this.broken);
        }
    }
}

