/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.defense;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.Ranged;
import mindustry.world.Block;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class RepairProjector
extends Block {
    static final float refreshInterval = 6.0f;
    public float range = 80.0f;
    public Color baseColor = Pal.heal.a(25.0f);
    public float healWaveSpeed = 120.0f;
    public float reload = 20.0f;
    public float healAmount = 1.0f;
    public TextureRegion top;

    public RepairProjector(String name) {
        super(name);
        this.update = true;
        this.solid = true;
    }

    public void load() {
        super.load();
        this.top = Core.atlas.find(this.name + "-top");
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.range, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.repairSpeed, this.healAmount * 60.0f, StatUnit.perSecond);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.range, (Color)Pal.placing);
    }

    public class RepairTowerBuild
    extends Building
    implements Ranged {
        public float refresh = Mathf.random((float)6.0f);
        public float warmup = 0.0f;
        public float totalProgress = 0.0f;
        public float charge;
        public Seq<Building> buildingTargets;
        public Seq<Unit> unitTargets;

        public RepairTowerBuild() {
            this.charge = Mathf.random((float)RepairProjector.this.reload);
            this.buildingTargets = new Seq();
            this.unitTargets = new Seq();
        }

        public void updateTile() {
            if (this.potentialEfficiency > 0.0f) {
                float f;
                this.refresh += Time.delta;
                if (f >= 6.0f) {
                    this.unitTargets.clear();
                    this.buildingTargets.clear();
                    this.refresh = 0.0f;
                    Vars.indexer.eachBlock(this.team, Tmp.r1.setCentered(this.x, this.y, this.range() * 2.0f), b -> b.damaged() && !b.isHealSuppressed(), arg_0 -> this.buildingTargets.add(arg_0));
                    Units.nearby((Team)this.team, (float)this.x, (float)this.y, (float)this.range(), u -> {
                        if (u.damaged()) {
                            this.unitTargets.add(u);
                        }
                    });
                }
            }
            this.charge += this.delta();
            if (this.charge >= RepairProjector.this.reload && this.efficiency > 0.0f) {
                this.charge = 0.0f;
                for (Building bTarget : this.buildingTargets) {
                    if (!bTarget.damaged()) continue;
                    bTarget.heal(RepairProjector.this.healAmount * this.efficiency);
                    Fx.healBlockFull.at(bTarget.x, bTarget.y, (float)bTarget.block.size, RepairProjector.this.baseColor, (Object)bTarget.block);
                }
                for (Unit uTarget : this.unitTargets) {
                    if (!uTarget.damaged()) continue;
                    uTarget.heal(RepairProjector.this.healAmount * this.efficiency);
                }
            }
            this.warmup = Mathf.lerpDelta((float)this.warmup, (float)(this.shouldConsume() ? this.efficiency : 0.0f), (float)0.08f);
            this.totalProgress += Time.delta / RepairProjector.this.healWaveSpeed;
        }

        public boolean shouldConsume() {
            return this.buildingTargets.size + this.unitTargets.size > 0;
        }

        public void draw() {
            super.draw();
            if (this.warmup <= 0.001f) {
                return;
            }
            float f = 1.0f - Time.time / 100.0f % 1.0f;
            Draw.color((Color)RepairProjector.this.baseColor);
            Draw.alpha((float)(Mathf.absin((float)Time.time, (float)7.957747f, (float)1.0f) * 0.5f));
            Draw.rect((TextureRegion)RepairProjector.this.top, (float)this.x, (float)this.y);
            Draw.alpha((float)1.0f);
            Lines.stroke((float)(2.0f * f * this.warmup));
            Lines.square((float)this.x, (float)this.y, (float)Math.min(1.0f + (1.0f - f) * (float)RepairProjector.this.size * 8.0f / 2.0f, (float)(RepairProjector.this.size * 8) / 2.0f));
        }

        public float range() {
            return RepairProjector.this.range;
        }

        public float warmup() {
            return this.warmup;
        }

        public void drawSelect() {
            Vars.indexer.eachBlock((Teamc)this, RepairProjector.this.range, other -> true, other -> Drawf.selected((Building)other, (Color)Tmp.c1.set(RepairProjector.this.baseColor).a(Mathf.absin((float)4.0f, (float)1.0f))));
            Units.nearby((Team)this.team, (float)this.x, (float)this.y, (float)this.range(), u -> {
                Draw.color((Color)RepairProjector.this.baseColor.a(Mathf.absin((float)4.0f, (float)1.0f)));
                Lines.square((float)u.x, (float)u.y, (float)u.hitSize, (float)45.0f);
            });
            Drawf.dashCircle((float)this.x, (float)this.y, (float)RepairProjector.this.range, (Color)Pal.placing);
        }
    }
}

