/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.defense;

import arc.graphics.Color;
import arc.math.geom.Position;
import arc.struct.ObjectMap;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Bullets;
import mindustry.entities.bullet.BulletType;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.PressureConfig;
import omaloon.world.modules.PressureModule;

public class ConsumeTurret
extends Turret {
    public PressureConfig pressureConfig = new PressureConfig();
    public boolean minRangeShoot = true;
    public BulletType shootType = Bullets.placeholder;

    public ConsumeTurret(String name) {
        super(name);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        if (!this.minRangeShoot) {
            Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.minRange, (Color)Pal.placing);
        }
    }

    public void setStats() {
        super.setStats();
        this.pressureConfig.addStats(this.stats);
    }

    public void setBars() {
        super.setBars();
        this.pressureConfig.addBars((Block)this);
        this.stats.add(Stat.ammo, StatValues.ammo((ObjectMap)ObjectMap.of((Object[])new Object[]{this, this.shootType})));
    }

    public class ConsumeTurretBuild
    extends Turret.TurretBuild
    implements HasPressure {
        public PressureModule pressure;

        public ConsumeTurretBuild() {
            super((Turret)ConsumeTurret.this);
            this.pressure = new PressureModule();
        }

        public void drawSelect() {
            super.drawSelect();
            if (!ConsumeTurret.this.minRangeShoot) {
                Drawf.dashCircle((float)this.x, (float)this.y, (float)ConsumeTurret.this.minRange, (Color)this.team.color);
            }
        }

        protected void findTarget() {
            super.findTarget();
            if (this.target != null && this.dst((Position)this.target) < ConsumeTurret.this.minRange && !ConsumeTurret.this.minRangeShoot) {
                this.target = null;
            }
        }

        public boolean hasAmmo() {
            return this.canConsume();
        }

        public BulletType peekAmmo() {
            return ConsumeTurret.this.shootType;
        }

        @Override
        public PressureModule pressure() {
            return this.pressure;
        }

        @Override
        public PressureConfig pressureConfig() {
            return ConsumeTurret.this.pressureConfig;
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.pressure.read(read);
        }

        protected void shoot(BulletType type) {
            super.shoot(type);
            this.consume();
        }

        public void updateTile() {
            this.updatePressure();
            this.dumpPressure();
            super.updateTile();
        }

        public BulletType useAmmo() {
            return ConsumeTurret.this.shootType;
        }

        public void write(Writes write) {
            super.write(write);
            this.pressure.write(write);
        }
    }
}

