/*
 * Decompiled with CFR 0.152.
 */
package omaloon.ui.fragments;

import arc.Core;
import arc.KeyBinds;
import arc.graphics.Color;
import arc.input.KeyCode;
import arc.math.Interp;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.event.EventListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.ui.Styles;
import omaloon.OmaloonMod;
import omaloon.ui.OlBinding;
import omaloon.world.blocks.environment.OlCliff;

public class CliffFragment
extends Table {
    private Table layout;
    private boolean enabled;
    private final Color col = Color.valueOf((String)"645654");

    public CliffFragment() {
        this.setFillParent(true);
        this.visible(() -> Vars.ui.hudfrag.shown && OmaloonMod.editorListener.isEditor());
        this.touchable(() -> this.enabled && this.visible ? Touchable.enabled : Touchable.disabled);
        this.left();
        this.layout = new Table(Styles.black5, t -> {
            t.table(title -> {
                title.image((Drawable)Icon.treeSmall).size(15.0f).center().padRight(15.0f).color(this.col);
                title.label(() -> "@fragment.omaloon.cliff-placer").grow();
                title.image((Drawable)Icon.treeSmall).size(15.0f).center().padLeft(15.0f).color(this.col);
            }).growX().padBottom(10.0f).row();
            t.table(Styles.black3, buttons -> {
                buttons.button("@ui.omaloon-process-cliffs", (Drawable)Icon.play, Styles.nonet, OlCliff::processCliffs).growX().height(50.0f).pad(5.0f).row();
                buttons.button("@ui.omaloon-un-process-cliffs", (Drawable)Icon.undo, Styles.nonet, OlCliff::unProcessCliffs).growX().height(50.0f).pad(5.0f);
            }).growX();
        });
        this.add((Element)this.layout).margin(10.0f);
    }

    public void build(Group parent) {
        this.layout.actions(new Action[]{Actions.alpha((float)0.0f)});
        parent.addChildAt(0, (Element)this);
        if (!Vars.mobile) {
            Core.scene.addListener((EventListener)new InputListener(){

                public boolean keyDown(InputEvent event, KeyCode keycode) {
                    if (Core.input.keyTap((KeyBinds.KeyBind)OlBinding.cliff_placer) && CliffFragment.this.visible) {
                        CliffFragment.this.toggle();
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    private void toggle() {
        if (!this.visible || this.layout.hasActions()) {
            return;
        }
        boolean bl = this.enabled = !this.enabled;
        if (this.enabled) {
            this.layout.actions(new Action[]{Actions.moveBy((float)(-this.layout.getWidth()), (float)0.0f), Actions.parallel((Action)Actions.alpha((float)1.0f, (float)0.3f, (Interp)Interp.pow3Out), (Action)Actions.moveBy((float)this.layout.getWidth(), (float)0.0f, (float)0.3f, (Interp)Interp.pow3Out))});
        } else {
            this.layout.actions(new Action[]{Actions.parallel((Action)Actions.moveBy((float)(-this.layout.getWidth()), (float)0.0f, (float)0.3f, (Interp)Interp.pow3Out), (Action)Actions.alpha((float)0.0f, (float)0.3f, (Interp)Interp.pow3Out)), Actions.moveBy((float)this.layout.getWidth(), (float)0.0f)});
        }
    }
}

