/*
 * Decompiled with CFR 0.152.
 */
package omaloon.ui.dialogs;

import arc.Core;
import arc.func.Boolp;
import arc.struct.Seq;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.ui.fragments.HintsFragment;
import mindustry.world.consumers.Consume;
import omaloon.content.blocks.OlCraftingBlocks;
import omaloon.content.blocks.OlDefenceBlocks;
import omaloon.content.blocks.OlDistributionBlocks;
import omaloon.content.blocks.OlProductionBlocks;
import omaloon.world.consumers.PressureEfficiencyRange;
import omaloon.world.interfaces.HasPressure;

public enum EventHints implements HintsFragment.Hint
{
    drill_positive_pressure(() -> false, () -> Vars.state.teams.get(Vars.state.rules.defaultTeam).getBuildings(OlProductionBlocks.hammerDrill).find(b -> ((HasPressure)b).getPressure() > 0.0f) != null),
    press_or_shelter_negative_pressure(() -> false, () -> Vars.state.teams.get(Vars.state.rules.defaultTeam).getBuildings(OlCraftingBlocks.carborundumPress).find(b -> ((HasPressure)b).getPressure() < 0.0f) != null || Vars.state.teams.get(Vars.state.rules.defaultTeam).getBuildings(OlDefenceBlocks.smallShelter).find(b -> ((HasPressure)b).getPressure() < 0.0f) != null),
    pump_positive(() -> false, () -> Vars.state.teams.get((Team)Vars.state.rules.defaultTeam).buildings.contains(b -> {
        if (b instanceof HasPressure) {
            HasPressure pressureBuilding = (HasPressure)b;
            for (Consume consumer : b.block().consumers) {
                if (!(consumer instanceof PressureEfficiencyRange)) continue;
                PressureEfficiencyRange rangeConsumer = (PressureEfficiencyRange)consumer;
                return pressureBuilding.getPressure() > 0.0f && rangeConsumer.shouldConsume(pressureBuilding);
            }
        }
        return false;
    })),
    pump_negative(() -> false, () -> Vars.state.teams.get((Team)Vars.state.rules.defaultTeam).buildings.contains(b -> {
        if (b instanceof HasPressure) {
            HasPressure pressureBuilding = (HasPressure)b;
            for (Consume consumer : b.block().consumers) {
                if (!(consumer instanceof PressureEfficiencyRange)) continue;
                PressureEfficiencyRange rangeConsumer = (PressureEfficiencyRange)consumer;
                return pressureBuilding.getPressure() < 0.0f && rangeConsumer.shouldConsume(pressureBuilding);
            }
        }
        return false;
    })),
    pump(() -> false, () -> !Vars.state.teams.get(Vars.state.rules.defaultTeam).getBuildings(OlDistributionBlocks.liquidPump).isEmpty()),
    valve(() -> false, () -> !Vars.state.teams.get(Vars.state.rules.defaultTeam).getBuildings(OlDistributionBlocks.liquidValve).isEmpty(), pump),
    low_pressure(() -> !Vars.state.teams.get(Vars.state.rules.defaultTeam).getBuildings(OlDistributionBlocks.liquidValve).isEmpty(), () -> Vars.state.teams.get((Team)Vars.state.rules.defaultTeam).buildings.contains(b -> {
        HasPressure pressure;
        return b instanceof HasPressure && (pressure = (HasPressure)b).getPressure() < 0.0f;
    }));

    final Boolp complete;
    Boolp shown = () -> true;
    EventHints[] requirements;
    int visibility = 3;
    boolean cached;
    boolean finished;
    static final String prefix = "omaloon-";

    public static void addHints() {
        Vars.ui.hints.hints.add(Seq.with((Object[])EventHints.values()).removeAll(hint -> Core.settings.getBool(prefix + hint.name() + "-hint-done", false)));
    }

    private EventHints(Boolp complete) {
        this.complete = complete;
    }

    private EventHints(Boolp complete, Boolp shown) {
        this(complete);
        this.shown = shown;
    }

    private EventHints(Boolp complete, Boolp shown, EventHints ... requirements) {
        this(complete, shown);
        this.requirements = requirements;
    }

    public boolean complete() {
        return this.complete.get();
    }

    public void finish() {
        this.finished = true;
        Core.settings.put(prefix + this.name() + "-hint-done", (Object)true);
    }

    public boolean finished() {
        if (!this.cached) {
            this.cached = true;
            this.finished = Core.settings.getBool(prefix + this.name() + "-hint-done", false);
        }
        return this.finished;
    }

    public int order() {
        return this.ordinal();
    }

    public static void reset() {
        for (EventHints hint : EventHints.values()) {
            hint.finished = false;
            Core.settings.put(prefix + hint.name() + "-hint-done", (Object)false);
        }
        EventHints.addHints();
    }

    public boolean show() {
        return this.shown.get() && (this.requirements == null || this.requirements.length == 0 || !Structs.contains((Object[])this.requirements, d -> !d.finished()));
    }

    public String text() {
        return Core.bundle.get("hint.omaloon-" + this.name(), "Missing bundle for hint: hint.omaloon-" + this.name());
    }

    public boolean valid() {
        return Vars.mobile && (this.visibility & 2) != 0 || !Vars.mobile && (this.visibility & 1) != 0;
    }
}

