/*
 * Decompiled with CFR 0.152.
 */
package omaloon.ui;

import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.type.Item;

public class MultiItemData {
    private final Seq<Item> items = new Seq();

    public int length() {
        return this.items.size;
    }

    public IntSet asIntSet() {
        IntSet seq = new IntSet();
        this.items.forEach(i -> seq.add((int)i.id));
        return seq;
    }

    public void write(Writes writes) {
        writes.i(this.items.size);
        this.items.forEach(item -> writes.str(item.name));
    }

    public void read(Reads reads) {
        int len = reads.i();
        for (int i = 0; i < len; ++i) {
            this.toggle(reads.str());
        }
    }

    public int[] config() {
        int[] config = new int[this.items.size];
        for (int i = 0; i < config.length; ++i) {
            config[i] = ((Item)this.items.get((int)i)).id;
        }
        return config;
    }

    public boolean isToggled(Item item) {
        return this.items.contains((Object)item);
    }

    public boolean isToggled(String name) {
        return this.isToggled(Vars.content.item(name));
    }

    public boolean isToggled(int id) {
        return this.isToggled(Vars.content.item(id));
    }

    public void toggle(Item item) {
        if (item != null) {
            if (this.items.contains((Object)item)) {
                this.items.remove((Object)item);
            } else {
                this.items.add((Object)item);
            }
        }
    }

    public void toggle(String name) {
        this.toggle(Vars.content.item(name));
    }

    public void toggle(int id) {
        this.toggle(Vars.content.item(id));
    }

    public void clear() {
        this.items.clear();
    }

    public void enable(Item item) {
        if (!this.items.contains((Object)item)) {
            this.items.add((Object)item);
        }
    }

    public void disable(Item item) {
        if (this.items.contains((Object)item)) {
            this.items.remove((Object)item);
        }
    }

    public Seq<Item> getItems() {
        return this.items;
    }
}

