/*
 * Decompiled with CFR 0.152.
 */
package omaloon.type.liquid;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.gen.Puddle;
import mindustry.type.Liquid;

public class CrystalLiquid
extends Liquid {
    public Color colorFrom = Color.white.cpy();
    public Color colorTo = Color.white.cpy();
    public int cells = 18;

    public CrystalLiquid(String name, Color color) {
        super(name, color);
    }

    public void drawPuddle(Puddle puddle) {
        super.drawPuddle(puddle);
        Draw.z((float)19.5f);
        int id = puddle.id;
        float amount = puddle.amount;
        float x = puddle.x;
        float y = puddle.y;
        float f = Mathf.clamp((float)(amount / 46.666668f));
        float smag = puddle.tile.floor().isLiquid ? 0.8f : 0.0f;
        float sscl = 25.0f;
        float length = Math.max(f, 0.3f) * 8.0f;
        Draw.color((Color)Tmp.c1.set(this.color).shiftValue(-0.05f));
        Fill.poly((float)(x + Mathf.sin((float)(Time.time + (float)(id * 5)), (float)sscl, (float)smag)), (float)(y + Mathf.sin((float)(Time.time + (float)(id * 3)), (float)sscl, (float)smag)), (int)6, (float)(f * 8.6f));
        rand.setSeed((long)id);
        for (int i = 0; i < this.cells; ++i) {
            Draw.z((float)(19.5f + (float)i / 1000.0f + (float)(id % 100) / 10000.0f));
            Tmp.v1.trns(rand.random(360.0f), rand.random(length));
            float vx = x + Tmp.v1.x;
            float vy = y + Tmp.v1.y;
            Draw.color((Color)this.colorFrom, (Color)this.colorTo, (float)rand.random(1.0f));
            Fill.poly((float)(vx + Mathf.sin((float)(Time.time + (float)(i * 53)), (float)sscl, (float)smag)), (float)(vy + Mathf.sin((float)(Time.time + (float)(i * 3)), (float)sscl, (float)smag)), (int)6, (float)(f * 3.8f * rand.random(0.2f, 1.0f) * Mathf.absin((float)(Time.time + (float)((i + id) % 60 * 54)), (float)(75.0f * rand.random(1.0f, 2.0f)), (float)1.0f)));
        }
        Draw.color();
    }
}

