/*
 * Decompiled with CFR 0.152.
 */
package omaloon.type;

import arc.Core;
import arc.func.Func;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.util.Strings;
import mindustry.content.Bullets;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.ui.Styles;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class FilterWeapon
extends Weapon {
    public BulletType[] bullets = new BulletType[]{Bullets.placeholder};
    public Func<Unit, BulletType> bulletFilter = unit -> this.bullets[0];
    public TextureRegion[] iconRegions;
    public String[] icons = new String[]{""};

    public void addStats(UnitType u, Table t) {
        if (this.inaccuracy > 0.0f) {
            t.row();
            t.add((CharSequence)("[lightgray]" + Stat.inaccuracy.localized() + ": [white]" + (int)this.inaccuracy + " " + StatUnit.degrees.localized()));
        }
        if (!this.alwaysContinuous && this.reload > 0.0f) {
            t.row();
            t.add((CharSequence)("[lightgray]" + Stat.reload.localized() + ": " + (this.mirror ? "2x " : "") + "[white]" + Strings.autoFixed((float)(60.0f / this.reload * (float)this.shoot.shots), (int)2) + " " + StatUnit.perSecond.localized()));
        }
        t.row();
        t.table(Styles.grayPanel, weapon -> {
            int i = 0;
            while (i < this.bullets.length) {
                int finalI = i++;
                weapon.table(Tex.underline, b -> {
                    b.left();
                    if (this.iconRegions[finalI].found()) {
                        b.image(this.iconRegions[finalI]).padRight(10.0f).center();
                    }
                    StatValues.ammo((ObjectMap)ObjectMap.of((Object[])new Object[]{u, this.bullets[finalI]})).display((Table)b.add((Element)new Table()).get());
                }).growX().row();
            }
        }).margin(10.0f);
    }

    public void load() {
        super.load();
        this.iconRegions = new TextureRegion[this.bullets.length];
        for (int i = 0; i < this.iconRegions.length; ++i) {
            this.iconRegions[i] = i < this.icons.length ? Core.atlas.find(this.icons[i]) : Core.atlas.find("error");
        }
    }

    protected void shoot(Unit unit, WeaponMount mount, float shootX, float shootY, float rotation) {
        this.bullet = (BulletType)this.bulletFilter.get((Object)unit);
        super.shoot(unit, mount, shootX, shootY, rotation);
    }
}

