/*
 * Decompiled with CFR 0.152.
 */
package omaloon.type;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Gl;
import arc.graphics.Mesh;
import arc.graphics.Texture;
import arc.graphics.g3d.Camera3D;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.Shader;
import arc.math.geom.Mat3D;
import arc.math.geom.Vec3;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.GenericMesh;
import mindustry.graphics.g3d.HexMesher;
import mindustry.graphics.g3d.MeshBuilder;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.type.Planet;
import omaloon.graphics.OlShaders;
import omaloon.graphics.shaders.DepthAtmosphereShader;
import omaloon.graphics.shaders.DepthShader;

public class BetterPlanet
extends Planet {
    @Nullable
    public FrameBuffer depthBuffer;

    public BetterPlanet(String name, Planet parent, float radius) {
        super(name, parent, radius);
    }

    public BetterPlanet(String name, Planet parent, float radius, int sectorSize) {
        super(name, parent, radius, sectorSize);
    }

    public void load() {
        super.load();
        if (!Vars.headless) {
            this.depthBuffer = new FrameBuffer(Core.graphics.getWidth(), Core.graphics.getHeight(), true);
            ((Texture)this.depthBuffer.getTexture()).setFilter(Texture.TextureFilter.nearest);
        }
    }

    public void drawAtmosphere(Mesh atmosphere, Camera3D cam) {
        Gl.depthMask((boolean)false);
        Blending.additive.apply();
        DepthAtmosphereShader shader = OlShaders.depthAtmosphere;
        shader.camera = cam;
        shader.planet = this;
        shader.bind();
        shader.apply();
        atmosphere.render((Shader)shader, 4);
        Blending.normal.apply();
        Gl.depthMask((boolean)true);
    }

    public class AtmosphereHexMesh
    implements GenericMesh {
        protected Mesh mesh;

        public AtmosphereHexMesh(HexMesher mesher, int divisions) {
            this.mesh = MeshBuilder.buildHex((HexMesher)mesher, (int)divisions, (boolean)false, (float)BetterPlanet.this.radius, (float)0.2f);
        }

        public AtmosphereHexMesh(int divisions) {
            this((HexMesher)this$0.generator, divisions);
        }

        public void render(PlanetParams params, Mat3D projection, Mat3D transform) {
            if (params.alwaysDrawAtmosphere || Core.settings.getBool("atmosphere")) {
                DepthShader depth = OlShaders.depth;
                BetterPlanet.this.depthBuffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
                BetterPlanet.this.depthBuffer.begin(Tmp.c1.set(-256));
                Blending.disabled.apply();
                depth.camera = Vars.renderer.planets.cam;
                depth.bind();
                depth.setUniformMatrix4("u_proj", projection.val);
                depth.setUniformMatrix4("u_trans", transform.val);
                depth.apply();
                this.mesh.render((Shader)depth, 4);
                Blending.normal.apply();
                BetterPlanet.this.depthBuffer.end();
            }
            Shaders.PlanetShader shader = Shaders.planet;
            shader.planet = BetterPlanet.this;
            shader.lightDir.set(BetterPlanet.this.solarSystem.position).sub(BetterPlanet.this.position).rotate(Vec3.Y, BetterPlanet.this.getRotation()).nor();
            shader.ambientColor.set(BetterPlanet.this.solarSystem.lightColor);
            shader.bind();
            shader.setUniformMatrix4("u_proj", projection.val);
            shader.setUniformMatrix4("u_trans", transform.val);
            shader.apply();
            this.mesh.render((Shader)shader, 4);
        }
    }
}

