/*
 * Decompiled with CFR 0.152.
 */
package omaloon.maps;

import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Vec3;
import arc.struct.Seq;
import arc.util.noise.Simplex;

public abstract class HeightPass {
    public abstract float height(Vec3 var1, float var2);

    public boolean valid(Vec3 pos, float height) {
        return true;
    }

    public static class MultiHeight
    extends HeightPass {
        public Seq<HeightPass> heights;
        public MixType mixType;
        public Operation operation;

        public MultiHeight(Seq<HeightPass> heights, MixType mixType, Operation operation) {
            this.heights = heights;
            this.mixType = mixType;
            this.operation = operation;
        }

        @Override
        public float height(Vec3 pos, float height) {
            if (!this.valid(pos, height)) {
                return height;
            }
            switch (this.operation) {
                case add: {
                    return height + this.rawHeight(pos, height);
                }
                case set: {
                    return this.rawHeight(pos, height);
                }
                case carve: {
                    return height - this.rawHeight(pos, height);
                }
            }
            return height;
        }

        float rawHeight(Vec3 pos, float base) {
            switch (this.mixType) {
                case max: {
                    return ((HeightPass)this.heights.select(pass -> pass.valid(pos, base)).max(pass -> pass.height(pos, base))).height(pos, base);
                }
                case average: {
                    return this.heights.select(pass -> pass.valid(pos, base)).sumf(pass -> pass.height(pos, base)) / (float)this.heights.size;
                }
                case min: {
                    return ((HeightPass)this.heights.select(pass -> pass.valid(pos, base)).min(pass -> pass.height(pos, base))).height(pos, base);
                }
            }
            return 0.0f;
        }

        @Override
        public boolean valid(Vec3 pos, float height) {
            return this.heights.contains(pass -> pass.valid(pos, height));
        }

        public static enum MixType {
            max,
            average,
            min;

        }

        public static enum Operation {
            add,
            set,
            carve;

        }
    }

    public static class DotHeight
    extends HeightPass {
        public Vec3 dir = new Vec3();
        public float min = -1.0f;
        public float max = 1.0f;
        public boolean map = true;
        public Interp interp = Interp.linear;
        public float magnitude = 1.0f;

        @Override
        public float height(Vec3 pos, float height) {
            if (!this.valid(pos, height)) {
                return height;
            }
            float dot = this.dir.nor().dot(pos);
            dot = Mathf.map((float)dot, (float)(this.map ? this.min : -1.0f), (float)(this.map ? this.max : 1.0f), (float)0.0f, (float)1.0f);
            return this.interp.apply(dot) * this.magnitude + height;
        }

        @Override
        public boolean valid(Vec3 pos, float height) {
            float dot = this.dir.nor().dot(pos);
            return dot >= this.min && dot <= this.max;
        }
    }

    public static class ClampHeight
    extends HeightPass {
        public float min;
        public float max;

        public ClampHeight(float min, float max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public float height(Vec3 pos, float height) {
            return Mathf.clamp((float)height, (float)this.min, (float)this.max);
        }
    }

    public static class NoiseHeight
    extends HeightPass {
        public Vec3 offset = new Vec3();
        public int seed;
        public double octaves = 1.0;
        public double persistence = 1.0;
        public double scale = 1.0;
        public float magnitude = 1.0f;
        public float heightOffset = 0.0f;

        @Override
        public float height(Vec3 pos, float height) {
            return Simplex.noise3d((int)this.seed, (double)this.octaves, (double)this.persistence, (double)this.scale, (double)(pos.x + this.offset.x), (double)(pos.y + this.offset.y), (double)(pos.z + this.offset.z)) * this.magnitude + this.heightOffset + height;
        }
    }

    public static class SphereHeight
    extends HeightPass {
        public Vec3 pos = new Vec3();
        public float radius = 0.0f;
        public float offset = 0.0f;
        public boolean set = false;

        @Override
        public float height(Vec3 pos, float height) {
            if (!this.valid(pos, height)) {
                return height;
            }
            if (pos.dst(this.pos) < this.radius) {
                return this.offset + height * (this.set ? 0.0f : 1.0f);
            }
            return height;
        }
    }
}

