/*
 * Decompiled with CFR 0.152.
 */
package omaloon.graphics.g3d;

import arc.graphics.Mesh;
import arc.graphics.VertexAttribute;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;

public class MeshUtils {
    static final Vec3 v1 = new Vec3();
    static final Vec3 v2 = new Vec3();
    static final Vec3 v3 = new Vec3();
    static final Vec3 v4 = new Vec3();
    static final float[] floats = new float[8];
    static Mesh mesh;

    static void begin(int count) {
        mesh = new Mesh(true, count, 0, new VertexAttribute[]{VertexAttribute.position3, VertexAttribute.normal, VertexAttribute.texCoords});
        mesh.getVerticesBuffer().limit(mesh.getMaxVertices());
        mesh.getVerticesBuffer().position(0);
    }

    static Mesh end() {
        Mesh last = mesh;
        last.getVerticesBuffer().limit(last.getVerticesBuffer().position());
        mesh = null;
        return last;
    }

    static Vec3 normal(Vec3 v1, Vec3 v2, Vec3 v3) {
        return v4.set(v2).sub(v1).crs(v3.x - v1.x, v3.y - v1.y, v3.z - v1.z).nor();
    }

    static void verts(Vec3 a, Vec3 b, Vec3 c, Vec3 normal, Vec2 texCords) {
        MeshUtils.vert(a, normal, texCords);
        MeshUtils.vert(b, normal, texCords);
        MeshUtils.vert(c, normal, texCords);
    }

    static void vert(Vec3 a, Vec3 normal, Vec2 texCords) {
        MeshUtils.floats[0] = a.x;
        MeshUtils.floats[1] = a.y;
        MeshUtils.floats[2] = a.z;
        MeshUtils.floats[3] = normal.x;
        MeshUtils.floats[4] = normal.y;
        MeshUtils.floats[5] = normal.z;
        MeshUtils.floats[6] = texCords.x;
        MeshUtils.floats[7] = texCords.y;
        mesh.getVerticesBuffer().put(floats);
    }
}

