/*
 * Decompiled with CFR 0.152.
 */
package omaloon.graphics.g3d;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Mesh;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.Shader;
import arc.math.Mathf;
import arc.math.geom.Mat3D;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.util.Tmp;
import mindustry.graphics.g3d.PlanetMesh;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.type.Planet;
import omaloon.graphics.OlShaders;
import omaloon.graphics.g3d.MeshUtils;

public class CircleMesh
extends PlanetMesh {
    public final Mesh mesh;
    public TextureRegion region;
    public Texture texture;
    public Color color = Color.white.cpy();

    public CircleMesh(TextureRegion region, Planet planet, int sides, float radiusIn, float radiusOut, Vec3 axis) {
        this.planet = planet;
        this.region = region;
        MeshUtils.begin(sides * 6 * 8 * 2);
        Tmp.v33.setZero();
        class MeshPoint {
            final Vec3 position;
            final Vec2 textureCords;

            public MeshPoint(Vec3 position, Vec2 textureCords) {
                this.position = position;
                this.textureCords = textureCords;
            }
        }
        MeshPoint[] meshPoints = new MeshPoint[]{new MeshPoint(Tmp.v31.setZero(), Tmp.v1.set(0.0f, 0.0f)), new MeshPoint(Tmp.v33.setZero(), Tmp.v3.set(1.0f, 0.0f)), new MeshPoint(Tmp.v34.setZero(), Tmp.v4.set(1.0f, 1.0f)), new MeshPoint(Tmp.v32.setZero(), Tmp.v2.set(0.0f, 1.0f))};
        int[] order = new int[]{0, 1, 2, 2, 3, 0};
        Vec3 plane = new Vec3().set(1.0f, 0.0f, 0.0f).rotate(Vec3.X, 90.0f).rotate(Vec3.X, axis.angle(Vec3.X) + 1.0f).rotate(Vec3.Y, axis.angle(Vec3.Y) + 1.0f).rotate(Vec3.Z, axis.angle(Vec3.Z) + 1.0f).crs(axis);
        Vec3 inv = (Vec3)axis.cpy().unaryMinus();
        for (int i = 0; i < sides; ++i) {
            meshPoints[0].position.set(plane).rotate(axis, (float)i * 1.0f / (float)sides * 360.0f).setLength2(1.0f).scl(radiusIn);
            meshPoints[1].position.set(plane).rotate(axis, (float)i * 1.0f / (float)sides * 360.0f).setLength2(1.0f).scl(radiusOut);
            meshPoints[2].position.set(plane).rotate(axis, ((float)i + 1.0f) / (float)sides * 360.0f).setLength2(1.0f).scl(radiusOut);
            meshPoints[3].position.set(plane).rotate(axis, ((float)i + 1.0f) / (float)sides * 360.0f).setLength2(1.0f).scl(radiusIn);
            for (int j : order) {
                MeshPoint point = meshPoints[j];
                MeshUtils.vert(point.position, axis, point.textureCords);
            }
            for (int j = order.length - 1; j >= 0; --j) {
                MeshPoint point = meshPoints[order[j]];
                MeshUtils.vert(point.position, inv, point.textureCords);
            }
        }
        this.mesh = MeshUtils.end();
    }

    public void render(PlanetParams params, Mat3D projection, Mat3D transform) {
        if (params.planet == this.planet && Mathf.zero((float)(1.0f - params.uiAlpha), (float)0.01f)) {
            return;
        }
        this.preRender(params);
        if (this.texture == null) {
            this.texture = new Texture(Core.atlas.getPixmap(this.region).crop());
        }
        Shader shader = CircleMesh.shader();
        shader.bind();
        shader.setUniformMatrix4("u_proj", projection.val);
        shader.setUniformMatrix4("u_trans", transform.val);
        shader.setUniformf("u_color", this.color);
        this.setPlanetInfo("u_sun_info", this.planet.solarSystem);
        this.setPlanetInfo("u_planet_info", this.planet);
        this.texture.bind(0);
        shader.setUniformi("u_texture", 0);
        shader.apply();
        this.mesh.render(shader, 4);
    }

    public void preRender(PlanetParams params) {
        OlShaders.planetTextureShader.planet = this.planet;
        OlShaders.planetTextureShader.lightDir.set(this.planet.solarSystem.position).sub(this.planet.position).rotate(Vec3.Y, this.planet.getRotation()).nor();
        OlShaders.planetTextureShader.ambientColor.set(this.planet.solarSystem.lightColor);
        OlShaders.planetTextureShader.alpha = params.planet == this.planet ? 1.0f - params.uiAlpha : 1.0f;
    }

    private void setPlanetInfo(String name, Planet planet) {
        Vec3 position = planet.position;
        Shader shader = CircleMesh.shader();
        shader.setUniformf(name, position.x, position.y, position.z, planet.radius);
    }

    private static Shader shader() {
        return OlShaders.planetTextureShader;
    }
}

