/*
 * Decompiled with CFR 0.152.
 */
package omaloon.gen;

import arc.func.Func;
import arc.func.Prov;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectMap;
import arc.util.Structs;
import mindustry.gen.EntityMapping;
import mindustry.gen.Entityc;
import omaloon.gen.DroneUnit;
import omaloon.gen.FloatMechCoreUnit;
import omaloon.gen.LegsMillipedeUnit;
import omaloon.gen.OrnitopterFlyingUnit;

public final class EntityRegistry {
    private static final ObjectIntMap<Class<? extends Entityc>> ids = new ObjectIntMap();
    private static final ObjectMap<String, Prov<? extends Entityc>> map = new ObjectMap();

    private EntityRegistry() {
        throw new AssertionError();
    }

    public static <T extends Entityc> Prov<T> get(Class<T> type) {
        return EntityRegistry.get(type.getCanonicalName());
    }

    public static <T extends Entityc> Prov<T> get(String name) {
        return (Prov)map.get((Object)name);
    }

    public static <T extends Entityc> void register(String name, Class<T> type, Prov<? extends T> prov) {
        map.put((Object)name, prov);
        ids.put(type, EntityMapping.register((String)name, prov));
    }

    public static <T, E extends Entityc> T content(String name, Class<E> type, Func<String, ? extends T> create) {
        if (type.getName().startsWith("mindustry.gen.")) {
            Prov prov = (Prov)Structs.find((Object[])EntityMapping.idMap, p -> p != null && p.get().getClass().equals(type));
            EntityMapping.nameMap.put((Object)("omaloon-" + name), (Object)prov);
        } else {
            EntityMapping.nameMap.put((Object)("omaloon-" + name), EntityRegistry.get(type));
        }
        return (T)create.get((Object)name);
    }

    public static int getID(Class<? extends Entityc> type) {
        return ids.get(type, -1);
    }

    public static void register() {
        EntityRegistry.register("omaloon.gen.DroneUnit", DroneUnit.class, DroneUnit::create);
        EntityRegistry.register("omaloon.gen.FloatMechCoreUnit", FloatMechCoreUnit.class, FloatMechCoreUnit::create);
        EntityRegistry.register("omaloon.gen.LegsMillipedeUnit", LegsMillipedeUnit.class, LegsMillipedeUnit::create);
        EntityRegistry.register("omaloon.gen.OrnitopterFlyingUnit", OrnitopterFlyingUnit.class, OrnitopterFlyingUnit::create);
    }
}

