/*
 * Decompiled with CFR 0.152.
 */
package omaloon.entities.units;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.audio.SoundLoop;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.units.AIController;
import mindustry.entities.units.UnitController;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Bullet;
import mindustry.gen.Call;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Hitboxc;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.gen.UnitEntity;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import omaloon.entities.units.MillipedeDefaultUnit;
import omaloon.type.MillipedeUnitType;
import omaloon.utils.OlUtils;

public class MillipedeSegmentUnit
extends UnitEntity {
    public MillipedeUnitType millipedeType;
    protected float segmentHealth;
    protected MillipedeDefaultUnit trueParentUnit;
    protected Unit parentUnit;
    protected boolean isBugged;
    protected int shootSequence;
    protected int segmentType;

    public int getSegmentLength() {
        return this.millipedeType.segmentLength;
    }

    public void type(UnitType type) {
        MillipedeUnitType m;
        super.type(type);
        if (!(type instanceof MillipedeUnitType)) {
            throw new ClassCastException("you set this unit's type a in sneaky way");
        }
        this.millipedeType = m = (MillipedeUnitType)type;
    }

    public boolean collides(Hitboxc other) {
        if (this.trueParentUnit == null) {
            return true;
        }
        MillipedeSegmentUnit[] segs = this.trueParentUnit.segmentUnits;
        int len = this.getSegmentLength();
        for (int i = 0; i < len; ++i) {
            if (segs[i] != other) continue;
            return false;
        }
        return true;
    }

    public void add() {
        if (this.added) {
            return;
        }
        this.isBugged = true;
        Groups.all.add((Entityc)this);
        Groups.unit.add((Entityc)this);
        Groups.sync.add((Entityc)this);
        Groups.draw.add((Entityc)this);
        this.added = true;
        this.updateLastPosition();
    }

    public void setType(UnitType type) {
        MillipedeUnitType m;
        this.type = type;
        this.maxHealth = this.segmentHealth = type.health;
        this.drag = type.drag;
        this.armor = type.armor;
        this.hitSize = type.hitSize;
        this.hovering = type.hovering;
        if (this.controller == null) {
            this.controller(type.createController((Unit)this.self()));
        }
        if (this.mounts().length != type.weapons.size) {
            this.setupWeapons(type);
        }
        if (!(type instanceof MillipedeUnitType)) {
            throw new ClassCastException("you set this unit's type in sneaky way");
        }
        this.millipedeType = m = (MillipedeUnitType)type;
    }

    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.remove((Entityc)this);
        Groups.unit.remove((Entityc)this);
        Groups.sync.remove((Entityc)this);
        Groups.draw.remove((Entityc)this);
        this.added = false;
        this.controller.removed((Unit)this);
        if (Vars.net.client()) {
            Vars.netClient.addRemovedEntity(this.id);
        }
    }

    public void damage(float amount) {
        if (this.millipedeType.splittable) {
            this.segmentHealth -= amount * this.millipedeType.segmentDamageScl;
        }
        this.trueParentUnit.damage(amount);
    }

    public void segmentDamage(float amount) {
        this.segmentHealth -= amount;
    }

    public void controller(UnitController next) {
        if (!(next instanceof Player)) {
            this.controller = next;
            if (this.controller.unit() != this) {
                this.controller.unit((Unit)this);
            }
        } else if (this.trueParentUnit != null) {
            this.trueParentUnit.controller(next);
            if (this.trueParentUnit.controller().unit() != this.trueParentUnit) {
                this.trueParentUnit.controller().unit((Unit)this.trueParentUnit);
            }
        }
    }

    public boolean isPlayer() {
        if (this.trueParentUnit == null) {
            return false;
        }
        return this.trueParentUnit.controller() instanceof Player;
    }

    public boolean isAI() {
        if (this.trueParentUnit == null) {
            return true;
        }
        return this.trueParentUnit.controller() instanceof AIController;
    }

    public Player getPlayer() {
        if (this.trueParentUnit == null) {
            return null;
        }
        return this.isPlayer() ? (Player)this.trueParentUnit.controller() : null;
    }

    public void heal(float amount) {
        if (this.trueParentUnit != null) {
            this.trueParentUnit.heal(amount);
        }
        this.health += amount;
        this.segmentHealth = Mathf.clamp((float)(this.segmentHealth + amount), (float)0.0f, (float)this.maxHealth);
        this.clampHealth();
    }

    public void kill() {
        if (this.dead || Vars.net.client()) {
            return;
        }
        if (this.trueParentUnit != null) {
            Call.unitDeath((int)this.trueParentUnit.id);
        }
        Call.unitDeath((int)this.id);
    }

    public void setSegmentType(int val) {
        this.segmentType = val;
    }

    public void setupWeapons(UnitType def) {
        if (!(def instanceof MillipedeUnitType)) {
            super.setupWeapons(def);
        } else {
            MillipedeUnitType w = (MillipedeUnitType)def;
            Seq tmpSeq = new Seq();
            Seq<Weapon> originSeq = w.segWeapSeq;
            for (int i = 0; i < originSeq.size; ++i) {
                tmpSeq.add((Object)new WeaponMount((Weapon)originSeq.get(i)));
            }
            this.mounts = (WeaponMount[])tmpSeq.toArray(WeaponMount.class);
        }
    }

    public boolean serialize() {
        return false;
    }

    public void update() {
        if (this.parentUnit == null || this.parentUnit.dead || !this.parentUnit.isAdded()) {
            this.dead = true;
            this.remove();
        }
        if (this.trueParentUnit != null && this.isBugged) {
            if (!Structs.contains((Object[])this.trueParentUnit.segmentUnits, s -> s == this)) {
                this.remove();
            } else {
                this.isBugged = false;
            }
        }
    }

    public void segmentUpdate() {
        if (this.trueParentUnit != null) {
            if (this.millipedeType.splittable && this.millipedeType.healthDistribution <= 0.0f) {
                this.maxHealth = this.trueParentUnit.maxHealth;
            }
            if (!this.millipedeType.splittable) {
                this.health = this.trueParentUnit.health;
            } else {
                if (this.segmentHealth > this.maxHealth) {
                    this.segmentHealth = this.maxHealth;
                }
                this.health = this.segmentHealth;
            }
        } else {
            return;
        }
        this.hitTime = this.trueParentUnit.hitTime;
        this.ammo = this.trueParentUnit.ammo;
        if (this.millipedeType.splittable && this.segmentHealth <= 0.0f) {
            this.split();
        }
        if (this.team != this.trueParentUnit.team) {
            this.team = this.trueParentUnit.team;
        }
        if (!Vars.net.client() && !this.dead && this.controller != null) {
            this.controller.updateUnit();
        }
        if (this.controller == null || !this.controller.isValidController()) {
            this.resetController();
        }
        this.updateWeapon();
        this.updateStatus();
    }

    protected void split() {
        int index = 0;
        MillipedeDefaultUnit hd = this.trueParentUnit;
        hd.maxHealth /= 2.0f;
        hd.health = Math.min(hd.health, hd.maxHealth);
        for (int i = 0; i < hd.segmentUnits.length; ++i) {
            if (hd.segmentUnits[i] != this) continue;
            index = i;
            break;
        }
        if (index >= hd.segmentUnits.length - 1) {
            this.trueParentUnit.removeTail();
        }
        if (index <= 0 || index >= hd.segmentUnits.length - 1) {
            return;
        }
        hd.segmentUnits[index - 1].segmentType = 1;
        MillipedeDefaultUnit newHead = (MillipedeDefaultUnit)this.type.create(this.team);
        hd.segmentUnits[index + 1].parentUnit = newHead;
        newHead.addSegments = false;
        newHead.attachTime = 0.0f;
        newHead.set((Position)this);
        newHead.vel.set(this.vel);
        newHead.maxHealth /= 2.0f;
        newHead.health /= 2.0f;
        newHead.rotation = this.rotation;
        SegmentData oldSeg = new SegmentData(hd.segmentUnits.length);
        SegmentData newSeg = new SegmentData(hd.segmentUnits.length);
        for (int i = 0; i < hd.segmentUnits.length; ++i) {
            hd.segmentUnits[i].maxHealth /= 2.0f;
            hd.segmentUnits[i].clampHealth();
            if (i < index) {
                oldSeg.add(hd, i);
            }
            if (i <= index) continue;
            newSeg.add(hd, i);
        }
        oldSeg.set(hd);
        newSeg.set(newHead);
        newHead.add();
        this.millipedeType.splitSound.at(this.x, this.y, Mathf.random((float)0.9f, (float)1.1f));
        this.remove();
    }

    protected void updateStatus() {
        if (this.trueParentUnit == null || this.trueParentUnit.dead) {
            return;
        }
        if (!this.statuses.isEmpty()) {
            this.statuses.each(s -> this.trueParentUnit.apply(s.effect, s.time));
        }
        this.statuses.clear();
    }

    protected void updateWeapon() {
        boolean can = this.canShoot();
        for (WeaponMount mount : this.mounts) {
            float shootAngle;
            Weapon weapon = mount.weapon;
            mount.reload = Math.max(mount.reload - Time.delta * this.reloadMultiplier, 0.0f);
            float weaponRotation = this.rotation - 90.0f + (weapon.rotate ? mount.rotation : 0.0f);
            float mountX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)weapon.x, (float)weapon.y);
            float mountY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)weapon.x, (float)weapon.y);
            float shootX = mountX + Angles.trnsx((float)weaponRotation, (float)weapon.shootX, (float)weapon.shootY);
            float shootY = mountY + Angles.trnsy((float)weaponRotation, (float)weapon.shootX, (float)weapon.shootY);
            float f = shootAngle = weapon.rotate ? weaponRotation + 90.0f : Angles.angle((float)shootX, (float)shootY, (float)mount.aimX, (float)mount.aimY) + (this.rotation - this.angleTo(mount.aimX, mount.aimY));
            if (weapon.continuous && mount.bullet != null) {
                if (!mount.bullet.isAdded() || mount.bullet.time >= mount.bullet.lifetime || mount.bullet.type != weapon.bullet) {
                    mount.bullet = null;
                } else {
                    mount.bullet.rotation(weaponRotation + 90.0f);
                    mount.bullet.set(shootX, shootY);
                    mount.reload = weapon.reload;
                    this.vel.add(Tmp.v1.trns(this.rotation + 180.0f, mount.bullet.type.recoil));
                    if (weapon.shootSound != Sounds.none && !Vars.headless) {
                        if (mount.sound == null) {
                            mount.sound = new SoundLoop(weapon.shootSound, 1.0f);
                        }
                        mount.sound.update(this.x, this.y, true);
                    }
                }
            } else {
                mount.heat = Math.max(mount.heat - Time.delta * this.reloadMultiplier / mount.weapon.cooldownTime, 0.0f);
                if (mount.sound != null) {
                    mount.sound.update(this.x, this.y, false);
                }
            }
            if (weapon.otherSide != -1 && weapon.alternate && mount.side == weapon.flipSprite && mount.reload + Time.delta > weapon.reload / 2.0f && mount.reload <= weapon.reload / 2.0f) {
                this.mounts[weapon.otherSide].side = !this.mounts[weapon.otherSide].side;
                boolean bl = mount.side = !mount.side;
            }
            if (weapon.rotate && (mount.rotate || mount.shoot) && can) {
                float axisX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)weapon.x, (float)weapon.y);
                float axisY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)weapon.x, (float)weapon.y);
                mount.targetRotation = Angles.angle((float)axisX, (float)axisY, (float)mount.aimX, (float)mount.aimY) - this.rotation;
                mount.rotation = Angles.moveToward((float)mount.rotation, (float)mount.targetRotation, (float)(weapon.rotateSpeed * Time.delta));
            } else if (!weapon.rotate) {
                mount.rotation = 0.0f;
                mount.targetRotation = this.angleTo(mount.aimX, mount.aimY);
            }
            if (!mount.shoot || !can || !(this.ammo > 0.0f) && Vars.state.rules.unitAmmo && !this.team().rules().infiniteAmmo || weapon.alternate && mount.side != weapon.flipSprite || !(this.vel.len() >= mount.weapon.minShootVelocity) && (!Vars.net.active() || this.isLocal()) || !(mount.reload <= 1.0E-4f) || !Angles.within((float)(weapon.rotate ? mount.rotation : this.rotation), (float)mount.targetRotation, (float)mount.weapon.shootCone)) continue;
            this.shoot(mount, shootX, shootY, mount.aimX, mount.aimY, mountX, mountY, shootAngle, Mathf.sign((float)weapon.x));
            mount.reload = weapon.reload;
            this.ammo -= 1.0f;
            if (!(this.ammo < 0.0f)) continue;
            this.ammo = 0.0f;
        }
    }

    protected void shoot(WeaponMount mount, float x, float y, float aimX, float aimY, float mountX, float mountY, float rotation, int side) {
        boolean delay;
        Weapon weapon = mount.weapon;
        float baseX = this.x;
        float baseY = this.y;
        boolean bl = delay = weapon.shoot.firstShotDelay + weapon.shoot.shotDelay > 0.0f;
        (delay ? weapon.chargeSound : (weapon.continuous ? Sounds.none : weapon.shootSound)).at(x, y, Mathf.random((float)weapon.soundPitchMin, (float)weapon.soundPitchMax));
        BulletType ammo = weapon.bullet;
        float lifeScl = ammo.keepVelocity ? Mathf.clamp((float)(Mathf.dst((float)x, (float)y, (float)aimX, (float)aimY) / ammo.range)) : 1.0f;
        float[] sequenceNum = new float[]{0.0f};
        if (delay) {
            OlUtils.shotgun(weapon.shoot.shots, weapon.reload, rotation, f -> {
                Time.run((float)(sequenceNum[0] * weapon.shoot.shotDelay + weapon.shoot.firstShotDelay), () -> {
                    if (!this.isAdded()) {
                        return;
                    }
                    mount.bullet = this.bullet(weapon, x + this.x - baseX, y + this.y - baseY, f + Mathf.range((float)weapon.inaccuracy), lifeScl);
                });
                sequenceNum[0] = sequenceNum[0] + 1.0f;
            });
        } else {
            OlUtils.shotgun(weapon.shoot.shots, weapon.reload, rotation, f -> {
                mount.bullet = this.bullet(weapon, x, y, f + Mathf.range((float)weapon.inaccuracy), lifeScl);
            });
        }
        boolean parentize = ammo.keepVelocity;
        if (delay) {
            Time.run((float)weapon.shoot.firstShotDelay, () -> {
                if (!this.isAdded()) {
                    return;
                }
                this.vel.add(Tmp.v1.trns(rotation + 180.0f, ammo.recoil));
                Effect.shake((float)weapon.shake, (float)weapon.shake, (float)x, (float)y);
                mount.heat = 1.0f;
                if (!weapon.continuous) {
                    weapon.shootSound.at(x, y, Mathf.random((float)weapon.soundPitchMin, (float)weapon.soundPitchMax));
                }
            });
        } else {
            this.vel.add(Tmp.v1.trns(rotation + 180.0f, ammo.recoil));
            Effect.shake((float)weapon.shake, (float)weapon.shake, (float)x, (float)y);
            mount.heat = 1.0f;
        }
        weapon.ejectEffect.at(mountX, mountY, rotation * (float)side);
        ammo.shootEffect.at(x, y, rotation, (Object)(parentize ? this : null));
        ammo.smokeEffect.at(x, y, rotation, (Object)(parentize ? this : null));
        this.apply(weapon.shootStatus, weapon.shootStatusDuration);
    }

    protected Bullet bullet(Weapon weapon, float x, float y, float angle, float lifescl) {
        return weapon.bullet.create((Entityc)this, this.team, x, y, angle, 1.0f - weapon.velocityRnd + Mathf.random((float)weapon.velocityRnd), lifescl);
    }

    public void drawBody() {
        TextureRegion outline;
        float z = Draw.z();
        this.type.applyColor((Unit)this);
        TextureRegion region = this.segmentType == 0 ? this.millipedeType.segmentRegion : this.millipedeType.tailRegion;
        Draw.rect((TextureRegion)region, (Position)this, (float)(this.rotation - 90.0f));
        TextureRegion segCellReg = this.millipedeType.segmentCellRegion;
        if (this.segmentType == 0 && segCellReg != Core.atlas.find("error")) {
            this.drawCell(segCellReg);
        }
        TextureRegion textureRegion = this.millipedeType.segmentOutline == null || this.millipedeType.tailOutline == null ? null : (outline = this.segmentType == 0 ? this.millipedeType.segmentOutline : this.millipedeType.tailOutline);
        if (outline != null) {
            Draw.color((Color)Color.white);
            Draw.z((float)Draw.z());
            Draw.rect((TextureRegion)outline, (Position)this, (float)(this.rotation - 90.0f));
            Draw.z((float)z);
        }
        Draw.reset();
    }

    public void drawCell(TextureRegion cellRegion) {
        Draw.color((Color)this.type.cellColor((Unit)this));
        Draw.rect((TextureRegion)cellRegion, (float)this.x, (float)this.y, (float)(this.rotation - 90.0f));
    }

    public void drawShadow() {
        TextureRegion region = this.segmentType == 0 ? this.millipedeType.segmentRegion : this.millipedeType.tailRegion;
        Draw.color((Color)Pal.shadow);
        float e = Math.max(this.elevation, this.type.shadowElevation);
        Draw.rect((TextureRegion)region, (float)(this.x + -12.0f * e), (float)(this.y + -13.0f * e), (float)(this.rotation - 90.0f));
        Draw.color();
    }

    public void draw() {
    }

    public void collision(Hitboxc other, float x, float y) {
        super.collision(other, x, y);
        if (this.trueParentUnit != null) {
            this.trueParentUnit.handleCollision((Hitboxc)this, other, x, y);
        }
    }

    protected void setTrueParent(MillipedeDefaultUnit parent) {
        this.shootSequence = 0;
        this.trueParentUnit = parent;
    }

    public void setParent(Unit parent) {
        this.parentUnit = parent;
    }

    protected static class SegmentData {
        MillipedeSegmentUnit[] units;
        Vec2[] pos;
        Vec2[] vel;
        int size = 0;

        SegmentData(int size) {
            this.units = new MillipedeSegmentUnit[size];
            this.pos = new Vec2[size];
            this.vel = new Vec2[size];
        }

        void add(MillipedeSegmentUnit unit, Vec2 vel) {
            this.units[this.size] = unit;
            this.pos[this.size] = new Vec2(unit.getX(), unit.getY());
            this.vel[this.size++] = vel;
        }

        void add(MillipedeDefaultUnit unit, int index) {
            Log.info((Object)(this.toString() + ":" + (Object)((Object)unit.segmentUnits[index]) + ":" + unit.segments[index] + ":" + unit.segmentVelocities[index] + ":" + index));
            this.units[this.size] = unit.segmentUnits[index];
            this.pos[this.size] = unit.segments[index];
            this.vel[this.size++] = unit.segmentVelocities[index];
        }

        void set(MillipedeDefaultUnit unit) {
            for (MillipedeSegmentUnit seg : this.units) {
                if (seg == null) break;
                seg.trueParentUnit = unit;
            }
            unit.segmentUnits = new MillipedeSegmentUnit[this.size];
            unit.segments = new Vec2[this.size];
            unit.segmentVelocities = new Vec2[this.size];
            System.arraycopy(this.units, 0, unit.segmentUnits, 0, this.size);
            System.arraycopy(this.pos, 0, unit.segments, 0, this.size);
            System.arraycopy(this.vel, 0, unit.segmentVelocities, 0, this.size);
        }
    }
}

