/*
 * Decompiled with CFR 0.152.
 */
package omaloon.entities.units;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Interval;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.game.Team;
import mindustry.gen.Hitboxc;
import mindustry.gen.Unit;
import mindustry.gen.UnitEntity;
import mindustry.type.UnitType;
import omaloon.entities.units.MillipedeSegmentUnit;
import omaloon.type.MillipedeUnitType;
import omaloon.utils.OlUtils;

public class MillipedeDefaultUnit
extends UnitEntity {
    public MillipedeUnitType wormType;
    public MillipedeSegmentUnit[] segmentUnits;
    public float repairTime = 0.0f;
    protected float attachTime = 240.0f;
    protected float healthDistributionEfficiency = 1.0f;
    protected Vec2[] segments;
    protected Vec2[] segmentVelocities;
    protected boolean addSegments = true;
    protected boolean found;
    protected final Interval scanTimer = new Interval();
    protected final Vec2 lastVelocityC = new Vec2();
    protected final Vec2 lastVelocityD = new Vec2();

    public int getSegmentLength() {
        return this.wormType.segmentLength;
    }

    public void type(UnitType type) {
        MillipedeUnitType w;
        super.type(type);
        if (!(type instanceof MillipedeUnitType)) {
            throw new ClassCastException("you set this unit's type in a sneaky way");
        }
        this.wormType = w = (MillipedeUnitType)type;
    }

    public void setType(UnitType type) {
        MillipedeUnitType w;
        super.setType(type);
        if (!(type instanceof MillipedeUnitType)) {
            throw new ClassCastException("you set this unit's type in a sneaky way");
        }
        this.wormType = w = (MillipedeUnitType)type;
    }

    protected void setEffects() {
        this.segmentUnits = new MillipedeSegmentUnit[this.wormType.segmentLength];
        this.segments = new Vec2[this.wormType.segmentLength];
        this.segmentVelocities = new Vec2[this.wormType.segmentLength];
        for (int i = 0; i < this.getSegmentLength(); ++i) {
            this.segments[i] = new Vec2(this.x, this.y);
            this.segmentVelocities[i] = new Vec2();
        }
    }

    public void damage(float amount) {
        super.damage(amount);
        this.healthDistributionEfficiency = Mathf.clamp((float)(this.healthDistributionEfficiency - amount / 15.0f));
    }

    public void update() {
        this.lastVelocityD.set(this.lastVelocityC);
        this.lastVelocityC.set(this.vel);
        super.update();
        this.healthDistributionEfficiency = Mathf.clamp((float)(this.healthDistributionEfficiency + Time.delta / 160.0f));
        this.updateSegmentVLocal(this.lastVelocityC);
        this.updateSegmentsLocal();
        if (this.wormType.chainable && this.segmentUnits.length < this.wormType.maxSegments && this.scanTimer.get(15.0f) && this.attachTime >= 240.0f) {
            this.scanTailSegment();
        }
        this.attachTime += Time.delta;
        if (this.regenAvailable()) {
            if (this.repairTime >= this.wormType.regenTime) {
                float damage = this.health / (float)this.segmentUnits.length / 2.0f;
                this.damage(damage);
                for (MillipedeSegmentUnit seg : this.segmentUnits) {
                    float sDamage = seg.segmentHealth / (float)this.segmentUnits.length / 2.0f;
                    seg.segmentDamage(sDamage);
                }
                this.addSegment();
                this.repairTime = 0.0f;
            } else {
                this.repairTime += Time.delta;
            }
        }
    }

    public boolean regenAvailable() {
        return this.wormType.splittable && (this.segmentUnits.length < this.wormType.segmentLength || this.segmentUnits.length < this.wormType.maxSegments) && this.wormType.regenTime > 0.0f;
    }

    protected void updateSegmentVLocal(Vec2 vec) {
        int i;
        int len = this.getSegmentLength();
        for (i = 0; i < len; ++i) {
            Vec2 seg = this.segments[i];
            Vec2 segV = this.segmentVelocities[i];
            segV.limit(this.type.speed);
            float angleB = i != 0 ? Angles.angle((float)seg.x, (float)seg.y, (float)this.segments[i - 1].x, (float)this.segments[i - 1].y) : Angles.angle((float)seg.x, (float)seg.y, (float)this.x, (float)this.y);
            float velocity = i != 0 ? this.segmentVelocities[i - 1].len() : vec.len();
            Tmp.v1.set(this.vel);
            Tmp.v1.add(vec);
            Tmp.v1.add(this.lastVelocityD);
            Tmp.v1.scl(0.33333334f);
            float trueVel = Math.max(Math.max(velocity, segV.len()), Tmp.v1.len());
            Tmp.v1.trns(angleB, trueVel);
            segV.add(Tmp.v1);
            segV.setLength(trueVel);
            if (this.wormType.counterDrag) {
                segV.scl(1.0f - this.drag);
            }
            this.segmentUnits[i].vel.set(segV);
        }
        for (i = 0; i < len; ++i) {
            this.segmentVelocities[i].scl(Time.delta);
        }
    }

    protected void updateSegmentsLocal() {
        MillipedeSegmentUnit segU;
        Vec2 seg;
        int i;
        float segmentOffset = this.wormType.segmentOffset / 2.0f;
        float angleC = OlUtils.clampedAngle(Angles.angle((float)this.segments[0].x, (float)this.segments[0].y, (float)this.x, (float)this.y), this.rotation, this.wormType.angleLimit) + 180.0f;
        Tmp.v1.trns(angleC, segmentOffset + this.wormType.headOffset);
        Tmp.v1.add(this.x, this.y);
        this.segments[0].set(Tmp.v1);
        int len = this.getSegmentLength();
        this.segments[0].add(this.segmentVelocities[0]);
        this.rotation -= OlUtils.angleDistSigned(this.rotation, this.segmentUnits[0].rotation, this.wormType.angleLimit) / 1.25f;
        Tmp.v1.trns(this.rotation + 180.0f, segmentOffset + this.wormType.headOffset).add((Position)this);
        this.segmentUnits[0].rotation = OlUtils.clampedAngle(this.segments[0].angleTo((Position)Tmp.v1), this.rotation, this.wormType.angleLimit);
        Tmp.v2.trns(this.segmentUnits[0].rotation, segmentOffset).add(this.segments[0]).sub(Tmp.v1);
        this.segments[0].sub(Tmp.v2);
        this.segmentVelocities[0].scl(Mathf.clamp((float)(1.0f - this.drag * Time.delta)));
        this.segmentUnits[0].set(this.segments[0].x, this.segments[0].y);
        this.segmentUnits[0].segmentUpdate();
        if (this.wormType.healthDistribution > 0.0f) {
            this.distributeHealth(0);
        }
        for (i = 1; i < len; ++i) {
            seg = this.segments[i];
            Vec2 segLast = this.segments[i - 1];
            segU = this.segmentUnits[i];
            MillipedeSegmentUnit segULast = this.segmentUnits[i - 1];
            seg.add(this.segmentVelocities[i]);
            segULast.rotation -= OlUtils.angleDistSigned(segULast.rotation, segU.rotation, this.wormType.angleLimit) / 1.25f;
            Tmp.v1.trns(segULast.rotation + 180.0f, segmentOffset).add(segLast);
            segU.rotation = OlUtils.clampedAngle(segU.angleTo((Position)Tmp.v1), segULast.rotation, this.wormType.angleLimit);
            Tmp.v2.trns(segU.rotation, segmentOffset).add(seg).sub(Tmp.v1);
            seg.sub(Tmp.v2);
            this.segmentVelocities[i].scl(Mathf.clamp((float)(1.0f - this.drag * Time.delta)));
            segU.set((Position)seg);
            segU.segmentUpdate();
            if (!(this.wormType.healthDistribution > 0.0f)) continue;
            this.distributeHealth(i);
        }
        for (i = 0; i < this.segmentUnits.length; ++i) {
            seg = this.segments[i];
            Vec2 segV = this.segmentVelocities[i];
            segU = this.segmentUnits[i];
            seg.add(segV);
            float angleD = i == 0 ? Angles.angle((float)seg.x, (float)seg.y, (float)this.x, (float)this.y) : Angles.angle((float)seg.x, (float)seg.y, (float)this.segments[i - 1].x, (float)this.segments[i - 1].y);
            segV.scl(Mathf.clamp((float)(1.0f - this.drag * Time.delta)));
            segU.set(seg.x, seg.y);
            segU.rotation = angleD;
            segU.segmentUpdate();
            if (!(this.wormType.healthDistribution > 0.0f)) continue;
            this.distributeHealth(i);
        }
    }

    protected void distributeHealth(int index) {
        Unit seg;
        int i;
        int idx = 0;
        float mHealth = 0.0f;
        float mMaxHealth = 0.0f;
        for (i = -1; i < 2 && (seg = this.getSegment(i + index)) != null; ++i) {
            mHealth += seg.health;
            mMaxHealth += seg.maxHealth;
            ++idx;
        }
        mMaxHealth /= (float)idx;
        mHealth /= (float)idx;
        for (i = -1; i < 2 && (seg = this.getSegment(i + index)) != null; ++i) {
            if (seg instanceof MillipedeSegmentUnit) {
                MillipedeSegmentUnit ws = (MillipedeSegmentUnit)seg;
                if (!Mathf.equal((float)ws.segmentHealth, (float)mHealth, (float)0.001f)) {
                    ws.segmentHealth = Mathf.lerpDelta((float)ws.segmentHealth, (float)mHealth, (float)(this.wormType.healthDistribution * this.healthDistributionEfficiency));
                }
            } else if (!Mathf.equal((float)seg.health, (float)mHealth, (float)0.001f)) {
                seg.health = Mathf.lerpDelta((float)seg.health, (float)mHealth, (float)(this.wormType.healthDistribution * this.healthDistributionEfficiency));
            }
            if (Mathf.equal((float)seg.maxHealth, (float)mMaxHealth, (float)0.001f)) continue;
            seg.maxHealth = Mathf.lerpDelta((float)seg.maxHealth, (float)mMaxHealth, (float)(this.wormType.healthDistribution * this.healthDistributionEfficiency));
        }
    }

    protected Unit getSegment(int index) {
        if (index < 0) {
            return this;
        }
        if (index >= this.segmentUnits.length) {
            return null;
        }
        return this.segmentUnits[index];
    }

    public float clipSize() {
        return (float)this.segmentUnits.length * this.wormType.segmentOffset * 2.0f;
    }

    public void drawShadow() {
        float originZ = Draw.z();
        int len = this.segmentUnits.length;
        for (int i = 0; i < len; ++i) {
            Draw.z((float)(originZ - (float)(i + 1) / 10000.0f));
            this.segmentUnits[i].drawShadow();
        }
        Draw.z((float)originZ);
    }

    public MillipedeSegmentUnit newSegment() {
        return new MillipedeSegmentUnit();
    }

    public void destroy() {
        if (!this.added) {
            return;
        }
        super.destroy();
        for (MillipedeSegmentUnit seg : this.segmentUnits) {
            float explosiveness = 2.0f + seg.item().explosiveness * (float)this.stack().amount * 1.53f;
            float flammability = seg.item().flammability * (float)seg.stack().amount / 1.9f;
            float power = seg.item().charge * (float)seg.stack().amount * 150.0f;
            if (!this.spawnedByCore) {
                Damage.dynamicExplosion((float)seg.x, (float)seg.y, (float)flammability, (float)explosiveness, (float)power, (float)(this.bounds() / 2.0f), (boolean)Vars.state.rules.damageExplosions, (this.item().flammability > 1.0f ? 1 : 0) != 0, (Team)this.team);
            }
            float shake = this.hitSize / 3.0f;
            Effect.scorch((float)seg.x, (float)seg.y, (int)((int)(this.hitSize / 5.0f)));
            Fx.explosion.at((Position)seg);
            Effect.shake((float)shake, (float)shake, (Position)seg);
            this.type.deathSound.at((Position)seg);
            if (this.type.flying && !this.spawnedByCore) {
                Damage.damage((Team)this.team, (float)seg.x, (float)seg.y, (float)(Mathf.pow((float)seg.hitSize, (float)0.94f) * 1.25f), (float)(Mathf.pow((float)seg.hitSize, (float)0.75f) * this.type.crashDamageMultiplier * 5.0f), (boolean)true, (boolean)false, (boolean)true);
            }
            if (Vars.headless) continue;
            for (int i = 0; i < this.type.wreckRegions.length; ++i) {
                if (!this.type.wreckRegions[i].found()) continue;
                float range = this.type.hitSize / 4.0f;
                Tmp.v1.rnd(range);
                Effect.decal((TextureRegion)this.type.wreckRegions[i], (float)(seg.x + Tmp.v1.x), (float)(seg.y + Tmp.v1.y), (float)(seg.rotation - 90.0f));
            }
        }
    }

    public void remove() {
        if (!this.added) {
            return;
        }
        super.remove();
        for (MillipedeSegmentUnit segmentUnit : this.segmentUnits) {
            segmentUnit.remove();
        }
    }

    protected void superRemove() {
        super.remove();
    }

    public int count() {
        return Math.max(super.count() / Math.max(this.wormType.segmentLength, this.wormType.maxSegments), 1);
    }

    protected void scanTailSegment() {
        Tmp.v1.trns(this.rotation, this.wormType.segmentOffset).add((Position)this);
        float size = this.wormType.hitSize / 2.0f;
        this.found = false;
        Units.nearby((Team)this.team, (float)(Tmp.v1.x - size), (float)(Tmp.v1.y - size), (float)(size * 2.0f), (float)(size * 2.0f), e -> {
            if (this.found) {
                return;
            }
            if (e instanceof MillipedeSegmentUnit) {
                MillipedeSegmentUnit ms = (MillipedeSegmentUnit)((Object)e);
                if (ms.segmentType == 1 && ms.millipedeType == this.wormType && ms.trueParentUnit != this && this.within((Position)ms, this.wormType.segmentOffset + 5.0f) && Angles.within((float)this.angleTo((Position)e), (float)e.rotation, (float)(this.wormType.angleLimit + 2.0f))) {
                    int i;
                    if (ms.trueParentUnit == null || ms.trueParentUnit.segmentUnits.length > this.wormType.maxSegments) {
                        return;
                    }
                    this.wormType.chainSound.at((Position)this, Mathf.random((float)0.9f, (float)1.1f));
                    MillipedeSegmentUnit head = this.newSegment();
                    head.setType(this.wormType);
                    head.set((Position)this);
                    head.rotation = this.rotation;
                    head.vel.set(this.vel);
                    head.team = this.team;
                    head.maxHealth = this.maxHealth;
                    head.health = head.segmentHealth = this.health;
                    head.segmentType = 0;
                    this.segmentUnits[0].parentUnit = head;
                    head.add();
                    this.superRemove();
                    MillipedeSegmentUnit.SegmentData data = new MillipedeSegmentUnit.SegmentData(this.segmentUnits.length + 1);
                    data.add(head, head.vel);
                    for (i = 0; i < this.segmentUnits.length; ++i) {
                        data.add(this, i);
                    }
                    for (i = 0; i < data.size; ++i) {
                        ms.trueParentUnit.addSegment(data.units[i], data.pos[i], data.vel[i]);
                    }
                    this.found = true;
                }
            }
        });
    }

    protected void removeTail() {
        int index = this.segments.length - 1;
        if (index <= 0) {
            return;
        }
        this.segmentUnits[index].remove();
        this.segmentUnits[index] = null;
        this.segmentUnits[index - 1].segmentType = 1;
        this.segmentUnits = Arrays.copyOf(this.segmentUnits, this.segmentUnits.length - 1);
        this.segments = Arrays.copyOf(this.segments, this.segments.length - 1);
        this.segmentVelocities = Arrays.copyOf(this.segmentVelocities, this.segmentVelocities.length - 1);
    }

    public void addSegment(MillipedeSegmentUnit unit, Vec2 pos, Vec2 vel) {
        int index = this.segments.length;
        MillipedeSegmentUnit parent = this.segmentUnits[index - 1];
        this.segmentUnits[index - 1].segmentType = 0;
        this.segmentUnits = Arrays.copyOf(this.segmentUnits, this.segmentUnits.length + 1);
        this.segments = Arrays.copyOf(this.segments, this.segments.length + 1);
        this.segmentVelocities = Arrays.copyOf(this.segmentVelocities, this.segmentVelocities.length + 1);
        unit.elevation = this.elevation;
        unit.segmentType = 1;
        unit.parentUnit = parent;
        unit.trueParentUnit = this;
        this.segmentUnits[this.segmentUnits.length - 1] = unit;
        this.segments[this.segments.length - 1] = pos;
        this.segmentVelocities[this.segmentVelocities.length - 1] = vel;
    }

    public void addSegment() {
        int index = this.segments.length;
        MillipedeSegmentUnit parent = this.segmentUnits[index - 1];
        Tmp.v1.trns(this.segmentUnits[index - 1].rotation + 180.0f, this.wormType.segmentOffset).add((Position)this.segmentUnits[index - 1]);
        this.segmentUnits[index - 1].segmentType = 0;
        this.segmentUnits = Arrays.copyOf(this.segmentUnits, this.segmentUnits.length + 1);
        this.segments = Arrays.copyOf(this.segments, this.segments.length + 1);
        this.segmentVelocities = Arrays.copyOf(this.segmentVelocities, this.segmentVelocities.length + 1);
        MillipedeSegmentUnit segment = this.newSegment();
        segment.elevation = this.elevation;
        segment.segmentType = 1;
        segment.setType(this.type);
        segment.parentUnit = parent;
        segment.trueParentUnit = this;
        segment.set((Position)Tmp.v1);
        segment.team = this.team;
        segment.health = this.health;
        segment.maxHealth = this.maxHealth;
        segment.segmentHealth = this.health;
        segment.dead = false;
        segment.add();
        this.segmentUnits[this.segmentUnits.length - 1] = segment;
        this.segments[this.segments.length - 1] = new Vec2(Tmp.v1);
        this.segmentVelocities[this.segmentVelocities.length - 1] = new Vec2(this.segmentVelocities[this.segmentVelocities.length - 2]);
    }

    public void add() {
        if (this.added) {
            return;
        }
        super.add();
        if (!this.addSegments) {
            this.postAdd();
            return;
        }
        this.setEffects();
        UnitEntity parent = this;
        int len = this.getSegmentLength();
        for (int i = 0; i < len; ++i) {
            int typeS = i == len - 1 ? 1 : 0;
            this.segments[i].set(this.x, this.y);
            MillipedeSegmentUnit temp = this.newSegment();
            temp.elevation = this.elevation;
            temp.setSegmentType(typeS);
            temp.type(this.type);
            temp.resetController();
            temp.team = this.team;
            temp.setTrueParent(this);
            temp.setParent((Unit)parent);
            temp.add();
            temp.afterSync();
            temp.heal();
            parent = temp;
            this.segmentUnits[i] = temp;
        }
    }

    void postAdd() {
        for (MillipedeSegmentUnit ms : this.segmentUnits) {
            ms.add();
        }
    }

    public void read(Reads read) {
        super.read(read);
        this.addSegments = false;
        int length = read.s();
        boolean splittable = read.bool();
        this.repairTime = read.f();
        this.segmentUnits = new MillipedeSegmentUnit[length];
        this.segments = new Vec2[length];
        this.segmentVelocities = new Vec2[length];
        UnitEntity parent = this;
        for (int i = 0; i < length; ++i) {
            this.segments[i] = new Vec2();
            this.segmentVelocities[i] = new Vec2();
            MillipedeSegmentUnit temp = this.newSegment();
            temp.elevation = this.elevation;
            temp.type(this.type);
            temp.team = this.team;
            temp.drag = this.type.drag;
            temp.armor = this.type.armor;
            temp.hitSize = this.type.hitSize;
            temp.hovering = this.type.hovering;
            temp.setupWeapons(this.type);
            temp.resetController();
            temp.abilities = (Ability[])this.type.abilities.toArray(Ability.class);
            temp.setTrueParent(this);
            temp.setParent((Unit)parent);
            temp.x = this.segments[i].x = read.f();
            temp.y = this.segments[i].y = read.f();
            temp.rotation = read.f();
            temp.segmentType = read.b();
            if (splittable) {
                temp.segmentHealth = temp.health = read.f();
                temp.maxHealth = read.f();
            }
            parent = temp;
            this.segmentUnits[i] = temp;
        }
    }

    public void write(Writes write) {
        super.write(write);
        write.s(this.segmentUnits.length);
        write.bool(this.wormType.splittable);
        write.f(this.repairTime);
        for (int i = 0; i < this.segmentUnits.length; ++i) {
            write.f(this.segments[i].x);
            write.f(this.segments[i].y);
            write.f(this.segmentUnits[i].rotation);
            write.b(this.segmentUnits[i].segmentType);
            if (!this.wormType.splittable) continue;
            write.f(this.segmentUnits[i].segmentHealth);
            write.f(this.segmentUnits[i].maxHealth);
        }
    }

    public void handleCollision(Hitboxc originUnit, Hitboxc other, float x, float y) {
    }
}

