/*
 * Decompiled with CFR 0.152.
 */
package omaloon.entities.bullet;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.gl.FrameBuffer;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Mat3D;
import arc.math.geom.Quat;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Tmp;
import arclibrary.graphics.Draw3d;
import arclibrary.graphics.EDraw;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.game.EventType;
import mindustry.gen.Bullet;
import mindustry.graphics.Pal;

public class LaunchBulletType
extends BasicBulletType {
    public float fadeAt = 0.25f;
    public float fragAt = 0.75f;
    public float fragRadius = 24.0f;
    public Interp shadowInterp = Interp.linear;
    public Interp fragInterp = Interp.linear;
    public float pitch = 1.0f;
    public static final FrameBuffer drawBuffer = new FrameBuffer();
    public static final FrameBuffer shadowBuffer = new FrameBuffer();
    public static final Seq<Runnable> shadowRuns = new Seq();
    public static boolean shouldResize;
    public static final Quat quat;
    public static final Mat3D mat;

    public LaunchBulletType(float speed, float damage) {
        super(speed, damage);
        this.collidesGround = false;
        this.collidesAir = false;
        this.collides = false;
        this.absorbable = false;
        this.scaleLife = true;
    }

    public void createFrags(Bullet b, float x, float y) {
        if (this.fragBullet != null) {
            Angles.randLenVectors((long)b.id, (int)this.fragBullets, (float)this.fragRadius, (ox, oy) -> this.fragBullet.create(b, Mathf.lerp((float)b.originX, (float)(x + ox), (float)this.fragAt), Mathf.lerp((float)b.originY, (float)(y + oy), (float)this.fragAt), Angles.angle((float)b.originX, (float)b.originY, (float)(x + ox), (float)(y + oy)), 1.0f, b.lifetime / this.lifetime));
        }
    }

    public void draw(Bullet b) {
        this.drawShadow(b);
        this.drawTrail(b);
        this.drawParts(b);
        if (b.fin() <= this.fadeAt) {
            int i;
            shouldResize = true;
            float currentPitch = b.fin() / this.fadeAt;
            mat.set(quat.set(Angles.trnsx((float)b.rotation(), (float)(this.shrinkInterp.apply(currentPitch) * this.pitch)), Angles.trnsy((float)b.rotation(), (float)(this.shrinkInterp.apply(currentPitch) * this.pitch)), 1.0f, 0.0f));
            drawBuffer.begin(Color.clear);
            for (i = 4; i >= 0; --i) {
                if (!this.backRegion.found()) continue;
                Draw3d.rect(mat, this.backRegion, b.x - this.width / 2.0f + Angles.trnsx((float)b.rotation(), (float)(currentPitch / 4.0f * (float)i)), b.y - this.height / 2.0f + Angles.trnsy((float)b.rotation(), (float)(currentPitch / 4.0f * (float)i)), this.width, this.height, b.rotation());
            }
            for (i = 4; i >= 0; --i) {
                Draw3d.rect(mat, this.frontRegion, b.x - this.width / 2.0f + Angles.trnsx((float)b.rotation(), (float)(currentPitch / 4.0f * (float)i)), b.y - this.height / 2.0f + Angles.trnsy((float)b.rotation(), (float)(currentPitch / 4.0f * (float)i)), this.width, this.height, b.rotation() + 90.0f);
            }
            drawBuffer.end();
            Draw.draw((float)99.9f, () -> {
                Draw.color((Color)Color.white);
                Draw.alpha((float)(1.0f - b.fin() / this.fadeAt));
                EDraw.drawBuffer(drawBuffer);
            });
        }
    }

    public void drawShadow(Bullet b) {
        if (b.fin() <= 0.5f) {
            shadowRuns.add(() -> Fill.circle((float)Mathf.lerp((float)b.x, (float)b.originX, (float)this.shadowInterp.apply(Mathf.clamp((float)(b.fin() * 2.0f)))), (float)Mathf.lerp((float)b.y, (float)b.originY, (float)this.shadowInterp.apply(Mathf.clamp((float)(b.fin() * 2.0f)))), (float)this.hitSize));
        } else if (this.fragBullet != null) {
            shadowRuns.add(() -> Angles.randLenVectors((long)b.id, (int)this.fragBullets, (float)this.fragRadius, (x, y) -> {
                float endX = b.x + Tmp.v1.set((Vec2)b.vel).scl((float)(b.lifetime - b.time)).x + x;
                float endY = b.y + Tmp.v1.set((Vec2)b.vel).scl((float)(b.lifetime - b.time)).y + y;
                Fill.circle((float)Mathf.lerp((float)b.originX, (float)endX, (float)(this.fragInterp.apply(Mathf.clamp((float)(b.fin() * 2.0f - 1.0f))) * this.fragAt)), (float)Mathf.lerp((float)b.originY, (float)endY, (float)(this.fragInterp.apply(Mathf.clamp((float)(b.fin() * 2.0f - 1.0f))) * this.fragAt)), (float)this.fragBullet.hitSize);
            }));
        }
    }

    public void drawTrail(Bullet b) {
        if (this.trailLength > 0 && b.trail != null && b.fin() <= this.fadeAt) {
            float z = Draw.z();
            Draw.z((float)(z - 1.0E-4f));
            b.trail.draw(this.trailColor, this.trailWidth * (1.0f - b.fin() / this.fadeAt));
            Draw.z((float)z);
        }
    }

    static {
        quat = new Quat();
        mat = new Mat3D();
        Events.run((Object)EventType.Trigger.draw, () -> {
            if (!shadowRuns.isEmpty()) {
                shadowBuffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
                Seq buffer = shadowRuns.copy();
                shadowRuns.clear();
                Draw.draw((float)99.0f, () -> {
                    Draw.flush();
                    shadowBuffer.begin(Color.clear);
                    buffer.each(Runnable::run);
                    shadowBuffer.end();
                    Draw.color((Color)Pal.shadow, (float)Pal.shadow.a);
                    EDraw.drawBuffer(shadowBuffer);
                    Draw.flush();
                    Draw.color();
                });
            }
            if (shouldResize) {
                drawBuffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
                shouldResize = false;
            }
        });
    }
}

