/*
 * Decompiled with CFR 0.152.
 */
package omaloon.entities.bullet;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Teamc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Trail;
import mindustry.type.StatusEffect;
import omaloon.math.Math3D;

public class FallingBulletType
extends BulletType {
    public float fallTime = 50.0f;
    public float fallSpread = 60.0f;
    public String sprite;
    public TextureRegion region;
    public Color regionColor = Color.white;
    public boolean canCollideFalling = false;
    public float fallingRadius = 20.0f;
    public float fallingDamage = 100.0f;
    public Effect hitFallingEffect = Fx.none;
    public Color hitFallingColor = Color.white;
    public boolean fallingHitCollideGround = false;
    public boolean immovable = true;
    public float minDistanceFallingCollide = 10.0f;

    public FallingBulletType(String sprite) {
        super(1.0f, 0.0f);
        this.sprite = sprite;
        this.backMove = false;
        this.keepVelocity = false;
        this.reflectable = false;
        this.hittable = false;
        this.collides = false;
        this.despawnHit = true;
    }

    public void load() {
        super.load();
        this.region = Core.atlas.find(this.sprite);
    }

    public void init(Bullet b) {
        super.init(b);
        if (this.immovable) {
            Tmp.v2.trns(b.rotation(), b.lifetime() * this.speed);
            b.set(b.x + Tmp.v2.x, b.y + Tmp.v2.y);
            b.vel.setZero();
        }
        b.lifetime(this.fallTime);
    }

    public void draw(Bullet b) {
        this.drawTrail(b);
        this.drawFalling(b, this.region, this.regionColor);
    }

    public void drawFalling(Bullet b, TextureRegion region, Color col) {
        float rot = this.getRotTrajectory(b);
        float sclFall = 1.0f + this.getElevation(b) / 4.0f;
        float sclShadow = 0.1f + b.fin();
        Vec2 pos = this.getTrajectory(b);
        Draw.z((float)80.0f);
        Draw.scl((float)sclShadow);
        Drawf.shadow((TextureRegion)region, (float)b.x, (float)b.y, (float)rot);
        Draw.scl();
        Draw.z((float)(115.0f + Math3D.layerOffset(pos.x, pos.y)));
        Draw.color((Color)col);
        Draw.alpha((float)Mathf.clamp((float)(b.fin() * 1.5f)));
        Draw.scl((float)sclFall);
        Draw.rect((TextureRegion)region, (float)pos.x, (float)pos.y, (float)rot);
        Draw.reset();
    }

    public void drawLight(Bullet b) {
        if (this.lightOpacity <= 0.0f || this.lightRadius <= 0.0f) {
            return;
        }
        Drawf.light((Position)this.getTrajectory(b), (float)((1.0f + b.fout()) * this.lightRadius), (Color)this.lightColor, (float)this.lightOpacity);
    }

    public void update(Bullet b) {
        super.update(b);
        this.updateFalling(b);
    }

    public void updateFalling(Bullet b) {
        if (this.canCollideFalling && this.isLanding(b)) {
            Teamc target = Units.closestTarget((Team)b.team, (float)b.x, (float)b.y, (float)this.fallingRadius, e -> e.checkTarget(true, false) && e.team != b.team && !b.hasCollided(e.id));
            Vec2 pos = this.getTrajectory(b);
            if (target != null && pos.dst(target.x(), target.y()) < this.minDistanceFallingCollide) {
                this.hitFalling(b);
                if (this.pierce) {
                    b.collided.add(target.id());
                } else {
                    b.remove();
                }
            }
        }
    }

    public void updateTrail(Bullet b) {
        if (!Vars.headless && this.trailLength > 0) {
            if (b.trail == null) {
                b.trail = new Trail(this.trailLength);
            }
            Vec2 pos = this.getTrajectory(b);
            b.trail.length = this.trailLength;
            b.trail.update(pos.x, pos.y, this.trailInterp.apply(b.fin()) * (1.0f + (this.trailSinMag > 0.0f ? Mathf.absin((float)Time.time, (float)this.trailSinScl, (float)this.trailSinMag) : 0.0f)));
        }
    }

    public void updateTrailEffects(Bullet b) {
        Vec2 pos;
        if (this.trailChance > 0.0f && Mathf.chanceDelta((double)this.trailChance)) {
            pos = this.getTrajectory(b);
            this.trailEffect.at(pos.x, pos.y, this.trailRotation ? b.rotation() : this.trailParam, this.trailColor);
        }
        if (this.trailInterval > 0.0f && b.timer(0, this.trailInterval)) {
            pos = this.getTrajectory(b);
            this.trailEffect.at(pos.x, pos.y, this.trailRotation ? b.rotation() : this.trailParam, this.trailColor);
        }
    }

    public void hitFalling(Bullet b) {
        this.hitFalling(b, b.x, b.y);
    }

    public void hitFalling(Bullet b, float x, float y) {
        this.hitFallingEffect.at(x, y, b.rotation(), this.hitFallingColor);
        this.hitSound.at(x, y, this.hitSoundPitch, this.hitSoundVolume);
        Effect.shake((float)this.hitShake, (float)this.hitShake, (Position)b);
        if (b.absorbed) {
            return;
        }
        Damage.damage((Team)b.team, (float)x, (float)y, (float)this.fallingRadius, (float)(this.fallingDamage * b.damageMultiplier()), (boolean)this.splashDamagePierce, (boolean)true, (boolean)this.fallingHitCollideGround, (boolean)this.scaledSplashDamage, (Bullet)b);
        if (this.status != StatusEffects.none) {
            Damage.status((Team)b.team, (float)x, (float)y, (float)this.fallingRadius, (StatusEffect)this.status, (float)this.statusDuration, (boolean)true, (boolean)this.fallingHitCollideGround);
        }
    }

    public Vec2 getTrajectory(Bullet b) {
        float elevation = this.getElevation(b);
        Vec2 off = this.getOffsetTrajectory(b);
        Vec2 pos = new Vec2(b.x, b.y);
        pos.add(off.x * b.fout(), off.y * b.fout() * 2.0f);
        pos.add(Math3D.xOffset(pos.x, elevation), Math3D.yOffset(pos.y, elevation));
        return pos;
    }

    public Vec2 getOffsetTrajectory(Bullet b) {
        return Tmp.v2.trns(90.0f + (Mathf.randomSeed((long)(b.id + 1)) - 0.5f) * this.fallSpread / 2.0f, this.fallTime);
    }

    public float getRotTrajectory(Bullet b) {
        return Mathf.randomSeed((long)b.id) * 360.0f;
    }

    public float getElevation(Bullet b) {
        return b.fout() * this.fallTime / 10.0f;
    }

    public boolean isLanding(Bullet b) {
        return (double)b.fin() > 0.75;
    }
}

