/*
 * Decompiled with CFR 0.152.
 */
package omaloon.entities.abilities;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Strings;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Healthc;
import mindustry.gen.Unit;
import mindustry.type.UnitType;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import omaloon.world.meta.OlStats;

public class JavelinAbility
extends Ability {
    public String suffix = "";
    public String name;
    public float damage = 1.0f;
    public float minDamage = 0.0f;
    public float damageInterval = 5.0f;
    public float radius = -1.0f;
    public boolean targetAir = true;
    public boolean targetGround = true;
    public float minSpeed = 0.8f;
    public float maxSpeed = 1.2f;
    public float x;
    public float y;
    public float layerOffset = 0.0f;
    public float sclX = 1.0f;
    public float magX = 0.0f;
    public float sclY = 1.0f;
    public float magY = 0.0f;
    public float sinOffset = (float)Math.PI;
    public Color color = Color.white;
    public Blending blending = Blending.additive;
    public boolean drawOverlay = true;
    public Effect hitEffect = Fx.none;
    public TextureRegion overlayRegion;
    protected float timer;
    protected final Seq<Healthc> targets = new Seq();

    public JavelinAbility(float damage, float damageInterval, float radius) {
        this.damage = damage;
        this.damageInterval = damageInterval;
        this.radius = radius;
        this.suffix = "-overlay";
    }

    public JavelinAbility() {
    }

    public void addStats(Table t) {
        t.add((CharSequence)("[lightgray]" + Stat.damage.localized() + ": [white]" + Strings.autoFixed((float)(60.0f * this.minDamage / this.damageInterval), (int)2) + " - " + Strings.autoFixed((float)(60.0f * this.damage / this.damageInterval), (int)2) + " " + StatUnit.perSecond.localized())).row();
        t.add((CharSequence)("[lightgray]" + Stat.range.localized() + ": [white]" + Strings.autoFixed((float)(this.radius / 8.0f), (int)2) + " " + StatUnit.blocks.localized())).row();
        t.add((CharSequence)("[lightgray]" + OlStats.minSpeed.localized() + ": [white]" + Strings.autoFixed((float)(this.minSpeed / 8.0f), (int)2) + " " + StatUnit.tilesSecond.localized())).row();
        t.add((CharSequence)("[lightgray]" + OlStats.maxSpeed.localized() + ": [white]" + Strings.autoFixed((float)(this.maxSpeed / 8.0f), (int)2) + " " + StatUnit.tilesSecond.localized())).row();
        t.add((CharSequence)("[lightgray]" + Stat.targetsAir.localized() + ": [white]" + Core.bundle.get(this.targetAir ? "yes" : "no"))).row();
        t.add((CharSequence)("[lightgray]" + Stat.targetsGround.localized() + ": [white]" + Core.bundle.get(this.targetGround ? "yes" : "no"))).row();
    }

    public void draw(Unit unit) {
        if (this.drawOverlay) {
            float scl = Mathf.clamp((float)Mathf.map((float)unit.vel().len(), (float)this.minSpeed, (float)this.maxSpeed, (float)0.0f, (float)1.0f));
            if (this.overlayRegion == null) {
                this.overlayRegion = Core.atlas.find(this.name);
            }
            float drawx = unit.x + this.x + Mathf.sin((float)(Time.time + (float)unit.id), (float)this.sclX, (float)this.magX);
            float drawy = unit.y + this.y + Mathf.sin((float)(Time.time + this.sinOffset + (float)unit.id), (float)this.sclY, (float)this.magY);
            float z = Draw.z();
            Draw.z((float)(z - this.layerOffset));
            Draw.color((Color)this.color);
            Draw.alpha((float)scl);
            Draw.blend((Blending)this.blending);
            Draw.rect((TextureRegion)this.overlayRegion, (float)drawx, (float)drawy, (float)(unit.rotation - 90.0f));
            Draw.blend();
            Draw.z((float)z);
        }
    }

    public void init(UnitType type) {
        if (this.name == null) {
            this.name = type.name + this.suffix;
        }
        if (this.radius == -1.0f) {
            this.radius = type.hitSize;
        }
    }

    public void update(Unit unit) {
        float scl = Mathf.clamp((float)Mathf.map((float)unit.vel().len(), (float)this.minSpeed, (float)this.maxSpeed, (float)0.0f, (float)1.0f));
        if (scl <= 0.0f) {
            return;
        }
        if (this.timer >= this.damageInterval) {
            float ax = unit.x + this.x;
            float ay = unit.y + this.y;
            this.targets.clear();
            Units.nearby(null, (float)ax, (float)ay, (float)this.radius, other -> {
                if (other != unit && other.checkTarget(this.targetAir, this.targetGround) && other.targetable(unit.team) && other.team != unit.team) {
                    this.targets.add(other);
                }
            });
            if (this.targetGround) {
                Units.nearbyBuildings((float)ax, (float)ay, (float)this.radius, b -> {
                    if ((b.team != Team.derelict || Vars.state.rules.coreCapture) && b.team != unit.team) {
                        this.targets.add(b);
                    }
                });
            }
            float dmg = Math.max(this.minDamage, this.damage * scl * Vars.state.rules.unitDamage(unit.team));
            this.targets.each(other -> {
                if (other instanceof Building) {
                    Building b = (Building)other;
                    b.damage(unit.team, dmg);
                } else {
                    other.damage(dmg);
                }
                this.hitEffect.at(other.x(), other.y(), unit.rotation - 90.0f, this.color);
            });
            this.timer %= 1.0f;
        }
        this.timer += Time.delta;
    }
}

