/*
 * Decompiled with CFR 0.152.
 */
package omaloon.entities.abilities;

import arc.Core;
import arc.Events;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.event.EventListener;
import arc.scene.event.HandCursorListener;
import arc.scene.event.Touchable;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Table;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Time;
import java.util.ArrayList;
import java.util.function.Function;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.abilities.Ability;
import mindustry.entities.units.UnitController;
import mindustry.game.EventType;
import mindustry.gen.Groups;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.type.UnitType;
import mindustry.world.meta.Stat;
import omaloon.ai.DroneAI;
import omaloon.gen.DroneUnit;
import omaloon.gen.Dronec;

public class DroneAbility
extends Ability {
    private Unit paramUnit;
    private DroneAbility paramAbility;
    private final Vec2 paramPos = new Vec2();
    public String name = "omaloon-drone";
    public UnitType droneUnit;
    public float spawnTime = 60.0f;
    public float spawnX = 0.0f;
    public float spawnY = 0.0f;
    public Effect spawnEffect = Fx.spawn;
    public boolean parentizeEffects = false;
    public Vec2[] anchorPos = new Vec2[]{new Vec2(40.0f, -40.0f)};
    public float layer = 59.99f;
    public float rotation = 0.0f;
    public int maxDroneCount = 1;
    protected float timer = 0.0f;
    public ArrayList<Unit> drones = new ArrayList();
    public Function<Unit, DroneAI> droneController = DroneAI::new;

    public void init(UnitType type) {
        this.data = 0.0f;
    }

    public void addStats(Table t) {
        t.add((CharSequence)("[lightgray]" + Stat.productionTime.localized() + ": []" + Strings.autoFixed((float)this.spawnTime, (int)2))).row();
        t.table(unit -> {
            Image icon = (Image)unit.image(this.droneUnit.fullIcon).get();
            icon.setScaling(Scaling.fit);
            icon.touchable = Touchable.enabled;
            icon.clicked(() -> Vars.ui.content.show((UnlockableContent)this.droneUnit));
            icon.addListener((EventListener)new HandCursorListener());
            unit.row();
            unit.add((CharSequence)this.droneUnit.localizedName);
        }).row();
    }

    public Ability copy() {
        DroneAbility ability = (DroneAbility)super.copy();
        ability.drones = new ArrayList();
        return ability;
    }

    public String localized() {
        return Core.bundle.get("ability." + this.name);
    }

    public void update(Unit unit) {
        this.paramUnit = unit;
        this.paramAbility = this;
        this.paramPos.set(this.spawnX, this.spawnY).rotate(unit.rotation - 90.0f).add((Position)unit);
        this.timer += Time.delta * Vars.state.rules.unitBuildSpeed(unit.team());
        if (this.drones.isEmpty()) {
            for (Unit u2 : Groups.unit) {
                if (u2.team() != unit.team() || u2.type != this.droneUnit || !(u2 instanceof DroneUnit) || ((DroneUnit)u2).owner != unit) continue;
                this.drones.add(u2);
                u2.controller((UnitController)this.droneController.apply(unit));
                this.data += 1.0f;
                this.updateAnchor();
            }
        }
        this.drones.removeIf(u -> {
            if (!u.isValid()) {
                this.data -= 1.0f;
                this.timer = 0.0f;
                return true;
            }
            return false;
        });
        if (this.data < (float)this.maxDroneCount && this.timer > this.spawnTime) {
            this.spawnDrone();
            this.timer = 0.0f;
        }
    }

    protected void spawnDrone() {
        this.spawnEffect.at(this.paramPos.x, this.paramPos.y, 0.0f, (Object)(this.parentizeEffects ? this.paramUnit : null));
        Unit u = this.droneUnit.create(this.paramUnit.team());
        u.set(this.paramPos.x, this.paramPos.y);
        u.rotation = this.paramUnit.rotation + this.rotation;
        if (u instanceof DroneUnit) {
            DroneUnit drone = (DroneUnit)u;
            drone.owner(this.paramUnit);
        }
        this.drones.add(0, u);
        this.data += 1.0f;
        for (int i = 0; i < this.paramUnit.abilities.length; ++i) {
            Ability self = this.paramUnit.abilities[i];
            if (self != this || !(u instanceof Dronec)) continue;
            Dronec drone = (Dronec)u;
            drone.abilityIndex(i);
        }
        u.controller((UnitController)this.droneController.apply(this.paramUnit));
        this.updateAnchor();
        Events.fire((Object)new EventType.UnitCreateEvent(u, null, this.paramUnit));
        if (!Vars.net.client()) {
            u.add();
        }
    }

    public void updateAnchor() {
        for (int i = 0; i < this.drones.size(); ++i) {
            Unit u = this.drones.get(i);
            ((DroneAI)u.controller()).rally(this.anchorPos[i]);
        }
    }

    public void draw(Unit unit) {
        this.paramUnit = unit;
        this.paramAbility = this;
        this.paramPos.set(this.spawnX, this.spawnY).rotate(unit.rotation - 90.0f).add((Position)unit);
        if (this.data < (float)this.maxDroneCount && this.timer <= this.spawnTime) {
            Draw.draw((float)this.layer, () -> Drawf.construct((float)this.paramPos.x, (float)this.paramPos.y, (TextureRegion)this.droneUnit.fullIcon, (float)(this.paramUnit.rotation - 90.0f), (float)(this.timer / this.spawnTime), (float)1.0f, (float)this.timer));
        }
    }
}

