/*
 * Decompiled with CFR 0.152.
 */
package omaloon.content.blocks;

import arc.graphics.Color;
import arc.math.geom.Vec2;
import mindustry.content.Items;
import mindustry.gen.Sounds;
import mindustry.world.Block;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OreBlock;
import mindustry.world.blocks.environment.OverlayFloor;
import mindustry.world.blocks.environment.Prop;
import mindustry.world.blocks.environment.StaticWall;
import mindustry.world.blocks.environment.TallBlock;
import omaloon.content.OlItems;
import omaloon.content.OlLiquids;
import omaloon.content.OlSounds;
import omaloon.content.OlStatusEffects;
import omaloon.graphics.OlShaders;
import omaloon.world.blocks.environment.CliffHelper;
import omaloon.world.blocks.environment.CustomShapeProp;
import omaloon.world.blocks.environment.OlCliff;
import omaloon.world.blocks.environment.RotatedProp;

public class OlEnvironmentBlocks {
    public static Block cliffUp;
    public static Block cliffHelper;
    public static Block oreCobalt;
    public static Block oreBeryllium;
    public static Block oreCoal;
    public static Block deadShrub;
    public static Block gerbDebris;
    public static Block deadGrass;
    public static Block frozenSoilWall;
    public static Block frozenSoilBoulder;
    public static Block frozenSoil;
    public static Block albasterWall;
    public static Block albasterBoulder;
    public static Block albaster;
    public static Block albasterTiles;
    public static Block albasterCrater;
    public static Block aghatiteWall;
    public static Block weatheredAghaniteWall;
    public static Block cobaltedAghaniteWall;
    public static Block aghatiteBoulder;
    public static Block weatheredAghaniteBoulder;
    public static Block berylledAghaniteBoulder;
    public static Block cobaltedAghaniteStones;
    public static Block aghaniteConcretion;
    public static Block largeAghaniteConcretion;
    public static Block aghatite;
    public static Block aghatitePebbles;
    public static Block smoothAghanite;
    public static Block weatheredAghanite;
    public static Block aghaniteShale;
    public static Block aghaniteDust;
    public static Block coastalAghanite;
    public static Block berylledAghanite;
    public static Block cobaltedAghanite;
    public static Block quartzSandWall;
    public static Block quartzSandBoulder;
    public static Block quartzSand;
    public static Block deepGlacium;
    public static Block glacium;
    public static Block greniteGlacium;
    public static Block greniteWall;
    public static Block darkGreniteWall;
    public static Block greniteBoulder;
    public static Block grenite;
    public static Block coastalGrenite;
    public static Block blueIceWall;
    public static Block blueSnowWall;
    public static Block blueBoulder;
    public static Block blueIce;
    public static Block blueIcePieces;
    public static Block blueSnow;
    public static Block blueSnowdrifts;
    public static Block weatheredIce;
    public static Block glasmoreMetal;
    public static Block ruinedGerbTiles;
    public static Block ruinedGerbMasonry;
    public static Block ruinedGerbWall;
    public static Block fallenDeadTree;
    public static Block fallenDeadTreeTopHalf;
    public static Block fallenDeadTreeBottomHalf;
    public static Block spikedTree;
    public static Block bushTree;
    public static Block standingDeadTree;
    public static Block deadTreeStump;
    public static Block end;

    public static void load() {
        cliffUp = new OlCliff("cliff-up");
        cliffHelper = new CliffHelper("cliff-helper");
        oreCobalt = new OreBlock("ore-cobalt", OlItems.cobalt){
            {
                this.mapColor = Color.valueOf((String)"85939d");
                this.oreThreshold = 0.81f;
                this.oreScale = 23.47619f;
            }
        };
        oreBeryllium = new OreBlock("ore-beril", Items.beryllium){
            {
                this.mapColor = Color.valueOf((String)"3a8f64");
            }
        };
        oreCoal = new OreBlock("ore-coal", Items.coal){
            {
                this.oreThreshold = 0.846f;
                this.oreScale = 24.428572f;
            }
        };
        glasmoreMetal = new Floor("glasmore-metal", 6);
        ruinedGerbTiles = new Floor("ruined-gerb-tiles", 3){
            {
                this.wall = ruinedGerbWall;
            }
        };
        ruinedGerbMasonry = new Floor("ruined-gerb-masonry", 3){
            {
                this.wall = ruinedGerbWall;
            }
        };
        ruinedGerbWall = new StaticWall("ruined-gerb-wall"){
            {
                this.variants = 4;
            }
        };
        gerbDebris = new RotatedProp("gerb-debris"){
            {
                this.variants = 3;
                this.breakSound = OlSounds.debrisBreak;
                OlEnvironmentBlocks.ruinedGerbTiles.asFloor().decoration = this;
                OlEnvironmentBlocks.ruinedGerbMasonry.asFloor().decoration = this;
            }
        };
        albaster = new Floor("albaster", 4){
            {
                this.wall = albasterWall;
            }
        };
        albasterTiles = new Floor("albaster-tiles", 3){
            {
                this.wall = albasterWall;
            }
        };
        albasterCrater = new Floor("albaster-craters", 3){
            {
                this.blendGroup = albaster;
                this.wall = albasterWall;
            }
        };
        albasterWall = new StaticWall("albaster-wall"){
            {
                this.variants = 3;
            }
        };
        albasterBoulder = new Prop("albaster-boulder"){
            {
                this.variants = 3;
                OlEnvironmentBlocks.albaster.asFloor().decoration = this;
                OlEnvironmentBlocks.albasterTiles.asFloor().decoration = this;
                OlEnvironmentBlocks.albasterCrater.asFloor().decoration = this;
            }
        };
        aghatiteWall = new StaticWall("aghatite-wall"){
            {
                this.variants = 4;
            }
        };
        weatheredAghaniteWall = new StaticWall("weathered-aghanite-wall"){
            {
                this.variants = 2;
            }
        };
        cobaltedAghaniteWall = new StaticWall("cobalted-aghanite-wall"){
            {
                this.variants = 2;
            }
        };
        aghatiteBoulder = new Prop("aghatite-boulder"){
            {
                this.variants = 2;
            }
        };
        weatheredAghaniteBoulder = new Prop("weathered-aghanite-boulder"){
            {
                this.customShadow = true;
                this.variants = 2;
            }
        };
        berylledAghaniteBoulder = new Prop("berylled-aghanite-boulder"){
            {
                this.customShadow = true;
                this.variants = 2;
            }
        };
        cobaltedAghaniteStones = new Prop("cobalted-aghanite-stones"){
            {
                this.customShadow = true;
                this.variants = 2;
            }
        };
        aghaniteConcretion = new TallBlock("aghanite-concretion"){
            {
                this.variants = 2;
            }
        };
        largeAghaniteConcretion = new TallBlock("large-aghanite-concretion"){
            {
                this.variants = 2;
            }
        };
        aghatite = new Floor("aghatite", 3){
            {
                this.wall = aghatiteWall;
                this.decoration = aghatiteBoulder;
            }
        };
        aghatitePebbles = new Floor("aghatite-pebbles", 4){
            {
                this.wall = aghatiteWall;
                this.decoration = aghatiteBoulder;
            }
        };
        smoothAghanite = new Floor("smooth-aghanite", 4){
            {
                this.wall = weatheredAghaniteWall;
                this.decoration = weatheredAghaniteBoulder;
            }
        };
        weatheredAghanite = new Floor("weathered-aghanite", 2){
            {
                this.wall = weatheredAghaniteWall;
                this.decoration = weatheredAghaniteBoulder;
            }
        };
        aghaniteShale = new Floor("aghanite-shale", 4){
            {
                this.wall = weatheredAghaniteWall;
                this.decoration = weatheredAghaniteBoulder;
            }
        };
        aghaniteDust = new OverlayFloor("aghanite-dust"){
            {
                this.variants = 2;
            }
        };
        coastalAghanite = new Floor("coastal-aghanite", 3){
            {
                this.wall = aghatiteWall;
                this.decoration = aghatiteBoulder;
            }
        };
        berylledAghanite = new Floor("berylled-aghanite", 3){
            {
                this.wall = weatheredAghaniteWall;
                this.decoration = berylledAghaniteBoulder;
            }
        };
        cobaltedAghanite = new Floor("cobalted-aghanite", 2){
            {
                this.wall = cobaltedAghaniteWall;
                this.decoration = cobaltedAghaniteStones;
            }
        };
        quartzSand = new Floor("quartz-sand-floor", 3){
            {
                this.wall = albasterWall;
            }
        };
        quartzSandWall = new StaticWall("quartz-sand-wall"){
            {
                this.variants = 4;
            }
        };
        quartzSandBoulder = new Prop("quartz-sand-boulder"){
            {
                this.variants = 3;
                OlEnvironmentBlocks.quartzSand.asFloor().decoration = this;
            }
        };
        deepGlacium = new Floor("deep-glacium", 0){
            {
                this.speedMultiplier = 0.1f;
                this.liquidDrop = OlLiquids.glacium;
                this.liquidMultiplier = 1.3f;
                this.isLiquid = true;
                this.status = OlStatusEffects.glacied;
                this.statusDuration = 120.0f;
                this.drownTime = 200.0f;
                this.cacheLayer = OlShaders.dalaniLayer;
                this.albedo = 0.9f;
                this.supportsOverlay = true;
            }
        };
        glacium = new Floor("shallow-glacium", 0){
            {
                this.speedMultiplier = 0.3f;
                this.status = OlStatusEffects.glacied;
                this.statusDuration = 90.0f;
                this.liquidDrop = OlLiquids.glacium;
                this.isLiquid = true;
                this.cacheLayer = OlShaders.dalaniLayer;
                this.albedo = 0.9f;
                this.supportsOverlay = true;
            }
        };
        greniteGlacium = new Floor("grenite-glacium", 3){
            {
                this.speedMultiplier = 0.6f;
                this.status = OlStatusEffects.glacied;
                this.statusDuration = 60.0f;
                this.liquidDrop = OlLiquids.glacium;
                this.isLiquid = true;
                this.cacheLayer = OlShaders.dalaniLayer;
                this.albedo = 0.9f;
                this.supportsOverlay = true;
            }
        };
        grenite = new Floor("grenite", 4){
            {
                this.wall = albasterWall;
            }
        };
        coastalGrenite = new Floor("coastal-grenite", 3){
            {
                this.wall = albasterWall;
            }
        };
        greniteWall = new StaticWall("grenite-wall"){
            {
                this.variants = 2;
            }
        };
        darkGreniteWall = new StaticWall("dark-grenite-wall"){
            {
                this.variants = 2;
            }
        };
        greniteBoulder = new Prop("grenite-boulder"){
            {
                this.variants = 3;
                OlEnvironmentBlocks.grenite.asFloor().decoration = this;
                OlEnvironmentBlocks.coastalGrenite.asFloor().decoration = this;
            }
        };
        blueIce = new Floor("blue-ice", 3){
            {
                this.mapColor = Color.valueOf((String)"5195ab");
                this.wall = blueIceWall;
                this.albedo = 0.9f;
            }
        };
        blueIcePieces = new OverlayFloor("blue-ice-pieces"){
            {
                this.variants = 3;
            }
        };
        weatheredIce = new OverlayFloor("weathered-ice"){
            {
                this.variants = 2;
            }
        };
        blueIceWall = new StaticWall("blue-ice-wall"){
            {
                this.mapColor = Color.valueOf((String)"b3e7fb");
                this.variants = 2;
            }
        };
        blueSnow = new Floor("blue-snow", 3){
            {
                this.mapColor = Color.valueOf((String)"9fd3e7");
                this.wall = blueIceWall;
                this.albedo = 0.7f;
            }
        };
        blueSnowdrifts = new OverlayFloor("blue-snowdrifts"){
            {
                this.variants = 3;
            }
        };
        blueSnowWall = new StaticWall("blue-snow-wall"){
            {
                this.mapColor = Color.valueOf((String)"d4f2ff");
                this.variants = 2;
            }
        };
        blueBoulder = new Prop("blue-boulder"){
            {
                this.variants = 3;
                OlEnvironmentBlocks.blueIce.asFloor().decoration = this;
                OlEnvironmentBlocks.blueSnow.asFloor().decoration = this;
            }
        };
        frozenSoil = new Floor("frozen-soil", 4){
            {
                this.wall = frozenSoilWall;
            }
        };
        frozenSoilWall = new StaticWall("frozen-soil-wall"){
            {
                this.variants = 4;
            }
        };
        frozenSoilBoulder = new Prop("frozen-soil-boulder"){
            {
                this.variants = 3;
                OlEnvironmentBlocks.frozenSoil.asFloor().decoration = this;
            }
        };
        deadGrass = new Floor("dead-grass", 5){
            {
                this.wall = frozenSoilWall;
            }
        };
        deadShrub = new Prop("dead-shrub"){
            {
                this.customShadow = true;
                this.variants = 3;
                OlEnvironmentBlocks.deadGrass.asFloor().decoration = this;
            }
        };
        fallenDeadTree = new CustomShapeProp("fallen-dead-tree"){
            {
                this.clipSize = 144.0f;
                this.variants = 8;
                this.canMirror = true;
                this.spriteOffsets = new Vec2[]{new Vec2(-16.0f, -32.0f), new Vec2(8.0f, -32.0f), new Vec2(-16.0f, -32.0f), new Vec2(-8.0f, -32.0f), new Vec2(-8.0f, -16.0f), new Vec2(-32.0f, -16.0f), new Vec2(0.0f, -16.0f), new Vec2(-32.0f, -16.0f)};
            }
        };
        fallenDeadTreeTopHalf = new CustomShapeProp("fallen-dead-tree-top-half"){
            {
                this.clipSize = 80.0f;
                this.variants = 8;
                this.canMirror = true;
                this.spriteOffsets = new Vec2[]{new Vec2(-8.0f, -16.0f), new Vec2(-8.0f, -16.0f), new Vec2(-8.0f, -16.0f), new Vec2(0.0f, -16.0f), new Vec2(-16.0f, -8.0f), new Vec2(-16.0f, -8.0f), new Vec2(-8.0f, -8.0f), new Vec2(-16.0f, -8.0f)};
            }
        };
        fallenDeadTreeBottomHalf = new CustomShapeProp("fallen-dead-tree-bottom-half"){
            {
                this.clipSize = 64.0f;
                this.variants = 8;
                this.canMirror = true;
                this.spriteOffsets = new Vec2[]{new Vec2(-12.0f, -8.0f), new Vec2(-4.0f, -8.0f), new Vec2(-12.0f, -8.0f), new Vec2(-12.0f, -8.0f), new Vec2(-8.0f, -12.0f), new Vec2(-8.0f, -12.0f), new Vec2(0.0f, -12.0f), new Vec2(-8.0f, -12.0f)};
            }
        };
        spikedTree = new Prop("spiked-tree"){
            {
                this.variants = 2;
                this.customShadow = true;
            }
        };
        bushTree = new RotatedProp("bush-tree"){
            {
                this.variants = 0;
                this.customShadow = true;
                this.breakSound = Sounds.plantBreak;
            }
        };
        standingDeadTree = new CustomShapeProp("standing-dead-tree"){
            {
                this.clipSize = 32.0f;
                this.variants = 1;
                this.spriteOffsets = new Vec2[]{new Vec2(-4.0f, -12.0f)};
            }
        };
        deadTreeStump = new CustomShapeProp("dead-tree-stump"){
            {
                this.clipSize = 16.0f;
                this.variants = 1;
                this.drawUnder = true;
                this.rotateRegions = true;
                this.spriteOffsets = new Vec2[]{new Vec2(-4.0f, -4.0f)};
            }
        };
    }
}

