/*
 * Decompiled with CFR 0.152.
 */
package omaloon.content;

import arc.Core;
import arc.graphics.Color;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import mindustry.ai.types.BuilderAI;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.content.StatusEffects;
import mindustry.entities.abilities.Ability;
import mindustry.entities.bullet.ArtilleryBulletType;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.ContinuousFlameBulletType;
import mindustry.entities.bullet.LiquidBulletType;
import mindustry.entities.bullet.MissileBulletType;
import mindustry.entities.effect.ParticleEffect;
import mindustry.entities.effect.WaveEffect;
import mindustry.entities.part.DrawPart;
import mindustry.entities.part.RegionPart;
import mindustry.entities.pattern.ShootSpread;
import mindustry.gen.MechUnit;
import mindustry.gen.Sounds;
import mindustry.gen.UnitEntity;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import omaloon.ai.CowardAI;
import omaloon.ai.MillipedeAI;
import omaloon.ai.drone.AttackDroneAI;
import omaloon.ai.drone.UtilityDroneAI;
import omaloon.content.OlFx;
import omaloon.content.OlItems;
import omaloon.content.OlLiquids;
import omaloon.content.OlSounds;
import omaloon.content.OlStatusEffects;
import omaloon.entities.abilities.DroneAbility;
import omaloon.entities.abilities.JavelinAbility;
import omaloon.entities.bullet.LaunchBulletType;
import omaloon.entities.part.ConstructPart;
import omaloon.gen.DroneUnit;
import omaloon.gen.FloatMechCoreUnit;
import omaloon.gen.LegsMillipedeUnit;
import omaloon.gen.OrnitopterFlyingUnit;
import omaloon.type.Blade;
import omaloon.type.DroneUnitType;
import omaloon.type.FilterWeapon;
import omaloon.type.GlassmoreUnitType;
import omaloon.type.MillipedeUnitType;
import omaloon.type.OrnitopterUnitType;

public class OlUnitTypes {
    public static UnitType cilantro;
    public static UnitType basil;
    public static UnitType sage;
    public static UnitType legionnaire;
    public static UnitType centurion;
    public static UnitType praetorian;
    public static UnitType lumen;
    public static UnitType effort;
    public static UnitType collector;
    public static UnitType discovery;
    public static UnitType walker;
    public static UnitType attackDroneAlpha;
    public static UnitType actionDroneMono;

    public static void load() {
        collector = new MillipedeUnitType("collector"){
            {
                this.constructor = LegsMillipedeUnit::create;
                this.aiController = MillipedeAI::new;
                this.speed = 0.6f;
                this.health = 200.0f;
                this.regenTime = 900.0f;
                this.chainable = true;
                this.omniMovement = false;
                this.angleLimit = 65.0f;
                this.segmentLength = 5;
                this.segmentDamageScl = 8.0f;
                this.segmentCast = 8;
                this.segmentOffset = 7.3f;
                this.maxSegments = 20;
                this.preventDrifting = true;
                this.hidden = true;
                this.legLength = 8.0f;
                this.lockLegBase = true;
                this.legContinuousMove = true;
                this.legExtension = -2.0f;
                this.legBaseOffset = 3.0f;
                this.legMaxLength = 1.1f;
                this.legMinLength = 0.2f;
                this.legLengthScl = 0.96f;
                this.legForwardScl = 0.7f;
                this.legGroupSize = 2;
                this.rippleScale = 0.7f;
                this.tailLegCount = 2;
                this.segmentLegCount = 2;
                this.headLegCount = 2;
                this.legMoveSpace = 2.0f;
                this.allowLegStep = true;
                this.hovering = false;
                this.legPhysicsLayer = true;
                Seq weaponSeq = Seq.with((Object[])new Weapon[]{new Weapon("omaloon-collector-beam"){
                    {
                        super(arg0);
                        this.x = 0.0f;
                        this.y = 1.0f;
                        this.rotate = true;
                        this.mirror = false;
                        this.reload = 60.0f;
                        this.bullet = new ArtilleryBulletType(5.0f, 7.0f){
                            {
                                super(arg0, arg1);
                                this.maxRange = 40.0f;
                                this.collidesGround = true;
                                this.collidesAir = true;
                                this.collidesTiles = true;
                                this.height = 11.0f;
                                this.width = 11.0f;
                                this.splashDamage = 25.0f;
                                this.splashDamageRadius = 25.0f;
                                this.lightColor = this.backColor = Pal.thoriumPink;
                                this.hitColor = this.backColor;
                                this.trailColor = this.backColor;
                                this.frontColor = Pal.thoriumPink;
                            }
                        };
                    }
                }});
                this.segmentWeapons = new Seq[]{Seq.with((Object[])new Object[0]), weaponSeq, weaponSeq, weaponSeq, weaponSeq, weaponSeq, weaponSeq, weaponSeq, weaponSeq, weaponSeq, weaponSeq, weaponSeq, weaponSeq, weaponSeq, weaponSeq, weaponSeq, weaponSeq, weaponSeq, weaponSeq, Seq.with((Object[])new Object[0])};
            }
        };
        attackDroneAlpha = new DroneUnitType("combat-drone-alpha"){
            {
                this.constructor = DroneUnit::create;
                this.itemCapacity = 0;
                this.speed = 2.2f;
                this.accel = 0.08f;
                this.drag = 0.04f;
                this.hidden = true;
                this.flying = true;
                this.health = 70.0f;
                this.engineOffset = 4.0f;
                this.engineSize = 2.0f;
                this.hitSize = 9.0f;
                this.isEnemy = false;
                this.weapons.add((Object)new Weapon(){
                    {
                        this.y = 0.0f;
                        this.x = 1.5f;
                        this.reload = 20.0f;
                        this.ejectEffect = Fx.casing1;
                        this.shootCone = 60.0f;
                        this.bullet = new BasicBulletType(2.5f, 6.0f){
                            {
                                super(arg0, arg1);
                                this.width = 7.0f;
                                this.height = 9.0f;
                                this.lifetime = 45.0f;
                                this.backColor = this.trailColor = Color.valueOf((String)"feb380");
                                this.hitColor = this.trailColor;
                                this.trailWidth = 1.3f;
                                this.trailLength = 7;
                                this.shootEffect = Fx.shootSmall;
                                this.smokeEffect = Fx.shootSmallSmoke;
                                this.ammoMultiplier = 2.0f;
                            }
                        };
                        this.shootSound = OlSounds.theShoot;
                    }
                });
                this.shadowElevationScl = 0.4f;
            }
        };
        actionDroneMono = new GlassmoreUnitType("main-drone-mono"){
            {
                this.constructor = DroneUnit::create;
                this.mineTier = 3;
                this.itemCapacity = 1;
                this.speed = 2.2f;
                this.accel = 0.08f;
                this.drag = 0.04f;
                this.hidden = true;
                this.flying = true;
                this.health = 70.0f;
                this.engineOffset = 4.0f;
                this.engineSize = 2.0f;
                this.buildRange = 60.0f;
                this.buildSpeed = 1.0f;
                this.mineSpeed = 5.5f;
                this.mineRange = 40.0f;
                this.hitSize = 9.0f;
                this.isEnemy = false;
                this.shadowElevationScl = 0.4f;
            }
        };
        walker = new GlassmoreUnitType("walker"){
            {
                this.constructor = FloatMechCoreUnit::create;
                this.aiController = BuilderAI::new;
                this.mineRange = 200.0f;
                this.range = 200.0f;
                this.buildRange = 200.0f;
                this.buildSpeed = 1.0f;
                this.faceTarget = false;
                this.rotateToBuilding = false;
                this.speed = 0.5f;
                this.hitSize = 8.0f;
                this.health = 150.0f;
                this.boostMultiplier = 0.8f;
                this.mineTier = 3;
                this.abilities.addAll((Object[])new Ability[]{new DroneAbility(){
                    {
                        this.name = "omaloon-combat-drone";
                        this.droneUnit = attackDroneAlpha;
                        this.droneController = AttackDroneAI::new;
                        this.spawnTime = 180.0f;
                        this.spawnX = 5.0f;
                        this.spawnY = 0.0f;
                        this.spawnEffect = Fx.spawn;
                        this.parentizeEffects = true;
                        this.anchorPos = new Vec2[]{new Vec2(12.0f, 0.0f)};
                    }
                }, new DroneAbility(){
                    {
                        this.name = "omaloon-utility-drone";
                        this.droneUnit = actionDroneMono;
                        this.droneController = UtilityDroneAI::new;
                        this.spawnTime = 180.0f;
                        this.spawnX = -5.0f;
                        this.spawnY = 0.0f;
                        this.spawnEffect = Fx.spawn;
                        this.parentizeEffects = true;
                        this.anchorPos = new Vec2[]{new Vec2(-12.0f, 0.0f)};
                    }
                }});
                this.shadowElevationScl = 0.3f;
            }
        };
        discovery = new GlassmoreUnitType("discovery"){
            {
                this.controller = u -> new BuilderAI(true, 500.0f);
                this.constructor = UnitEntity::create;
                this.hittable = false;
                this.isEnemy = false;
                this.lowAltitude = true;
                this.flying = true;
                this.mineSpeed = 4.5f;
                this.mineTier = 2;
                this.mineItems = Seq.with((Object[])new Item[]{OlItems.cobalt, Items.beryllium});
                this.buildSpeed = 0.3f;
                this.drag = 0.03f;
                this.speed = 2.0f;
                this.rotateSpeed = 13.0f;
                this.accel = 0.1f;
                this.itemCapacity = 20;
                this.health = 110.0f;
                this.engineOffset = 5.0f;
                this.hitSize = 8.0f;
                this.alwaysUnlocked = true;
            }
        };
        effort = new OrnitopterUnitType("effort"){
            {
                this.constructor = OrnitopterFlyingUnit::create;
                this.aiController = CowardAI::new;
                this.lowAltitude = true;
                this.speed = 2.7f;
                this.accel = 0.08f;
                this.drag = 0.04f;
                this.flying = true;
                this.health = 210.0f;
                this.maxRange = this.range = 120.0f;
                this.rotateMoveFirst = true;
                this.rotateSpeed = 6.0f;
                this.fallDriftScl = 60.0f;
                for (final float angle : new float[]{40.0f, -40.0f}) {
                    this.blades.addAll((Object[])new Blade[]{new Blade(this.name + "-blade"){
                        {
                            super(name);
                            this.x = 6.0f;
                            this.y = 2.0f;
                            this.bladeMaxMoveAngle = angle;
                            this.blurAlpha = 1.0f;
                        }
                    }});
                }
                this.parts.add((Object)new RegionPart("-tusk"){
                    {
                        super(arg0);
                        this.layerOffset = -0.001f;
                        this.mirror = true;
                        this.x = 2.7f;
                        this.y = 8.6f;
                        this.outline = true;
                    }
                });
                this.abilities.add((Object)new JavelinAbility(20.0f, 5.0f, 29.0f){
                    {
                        super(damage, damageInterval, radius);
                        this.minDamage = 5.0f;
                        this.minSpeed = 2.0f;
                        this.maxSpeed = 4.0f;
                        this.magX = 0.2f;
                        this.magY = 0.1f;
                    }
                });
                this.weapons.add((Object)new Weapon(this.name + "-launcher"){
                    {
                        super(arg0);
                        this.layerOffset = 1.0f;
                        this.mirror = true;
                        this.x = 4.7f;
                        this.y = 2.0f;
                        this.shootCone = 60.0f;
                        this.smoothReloadSpeed = 0.5f;
                        this.shootSound = Sounds.missile;
                        this.reload = 50.0f;
                        this.shoot.shots = 2;
                        this.shoot.shotDelay = 7.0f;
                        this.bullet = new MissileBulletType(3.0f, 3.0f){
                            {
                                super(arg0, arg1);
                                this.width = 5.0f;
                                this.height = 4.0f;
                                this.shrinkY = 0.0f;
                                this.homingRange = 60.0f;
                                this.maxRange = 120.0f;
                                this.splashDamageRadius = 25.0f;
                                this.splashDamage = 5.0f;
                                this.lifetime = 45.0f;
                                this.backColor = this.trailColor = Color.valueOf((String)"feb380");
                                this.frontColor = this.trailColor;
                                this.trailChance = 0.0f;
                                this.trailInterval = 3.0f;
                                this.hitEffect = Fx.blastExplosion;
                                this.despawnEffect = Fx.blastExplosion;
                                this.weaveScale = 6.0f;
                                this.weaveMag = 1.0f;
                            }
                        };
                    }
                });
                this.hitSize = 16.0f;
            }
        };
        lumen = new GlassmoreUnitType("lumen"){
            {
                this.constructor = UnitEntity::create;
                this.hitSize = 10.0f;
                this.speed = 1.7f;
                this.accel = 0.08f;
                this.drag = 0.04f;
                this.flying = true;
                this.range = 5.0f;
                this.health = 70.0f;
                this.weapons.add((Object)new FilterWeapon(){
                    {
                        this.mirror = false;
                        this.x = 0.0f;
                        this.y = 4.0f;
                        this.shootSound = Sounds.release;
                        this.shoot = new ShootSpread(30, 1.0f);
                        this.inaccuracy = 12.0f;
                        this.velocityRnd = 0.8f;
                        this.reload = 30.0f;
                        this.shootCone = 20.0f;
                        this.bullets = new BulletType[]{new LiquidBulletType(OlLiquids.glacium){
                            {
                                super(arg0);
                                this.recoil = 0.06f;
                                this.killShooter = true;
                                this.speed = 2.5f;
                                this.drag = 0.009f;
                                this.shootEffect = Fx.shootSmall;
                                this.lifetime = 27.0f;
                                this.collidesAir = false;
                                this.status = OlStatusEffects.glacied;
                                this.statusDuration = 300.0f;
                                this.despawnSound = this.hitSound = Sounds.splash;
                            }
                        }, new LiquidBulletType(Liquids.water){
                            {
                                super(arg0);
                                this.recoil = 0.06f;
                                this.killShooter = true;
                                this.speed = 2.5f;
                                this.drag = 0.009f;
                                this.shootEffect = Fx.shootSmall;
                                this.lifetime = 27.0f;
                                this.collidesAir = false;
                                this.status = StatusEffects.wet;
                                this.statusDuration = 300.0f;
                                this.despawnSound = this.hitSound = Sounds.splash;
                            }
                        }, new LiquidBulletType(Liquids.slag){
                            {
                                super(arg0);
                                this.recoil = 0.06f;
                                this.killShooter = true;
                                this.speed = 2.5f;
                                this.drag = 0.009f;
                                this.shootEffect = Fx.shootSmall;
                                this.lifetime = 27.0f;
                                this.collidesAir = false;
                                this.status = StatusEffects.melting;
                                this.statusDuration = 300.0f;
                                this.despawnSound = this.hitSound = Sounds.splash;
                            }
                        }, new LiquidBulletType(Liquids.oil){
                            {
                                super(arg0);
                                this.recoil = 0.06f;
                                this.killShooter = true;
                                this.speed = 2.5f;
                                this.drag = 0.009f;
                                this.shootEffect = Fx.shootSmall;
                                this.lifetime = 27.0f;
                                this.collidesAir = false;
                                this.status = StatusEffects.tarred;
                                this.statusDuration = 300.0f;
                                this.despawnSound = this.hitSound = Sounds.splash;
                            }
                        }};
                        this.icons = new String[]{"omaloon-filled-with-glacium", "omaloon-filled-with-water", "omaloon-filled-with-slag", "omaloon-filled-with-oil"};
                        this.bulletFilter = unit -> {
                            if (unit.hasEffect(OlStatusEffects.filledWithGlacium)) {
                                return this.bullets[0];
                            }
                            if (unit.hasEffect(OlStatusEffects.filledWithWater)) {
                                return this.bullets[1];
                            }
                            if (unit.hasEffect(OlStatusEffects.filledWithSlag)) {
                                return this.bullets[2];
                            }
                            if (unit.hasEffect(OlStatusEffects.filledWithOil)) {
                                return this.bullets[3];
                            }
                            return new BulletType(0.0f, 0.0f){
                                {
                                    super(arg0, arg1);
                                    this.hitEffect = this.despawnEffect = Fx.none;
                                    this.smokeEffect = this.despawnEffect;
                                    this.shootEffect = this.despawnEffect;
                                }
                            };
                        };
                    }
                });
            }
        };
        legionnaire = new GlassmoreUnitType("legionnaire"){
            {
                this.constructor = MechUnit::create;
                this.speed = 0.5f;
                this.hitSize = 8.0f;
                this.health = 150.0f;
                this.outlineRegion = Core.atlas.find("omaloon-legionnaire-outline");
                this.alwaysCreateOutline = true;
                this.weapons.add((Object)new Weapon("omaloon-legionnaire-weapon"){
                    {
                        super(arg0);
                        this.shootSound = OlSounds.theShoot;
                        this.top = false;
                        this.layerOffset = -0.001f;
                        this.reload = 35.0f;
                        this.x = 4.7f;
                        this.y = 0.4f;
                        this.shootCone = 45.0f;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = new BasicBulletType(2.5f, 5.0f){
                            {
                                super(arg0, arg1);
                                this.width = 7.0f;
                                this.height = 7.0f;
                                this.lifetime = 35.0f;
                                this.maxRange = 100.0f;
                                this.despawnEffect = Fx.hitBulletSmall;
                                this.hitEffect = Fx.none;
                                this.backColor = this.trailColor = Color.valueOf((String)"feb380");
                                this.hitColor = this.trailColor;
                                this.trailWidth = 1.3f;
                                this.trailLength = 10;
                            }
                        };
                    }
                });
            }
        };
        centurion = new GlassmoreUnitType("centurion"){
            {
                this.constructor = MechUnit::create;
                this.speed = 0.4f;
                this.hitSize = 9.0f;
                this.health = 250.0f;
                this.range = 100.0f;
                this.weapons.add((Object)new Weapon("omaloon-centurion-weapon"){
                    {
                        super(arg0);
                        this.shootSound = OlSounds.theShoot;
                        this.mirror = true;
                        this.top = false;
                        this.x = 5.5f;
                        this.y = 0.7f;
                        this.shootX = -0.5f;
                        this.shootY = 5.5f;
                        this.reload = 35.0f;
                        this.recoil = 0.6f;
                        this.shoot.shots = 2;
                        this.shoot.shotDelay = 4.0f;
                        this.shootCone = 45.0f;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = new BasicBulletType(2.5f, 5.0f){
                            {
                                super(arg0, arg1);
                                this.width = 7.0f;
                                this.height = 7.0f;
                                this.lifetime = 35.0f;
                                this.maxRange = 100.0f;
                                this.despawnEffect = Fx.hitBulletSmall;
                                this.hitEffect = Fx.none;
                                this.backColor = this.trailColor = Color.valueOf((String)"feb380");
                                this.hitColor = this.trailColor;
                                this.trailWidth = 1.3f;
                                this.trailLength = 10;
                                this.fragBullet = new BasicBulletType(2.5f, 1.5f){
                                    {
                                        super(arg0, arg1);
                                        this.width = 4.0f;
                                        this.height = 4.0f;
                                        this.lifetime = 15.0f;
                                        this.despawnEffect = Fx.none;
                                        this.hitEffect = Fx.none;
                                        this.backColor = this.trailColor = Color.valueOf((String)"feb380");
                                        this.hitColor = this.trailColor;
                                        this.trailWidth = 0.8f;
                                        this.trailLength = 10;
                                    }
                                };
                                this.fragOnHit = true;
                                this.fragBullets = 4;
                                this.fragRandomSpread = 45.0f;
                                this.fragVelocityMin = 0.7f;
                            }
                        };
                    }
                });
            }
        };
        praetorian = new GlassmoreUnitType("praetorian"){
            {
                this.constructor = MechUnit::create;
                this.speed = 0.3f;
                this.hitSize = 16.0f;
                this.rotateSpeed = 2.0f;
                this.health = 400.0f;
                this.range = 80.0f;
                this.parts.add((Object)new ConstructPart("-can"){
                    {
                        super(suffix);
                        this.y = 3.75f;
                        this.outlineLayerOffset = -0.01f;
                        this.progress = DrawPart.PartProgress.reload.inv();
                    }
                });
                this.weapons.add((Object)new Weapon(""){
                    {
                        super(arg0);
                        this.x = 0.0f;
                        this.y = 3.75f;
                        this.reload = 100.0f;
                        this.mirror = false;
                        this.shootCone = 45.0f;
                        this.shootSound = Sounds.missileLarge;
                        this.bullet = new LaunchBulletType(1.0f, 0.0f){
                            {
                                super(speed, damage);
                                this.sprite = "omaloon-praetorian-can";
                                this.frontColor = Color.white;
                                this.lifetime = 120.0f;
                                this.height = 12.0f;
                                this.width = 12.0f;
                                this.drawSize = 240.0f;
                                this.fadeAt = 0.4f;
                                this.pitch = 0.3f;
                                this.trailWidth = 4.0f;
                                this.trailLength = 5;
                                this.despawnSound = Sounds.artillery;
                                this.despawnEffect = new WaveEffect(){
                                    {
                                        this.colorFrom = this.colorTo = Color.valueOf((String)"FEB380");
                                        this.interp = Interp.bounceOut;
                                        this.lifetime = 60.0f;
                                        this.sizeTo = 24.0f;
                                        this.sizeFrom = 24.0f;
                                    }
                                };
                                this.hitEffect = Fx.none;
                                this.shrinkInterp = Interp.smooth;
                                this.fragInterp = Interp.circleIn;
                                this.shadowInterp = Interp.circleOut;
                                this.fragBullets = 3;
                                this.fragBullet = new BasicBulletType(6.0f, 10.0f, "omaloon-cross-bullet"){
                                    {
                                        super(arg0, arg1, arg2);
                                        this.hitColor = this.trailColor = Color.valueOf((String)"FEB380");
                                        this.backColor = this.trailColor;
                                        this.frontColor = this.trailColor;
                                        this.lifetime = 20.0f;
                                        this.height = 12.0f;
                                        this.width = 12.0f;
                                        this.shrinkY = 0.0f;
                                        this.shrinkX = 0.0f;
                                        this.drag = 0.15f;
                                        this.trailWidth = 2.0f;
                                        this.trailLength = 5;
                                        this.hitSound = this.despawnSound = Sounds.explosion;
                                    }
                                };
                            }
                        };
                    }
                });
            }
        };
        cilantro = new GlassmoreUnitType("cilantro"){
            {
                this.lowAltitude = true;
                this.flying = true;
                this.health = 160.0f;
                this.hitSize = 8.0f;
                this.accel = 0.05f;
                this.drag = 0.03f;
                this.rotateSpeed = 10.0f;
                this.trailLength = 10;
                this.constructor = UnitEntity::create;
                this.weapons.addAll((Object[])new Weapon[]{new Weapon(){
                    {
                        this.mirror = false;
                        this.x = 0.0f;
                        this.y = 1.0f;
                        this.reload = 30.0f;
                        this.shoot.firstShotDelay = 60.0f;
                        this.shootCone = 45.0f;
                        this.shootSound = Sounds.lasershoot;
                        this.bullet = new BasicBulletType(2.0f, 6.0f, "omaloon-triangle-bullet"){
                            {
                                super(arg0, arg1, arg2);
                                this.height = 8.0f;
                                this.width = 8.0f;
                                this.shrinkY = 0.0f;
                                this.trailWidth = 2.0f;
                                this.trailLength = 5;
                                this.frontColor = Color.valueOf((String)"D1EFFF");
                                this.hitColor = this.trailColor = Color.valueOf((String)"8CA9E8");
                                this.backColor = this.trailColor;
                                this.chargeEffect = OlFx.shootShockwave;
                                this.shootEffect = this.smokeEffect = Fx.none;
                            }
                        };
                    }
                }});
            }
        };
        basil = new GlassmoreUnitType("basil"){
            {
                this.lowAltitude = true;
                this.flying = true;
                this.health = 280.0f;
                this.hitSize = 20.0f;
                this.drag = 0.09f;
                this.speed = 1.8f;
                this.rotateSpeed = 2.5f;
                this.accel = 0.05f;
                this.engineOffset = 12.0f;
                this.setEnginesMirror(new UnitType.UnitEngine[]{new UnitType.UnitEngine(5.0f, -10.0f, 2.0f, -45.0f)});
                this.constructor = UnitEntity::create;
                this.weapons.addAll((Object[])new Weapon[]{new Weapon(){
                    {
                        this.mirror = false;
                        this.alwaysContinuous = true;
                        this.continuous = true;
                        this.x = 0.0f;
                        this.y = -3.0f;
                        this.shootSound = Sounds.smelter;
                        this.bullet = new ContinuousFlameBulletType(5.0f){
                            {
                                super(arg0);
                                this.colors = new Color[]{Color.valueOf((String)"8CA9E8"), Color.valueOf((String)"8CA9E8"), Color.valueOf((String)"D1EFFF")};
                                this.lifetime = 60.0f;
                                shootCone = 360.0f;
                                this.width = 2.5f;
                                this.length = 75.0f;
                                this.lengthInterp = a -> Interp.smoother.apply(Mathf.slope((float)a));
                                this.flareLength = 20.0f;
                                this.flareRotSpeed = 0.0f;
                                this.flareInnerLenScl = 0.0f;
                                this.pierceCap = 1;
                                this.flareColor = Color.valueOf((String)"D1EFFF");
                                this.hitEffect = new ParticleEffect(){
                                    {
                                        this.lifetime = 30.0f;
                                        this.length = 20.0f;
                                        this.interp = Interp.pow2Out;
                                        this.colorFrom = Color.valueOf((String)"D1EFFF");
                                        this.colorTo = Color.valueOf((String)"8CA9E8");
                                    }
                                };
                            }
                        };
                    }
                }});
            }
        };
        sage = new GlassmoreUnitType("sage"){
            {
                this.lowAltitude = true;
                this.flying = true;
                this.health = 550.0f;
                this.hitSize = 35.0f;
                this.speed = 0.8f;
                this.accel = 0.04f;
                this.drag = 0.04f;
                this.rotateSpeed = 1.9f;
                this.constructor = UnitEntity::create;
                this.engineOffset = 16.0f;
                this.engineSize = 6.0f;
                this.setEnginesMirror(new UnitType.UnitEngine[]{new UnitType.UnitEngine(10.0f, -14.0f, 3.0f, -45.0f)});
                BasicBulletType shootType = new BasicBulletType(2.0f, 5.0f){
                    {
                        super(arg0, arg1);
                        this.lifetime = 55.0f;
                        this.splashDamage = 20.0f;
                        this.splashDamageRadius = 32.0f;
                        this.height = 8.0f;
                        this.width = 8.0f;
                        this.shrinkY = 0.0f;
                        this.trailWidth = 2.0f;
                        this.trailLength = 5;
                        this.frontColor = Color.valueOf((String)"D1EFFF");
                        this.backColor = this.trailColor = Color.valueOf((String)"8CA9E8");
                        this.hitEffect = this.despawnEffect = OlFx.hitSage;
                        this.hitSound = this.despawnSound = Sounds.plasmaboom;
                    }
                };
                this.weapons.addAll((Object[])new Weapon[]{new Weapon("omaloon-sage-salvo", (BulletType)shootType){
                    final /* synthetic */ BulletType val$shootType;
                    {
                        this.val$shootType = bulletType;
                        super(arg0);
                        this.reload = 90.0f;
                        this.rotate = true;
                        this.rotateSpeed = 12.0f;
                        this.x = 6.5f;
                        this.y = 1.0f;
                        this.shoot.firstShotDelay = 40.0f;
                        this.shootCone = 45.0f;
                        this.shootSound = Sounds.missile;
                        this.bullet = this.val$shootType;
                    }
                }, new Weapon("omaloon-sage-salvo", (BulletType)shootType){
                    final /* synthetic */ BulletType val$shootType;
                    {
                        this.val$shootType = bulletType;
                        super(arg0);
                        this.reload = 90.0f;
                        this.rotate = true;
                        this.rotateSpeed = 14.0f;
                        this.x = -10.25f;
                        this.y = -8.0f;
                        this.shootSound = Sounds.missile;
                        this.bullet = this.val$shootType;
                    }
                }});
            }
        };
    }
}

