/*
 * Decompiled with CFR 0.152.
 */
package omaloon.content;

import arc.Core;
import arc.assets.AssetDescriptor;
import arc.assets.AssetLoaderParameters;
import arc.assets.loaders.SoundLoader;
import arc.audio.Sound;
import mindustry.Vars;

public class OlSounds {
    public static Sound debrisBreak = new Sound();
    public static Sound bigHailstoneHit = new Sound();
    public static Sound giantHailstoneFall = new Sound();
    public static Sound giantHailstoneHit = new Sound();
    public static Sound hailRain = new Sound();
    public static Sound hammer = new Sound();
    public static Sound jam = new Sound();
    public static Sound shelter = new Sound();
    public static Sound shelterPush = new Sound();
    public static Sound theShoot = new Sound();
    public static Sound convergence = new Sound();

    public static void load() {
        debrisBreak = OlSounds.loadSound("debris_break");
        theShoot = OlSounds.loadSound("the_shoot");
        hailRain = OlSounds.loadSound("hail_rain");
        bigHailstoneHit = OlSounds.loadSound("big_hailstone_hit");
        giantHailstoneFall = OlSounds.loadSound("giant_hailstone_fall");
        giantHailstoneHit = OlSounds.loadSound("giant_hailstone_hit");
        hammer = OlSounds.loadSound("hammer");
        jam = OlSounds.loadSound("jam");
        shelter = OlSounds.loadSound("shelter");
        shelterPush = OlSounds.loadSound("shelter_push");
        convergence = OlSounds.loadSound("convergence");
    }

    private static Sound loadSound(String soundName) {
        if (!Vars.headless) {
            String name = "sounds/" + soundName;
            String path = Vars.tree.get(name + ".ogg").exists() ? name + ".ogg" : name + ".mp3";
            Sound sound = new Sound();
            AssetDescriptor desc = Core.assets.load(path, Sound.class, (AssetLoaderParameters)new SoundLoader.SoundParameter(sound));
            desc.errored = Throwable::printStackTrace;
            return sound;
        }
        return new Sound();
    }
}

