/*
 * Decompiled with CFR 0.152.
 */
package omaloon.content;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Mat3D;
import arc.math.geom.Vec3;
import arc.struct.Seq;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.game.Schematics;
import mindustry.graphics.g3d.GenericMesh;
import mindustry.graphics.g3d.HexMesh;
import mindustry.graphics.g3d.HexSkyMesh;
import mindustry.graphics.g3d.MatMesh;
import mindustry.graphics.g3d.MultiMesh;
import mindustry.graphics.g3d.NoiseMesh;
import mindustry.graphics.g3d.PlanetGrid;
import mindustry.graphics.g3d.SunMesh;
import mindustry.maps.planet.AsteroidGenerator;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.world.Block;
import mindustry.world.meta.BuildVisibility;
import omaloon.content.OlItems;
import omaloon.content.blocks.OlEnvironmentBlocks;
import omaloon.graphics.g3d.CircleMesh;
import omaloon.maps.ColorPass;
import omaloon.maps.HeightPass;
import omaloon.maps.planets.GlasmorePlanetGenerator;
import omaloon.maps.planets.PurpuraPlanetGenerator;
import omaloon.type.BetterPlanet;

public class OlPlanets {
    public static Planet omaloon;
    public static Planet glasmore;
    public static Planet purpura;
    public static Planet tupi;
    public static Planet salv;
    public static Planet lyssa;

    public static void load() {
        omaloon = new Planet("omaloon", null, 4.0f, 0){
            {
                this.bloom = true;
                this.accessible = false;
                this.hasAtmosphere = true;
                this.solarSystem = this;
                this.meshLoader = () -> new SunMesh((Planet)this, 4, 5.0, (double)0.3f, 1.0, (double)1.2f, 1.0, 1.3f, new Color[]{Color.valueOf((String)"#8B4513"), Color.valueOf((String)"#A0522D"), Color.valueOf((String)"c2311e"), Color.valueOf((String)"ff6730"), Color.valueOf((String)"bf342f"), Color.valueOf((String)"8e261d")});
            }
        };
        glasmore = new BetterPlanet("glasmore", omaloon, 1.0f, 4){
            {
                this.icon = "glasmore";
                this.solarSystem = omaloon;
                this.startSector = 492;
                this.clearSectorOnLose = true;
                this.allowLaunchSchematics = true;
                this.allowLaunchLoadout = true;
                this.alwaysUnlocked = true;
                this.allowLaunchToNumbered = false;
                this.orbitRadius = 40.0f;
                this.rotateTime = 1380.0f;
                this.atmosphereRadIn = 0.0f;
                this.atmosphereRadOut = 0.3f;
                this.atmosphereColor = OlEnvironmentBlocks.glacium.mapColor;
                this.itemWhitelist.add(OlItems.glasmoreItems);
                this.unlockedOnLand.add((Object)OlItems.cobalt);
                this.ruleSetter = r -> {
                    r.blockWhitelist = true;
                    r.hideBannedBlocks = true;
                    r.bannedBlocks.clear();
                    r.bannedBlocks.addAll(Vars.content.blocks().select(block -> {
                        boolean omaloonOnly = block.minfo.mod != null && block.minfo.mod.name.equals("omaloon");
                        boolean sandboxOnly = block.buildVisibility == BuildVisibility.sandboxOnly;
                        return omaloonOnly || sandboxOnly;
                    }));
                };
                final Vec3 ringPos = new Vec3(0.0f, 1.0f, 0.0f).rotate(Vec3.X, 25.0f);
                this.generator = new GlasmorePlanetGenerator(){
                    {
                        int i;
                        int i2;
                        this.defaultLoadout = Schematics.readBase64((String)"bXNjaAF4nGNgZmBmZmDJS8xNZeB0zi9KVXDLyU9l4E5JLU4uyiwoyczPY2BgYMtJTErNKWZgio5lZBDMz03Myc/P000GKtdNAylnYGAEISABADBoE3w=");
                        this.baseHeight = 0.0f;
                        this.baseColor = OlEnvironmentBlocks.albaster.mapColor;
                        this.heights.add((Object)new HeightPass.NoiseHeight(){
                            {
                                this.offset.set(1000.0f, 0.0f, 0.0f);
                                this.octaves = 7.0;
                                this.persistence = 0.5;
                                this.magnitude = 1.0f;
                                this.heightOffset = -0.5f;
                            }
                        });
                        Mathf.rand.setSeed(2L);
                        Seq mountains = new Seq();
                        for (i2 = 0; i2 < 20; ++i2) {
                            mountains.add((Object)new HeightPass.DotHeight(){
                                {
                                    this.dir.setToRandomDirection().y = Mathf.random((float)2.0f, (float)5.0f);
                                    this.min = 0.99f;
                                    this.magnitude = Math.max(0.7f, this.dir.nor().y) * 0.3f;
                                    this.interp = Interp.exp10In;
                                }
                            });
                        }
                        this.heights.add((Object)new HeightPass.MultiHeight((Seq<HeightPass>)mountains, HeightPass.MultiHeight.MixType.max, HeightPass.MultiHeight.Operation.add));
                        mountains = new Seq();
                        for (i2 = 0; i2 < 20; ++i2) {
                            mountains.add((Object)new HeightPass.DotHeight(){
                                {
                                    this.dir.setToRandomDirection().y = Mathf.random((float)-2.0f, (float)-5.0f);
                                    this.min = 0.99f;
                                    this.magnitude = Math.max(0.7f, this.dir.nor().y) * 0.3f;
                                    this.dir.rotate(Vec3.X, 22.0f);
                                    this.interp = Interp.exp10In;
                                }
                            });
                        }
                        this.heights.add((Object)new HeightPass.MultiHeight((Seq<HeightPass>)mountains, HeightPass.MultiHeight.MixType.max, HeightPass.MultiHeight.Operation.add));
                        Seq craters = new Seq();
                        Mathf.rand.setSeed(3L);
                        for (i = 0; i < 5; ++i) {
                            craters.add((Object)new HeightPass.SphereHeight(){
                                {
                                    this.pos.set(Vec3.Y).rotate(Vec3.X, 115.0f).rotate(ringPos, Mathf.random((float)360.0f));
                                    this.radius = 0.14f + Mathf.random((float)0.05f);
                                    this.offset = 0.2f;
                                    this.set = true;
                                }
                            });
                        }
                        this.heights.addAll((Object[])new HeightPass[]{new HeightPass.MultiHeight((Seq<HeightPass>)craters, HeightPass.MultiHeight.MixType.max, HeightPass.MultiHeight.Operation.set)});
                        Mathf.rand.setSeed(3L);
                        for (i = 0; i < 5; ++i) {
                            this.heights.add((Object)new HeightPass.SphereHeight(){
                                {
                                    this.pos.set(Vec3.Y).rotate(Vec3.X, 115.0f).rotate(ringPos, Mathf.random((float)360.0f));
                                    this.radius = 0.07f + Mathf.random((float)0.05f);
                                    this.set = true;
                                }
                            });
                        }
                        this.heights.add((Object)new HeightPass.ClampHeight(0.0f, 0.8f));
                        this.colors.addAll((Object[])new ColorPass[]{new ColorPass.NoiseColorPass(){
                            {
                                this.scale = 1.5;
                                this.persistence = 0.5;
                                this.octaves = 3.0;
                                this.magnitude = 1.2f;
                                this.min = 0.3f;
                                this.max = 0.6f;
                                this.out = OlEnvironmentBlocks.deadGrass.mapColor;
                                this.offset.set(1500.0f, 300.0f, -500.0f);
                            }
                        }, new ColorPass.NoiseColorPass(){
                            {
                                this.seed = 5;
                                this.scale = 1.5;
                                this.persistence = 0.5;
                                this.octaves = 5.0;
                                this.magnitude = 1.2f;
                                this.min = 0.1f;
                                this.max = 0.4f;
                                this.out = OlEnvironmentBlocks.aghatite.mapColor;
                                this.offset.set(1500.0f, 300.0f, -500.0f);
                            }
                        }, new ColorPass.NoiseColorPass(){
                            {
                                this.seed = 8;
                                this.scale = 1.5;
                                this.persistence = 0.5;
                                this.octaves = 7.0;
                                this.magnitude = 1.2f;
                                this.min = 0.1f;
                                this.max = 0.4f;
                                this.out = OlEnvironmentBlocks.quartzSand.mapColor;
                                this.offset.set(1500.0f, 300.0f, -500.0f);
                            }
                        }});
                        for (i = 0; i < 5; ++i) {
                            this.colors.add((Object)new ColorPass.SphereColorPass(new Vec3().setToRandomDirection(), 0.06f, OlEnvironmentBlocks.grenite.mapColor));
                        }
                        this.colors.add((Object)new ColorPass.FlatColorPass(){
                            {
                                this.max = 0.0f;
                                this.min = 0.0f;
                                this.out = OlEnvironmentBlocks.blueIce.mapColor;
                            }
                        }, (Object)new ColorPass.FlatColorPass(){
                            {
                                this.min = 0.3f;
                                this.max = 0.5f;
                                this.out = OlEnvironmentBlocks.deadGrass.mapColor;
                            }
                        }, (Object)new ColorPass.FlatColorPass(){
                            {
                                this.max = 1.0f;
                                this.min = 0.5f;
                                this.out = OlEnvironmentBlocks.blueIce.mapColor;
                            }
                        });
                        craters.map(height -> (HeightPass.SphereHeight)height).each(height -> this.colors.add((Object)new ColorPass.SphereColorPass(height.pos, height.radius / 1.75f, OlEnvironmentBlocks.glacium.mapColor)));
                    }
                };
                this.meshLoader = () -> new MultiMesh(new GenericMesh[]{new BetterPlanet.AtmosphereHexMesh(this, 7), new HexMesh((Planet)this, 7), new CircleMesh((TextureRegion)Core.atlas.find("omaloon-ring4"), this, 80, 2.55f, 2.6f, ringPos), new CircleMesh((TextureRegion)Core.atlas.find("omaloon-ring3"), this, 80, 2.2f, 2.5f, ringPos), new CircleMesh((TextureRegion)Core.atlas.find("omaloon-ring2"), this, 80, 1.9f, 2.1f, ringPos), new CircleMesh((TextureRegion)Core.atlas.find("omaloon-ring1"), this, 80, 1.8f, 1.85f, ringPos)});
                this.cloudMeshLoader = () -> new MultiMesh(new GenericMesh[]{new HexSkyMesh((Planet)this, 6, -0.5f, 0.14f, 6, OlEnvironmentBlocks.blueIce.mapColor.cpy().a(0.2f), 2, 0.42f, 1.0f, 0.6f), new HexSkyMesh((Planet)this, 1, 0.6f, 0.15f, 6, OlEnvironmentBlocks.blueIce.mapColor.cpy().a(0.2f), 2, 0.42f, 1.2f, 0.5f)});
            }
        };
        purpura = new BetterPlanet("purpura", omaloon, 1.0f){
            {
                this.icon = "purpura";
                this.accessible = false;
                this.atmosphereColor = Color.valueOf((String)"4F424D");
                this.atmosphereRadIn = 0.0f;
                this.atmosphereRadOut = 0.05f;
                this.orbitRadius = 20.0f;
                this.generator = new PurpuraPlanetGenerator();
                this.meshLoader = () -> new MultiMesh(new GenericMesh[]{new BetterPlanet.AtmosphereHexMesh(this, 7), new HexMesh((Planet)this, 7)});
                this.cloudMeshLoader = () -> new MultiMesh(new GenericMesh[]{new HexSkyMesh((Planet)this, 1, 1.0f, 0.05f, 6, Color.valueOf((String)"242424").a(0.6f), 2, 0.8f, 1.0f, 0.0f), new HexSkyMesh((Planet)this, 2, -1.3f, 0.06f, 6, Color.valueOf((String)"413B42").a(0.6f), 2, 0.8f, 1.0f, 0.5f), new HexSkyMesh((Planet)this, 3, 1.3f, 0.07f, 6, Color.valueOf((String)"7F777E").a(0.6f), 2, 0.8f, 1.2f, 0.5f), new HexSkyMesh((Planet)this, 4, -1.6f, 0.08f, 6, Color.valueOf((String)"B2B2B2").a(0.6f), 2, 0.8f, 1.2f, 0.5f)});
            }
        };
        tupi = new Planet("tupi", omaloon, 0.12f){
            {
                Block base = OlEnvironmentBlocks.albaster;
                Block tint = OlEnvironmentBlocks.blueIce;
                this.hasAtmosphere = false;
                this.updateLighting = false;
                this.sectors.add((Object)new Sector((Planet)this, PlanetGrid.Ptile.empty));
                this.camRadius = 1.36f;
                this.minZoom = 0.6f;
                this.orbitRadius = 30.0f;
                this.drawOrbit = false;
                this.accessible = false;
                this.clipRadius = 2.0f;
                this.defaultEnv = 2;
                this.icon = "commandRally";
                this.generator = new AsteroidGenerator();
                this.meshLoader = () -> {
                    this.iconColor = tint.mapColor;
                    Color tinted = tint.mapColor.cpy().a(1.0f - tint.mapColor.a);
                    Seq meshes = new Seq();
                    Color color = base.mapColor;
                    Rand rand = new Rand((long)(this.id + 2));
                    meshes.add((Object)new NoiseMesh((Planet)this, 0, 2, this.radius, 2, 0.55f, 0.45f, 14.0f, color, tinted, 3, 0.6f, 0.38f, 0.5f));
                    for (int j = 0; j < 8; ++j) {
                        meshes.add((Object)new MatMesh((GenericMesh)new NoiseMesh((Planet)this, j + 1, 1, 0.022f + rand.random(0.039f) * 2.0f, 2, 0.6f, 0.38f, 20.0f, color, tinted, 3, 0.6f, 0.38f, 0.5f), new Mat3D().setToTranslation(Tmp.v31.setToRandomDirection(rand).setLength(rand.random(0.44f, 1.4f) * 2.0f))));
                    }
                    return new MultiMesh((GenericMesh[])meshes.toArray(GenericMesh.class));
                };
            }
        };
        salv = new Planet("salv", omaloon, 0.12f){
            {
                Block base = OlEnvironmentBlocks.aghatite;
                Block tint = OlEnvironmentBlocks.weatheredAghanite;
                this.hasAtmosphere = false;
                this.updateLighting = false;
                this.orbitRadius = 10.0f;
                this.sectors.add((Object)new Sector((Planet)this, PlanetGrid.Ptile.empty));
                this.camRadius = 1.36f;
                this.minZoom = 0.6f;
                this.drawOrbit = false;
                this.accessible = false;
                this.clipRadius = 2.0f;
                this.defaultEnv = 2;
                this.icon = "commandRally";
                this.generator = new AsteroidGenerator();
                this.meshLoader = () -> {
                    this.iconColor = tint.mapColor;
                    Color tinted = tint.mapColor.cpy().a(1.0f - tint.mapColor.a);
                    Seq meshes = new Seq();
                    Color color = base.mapColor;
                    Rand rand = new Rand((long)(this.id + 2));
                    meshes.add((Object)new NoiseMesh((Planet)this, 0, 2, this.radius, 2, 0.55f, 0.45f, 14.0f, color, tinted, 3, 0.6f, 0.38f, 0.5f));
                    for (int j = 0; j < 8; ++j) {
                        meshes.add((Object)new MatMesh((GenericMesh)new NoiseMesh((Planet)this, j + 1, 1, 0.022f + rand.random(0.039f) * 2.0f, 2, 0.6f, 0.38f, 20.0f, color, tinted, 3, 0.6f, 0.38f, 0.5f), new Mat3D().setToTranslation(Tmp.v31.setToRandomDirection(rand).setLength(rand.random(0.44f, 1.4f) * 2.0f))));
                    }
                    return new MultiMesh((GenericMesh[])meshes.toArray(GenericMesh.class));
                };
            }
        };
        lyssa = new Planet("lyssa", omaloon, 0.12f){
            {
                Block base = OlEnvironmentBlocks.blueIce;
                Block tint = OlEnvironmentBlocks.berylledAghanite;
                this.hasAtmosphere = false;
                this.updateLighting = false;
                this.orbitRadius = 50.0f;
                this.sectors.add((Object)new Sector((Planet)this, PlanetGrid.Ptile.empty));
                this.camRadius = 1.36f;
                this.minZoom = 0.6f;
                this.drawOrbit = false;
                this.accessible = false;
                this.clipRadius = 2.0f;
                this.defaultEnv = 2;
                this.icon = "commandRally";
                this.generator = new AsteroidGenerator();
                this.meshLoader = () -> {
                    this.iconColor = tint.mapColor;
                    Color tinted = tint.mapColor.cpy().a(1.0f - tint.mapColor.a);
                    Seq meshes = new Seq();
                    Color color = base.mapColor;
                    Rand rand = new Rand((long)(this.id + 2));
                    meshes.add((Object)new NoiseMesh((Planet)this, 0, 2, this.radius, 2, 0.55f, 0.45f, 14.0f, color, tinted, 3, 0.6f, 0.38f, 0.5f));
                    for (int j = 0; j < 8; ++j) {
                        meshes.add((Object)new MatMesh((GenericMesh)new NoiseMesh((Planet)this, j + 1, 1, 0.022f + rand.random(0.039f) * 2.0f, 2, 0.6f, 0.38f, 20.0f, color, tinted, 3, 0.6f, 0.38f, 0.5f), new Mat3D().setToTranslation(Tmp.v31.setToRandomDirection(rand).setLength(rand.random(0.44f, 1.4f) * 2.0f))));
                    }
                    return new MultiMesh((GenericMesh[])meshes.toArray(GenericMesh.class));
                };
            }
        };
    }
}

