/*
 * Decompiled with CFR 0.152.
 */
package omaloon.ai;

import arc.math.Angles;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.ai.types.GroundAI;
import mindustry.entities.Predict;
import mindustry.entities.Sized;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.Weapon;
import omaloon.gen.Millipedec;

public class MillipedeAI
extends GroundAI {
    protected Vec2 commandPosition = new Vec2();
    protected Teamc commandTarget;

    public void updateWeapons() {
        Unit unit = this.unit;
        if (!(unit instanceof Millipedec)) {
            return;
        }
        Millipedec millipedec = (Millipedec)unit;
        if (!millipedec.isHead()) {
            return;
        }
        float rotation = this.unit.rotation - 90.0f;
        boolean ret = this.retarget();
        if (ret) {
            this.target = this.findMainTarget(this.unit.x, this.unit.y, this.unit.range(), this.unit.type.targetAir, this.unit.type.targetGround);
        }
        this.noTargetTime += Time.delta;
        if (this.invalid(this.target)) {
            this.target = null;
        } else {
            this.noTargetTime = 0.0f;
        }
        this.unit.isShooting = false;
        ((Millipedec)this.cast()).distributeActionBack(u -> {
            for (WeaponMount mount : u.mounts) {
                Weapon weapon = mount.weapon;
                float wrange = weapon.range();
                if (!weapon.controllable || weapon.noAttack) continue;
                if (!weapon.aiControllable) {
                    mount.rotate = false;
                    continue;
                }
                float mountX = u.x + Angles.trnsx((float)rotation, (float)weapon.x, (float)weapon.y);
                float mountY = u.y + Angles.trnsy((float)rotation, (float)weapon.x, (float)weapon.y);
                if (this.unit.type.singleTarget) {
                    mount.target = this.target;
                } else {
                    if (ret) {
                        mount.target = this.findTarget(mountX, mountY, wrange, weapon.bullet.collidesAir, weapon.bullet.collidesGround);
                    }
                    if (this.checkTarget(mount.target, mountX, mountY, wrange)) {
                        mount.target = null;
                    }
                }
                boolean shoot = false;
                if (mount.target != null) {
                    float f;
                    Teamc patt1655$temp;
                    Teamc teamc = patt1655$temp = mount.target;
                    if (patt1655$temp instanceof Sized) {
                        Sized s = (Sized)patt1655$temp;
                        f = s.hitSize() / 2.0f;
                    } else {
                        f = 0.0f;
                    }
                    shoot = teamc.within(mountX, mountY, wrange + f) && this.shouldShoot();
                    Vec2 to = Predict.intercept((Position)this.unit, (Position)mount.target, (float)weapon.bullet.speed);
                    mount.aimX = to.x;
                    mount.aimY = to.y;
                }
                mount.shoot = mount.rotate = shoot;
                this.unit.isShooting |= mount.rotate;
                if (mount.target == null && !shoot && !Angles.within((float)mount.rotation, (float)mount.weapon.baseRotation, (float)0.01f) && this.noTargetTime >= 300.0f) {
                    mount.rotate = true;
                    Tmp.v1.trns(u.rotation + mount.weapon.baseRotation, 5.0f);
                    mount.aimX = mountX + Tmp.v1.x;
                    mount.aimY = mountY + Tmp.v1.y;
                }
                if (!shoot) continue;
                this.unit.aimX = mount.aimX;
                this.unit.aimY = mount.aimY;
            }
        });
    }

    public void updateMovement() {
        if (this.commandTarget != null && !this.unit.within((Position)this.commandTarget, this.unit.type.range * 0.8f)) {
            this.moveTo((Position)this.commandTarget, this.unit.type.range * 0.8f);
        } else if (!this.commandPosition.isZero()) {
            this.moveTo((Position)this.commandPosition, 0.0f);
        } else {
            super.updateMovement();
        }
        this.faceTarget();
    }

    public Teamc findTarget(float x, float y, float range, boolean air, boolean ground) {
        Teamc target = this.commandTarget != null && this.commandTarget.within(x, y, range) && this.commandTarget.team() == this.unit.team && this.commandTarget.isNull() ? this.commandTarget : null;
        return target != null ? target : super.findTarget(x, y, range, air, ground);
    }

    public void commandPosition(Vec2 pos) {
        this.commandPosition.set(pos);
        this.commandTarget = null;
    }

    public void commandTarget(Teamc moveTo) {
        this.commandTarget = moveTo;
        this.commandPosition.setZero();
    }

    public <T extends Unit> T cast() {
        return (T)this.unit;
    }
}

