/*
 * Decompiled with CFR 0.152.
 */
package omaloon;

import arc.Core;
import arc.Events;
import arc.scene.Action;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.util.Log;
import mindustry.Vars;
import mindustry.content.TechTree;
import mindustry.game.EventType;
import mindustry.mod.Mod;
import mindustry.mod.Mods;
import mindustry.type.Planet;
import omaloon.content.OlBlocks;
import omaloon.content.OlIcons;
import omaloon.content.OlItems;
import omaloon.content.OlLiquids;
import omaloon.content.OlMusics;
import omaloon.content.OlPlanets;
import omaloon.content.OlSchematics;
import omaloon.content.OlSectorPresets;
import omaloon.content.OlSounds;
import omaloon.content.OlStatusEffects;
import omaloon.content.OlTechTree;
import omaloon.content.OlUnitTypes;
import omaloon.content.OlWeathers;
import omaloon.core.EditorListener;
import omaloon.core.OlSettings;
import omaloon.core.SafeClearer;
import omaloon.gen.EntityRegistry;
import omaloon.graphics.OlShaders;
import omaloon.ui.OlBinding;
import omaloon.ui.StartSplash;
import omaloon.ui.dialogs.EventHints;
import omaloon.ui.dialogs.OlEndDialog;
import omaloon.ui.dialogs.OlGameDataDialog;
import omaloon.ui.dialogs.OlInputDialog;
import omaloon.ui.fragments.CliffFragment;
import omaloon.ui.fragments.ShapedEnvPlacerFragment;
import omaloon.utils.IconLoader;
import omaloon.world.blocks.environment.CustomShapePropProcess;

public class OmaloonMod
extends Mod {
    public static EditorListener editorListener;
    public static SafeClearer safeClearer;
    public static ShapedEnvPlacerFragment shapedEnvPlacerFragment;
    public static CliffFragment cliffFragment;
    public static OlInputDialog olInputDialog;
    public static OlGameDataDialog olGameDataDialog;
    public static OlEndDialog olEndDialog;
    public static float shieldBuffer;

    public OmaloonMod() {
        Events.on(EventType.ClientLoadEvent.class, e -> {
            StartSplash.build((Group)Vars.ui.menuGroup);
            StartSplash.show();
            if (!Vars.mobile && !Vars.headless) {
                shapedEnvPlacerFragment.build((Group)Vars.ui.hudGroup);
                cliffFragment.build((Group)Vars.ui.hudGroup);
                OlBinding.load();
            }
            Vars.maps.all().removeAll(map -> {
                if (map.mod != null && map.mod.name.equals("omaloon")) {
                    Mods.LoadedMod otherMod = Vars.mods.getMod("test-utils");
                    return otherMod == null || !otherMod.enabled();
                }
                return false;
            });
        });
        if (!Vars.headless) {
            editorListener = new EditorListener();
        }
        Events.on(EventType.ClientLoadEvent.class, ignored -> {
            OlIcons.load();
            OlSettings.load();
            EventHints.addHints();
            CustomShapePropProcess.instance = new CustomShapePropProcess();
            Vars.asyncCore.processes.add((Object)CustomShapePropProcess.instance);
            safeClearer = new SafeClearer();
        });
        Events.on(EventType.FileTreeInitEvent.class, e -> Core.app.post(OlShaders::load));
        Events.on(EventType.MusicRegisterEvent.class, e -> OlMusics.load());
        Events.on(EventType.DisposeEvent.class, e -> OlShaders.dispose());
        Log.info((Object)"Loaded OmaloonMod constructor.");
    }

    public void init() {
        super.init();
        if (!Vars.headless) {
            shapedEnvPlacerFragment = new ShapedEnvPlacerFragment();
            cliffFragment = new CliffFragment();
            olInputDialog = new OlInputDialog();
            olGameDataDialog = new OlGameDataDialog();
            olEndDialog = new OlEndDialog();
            Events.on(EventType.SectorCaptureEvent.class, e -> {
                if (e.sector.preset == OlSectorPresets.deadValley) {
                    olEndDialog.show(Core.scene, (Action)Actions.sequence((Action)Actions.fadeOut((float)0.0f), (Action)Actions.fadeIn((float)1.0f)));
                }
            });
        }
        IconLoader.loadIcons();
    }

    public void loadContent() {
        EntityRegistry.register();
        OlSounds.load();
        OlItems.load();
        OlLiquids.load();
        OlStatusEffects.load();
        OlUnitTypes.load();
        OlBlocks.load();
        OlWeathers.load();
        OlPlanets.load();
        OlSectorPresets.load();
        OlSchematics.load();
        OlTechTree.load();
    }

    public static void resetSaves(Planet planet) {
        planet.sectors.each(sector -> {
            if (sector.hasSave()) {
                sector.save.delete();
                sector.save = null;
            }
        });
    }

    public static void resetTree(TechTree.TechNode root) {
        root.reset();
        root.content.clearUnlock();
        root.children.each(OmaloonMod::resetTree);
    }

    static {
        shieldBuffer = 40.0f;
    }
}

