/*
 * Decompiled with CFR 0.152.
 */
package arclibrary.graphics;

import arc.graphics.g2d.Fill;
import arc.math.geom.Vec2;
import arc.struct.FloatSeq;

public class EFill {
    private static final Vec2 vector = new Vec2();
    private static final FloatSeq floats = new FloatSeq(20);
    private static final DonutEllipseDraw donutEllipseDraw = new DonutEllipseDraw();

    public static void polyCircle(float x, float y, float radius) {
        EFill.pie(x, y, radius, 1.0f, 0.0f);
    }

    public static void pie(float x, float y, float radius, float finion, float rotation) {
        EFill.ellipse(x, y, radius * 2.0f, radius * 2.0f, finion, 0.0f, rotation);
    }

    public static void ellipse(float x, float y, float width, float height, float finion, float rotation) {
        EFill.ellipse(x, y, width, height, finion, 0.0f, rotation);
    }

    public static void ellipse(float x, float y, float width, float height, float finion, float angle, float rotation) {
        EFill.donutEllipse(x, y, 0.0f, 0.0f, width, height, finion, angle, rotation);
    }

    public static void donut(float x, float y, float radius1, float radius2) {
        EFill.donut(x, y, radius1, radius2, 1.0f);
    }

    public static void donut(float x, float y, float radius1, float radius2, float finion) {
        EFill.donut(x, y, radius1, radius2, finion, 0.0f);
    }

    public static void donut(float x, float y, float radius1, float radius2, float finion, float rotation) {
        EFill.donutEllipse(x, y, radius1 * 2.0f, radius1 * 2.0f, radius2 * 2.0f, radius2 * 2.0f, finion, 0.0f, rotation);
    }

    public static void donutEllipse(float x, float y, float width, float height, float width2, float height2, float finion, float rotation) {
        EFill.donutEllipse(x, y, width, height, width2, height2, finion, 0.0f, rotation);
    }

    public static void donutEllipse(float x, float y, float width, float height, float width2, float height2, float finion, float angleOffset, float rotation) {
        donutEllipseDraw.set(x, y, width, height, width2, height2, finion, angleOffset, rotation).donutEllipse();
    }

    private static void flushPoly() {
        Fill.poly((FloatSeq)floats);
        floats.clear();
    }

    public static void tri(FloatSeq floats) {
        if (floats.size < 6) {
            return;
        }
        float[] items = floats.items;
        Fill.tri((float)items[0], (float)items[1], (float)items[2], (float)items[3], (float)items[4], (float)items[5]);
    }

    public static void quad(FloatSeq floats) {
        if (floats.size < 8) {
            return;
        }
        float[] items = floats.items;
        Fill.quad((float)items[0], (float)items[1], (float)items[2], (float)items[3], (float)items[4], (float)items[5], (float)items[6], (float)items[7]);
    }

    private static final class DonutEllipseDraw {
        final float sides = 50.0f;
        final float max = 50.0f;
        float x;
        float y;
        float width;
        float height;
        float width2;
        float height2;
        float finion;
        float angleOffset;
        float rotation;

        private DonutEllipseDraw() {
        }

        public DonutEllipseDraw set(float x, float y, float width, float height, float width2, float height2, float finion, float angleOffset, float rotation) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.width2 = width2;
            this.height2 = height2;
            this.finion = finion;
            this.angleOffset = angleOffset;
            this.rotation = rotation;
            return this;
        }

        public void donutEllipse() {
            vector.set(0.0f, 0.0f);
            floats.clear();
            boolean startI = false;
            for (float i = (float)startI; i < 50.0f; i += 2.0f) {
                this.apply1(Float.valueOf(i));
                this.apply2(i + 1.0f);
                EFill.flushPoly();
                this.apply1(Float.valueOf(i + 1.0f));
                this.apply2(i + 2.0f);
                EFill.flushPoly();
            }
        }

        private void apply2(float ix) {
            this.addPoints(360.0f * this.finion / 50.0f * ix, this.width2, this.height2, this.width, this.height);
        }

        private void addPoints(float v, float startWidth, float startHeight, float endWidth, float endHeight) {
            vector.set(0.5f, 0.0f).setAngle(v + this.angleOffset).scl(startWidth, startHeight).rotate(this.rotation);
            floats.add(vector.x + this.x, vector.y + this.y);
            vector.set(0.5f, 0.0f).setAngle(v + this.angleOffset).scl(endWidth, endHeight).rotate(this.rotation);
            floats.add(vector.x + this.x, vector.y + this.y);
        }

        private void apply1(Float ix) {
            this.addPoints(360.0f * this.finion / 50.0f * ix.floatValue(), this.width, this.height, this.width2, this.height2);
        }
    }
}

