/*
 * Decompiled with CFR 0.152.
 */
package arclibrary.graphics;

import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Mat3D;
import arc.math.geom.Vec3;

public class Draw3d {
    public static final Mat3D tmpMat1 = new Mat3D();
    public static final Mat3D tmpMat2 = new Mat3D();
    public static final Mat3D tmpMat3 = new Mat3D();
    public static final Mat3D tmpMat4 = new Mat3D();
    public static final Mat3D tmpMat5 = new Mat3D();
    public static final Vec3 v1 = new Vec3();
    public static final Vec3 v2 = new Vec3();
    public static final Vec3 v3 = new Vec3();
    public static final Vec3 v4 = new Vec3();
    public static final Vec3 v5 = new Vec3();
    public static final Vec3 v6 = new Vec3();
    public static final Vec3 v7 = new Vec3();
    static float[] vertices = new float[24];

    public static void rect(Mat3D mat3D, TextureRegion region, float x, float y, float width, float height, float rotation) {
        float originX = width / 2.0f;
        float originY = height / 2.0f;
        Draw3d.rect(mat3D, region, x, y, width, height, rotation, originX, originY);
    }

    public static void rect(Mat3D mat3D, TextureRegion region, float x, float y, float width, float height, float rotation, float originX, float originY) {
        int idx = 0;
        float worldOriginX = x + originX;
        float worldOriginY = y + originY;
        float fx = -originX;
        float fy = -originY;
        float fx2 = width - originX;
        float fy2 = height - originY;
        float cos = Mathf.cosDeg((float)rotation);
        float sin = Mathf.sinDeg((float)rotation);
        v5.set(worldOriginX, worldOriginY, 0.0f);
        Draw3d.setPoint(mat3D, cos * fx - sin * fy, sin * fx + cos * fy, v1);
        Draw3d.setPoint(mat3D, cos * fx - sin * fy2, sin * fx + cos * fy2, v2);
        Draw3d.setPoint(mat3D, cos * fx2 - sin * fy2, sin * fx2 + cos * fy2, v3);
        Draw3d.setPoint(mat3D, cos * fx2 - sin * fy, sin * fx2 + cos * fy, v4);
        Draw3d.setPoint(mat3D, 0.0f, 0.0f, v6);
        float u = region.u;
        float v = region.v2;
        float u2 = region.u2;
        float _v2 = region.v;
        float color = Draw.getColor().toFloatBits();
        float mixColor = Draw.getMixColor().toFloatBits();
        float u5 = (u + u2) / 2.0f;
        float _v5 = (v + _v2) / 2.0f;
        idx = Draw3d.vertex(idx, v1, u, v, color, mixColor);
        idx = Draw3d.vertex(idx, v2, u, _v2, color, mixColor);
        Draw3d.doubleLast(idx, v6, color, mixColor, u5, _v5);
        Draw.vert((Texture)region.texture, (float[])vertices, (int)0, (int)vertices.length);
        idx = 0;
        idx = Draw3d.vertex(idx, v2, u, _v2, color, mixColor);
        idx = Draw3d.vertex(idx, v3, u2, _v2, color, mixColor);
        Draw3d.doubleLast(idx, v6, color, mixColor, u5, _v5);
        Draw.vert((Texture)region.texture, (float[])vertices, (int)0, (int)vertices.length);
        idx = 0;
        idx = Draw3d.vertex(idx, v3, u2, _v2, color, mixColor);
        idx = Draw3d.vertex(idx, v4, u2, v, color, mixColor);
        Draw3d.doubleLast(idx, v6, color, mixColor, u5, _v5);
        Draw.vert((Texture)region.texture, (float[])vertices, (int)0, (int)vertices.length);
        idx = 0;
        idx = Draw3d.vertex(idx, v4, u2, v, color, mixColor);
        idx = Draw3d.vertex(idx, v1, u, v, color, mixColor);
        Draw3d.doubleLast(idx, v6, color, mixColor, u5, _v5);
        Draw.vert((Texture)region.texture, (float[])vertices, (int)0, (int)vertices.length);
    }

    private static void doubleLast(int idx, Vec3 vector, float color, float mixColor, float u5, float _v5) {
        idx = Draw3d.vertex(idx, vector, u5, _v5, color, mixColor);
        idx = Draw3d.vertex(idx, vector, u5, _v5, color, mixColor);
    }

    private static int vertex(int idx, Vec3 v1, float u, float v, float color, float mixColor) {
        Draw3d.vertices[idx++] = v1.x;
        Draw3d.vertices[idx++] = v1.y;
        Draw3d.vertices[idx++] = color;
        Draw3d.vertices[idx++] = u;
        Draw3d.vertices[idx++] = v;
        Draw3d.vertices[idx++] = mixColor;
        return idx;
    }

    private static void setPoint(Mat3D mat3D, float x, float y, Vec3 v) {
        v.set(x, y, 0.0f);
        float len2 = v.len();
        Mat3D.prj((Vec3)v, (Mat3D)mat3D);
        v.x = Draw3d.transformCoord(v.x, v.z, len2);
        v.y = Draw3d.transformCoord(v.y, v.z, len2);
        v.add(v5);
    }

    private static float transformCoord(float coord, float z, float len2) {
        if (len2 == 0.0f) {
            return coord;
        }
        return z > 0.0f ? coord / (z / len2 + 1.0f) : coord * (-z / len2 + 1.0f);
    }
}

