/*
 * Decompiled with CFR 0.152.
 */
package arclibrary.graphics;

import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.FloatSeq;
import arc.util.Tmp;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;

public class DashLine {
    private static final Vec2 tmp1 = new Vec2();
    private static final Vec2 tmp2 = new Vec2();
    private static final Vec2 tmp3 = new Vec2();
    private static final Vec2 tmp4 = new Vec2();
    private static final Vec2 vector = new Vec2();
    private static final Vec2 u = new Vec2();
    private static final Vec2 v = new Vec2();
    private static final Vec2 inner = new Vec2();
    private static final Vec2 outer = new Vec2();
    private static final Pool<PointList> pointListPool = Pools.get(PointList.class, PointList::new);
    private static final FloatSeq floats = new FloatSeq(20);

    public static void dashPoly(float ... cords) {
        DashLine.dashPolyWithLength(10.0f, cords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void brokenLine(float ... cords) {
        int length = cords.length - cords.length % 2;
        int realSize = length / 2;
        if (realSize < 2) {
            return;
        }
        PointList pointList = ((PointList)pointListPool.obtain()).set(cords, length);
        try {
            float stroke = Lines.getStroke();
            floats.clear();
            float x = pointList.x(0);
            float y = pointList.y(0);
            float x2 = pointList.x(1);
            float y2 = pointList.y(1);
            float hstroke = stroke / 2.0f;
            float len = Mathf.len((float)(x2 - x), (float)(y2 - y));
            float diffx = (x2 - x) / len * hstroke;
            float diffy = (y2 - y) / len * hstroke;
            floats.add(x - diffx - diffy, y - diffy + diffx, x - diffx + diffy, y - diffy - diffx);
            for (int i = 0; i < realSize - 2; ++i) {
                int i0 = i;
                int i1 = i + 1;
                int i2 = i + 2;
                float x0 = pointList.x(i0);
                float y0 = pointList.y(i0);
                float x1 = pointList.x(i1);
                float y1 = pointList.y(i1);
                float x22 = pointList.x(i2);
                float y22 = pointList.y(i2);
                float ang0 = Angles.angle((float)x0, (float)y0, (float)x1, (float)y1);
                float ang1 = Angles.angle((float)x1, (float)y1, (float)x22, (float)y22);
                float beta = Mathf.sinDeg((float)(ang1 - ang0));
                u.set(x0, y0).sub(x1, y1).setLength(stroke).scl(1.0f / beta).scl(0.5f);
                v.set(x22, y22).sub(x1, y1).setLength(stroke).scl(1.0f / beta).scl(0.5f);
                if (beta == 0.0f) {
                    v.setZero();
                    float hstroke2 = stroke / 2.0f;
                    tmp1.set(x22, y22).sub(x1, y1);
                    tmp2.set(x0, y0).sub(x1, y1);
                    float angleDiff = Mathf.mod((float)(tmp1.angle() - tmp2.angle()), (float)360.0f);
                    float len2 = hstroke2 / Mathf.sinDeg((float)(angleDiff / 2.0f));
                    tmp1.setLength(len2).rotate(90.0f);
                    tmp2.setLength(len2).rotate(90.0f);
                    floats.add(DashLine.tmp1.x + x1, DashLine.tmp1.y + y1, DashLine.tmp2.x + x1, DashLine.tmp2.y + y1);
                    continue;
                }
                inner.set(x1, y1).add(u).add(v);
                outer.set(x1, y1).sub(u).sub(v);
                floats.add(DashLine.inner.x, DashLine.inner.y, DashLine.outer.x, DashLine.outer.y);
            }
            x = pointList.x(-2);
            y = pointList.y(-2);
            x2 = pointList.x(-1);
            y2 = pointList.y(-1);
            hstroke = stroke / 2.0f;
            len = Mathf.len((float)(x2 - x), (float)(y2 - y));
            diffx = (x2 - x) / len * hstroke;
            diffy = (y2 - y) / len * hstroke;
            floats.add(x2 + diffx - diffy, y2 + diffy + diffx, x2 + diffx + diffy, y2 + diffy - diffx);
            for (int i = 0; i < DashLine.floats.size / 2 - 2; i += 2) {
                float x1 = DashLine.xfloats(i);
                float y1 = DashLine.yfloats(i);
                float x23 = DashLine.xfloats(i + 1);
                float y23 = DashLine.yfloats(i + 1);
                float x3 = DashLine.xfloats(i + 2);
                float y3 = DashLine.yfloats(i + 2);
                float x4 = DashLine.xfloats(i + 3);
                float y4 = DashLine.yfloats(i + 3);
                if (DashLine.floats.size / 2 == 4) {
                    Fill.quad((float)x1, (float)y1, (float)x3, (float)y3, (float)x4, (float)y4, (float)x23, (float)y23);
                    continue;
                }
                Fill.quad((float)x1, (float)y1, (float)x23, (float)y23, (float)x4, (float)y4, (float)x3, (float)y3);
            }
        }
        finally {
            pointList.free();
        }
    }

    private static float xfloats(int x) {
        return DashLine.floats.items[Mathf.mod((int)(x * 2), (int)DashLine.floats.size)];
    }

    private static float yfloats(int y) {
        return DashLine.floats.items[Mathf.mod((int)(y * 2 + 1), (int)DashLine.floats.size)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dashPolyWithLength(float middleLength, float ... cords) {
        if (cords.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        PointList pointList = ((PointList)pointListPool.obtain()).set(cords, cords.length);
        try {
            float perimeter = 0.0f;
            for (int currentIndex = 0; currentIndex < cords.length / 2; ++currentIndex) {
                perimeter += Mathf.dst((float)pointList.x(currentIndex), (float)pointList.y(currentIndex), (float)pointList.x(currentIndex + 1), (float)pointList.y(currentIndex + 1));
            }
            int k = (int)(perimeter / middleLength) / 2;
            int amount = k * 2;
            float len = perimeter / (float)amount;
            float len2 = len * len;
            boolean line = true;
            float cornerPercent = -1.0f;
            block5: for (int currentIndex = 0; currentIndex < cords.length / 2; ++currentIndex) {
                Vec2 cur = Tmp.v1.set(pointList.x(currentIndex), pointList.y(currentIndex));
                Vec2 next = Tmp.v2.set(pointList.x(currentIndex + 1), pointList.y(currentIndex + 1));
                Vec2 position = Tmp.v3.set(cur);
                vector.set(next).sub(cur).limit2(len2);
                if (cornerPercent != -1.0f) {
                    Vec2 set = Tmp.v4.set(DashLine.vector.x * cornerPercent, DashLine.vector.y * cornerPercent);
                    position.add(set);
                    cornerPercent = -1.0f;
                }
                while (!position.within((Position)next, len / 10000.0f)) {
                    if (position.dst2(next) > len2) {
                        if (line) {
                            Lines.line((float)position.x, (float)position.y, (float)(position.x + DashLine.vector.x), (float)(position.y + DashLine.vector.y));
                        }
                        line = !line;
                        position.add(vector);
                        continue;
                    }
                    cornerPercent = 1.0f - position.dst(next) / len;
                    int nextIndex = currentIndex + 2;
                    FloatSeq floats = new FloatSeq();
                    floats.add(position.x, position.y);
                    floats.add(next.x, next.y);
                    while (true) {
                        if (nextIndex % cords.length == 0) {
                            return;
                        }
                        float next2x = pointList.x(nextIndex);
                        float next2y = pointList.y(nextIndex);
                        float currentx = pointList.x(nextIndex - 1);
                        float currenty = pointList.y(nextIndex - 1);
                        Vec2 nextPosition = Tmp.v4.set(next2x, next2y).sub(currentx, currenty);
                        float perfectLen = len * cornerPercent;
                        float nextLen = nextPosition.len();
                        if (nextLen > perfectLen) {
                            nextPosition.setLength(perfectLen);
                            nextLen = perfectLen;
                        }
                        floats.add(currentx + nextPosition.x, currenty + nextPosition.y);
                        if (!(nextLen < perfectLen) || !(cornerPercent > 1.0E-7f)) break;
                        cornerPercent = (perfectLen - nextLen) / len;
                        ++nextIndex;
                    }
                    currentIndex = nextIndex - 2;
                    if (line) {
                        DashLine.brokenLine(floats.toArray());
                    }
                    line = !line;
                    continue block5;
                }
            }
        }
        finally {
            pointList.free();
        }
    }

    static class PointList
    implements Pool.Poolable {
        public float[] cords;
        public int len;

        PointList() {
        }

        public PointList set(float[] cords, int len) {
            this.cords = cords;
            this.len = len;
            return this;
        }

        public float x(int i) {
            return this.cords[Mathf.mod((int)(i * 2), (int)this.len)];
        }

        public float y(int i) {
            return this.cords[Mathf.mod((int)(i * 2 + 1), (int)this.len)];
        }

        public void free() {
            pointListPool.free((Object)this);
        }

        public void reset() {
            this.cords = null;
            this.len = -1;
        }
    }
}

