-- This file is automatically generated, do not edit!
-- Path of Building
--
-- Other active skills
-- Skill data (c) Grinding Gear Games
--
local skills, mod, flag, skill = ...

skills["AcidicConcoctionPlayer"] = {
	name = "Acidic Concoction",
	baseTypeName = "Acidic Concoction",
	fromTree = true,
	color = 4,
	description = "Consume charges from your Mana Flask to throw a flask that explodes, dealing Physical Attack damage in an area. The thrown flask Consumes Poison on Hit to cause an acidic burst.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.UsableWhileMoving] = true, [SkillType.ProjectileNoCollision] = true, [SkillType.Physical] = true, [SkillType.NoAttackInPlace] = true, [SkillType.GroundTargetedProjectile] = true, },
	weaponTypes = {
		["None"] = true,
	},
	castTime = 1,
	qualityStats = {
		{ "active_skill_base_area_of_effect_radius", 0.2 },
	},
	levels = {
		[1] = { critChance = 5, baseMultiplier = 0.7, levelRequirement = 0, cost = { Mana = 0, }, },
		[2] = { critChance = 5, baseMultiplier = 0.77, levelRequirement = 3, cost = { Mana = 0, }, },
		[3] = { critChance = 5, baseMultiplier = 0.84, levelRequirement = 6, cost = { Mana = 0, }, },
		[4] = { critChance = 5, baseMultiplier = 0.92, levelRequirement = 10, cost = { Mana = 0, }, },
		[5] = { critChance = 5, baseMultiplier = 0.99, levelRequirement = 14, cost = { Mana = 0, }, },
		[6] = { critChance = 5, baseMultiplier = 1.05, levelRequirement = 18, cost = { Mana = 0, }, },
		[7] = { critChance = 5, baseMultiplier = 1.12, levelRequirement = 22, cost = { Mana = 0, }, },
		[8] = { critChance = 5, baseMultiplier = 1.18, levelRequirement = 26, cost = { Mana = 0, }, },
		[9] = { critChance = 5, baseMultiplier = 1.23, levelRequirement = 31, cost = { Mana = 0, }, },
		[10] = { critChance = 5, baseMultiplier = 1.28, levelRequirement = 36, cost = { Mana = 0, }, },
		[11] = { critChance = 5, baseMultiplier = 1.34, levelRequirement = 41, cost = { Mana = 0, }, },
		[12] = { critChance = 5, baseMultiplier = 1.39, levelRequirement = 46, cost = { Mana = 0, }, },
		[13] = { critChance = 5, baseMultiplier = 1.44, levelRequirement = 52, cost = { Mana = 0, }, },
		[14] = { critChance = 5, baseMultiplier = 1.5, levelRequirement = 58, cost = { Mana = 0, }, },
		[15] = { critChance = 5, baseMultiplier = 1.55, levelRequirement = 64, cost = { Mana = 0, }, },
		[16] = { critChance = 5, baseMultiplier = 1.61, levelRequirement = 66, cost = { Mana = 0, }, },
		[17] = { critChance = 5, baseMultiplier = 1.67, levelRequirement = 72, cost = { Mana = 0, }, },
		[18] = { critChance = 5, baseMultiplier = 1.73, levelRequirement = 78, cost = { Mana = 0, }, },
		[19] = { critChance = 5, baseMultiplier = 1.79, levelRequirement = 84, cost = { Mana = 0, }, },
		[20] = { critChance = 5, baseMultiplier = 1.85, levelRequirement = 90, cost = { Mana = 0, }, },
		[21] = { critChance = 5, baseMultiplier = 1.91, levelRequirement = 90, cost = { Mana = 0, }, },
		[22] = { critChance = 5, baseMultiplier = 1.97, levelRequirement = 90, cost = { Mana = 0, }, },
		[23] = { critChance = 5, baseMultiplier = 2.04, levelRequirement = 90, cost = { Mana = 0, }, },
		[24] = { critChance = 5, baseMultiplier = 2.1, levelRequirement = 90, cost = { Mana = 0, }, },
		[25] = { critChance = 5, baseMultiplier = 2.17, levelRequirement = 90, cost = { Mana = 0, }, },
		[26] = { critChance = 5, baseMultiplier = 2.24, levelRequirement = 90, cost = { Mana = 0, }, },
		[27] = { critChance = 5, baseMultiplier = 2.32, levelRequirement = 90, cost = { Mana = 0, }, },
		[28] = { critChance = 5, baseMultiplier = 2.4, levelRequirement = 90, cost = { Mana = 0, }, },
		[29] = { critChance = 5, baseMultiplier = 2.48, levelRequirement = 90, cost = { Mana = 0, }, },
		[30] = { critChance = 5, baseMultiplier = 2.56, levelRequirement = 90, cost = { Mana = 0, }, },
		[31] = { critChance = 5, baseMultiplier = 2.64, levelRequirement = 90, cost = { Mana = 0, }, },
		[32] = { critChance = 5, baseMultiplier = 2.73, levelRequirement = 90, cost = { Mana = 0, }, },
		[33] = { critChance = 5, baseMultiplier = 2.82, levelRequirement = 90, cost = { Mana = 0, }, },
		[34] = { critChance = 5, baseMultiplier = 2.91, levelRequirement = 90, cost = { Mana = 0, }, },
		[35] = { critChance = 5, baseMultiplier = 3.01, levelRequirement = 90, cost = { Mana = 0, }, },
		[36] = { critChance = 5, baseMultiplier = 3.11, levelRequirement = 90, cost = { Mana = 0, }, },
		[37] = { critChance = 5, baseMultiplier = 3.21, levelRequirement = 90, cost = { Mana = 0, }, },
		[38] = { critChance = 5, baseMultiplier = 3.32, levelRequirement = 90, cost = { Mana = 0, }, },
		[39] = { critChance = 5, baseMultiplier = 3.43, levelRequirement = 90, cost = { Mana = 0, }, },
		[40] = { critChance = 5, baseMultiplier = 3.55, levelRequirement = 90, cost = { Mana = 0, }, },
	},
	statSets = {
		[1] = {
			label = "Flask",
			baseEffectiveness = 2.2999999523163,
			incrementalEffectiveness = 0.27349999547005,
			statDescriptionScope = "poisonous_concoction",
			baseFlags = {
				attack = true,
				projectile = true,
				unarmed = true,
				area = true,
			},
			constantStats = {
				{ "flask_throw_base_charges_used", 5 },
				{ "base_number_of_projectiles", 1 },
				{ "active_skill_base_area_of_effect_radius", 18 },
				{ "throw_flask_effects_type", 4 },
				{ "movement_speed_+%_final_while_performing_action", -70 },
				{ "movement_speed_acceleration_+%_per_second_while_performing_action", 160 },
				{ "movement_speed_while_performing_action_locked_duration_%", 50 },
				{ "main_hand_base_weapon_attack_duration_ms", 714 },
			},
			stats = {
				"main_hand_weapon_minimum_physical_damage",
				"main_hand_weapon_maximum_physical_damage",
				"base_is_projectile",
				"projectile_behaviour_only_explode",
				"can_perform_skill_while_moving",
				"replace_main_hand_unarmed_attack_stats_with_nothing_type",
				"is_area_damage",
				"base_consume_enemy_poison_on_hit",
				"cannot_poison",
			},
			notMinionStat = {
				"main_hand_weapon_minimum_physical_damage",
				"main_hand_weapon_maximum_physical_damage",
			},
			levels = {
				[1] = { 7, 11, statInterpolation = { 1, 1, }, actorLevel = 1, },
				[2] = { 12, 18, statInterpolation = { 1, 1, }, actorLevel = 3.4519999027252, },
				[3] = { 18, 28, statInterpolation = { 1, 1, }, actorLevel = 6.7670001983643, },
				[4] = { 25, 38, statInterpolation = { 1, 1, }, actorLevel = 10.307999610901, },
				[5] = { 33, 49, statInterpolation = { 1, 1, }, actorLevel = 14.074999809265, },
				[6] = { 41, 61, statInterpolation = { 1, 1, }, actorLevel = 18.068000793457, },
				[7] = { 49, 73, statInterpolation = { 1, 1, }, actorLevel = 22.287000656128, },
				[8] = { 57, 86, statInterpolation = { 1, 1, }, actorLevel = 26.732000350952, },
				[9] = { 67, 100, statInterpolation = { 1, 1, }, actorLevel = 31.40299987793, },
				[10] = { 76, 114, statInterpolation = { 1, 1, }, actorLevel = 36.299999237061, },
				[11] = { 86, 129, statInterpolation = { 1, 1, }, actorLevel = 41.423000335693, },
				[12] = { 97, 145, statInterpolation = { 1, 1, }, actorLevel = 46.771999359131, },
				[13] = { 108, 161, statInterpolation = { 1, 1, }, actorLevel = 52.34700012207, },
				[14] = { 119, 178, statInterpolation = { 1, 1, }, actorLevel = 58.147998809814, },
				[15] = { 131, 196, statInterpolation = { 1, 1, }, actorLevel = 64.175003051758, },
				[16] = { 143, 214, statInterpolation = { 1, 1, }, actorLevel = 70.428001403809, },
				[17] = { 156, 233, statInterpolation = { 1, 1, }, actorLevel = 76.906997680664, },
				[18] = { 169, 253, statInterpolation = { 1, 1, }, actorLevel = 83.611999511719, },
				[19] = { 182, 273, statInterpolation = { 1, 1, }, actorLevel = 90.542999267578, },
				[20] = { 196, 294, statInterpolation = { 1, 1, }, actorLevel = 97.699996948242, },
				[21] = { 211, 316, statInterpolation = { 1, 1, }, actorLevel = 105.08300018311, },
				[22] = { 226, 338, statInterpolation = { 1, 1, }, actorLevel = 112.69200134277, },
				[23] = { 241, 361, statInterpolation = { 1, 1, }, actorLevel = 120.52700042725, },
				[24] = { 257, 385, statInterpolation = { 1, 1, }, actorLevel = 128.58799743652, },
				[25] = { 273, 409, statInterpolation = { 1, 1, }, actorLevel = 136.875, },
				[26] = { 289, 434, statInterpolation = { 1, 1, }, actorLevel = 145.38800048828, },
				[27] = { 307, 460, statInterpolation = { 1, 1, }, actorLevel = 154.12699890137, },
				[28] = { 324, 486, statInterpolation = { 1, 1, }, actorLevel = 163.09199523926, },
				[29] = { 342, 513, statInterpolation = { 1, 1, }, actorLevel = 172.28300476074, },
				[30] = { 360, 541, statInterpolation = { 1, 1, }, actorLevel = 181.69999694824, },
				[31] = { 379, 569, statInterpolation = { 1, 1, }, actorLevel = 191.34300231934, },
				[32] = { 399, 598, statInterpolation = { 1, 1, }, actorLevel = 201.21200561523, },
				[33] = { 418, 628, statInterpolation = { 1, 1, }, actorLevel = 211.30700683594, },
				[34] = { 439, 658, statInterpolation = { 1, 1, }, actorLevel = 221.62800598145, },
				[35] = { 459, 689, statInterpolation = { 1, 1, }, actorLevel = 232.17500305176, },
				[36] = { 480, 720, statInterpolation = { 1, 1, }, actorLevel = 242.94799804688, },
				[37] = { 502, 753, statInterpolation = { 1, 1, }, actorLevel = 253.94700622559, },
				[38] = { 524, 785, statInterpolation = { 1, 1, }, actorLevel = 265.17199707031, },
				[39] = { 546, 819, statInterpolation = { 1, 1, }, actorLevel = 276.62298583984, },
				[40] = { 569, 853, statInterpolation = { 1, 1, }, actorLevel = 288.29998779297, },
			},
		},
		[2] = {
			label = "Acidic Burst",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "poisonous_concoction",
			statMap = {
				["poisonous_concoction_area_of_effect_+%_final_per_active_poison_consumed"] = {
					mod("AreaOfEffect", "MORE", nil, 0, 0, { type = "Multiplier", actor = "enemy", var = "PoisonStacks" }),
				},
				["active_skill_base_secondary_area_of_effect_radius"] = {
					skill("radius", nil),
				},
			},
			baseFlags = {
				attack = true,
				area = true,
			},
			constantStats = {
				{ "base_number_of_projectiles", 1 },
				{ "throw_flask_effects_type", 4 },
				{ "movement_speed_+%_final_while_performing_action", -70 },
				{ "movement_speed_acceleration_+%_per_second_while_performing_action", 160 },
				{ "movement_speed_while_performing_action_locked_duration_%", 50 },
				{ "main_hand_base_weapon_attack_duration_ms", 714 },
				{ "active_skill_base_secondary_area_of_effect_radius", 15 },
				{ "poison_concoction_poison_burst_physical_damage_equal_to_%_of_strongest_active_poison", 150 },
				{ "poisonous_concoction_area_of_effect_+%_final_per_active_poison_consumed", 30 },
			},
			stats = {
				"main_hand_weapon_minimum_physical_damage",
				"main_hand_weapon_maximum_physical_damage",
				"base_is_projectile",
				"projectile_behaviour_only_explode",
				"can_perform_skill_while_moving",
				"replace_main_hand_unarmed_attack_stats_with_nothing_type",
				"is_area_damage",
				"base_consume_enemy_poison_on_hit",
				"cannot_poison",
			},
			notMinionStat = {
				"main_hand_weapon_minimum_physical_damage",
				"main_hand_weapon_maximum_physical_damage",
			},
			levels = {
				[1] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 1, },
				[2] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 3.4519999027252, },
				[3] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 6.7670001983643, },
				[4] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 10.307999610901, },
				[5] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 14.074999809265, },
				[6] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 18.068000793457, },
				[7] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 22.287000656128, },
				[8] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 26.732000350952, },
				[9] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 31.40299987793, },
				[10] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 36.299999237061, },
				[11] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 41.423000335693, },
				[12] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 46.771999359131, },
				[13] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 52.34700012207, },
				[14] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 58.147998809814, },
				[15] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 64.175003051758, },
				[16] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 70.428001403809, },
				[17] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 76.906997680664, },
				[18] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 83.611999511719, },
				[19] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 90.542999267578, },
				[20] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 97.699996948242, },
				[21] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 105.08300018311, },
				[22] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 112.69200134277, },
				[23] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 120.52700042725, },
				[24] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 128.58799743652, },
				[25] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 136.875, },
				[26] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 145.38800048828, },
				[27] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 154.12699890137, },
				[28] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 163.09199523926, },
				[29] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 172.28300476074, },
				[30] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 181.69999694824, },
				[31] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 191.34300231934, },
				[32] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 201.21200561523, },
				[33] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 211.30700683594, },
				[34] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 221.62800598145, },
				[35] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 232.17500305176, },
				[36] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 242.94799804688, },
				[37] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 253.94700622559, },
				[38] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 265.17199707031, },
				[39] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 276.62298583984, },
				[40] = { 0, 0, statInterpolation = { 1, 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["AncestralSpiritsPlayer"] = {
	name = "Ancestral Spirits",
	baseTypeName = "Ancestral Spirits",
	fromTree = true,
	minionList = {
		"AncestralSpiritTurtle",
		"AncestralSpiritHulk",
		"AncestralSpiritCaster",
		"AncestralSpiritWarhorn",
	},
	color = 4,
	description = "Each of your Totems will summon an Ancestral Spirit Minion to fight for you. If the Totem that summoned the Minion dies then the Ancestral Spirit will too.",
	skillTypes = { [SkillType.Minion] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.CreatesMinion] = true, [SkillType.Triggered] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.Chains] = true, [SkillType.Duration] = true, [SkillType.DamageOverTime] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesFromUser] = true, },
	castTime = 0,
	qualityStats = {
		{ "active_skill_minion_life_+%_final", 1 },
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 3, },
		[3] = { levelRequirement = 6, },
		[4] = { levelRequirement = 10, },
		[5] = { levelRequirement = 14, },
		[6] = { levelRequirement = 18, },
		[7] = { levelRequirement = 22, },
		[8] = { levelRequirement = 26, },
		[9] = { levelRequirement = 31, },
		[10] = { levelRequirement = 36, },
		[11] = { levelRequirement = 41, },
		[12] = { levelRequirement = 46, },
		[13] = { levelRequirement = 52, },
		[14] = { levelRequirement = 58, },
		[15] = { levelRequirement = 64, },
		[16] = { levelRequirement = 66, },
		[17] = { levelRequirement = 72, },
		[18] = { levelRequirement = 78, },
		[19] = { levelRequirement = 84, },
		[20] = { levelRequirement = 90, },
		[21] = { levelRequirement = 90, },
		[22] = { levelRequirement = 90, },
		[23] = { levelRequirement = 90, },
		[24] = { levelRequirement = 90, },
		[25] = { levelRequirement = 90, },
		[26] = { levelRequirement = 90, },
		[27] = { levelRequirement = 90, },
		[28] = { levelRequirement = 90, },
		[29] = { levelRequirement = 90, },
		[30] = { levelRequirement = 90, },
		[31] = { levelRequirement = 90, },
		[32] = { levelRequirement = 90, },
		[33] = { levelRequirement = 90, },
		[34] = { levelRequirement = 90, },
		[35] = { levelRequirement = 90, },
		[36] = { levelRequirement = 90, },
		[37] = { levelRequirement = 90, },
		[38] = { levelRequirement = 90, },
		[39] = { levelRequirement = 90, },
		[40] = { levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Ancestral Spirits",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			statMap = {
				["minion_1%_damage_+%_per_X_player_strength"] = {
					mod("MinionModifier", "LIST", { mod = mod("Damage", "INC", nil, 0, 0, { type = "PerStat", stat = "Str", actor = "parent" }) }),
				},
				["minion_1%_attack_speed_+%_per_X_player_dexterity"] = {
					mod("MinionModifier", "LIST", { mod = mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "PerStat", stat = "Dex", actor = "parent", div = 3 }) }),
					div = 3,
				},
			},
			baseFlags = {
				spell = true,
				minion = true,
			},
			constantStats = {
				{ "minion_1%_damage_+%_per_X_player_strength", 1 },
				{ "minion_1%_attack_speed_+%_per_X_player_dexterity", 3 },
			},
			stats = {
				"display_modifiers_to_totem_life_effect_these_minions",
				"triggerable_in_any_set",
				"base_deal_no_damage",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["BleedingConcoctionPlayer"] = {
	name = "Bleeding Concoction",
	baseTypeName = "Bleeding Concoction",
	fromTree = true,
	color = 4,
	description = "Consume charges from your Mana Flask to throw a flask that explodes, dealing Physical Attack damage in an area and Aggravating Bleeding on Enemies hit.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.Physical] = true, [SkillType.UsableWhileMoving] = true, [SkillType.ProjectileNoCollision] = true, [SkillType.NoAttackInPlace] = true, [SkillType.GroundTargetedProjectile] = true, },
	weaponTypes = {
		["None"] = true,
	},
	castTime = 1,
	qualityStats = {
		{ "active_skill_base_area_of_effect_radius", 0.2 },
	},
	levels = {
		[1] = { critChance = 5, baseMultiplier = 0.7, levelRequirement = 0, cost = { Mana = 0, }, },
		[2] = { critChance = 5, baseMultiplier = 0.77, levelRequirement = 3, cost = { Mana = 0, }, },
		[3] = { critChance = 5, baseMultiplier = 0.84, levelRequirement = 6, cost = { Mana = 0, }, },
		[4] = { critChance = 5, baseMultiplier = 0.92, levelRequirement = 10, cost = { Mana = 0, }, },
		[5] = { critChance = 5, baseMultiplier = 0.99, levelRequirement = 14, cost = { Mana = 0, }, },
		[6] = { critChance = 5, baseMultiplier = 1.05, levelRequirement = 18, cost = { Mana = 0, }, },
		[7] = { critChance = 5, baseMultiplier = 1.12, levelRequirement = 22, cost = { Mana = 0, }, },
		[8] = { critChance = 5, baseMultiplier = 1.18, levelRequirement = 26, cost = { Mana = 0, }, },
		[9] = { critChance = 5, baseMultiplier = 1.23, levelRequirement = 31, cost = { Mana = 0, }, },
		[10] = { critChance = 5, baseMultiplier = 1.28, levelRequirement = 36, cost = { Mana = 0, }, },
		[11] = { critChance = 5, baseMultiplier = 1.34, levelRequirement = 41, cost = { Mana = 0, }, },
		[12] = { critChance = 5, baseMultiplier = 1.39, levelRequirement = 46, cost = { Mana = 0, }, },
		[13] = { critChance = 5, baseMultiplier = 1.44, levelRequirement = 52, cost = { Mana = 0, }, },
		[14] = { critChance = 5, baseMultiplier = 1.5, levelRequirement = 58, cost = { Mana = 0, }, },
		[15] = { critChance = 5, baseMultiplier = 1.55, levelRequirement = 64, cost = { Mana = 0, }, },
		[16] = { critChance = 5, baseMultiplier = 1.61, levelRequirement = 66, cost = { Mana = 0, }, },
		[17] = { critChance = 5, baseMultiplier = 1.67, levelRequirement = 72, cost = { Mana = 0, }, },
		[18] = { critChance = 5, baseMultiplier = 1.73, levelRequirement = 78, cost = { Mana = 0, }, },
		[19] = { critChance = 5, baseMultiplier = 1.79, levelRequirement = 84, cost = { Mana = 0, }, },
		[20] = { critChance = 5, baseMultiplier = 1.85, levelRequirement = 90, cost = { Mana = 0, }, },
		[21] = { critChance = 5, baseMultiplier = 1.91, levelRequirement = 90, cost = { Mana = 0, }, },
		[22] = { critChance = 5, baseMultiplier = 1.97, levelRequirement = 90, cost = { Mana = 0, }, },
		[23] = { critChance = 5, baseMultiplier = 2.04, levelRequirement = 90, cost = { Mana = 0, }, },
		[24] = { critChance = 5, baseMultiplier = 2.1, levelRequirement = 90, cost = { Mana = 0, }, },
		[25] = { critChance = 5, baseMultiplier = 2.17, levelRequirement = 90, cost = { Mana = 0, }, },
		[26] = { critChance = 5, baseMultiplier = 2.24, levelRequirement = 90, cost = { Mana = 0, }, },
		[27] = { critChance = 5, baseMultiplier = 2.32, levelRequirement = 90, cost = { Mana = 0, }, },
		[28] = { critChance = 5, baseMultiplier = 2.4, levelRequirement = 90, cost = { Mana = 0, }, },
		[29] = { critChance = 5, baseMultiplier = 2.48, levelRequirement = 90, cost = { Mana = 0, }, },
		[30] = { critChance = 5, baseMultiplier = 2.56, levelRequirement = 90, cost = { Mana = 0, }, },
		[31] = { critChance = 5, baseMultiplier = 2.64, levelRequirement = 90, cost = { Mana = 0, }, },
		[32] = { critChance = 5, baseMultiplier = 2.73, levelRequirement = 90, cost = { Mana = 0, }, },
		[33] = { critChance = 5, baseMultiplier = 2.82, levelRequirement = 90, cost = { Mana = 0, }, },
		[34] = { critChance = 5, baseMultiplier = 2.91, levelRequirement = 90, cost = { Mana = 0, }, },
		[35] = { critChance = 5, baseMultiplier = 3.01, levelRequirement = 90, cost = { Mana = 0, }, },
		[36] = { critChance = 5, baseMultiplier = 3.11, levelRequirement = 90, cost = { Mana = 0, }, },
		[37] = { critChance = 5, baseMultiplier = 3.21, levelRequirement = 90, cost = { Mana = 0, }, },
		[38] = { critChance = 5, baseMultiplier = 3.32, levelRequirement = 90, cost = { Mana = 0, }, },
		[39] = { critChance = 5, baseMultiplier = 3.43, levelRequirement = 90, cost = { Mana = 0, }, },
		[40] = { critChance = 5, baseMultiplier = 3.55, levelRequirement = 90, cost = { Mana = 0, }, },
	},
	statSets = {
		[1] = {
			label = "Bleeding Concoction",
			baseEffectiveness = 4.1999998092651,
			incrementalEffectiveness = 0.27349999547005,
			statDescriptionScope = "bleeding_concoction",
			baseFlags = {
				attack = true,
				projectile = true,
				unarmed = true,
				area = true,
			},
			constantStats = {
				{ "flask_throw_base_charges_used", 5 },
				{ "base_number_of_projectiles", 1 },
				{ "active_skill_base_area_of_effect_radius", 18 },
				{ "throw_flask_effects_type", 3 },
				{ "movement_speed_+%_final_while_performing_action", -70 },
				{ "movement_speed_acceleration_+%_per_second_while_performing_action", 160 },
				{ "movement_speed_while_performing_action_locked_duration_%", 50 },
				{ "main_hand_base_weapon_attack_duration_ms", 714 },
				{ "base_chance_to_inflict_bleeding_%", 100 },
				{ "base_aggravate_bleeding_on_attack_hit_chance_%", 100 },
			},
			stats = {
				"main_hand_weapon_minimum_physical_damage",
				"main_hand_weapon_maximum_physical_damage",
				"base_is_projectile",
				"projectile_behaviour_only_explode",
				"can_perform_skill_while_moving",
				"replace_main_hand_unarmed_attack_stats_with_nothing_type",
				"is_area_damage",
			},
			notMinionStat = {
				"main_hand_weapon_minimum_physical_damage",
				"main_hand_weapon_maximum_physical_damage",
			},
			levels = {
				[1] = { 11, 21, statInterpolation = { 1, 1, }, actorLevel = 1, },
				[2] = { 19, 35, statInterpolation = { 1, 1, }, actorLevel = 3.4519999027252, },
				[3] = { 29, 55, statInterpolation = { 1, 1, }, actorLevel = 6.7670001983643, },
				[4] = { 41, 75, statInterpolation = { 1, 1, }, actorLevel = 10.307999610901, },
				[5] = { 52, 97, statInterpolation = { 1, 1, }, actorLevel = 14.074999809265, },
				[6] = { 65, 120, statInterpolation = { 1, 1, }, actorLevel = 18.068000793457, },
				[7] = { 78, 145, statInterpolation = { 1, 1, }, actorLevel = 22.287000656128, },
				[8] = { 92, 171, statInterpolation = { 1, 1, }, actorLevel = 26.732000350952, },
				[9] = { 106, 198, statInterpolation = { 1, 1, }, actorLevel = 31.40299987793, },
				[10] = { 122, 226, statInterpolation = { 1, 1, }, actorLevel = 36.299999237061, },
				[11] = { 138, 256, statInterpolation = { 1, 1, }, actorLevel = 41.423000335693, },
				[12] = { 154, 287, statInterpolation = { 1, 1, }, actorLevel = 46.771999359131, },
				[13] = { 172, 319, statInterpolation = { 1, 1, }, actorLevel = 52.34700012207, },
				[14] = { 190, 353, statInterpolation = { 1, 1, }, actorLevel = 58.147998809814, },
				[15] = { 209, 388, statInterpolation = { 1, 1, }, actorLevel = 64.175003051758, },
				[16] = { 228, 424, statInterpolation = { 1, 1, }, actorLevel = 70.428001403809, },
				[17] = { 249, 462, statInterpolation = { 1, 1, }, actorLevel = 76.906997680664, },
				[18] = { 270, 501, statInterpolation = { 1, 1, }, actorLevel = 83.611999511719, },
				[19] = { 291, 541, statInterpolation = { 1, 1, }, actorLevel = 90.542999267578, },
				[20] = { 314, 582, statInterpolation = { 1, 1, }, actorLevel = 97.699996948242, },
				[21] = { 337, 625, statInterpolation = { 1, 1, }, actorLevel = 105.08300018311, },
				[22] = { 360, 669, statInterpolation = { 1, 1, }, actorLevel = 112.69200134277, },
				[23] = { 385, 715, statInterpolation = { 1, 1, }, actorLevel = 120.52700042725, },
				[24] = { 410, 761, statInterpolation = { 1, 1, }, actorLevel = 128.58799743652, },
				[25] = { 436, 810, statInterpolation = { 1, 1, }, actorLevel = 136.875, },
				[26] = { 462, 859, statInterpolation = { 1, 1, }, actorLevel = 145.38800048828, },
				[27] = { 490, 910, statInterpolation = { 1, 1, }, actorLevel = 154.12699890137, },
				[28] = { 518, 962, statInterpolation = { 1, 1, }, actorLevel = 163.09199523926, },
				[29] = { 547, 1015, statInterpolation = { 1, 1, }, actorLevel = 172.28300476074, },
				[30] = { 576, 1070, statInterpolation = { 1, 1, }, actorLevel = 181.69999694824, },
				[31] = { 606, 1126, statInterpolation = { 1, 1, }, actorLevel = 191.34300231934, },
				[32] = { 637, 1183, statInterpolation = { 1, 1, }, actorLevel = 201.21200561523, },
				[33] = { 668, 1241, statInterpolation = { 1, 1, }, actorLevel = 211.30700683594, },
				[34] = { 701, 1301, statInterpolation = { 1, 1, }, actorLevel = 221.62800598145, },
				[35] = { 734, 1362, statInterpolation = { 1, 1, }, actorLevel = 232.17500305176, },
				[36] = { 767, 1425, statInterpolation = { 1, 1, }, actorLevel = 242.94799804688, },
				[37] = { 802, 1489, statInterpolation = { 1, 1, }, actorLevel = 253.94700622559, },
				[38] = { 837, 1554, statInterpolation = { 1, 1, }, actorLevel = 265.17199707031, },
				[39] = { 872, 1620, statInterpolation = { 1, 1, }, actorLevel = 276.62298583984, },
				[40] = { 909, 1688, statInterpolation = { 1, 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["BloodBoilPlayer"] = {
	name = "Blood Boil",
	baseTypeName = "Blood Boil",
	fromTree = true,
	color = 4,
	description = "Enemies in your Presence accumulate blood boils periodically. When they die, the boils pop applying Corrupted Blood to enemies near them.",
	skillTypes = { [SkillType.HasReservation] = true, [SkillType.OngoingSkill] = true, [SkillType.Buff] = true, [SkillType.Persistent] = true, [SkillType.Duration] = true, [SkillType.Physical] = true, [SkillType.DamageOverTime] = true, [SkillType.Area] = true, },
	castTime = 0,
	qualityStats = {
		{ "base_skill_effect_duration", 75 },
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 3, },
		[3] = { levelRequirement = 6, },
		[4] = { levelRequirement = 10, },
		[5] = { levelRequirement = 14, },
		[6] = { levelRequirement = 18, },
		[7] = { levelRequirement = 22, },
		[8] = { levelRequirement = 26, },
		[9] = { levelRequirement = 31, },
		[10] = { levelRequirement = 36, },
		[11] = { levelRequirement = 41, },
		[12] = { levelRequirement = 46, },
		[13] = { levelRequirement = 52, },
		[14] = { levelRequirement = 58, },
		[15] = { levelRequirement = 64, },
		[16] = { levelRequirement = 66, },
		[17] = { levelRequirement = 72, },
		[18] = { levelRequirement = 78, },
		[19] = { levelRequirement = 84, },
		[20] = { levelRequirement = 90, },
		[21] = { levelRequirement = 90, },
		[22] = { levelRequirement = 90, },
		[23] = { levelRequirement = 90, },
		[24] = { levelRequirement = 90, },
		[25] = { levelRequirement = 90, },
		[26] = { levelRequirement = 90, },
		[27] = { levelRequirement = 90, },
		[28] = { levelRequirement = 90, },
		[29] = { levelRequirement = 90, },
		[30] = { levelRequirement = 90, },
		[31] = { levelRequirement = 90, },
		[32] = { levelRequirement = 90, },
		[33] = { levelRequirement = 90, },
		[34] = { levelRequirement = 90, },
		[35] = { levelRequirement = 90, },
		[36] = { levelRequirement = 90, },
		[37] = { levelRequirement = 90, },
		[38] = { levelRequirement = 90, },
		[39] = { levelRequirement = 90, },
		[40] = { levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Blood Boil",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "blood_boil",
			baseFlags = {
			},
			constantStats = {
				{ "active_skill_base_area_of_effect_radius", 15 },
				{ "blood_boil_%_health_as_corrupted_blood_damage_per_minute", 120 },
				{ "base_skill_effect_duration", 5000 },
				{ "blood_boil_explosion_area_+%_final_per_boil", 20 },
				{ "blood_boil_explosion_delay_ms", 1000 },
			},
			stats = {
				"blood_boil_application_interval_ms",
				"quality_display_base_skill_effect_duration_is_gem",
			},
			levels = {
				[1] = { 2000, statInterpolation = { 1, }, actorLevel = 1, },
				[2] = { 1975, statInterpolation = { 1, }, actorLevel = 3.4519999027252, },
				[3] = { 1950, statInterpolation = { 1, }, actorLevel = 6.7670001983643, },
				[4] = { 1925, statInterpolation = { 1, }, actorLevel = 10.307999610901, },
				[5] = { 1900, statInterpolation = { 1, }, actorLevel = 14.074999809265, },
				[6] = { 1875, statInterpolation = { 1, }, actorLevel = 18.068000793457, },
				[7] = { 1850, statInterpolation = { 1, }, actorLevel = 22.287000656128, },
				[8] = { 1825, statInterpolation = { 1, }, actorLevel = 26.732000350952, },
				[9] = { 1800, statInterpolation = { 1, }, actorLevel = 31.40299987793, },
				[10] = { 1775, statInterpolation = { 1, }, actorLevel = 36.299999237061, },
				[11] = { 1750, statInterpolation = { 1, }, actorLevel = 41.423000335693, },
				[12] = { 1725, statInterpolation = { 1, }, actorLevel = 46.771999359131, },
				[13] = { 1700, statInterpolation = { 1, }, actorLevel = 52.34700012207, },
				[14] = { 1675, statInterpolation = { 1, }, actorLevel = 58.147998809814, },
				[15] = { 1650, statInterpolation = { 1, }, actorLevel = 64.175003051758, },
				[16] = { 1625, statInterpolation = { 1, }, actorLevel = 70.428001403809, },
				[17] = { 1600, statInterpolation = { 1, }, actorLevel = 76.906997680664, },
				[18] = { 1575, statInterpolation = { 1, }, actorLevel = 83.611999511719, },
				[19] = { 1550, statInterpolation = { 1, }, actorLevel = 90.542999267578, },
				[20] = { 1525, statInterpolation = { 1, }, actorLevel = 97.699996948242, },
				[21] = { 1500, statInterpolation = { 1, }, actorLevel = 105.08300018311, },
				[22] = { 1475, statInterpolation = { 1, }, actorLevel = 112.69200134277, },
				[23] = { 1450, statInterpolation = { 1, }, actorLevel = 120.52700042725, },
				[24] = { 1425, statInterpolation = { 1, }, actorLevel = 128.58799743652, },
				[25] = { 1400, statInterpolation = { 1, }, actorLevel = 136.875, },
				[26] = { 1375, statInterpolation = { 1, }, actorLevel = 145.38800048828, },
				[27] = { 1350, statInterpolation = { 1, }, actorLevel = 154.12699890137, },
				[28] = { 1325, statInterpolation = { 1, }, actorLevel = 163.09199523926, },
				[29] = { 1300, statInterpolation = { 1, }, actorLevel = 172.28300476074, },
				[30] = { 1275, statInterpolation = { 1, }, actorLevel = 181.69999694824, },
				[31] = { 1263, statInterpolation = { 1, }, actorLevel = 191.34300231934, },
				[32] = { 1250, statInterpolation = { 1, }, actorLevel = 201.21200561523, },
				[33] = { 1238, statInterpolation = { 1, }, actorLevel = 211.30700683594, },
				[34] = { 1225, statInterpolation = { 1, }, actorLevel = 221.62800598145, },
				[35] = { 1213, statInterpolation = { 1, }, actorLevel = 232.17500305176, },
				[36] = { 1200, statInterpolation = { 1, }, actorLevel = 242.94799804688, },
				[37] = { 1188, statInterpolation = { 1, }, actorLevel = 253.94700622559, },
				[38] = { 1175, statInterpolation = { 1, }, actorLevel = 265.17199707031, },
				[39] = { 1163, statInterpolation = { 1, }, actorLevel = 276.62298583984, },
				[40] = { 1150, statInterpolation = { 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["MeleeBowPlayer"] = {
	name = "Bow Shot",
	baseTypeName = "Bow Shot",
	fromItem = true,
	color = 4,
	description = "Fire an arrow with your Bow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Barrageable] = true, [SkillType.UsableWhileMoving] = true, [SkillType.Bow] = true, [SkillType.NoAttackInPlace] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	castTime = 1,
	qualityStats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { baseMultiplier = 1.1, levelRequirement = 3, },
		[3] = { baseMultiplier = 1.21, levelRequirement = 6, },
		[4] = { baseMultiplier = 1.32, levelRequirement = 10, },
		[5] = { baseMultiplier = 1.42, levelRequirement = 14, },
		[6] = { baseMultiplier = 1.53, levelRequirement = 18, },
		[7] = { baseMultiplier = 1.64, levelRequirement = 22, },
		[8] = { baseMultiplier = 1.74, levelRequirement = 26, },
		[9] = { baseMultiplier = 1.82, levelRequirement = 31, },
		[10] = { baseMultiplier = 1.91, levelRequirement = 36, },
		[11] = { baseMultiplier = 2.01, levelRequirement = 41, },
		[12] = { baseMultiplier = 2.11, levelRequirement = 46, },
		[13] = { baseMultiplier = 2.22, levelRequirement = 52, },
		[14] = { baseMultiplier = 2.33, levelRequirement = 58, },
		[15] = { baseMultiplier = 2.44, levelRequirement = 64, },
		[16] = { baseMultiplier = 2.57, levelRequirement = 66, },
		[17] = { baseMultiplier = 2.69, levelRequirement = 72, },
		[18] = { baseMultiplier = 2.83, levelRequirement = 78, },
		[19] = { baseMultiplier = 2.97, levelRequirement = 84, },
		[20] = { baseMultiplier = 3.12, levelRequirement = 90, },
		[21] = { baseMultiplier = 3.27, levelRequirement = 90, },
		[22] = { baseMultiplier = 3.44, levelRequirement = 90, },
		[23] = { baseMultiplier = 3.61, levelRequirement = 90, },
		[24] = { baseMultiplier = 3.79, levelRequirement = 90, },
		[25] = { baseMultiplier = 3.98, levelRequirement = 90, },
		[26] = { baseMultiplier = 4.18, levelRequirement = 90, },
		[27] = { baseMultiplier = 4.39, levelRequirement = 90, },
		[28] = { baseMultiplier = 4.61, levelRequirement = 90, },
		[29] = { baseMultiplier = 4.84, levelRequirement = 90, },
		[30] = { baseMultiplier = 5.08, levelRequirement = 90, },
		[31] = { baseMultiplier = 5.33, levelRequirement = 90, },
		[32] = { baseMultiplier = 5.6, levelRequirement = 90, },
		[33] = { baseMultiplier = 5.88, levelRequirement = 90, },
		[34] = { baseMultiplier = 6.18, levelRequirement = 90, },
		[35] = { baseMultiplier = 6.48, levelRequirement = 90, },
		[36] = { baseMultiplier = 6.81, levelRequirement = 90, },
		[37] = { baseMultiplier = 7.15, levelRequirement = 90, },
		[38] = { baseMultiplier = 7.51, levelRequirement = 90, },
		[39] = { baseMultiplier = 7.88, levelRequirement = 90, },
		[40] = { baseMultiplier = 8.28, levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Bow Shot",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			baseFlags = {
				attack = true,
				projectile = true,
			},
			constantStats = {
				{ "movement_speed_+%_final_while_performing_action", -70 },
				{ "movement_speed_acceleration_+%_per_second_while_performing_action", 160 },
				{ "movement_speed_while_performing_action_locked_duration_%", 50 },
			},
			stats = {
				"base_is_projectile",
				"projectile_uses_contact_position",
				"projectile_uses_contact_direction",
				"check_for_targets_between_initiator_and_projectile_source",
				"skill_can_fire_arrows",
				"can_perform_skill_while_moving",
				"should_use_additive_aiming_animation",
				"has_modular_projectiles_enabled",
				"precise_cursor_targeting_uses_contact_point_height_offset",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["ExplodingPoisonToadPlayer"] = {
	name = "Bursting Fen Toad",
	baseTypeName = "Bursting Fen Toad",
	fromItem = true,
	color = 4,
	description = "A Poisonous Toad leaps towards enemies and explodes, dealing damage in an area and inflicting Poison.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Chaos] = true, [SkillType.Physical] = true, [SkillType.Triggered] = true, [SkillType.Triggerable] = true, [SkillType.NonWeaponAttack] = true, [SkillType.NoAttackOrCastTime] = true, [SkillType.UseGlobalStats] = true, },
	castTime = 1,
	qualityStats = {
		{ "trigger_toad_spawn_chance_%", 0.5 },
	},
	levels = {
		[1] = { critChance = 5, baseMultiplier = 2.25, levelRequirement = 0, },
		[2] = { critChance = 5, baseMultiplier = 2.48, levelRequirement = 3, },
		[3] = { critChance = 5, baseMultiplier = 2.72, levelRequirement = 6, },
		[4] = { critChance = 5, baseMultiplier = 2.97, levelRequirement = 10, },
		[5] = { critChance = 5, baseMultiplier = 3.2, levelRequirement = 14, },
		[6] = { critChance = 5, baseMultiplier = 3.45, levelRequirement = 18, },
		[7] = { critChance = 5, baseMultiplier = 3.69, levelRequirement = 22, },
		[8] = { critChance = 5, baseMultiplier = 3.91, levelRequirement = 26, },
		[9] = { critChance = 5, baseMultiplier = 4.1, levelRequirement = 31, },
		[10] = { critChance = 5, baseMultiplier = 4.31, levelRequirement = 36, },
		[11] = { critChance = 5, baseMultiplier = 4.52, levelRequirement = 41, },
		[12] = { critChance = 5, baseMultiplier = 4.75, levelRequirement = 46, },
		[13] = { critChance = 5, baseMultiplier = 4.99, levelRequirement = 52, },
		[14] = { critChance = 5, baseMultiplier = 5.24, levelRequirement = 58, },
		[15] = { critChance = 5, baseMultiplier = 5.5, levelRequirement = 64, },
		[16] = { critChance = 5, baseMultiplier = 5.77, levelRequirement = 66, },
		[17] = { critChance = 5, baseMultiplier = 6.06, levelRequirement = 72, },
		[18] = { critChance = 5, baseMultiplier = 6.37, levelRequirement = 78, },
		[19] = { critChance = 5, baseMultiplier = 6.68, levelRequirement = 84, },
		[20] = { critChance = 5, baseMultiplier = 7.02, levelRequirement = 90, },
		[21] = { critChance = 5, baseMultiplier = 7.37, levelRequirement = 90, },
		[22] = { critChance = 5, baseMultiplier = 7.74, levelRequirement = 90, },
		[23] = { critChance = 5, baseMultiplier = 8.12, levelRequirement = 90, },
		[24] = { critChance = 5, baseMultiplier = 8.53, levelRequirement = 90, },
		[25] = { critChance = 5, baseMultiplier = 8.96, levelRequirement = 90, },
		[26] = { critChance = 5, baseMultiplier = 9.4, levelRequirement = 90, },
		[27] = { critChance = 5, baseMultiplier = 9.87, levelRequirement = 90, },
		[28] = { critChance = 5, baseMultiplier = 10.37, levelRequirement = 90, },
		[29] = { critChance = 5, baseMultiplier = 10.89, levelRequirement = 90, },
		[30] = { critChance = 5, baseMultiplier = 11.43, levelRequirement = 90, },
		[31] = { critChance = 5, baseMultiplier = 12, levelRequirement = 90, },
		[32] = { critChance = 5, baseMultiplier = 12.6, levelRequirement = 90, },
		[33] = { critChance = 5, baseMultiplier = 13.23, levelRequirement = 90, },
		[34] = { critChance = 5, baseMultiplier = 13.89, levelRequirement = 90, },
		[35] = { critChance = 5, baseMultiplier = 14.59, levelRequirement = 90, },
		[36] = { critChance = 5, baseMultiplier = 15.32, levelRequirement = 90, },
		[37] = { critChance = 5, baseMultiplier = 16.08, levelRequirement = 90, },
		[38] = { critChance = 5, baseMultiplier = 16.89, levelRequirement = 90, },
		[39] = { critChance = 5, baseMultiplier = 17.73, levelRequirement = 90, },
		[40] = { critChance = 5, baseMultiplier = 18.62, levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Bursting Fen Toad",
			baseEffectiveness = 2,
			incrementalEffectiveness = 0.27349999547005,
			statDescriptionScope = "exploding_poison_toad",
			baseFlags = {
				area = true,
				attack = true,
			},
			constantStats = {
				{ "trigger_toad_spawn_chance_%", 25 },
				{ "base_chance_to_poison_on_hit_%", 100 },
				{ "active_skill_base_area_of_effect_radius", 25 },
			},
			stats = {
				"attack_minimum_added_physical_damage",
				"attack_maximum_added_physical_damage",
				"is_area_damage",
			},
			levels = {
				[1] = { 6, 9, statInterpolation = { 1, 1, }, actorLevel = 1, },
				[2] = { 10, 16, statInterpolation = { 1, 1, }, actorLevel = 3.4519999027252, },
				[3] = { 16, 24, statInterpolation = { 1, 1, }, actorLevel = 6.7670001983643, },
				[4] = { 22, 33, statInterpolation = { 1, 1, }, actorLevel = 10.307999610901, },
				[5] = { 28, 43, statInterpolation = { 1, 1, }, actorLevel = 14.074999809265, },
				[6] = { 35, 53, statInterpolation = { 1, 1, }, actorLevel = 18.068000793457, },
				[7] = { 42, 64, statInterpolation = { 1, 1, }, actorLevel = 22.287000656128, },
				[8] = { 50, 75, statInterpolation = { 1, 1, }, actorLevel = 26.732000350952, },
				[9] = { 58, 87, statInterpolation = { 1, 1, }, actorLevel = 31.40299987793, },
				[10] = { 66, 99, statInterpolation = { 1, 1, }, actorLevel = 36.299999237061, },
				[11] = { 75, 112, statInterpolation = { 1, 1, }, actorLevel = 41.423000335693, },
				[12] = { 84, 126, statInterpolation = { 1, 1, }, actorLevel = 46.771999359131, },
				[13] = { 94, 140, statInterpolation = { 1, 1, }, actorLevel = 52.34700012207, },
				[14] = { 103, 155, statInterpolation = { 1, 1, }, actorLevel = 58.147998809814, },
				[15] = { 114, 170, statInterpolation = { 1, 1, }, actorLevel = 64.175003051758, },
				[16] = { 124, 186, statInterpolation = { 1, 1, }, actorLevel = 70.428001403809, },
				[17] = { 135, 203, statInterpolation = { 1, 1, }, actorLevel = 76.906997680664, },
				[18] = { 147, 220, statInterpolation = { 1, 1, }, actorLevel = 83.611999511719, },
				[19] = { 158, 238, statInterpolation = { 1, 1, }, actorLevel = 90.542999267578, },
				[20] = { 171, 256, statInterpolation = { 1, 1, }, actorLevel = 97.699996948242, },
				[21] = { 183, 275, statInterpolation = { 1, 1, }, actorLevel = 105.08300018311, },
				[22] = { 196, 294, statInterpolation = { 1, 1, }, actorLevel = 112.69200134277, },
				[23] = { 209, 314, statInterpolation = { 1, 1, }, actorLevel = 120.52700042725, },
				[24] = { 223, 335, statInterpolation = { 1, 1, }, actorLevel = 128.58799743652, },
				[25] = { 237, 356, statInterpolation = { 1, 1, }, actorLevel = 136.875, },
				[26] = { 252, 378, statInterpolation = { 1, 1, }, actorLevel = 145.38800048828, },
				[27] = { 267, 400, statInterpolation = { 1, 1, }, actorLevel = 154.12699890137, },
				[28] = { 282, 423, statInterpolation = { 1, 1, }, actorLevel = 163.09199523926, },
				[29] = { 297, 446, statInterpolation = { 1, 1, }, actorLevel = 172.28300476074, },
				[30] = { 313, 470, statInterpolation = { 1, 1, }, actorLevel = 181.69999694824, },
				[31] = { 330, 495, statInterpolation = { 1, 1, }, actorLevel = 191.34300231934, },
				[32] = { 347, 520, statInterpolation = { 1, 1, }, actorLevel = 201.21200561523, },
				[33] = { 364, 546, statInterpolation = { 1, 1, }, actorLevel = 211.30700683594, },
				[34] = { 381, 572, statInterpolation = { 1, 1, }, actorLevel = 221.62800598145, },
				[35] = { 399, 599, statInterpolation = { 1, 1, }, actorLevel = 232.17500305176, },
				[36] = { 418, 626, statInterpolation = { 1, 1, }, actorLevel = 242.94799804688, },
				[37] = { 436, 654, statInterpolation = { 1, 1, }, actorLevel = 253.94700622559, },
				[38] = { 455, 683, statInterpolation = { 1, 1, }, actorLevel = 265.17199707031, },
				[39] = { 475, 712, statInterpolation = { 1, 1, }, actorLevel = 276.62298583984, },
				[40] = { 495, 742, statInterpolation = { 1, 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["MetaDeadeyeMarksPlayer"] = {
	name = "Called Shots",
	baseTypeName = "Called Shots",
	fromTree = true,
	color = 4,
	description = "Applies a socketed Mark Skill to a nearby unmarked Enemy every few seconds. Consuming socketed Marks will cause them to be reapplied to an unmarked Enemy. This reapplication can happen at most once every half second.",
	skillTypes = { [SkillType.OngoingSkill] = true, [SkillType.Meta] = true, [SkillType.Persistent] = true, [SkillType.Buff] = true, [SkillType.CanHaveMultipleOngoingSkillInstances] = true, [SkillType.Triggers] = true, [SkillType.Area] = true, [SkillType.HasReservation] = true, [SkillType.ZeroReservation] = true, },
	castTime = 1,
	qualityStats = {
		{ "active_skill_base_area_of_effect_radius", 0.2 },
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 3, },
		[3] = { levelRequirement = 6, },
		[4] = { levelRequirement = 10, },
		[5] = { levelRequirement = 14, },
		[6] = { levelRequirement = 18, },
		[7] = { levelRequirement = 22, },
		[8] = { levelRequirement = 26, },
		[9] = { levelRequirement = 31, },
		[10] = { levelRequirement = 36, },
		[11] = { levelRequirement = 41, },
		[12] = { levelRequirement = 46, },
		[13] = { levelRequirement = 52, },
		[14] = { levelRequirement = 58, },
		[15] = { levelRequirement = 64, },
		[16] = { levelRequirement = 66, },
		[17] = { levelRequirement = 72, },
		[18] = { levelRequirement = 78, },
		[19] = { levelRequirement = 84, },
		[20] = { levelRequirement = 90, },
		[21] = { levelRequirement = 90, },
		[22] = { levelRequirement = 90, },
		[23] = { levelRequirement = 90, },
		[24] = { levelRequirement = 90, },
		[25] = { levelRequirement = 90, },
		[26] = { levelRequirement = 90, },
		[27] = { levelRequirement = 90, },
		[28] = { levelRequirement = 90, },
		[29] = { levelRequirement = 90, },
		[30] = { levelRequirement = 90, },
		[31] = { levelRequirement = 90, },
		[32] = { levelRequirement = 90, },
		[33] = { levelRequirement = 90, },
		[34] = { levelRequirement = 90, },
		[35] = { levelRequirement = 90, },
		[36] = { levelRequirement = 90, },
		[37] = { levelRequirement = 90, },
		[38] = { levelRequirement = 90, },
		[39] = { levelRequirement = 90, },
		[40] = { levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Called Shots",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "meta_deadeye_marks",
			baseFlags = {
			},
			constantStats = {
				{ "active_skill_base_area_of_effect_radius", 40 },
				{ "deadeye_meta_marks_number_of_enemies_to_mark", 1 },
			},
			stats = {
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["SupportMetaDeadeyeMarksPlayer"] = {
	name = "SupportMetaDeadeyeMarksPlayer",
	hidden = true,
	fromTree = true,
	support = true,
	requireSkillTypes = { SkillType.Mark, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	qualityStats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 0, },
		[3] = { levelRequirement = 0, },
		[4] = { levelRequirement = 0, },
		[5] = { levelRequirement = 0, },
		[6] = { levelRequirement = 0, },
		[7] = { levelRequirement = 0, },
		[8] = { levelRequirement = 0, },
		[9] = { levelRequirement = 0, },
		[10] = { levelRequirement = 0, },
		[11] = { levelRequirement = 0, },
		[12] = { levelRequirement = 0, },
		[13] = { levelRequirement = 0, },
		[14] = { levelRequirement = 0, },
		[15] = { levelRequirement = 0, },
		[16] = { levelRequirement = 0, },
		[17] = { levelRequirement = 0, },
		[18] = { levelRequirement = 0, },
		[19] = { levelRequirement = 0, },
		[20] = { levelRequirement = 0, },
		[21] = { levelRequirement = 0, },
		[22] = { levelRequirement = 0, },
		[23] = { levelRequirement = 0, },
		[24] = { levelRequirement = 0, },
		[25] = { levelRequirement = 0, },
		[26] = { levelRequirement = 0, },
		[27] = { levelRequirement = 0, },
		[28] = { levelRequirement = 0, },
		[29] = { levelRequirement = 0, },
		[30] = { levelRequirement = 0, },
		[31] = { levelRequirement = 0, },
		[32] = { levelRequirement = 0, },
		[33] = { levelRequirement = 0, },
		[34] = { levelRequirement = 0, },
		[35] = { levelRequirement = 0, },
		[36] = { levelRequirement = 0, },
		[37] = { levelRequirement = 0, },
		[38] = { levelRequirement = 0, },
		[39] = { levelRequirement = 0, },
		[40] = { levelRequirement = 0, },
	},
	statSets = {
		[1] = {
			label = "SupportMetaDeadeyeMarksPlayer",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "meta_gem_stat_descriptions",
			baseFlags = {
			},
			constantStats = {
				{ "your_marks_spread_to_a_nearby_enemies_on_consume_%_chance", 100 },
			},
			stats = {
				"mark_supported_by_deadeye_meta_gem",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["MetaCastOnCharmUsePlayer"] = {
	name = "Cast on Charm Use",
	baseTypeName = "Cast on Charm Use",
	fromItem = true,
	color = 4,
	description = "While active, gains Energy when one of your Charms is used and triggers socketed Spells on reaching maximum Energy.",
	skillTypes = { [SkillType.HasReservation] = true, [SkillType.OngoingSkill] = true, [SkillType.Meta] = true, [SkillType.Persistent] = true, [SkillType.Buff] = true, [SkillType.CanHaveMultipleOngoingSkillInstances] = true, [SkillType.GeneratesEnergy] = true, [SkillType.Triggers] = true, },
	castTime = 0,
	qualityStats = {
		{ "energy_generated_+%", 0.75 },
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 3, },
		[3] = { levelRequirement = 6, },
		[4] = { levelRequirement = 10, },
		[5] = { levelRequirement = 14, },
		[6] = { levelRequirement = 18, },
		[7] = { levelRequirement = 22, },
		[8] = { levelRequirement = 26, },
		[9] = { levelRequirement = 31, },
		[10] = { levelRequirement = 36, },
		[11] = { levelRequirement = 41, },
		[12] = { levelRequirement = 46, },
		[13] = { levelRequirement = 52, },
		[14] = { levelRequirement = 58, },
		[15] = { levelRequirement = 64, },
		[16] = { levelRequirement = 66, },
		[17] = { levelRequirement = 72, },
		[18] = { levelRequirement = 78, },
		[19] = { levelRequirement = 84, },
		[20] = { levelRequirement = 90, },
		[21] = { levelRequirement = 90, },
		[22] = { levelRequirement = 90, },
		[23] = { levelRequirement = 90, },
		[24] = { levelRequirement = 90, },
		[25] = { levelRequirement = 90, },
		[26] = { levelRequirement = 90, },
		[27] = { levelRequirement = 90, },
		[28] = { levelRequirement = 90, },
		[29] = { levelRequirement = 90, },
		[30] = { levelRequirement = 90, },
		[31] = { levelRequirement = 90, },
		[32] = { levelRequirement = 90, },
		[33] = { levelRequirement = 90, },
		[34] = { levelRequirement = 90, },
		[35] = { levelRequirement = 90, },
		[36] = { levelRequirement = 90, },
		[37] = { levelRequirement = 90, },
		[38] = { levelRequirement = 90, },
		[39] = { levelRequirement = 90, },
		[40] = { levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Cast on Charm Use",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			baseFlags = {
			},
			constantStats = {
				{ "cast_on_using_charm_gain_X_centienergy_per_charm_charge_used_on_using_charm", 200 },
				{ "skill_desired_amount_override", 1 },
			},
			stats = {
				"energy_generated_+%",
				"generic_ongoing_trigger_triggers_at_maximum_energy",
				"generic_ongoing_trigger_maximum_energy_is_total_of_socketed_skills",
				"base_deal_no_damage",
			},
			levels = {
				[1] = { 0, statInterpolation = { 1, }, actorLevel = 1, },
				[2] = { 3, statInterpolation = { 1, }, actorLevel = 3.4519999027252, },
				[3] = { 6, statInterpolation = { 1, }, actorLevel = 6.7670001983643, },
				[4] = { 9, statInterpolation = { 1, }, actorLevel = 10.307999610901, },
				[5] = { 12, statInterpolation = { 1, }, actorLevel = 14.074999809265, },
				[6] = { 15, statInterpolation = { 1, }, actorLevel = 18.068000793457, },
				[7] = { 18, statInterpolation = { 1, }, actorLevel = 22.287000656128, },
				[8] = { 21, statInterpolation = { 1, }, actorLevel = 26.732000350952, },
				[9] = { 24, statInterpolation = { 1, }, actorLevel = 31.40299987793, },
				[10] = { 27, statInterpolation = { 1, }, actorLevel = 36.299999237061, },
				[11] = { 30, statInterpolation = { 1, }, actorLevel = 41.423000335693, },
				[12] = { 33, statInterpolation = { 1, }, actorLevel = 46.771999359131, },
				[13] = { 36, statInterpolation = { 1, }, actorLevel = 52.34700012207, },
				[14] = { 39, statInterpolation = { 1, }, actorLevel = 58.147998809814, },
				[15] = { 42, statInterpolation = { 1, }, actorLevel = 64.175003051758, },
				[16] = { 45, statInterpolation = { 1, }, actorLevel = 70.428001403809, },
				[17] = { 48, statInterpolation = { 1, }, actorLevel = 76.906997680664, },
				[18] = { 51, statInterpolation = { 1, }, actorLevel = 83.611999511719, },
				[19] = { 54, statInterpolation = { 1, }, actorLevel = 90.542999267578, },
				[20] = { 57, statInterpolation = { 1, }, actorLevel = 97.699996948242, },
				[21] = { 60, statInterpolation = { 1, }, actorLevel = 105.08300018311, },
				[22] = { 63, statInterpolation = { 1, }, actorLevel = 112.69200134277, },
				[23] = { 66, statInterpolation = { 1, }, actorLevel = 120.52700042725, },
				[24] = { 69, statInterpolation = { 1, }, actorLevel = 128.58799743652, },
				[25] = { 72, statInterpolation = { 1, }, actorLevel = 136.875, },
				[26] = { 75, statInterpolation = { 1, }, actorLevel = 145.38800048828, },
				[27] = { 78, statInterpolation = { 1, }, actorLevel = 154.12699890137, },
				[28] = { 81, statInterpolation = { 1, }, actorLevel = 163.09199523926, },
				[29] = { 84, statInterpolation = { 1, }, actorLevel = 172.28300476074, },
				[30] = { 87, statInterpolation = { 1, }, actorLevel = 181.69999694824, },
				[31] = { 90, statInterpolation = { 1, }, actorLevel = 191.34300231934, },
				[32] = { 93, statInterpolation = { 1, }, actorLevel = 201.21200561523, },
				[33] = { 96, statInterpolation = { 1, }, actorLevel = 211.30700683594, },
				[34] = { 99, statInterpolation = { 1, }, actorLevel = 221.62800598145, },
				[35] = { 102, statInterpolation = { 1, }, actorLevel = 232.17500305176, },
				[36] = { 105, statInterpolation = { 1, }, actorLevel = 242.94799804688, },
				[37] = { 108, statInterpolation = { 1, }, actorLevel = 253.94700622559, },
				[38] = { 111, statInterpolation = { 1, }, actorLevel = 265.17199707031, },
				[39] = { 114, statInterpolation = { 1, }, actorLevel = 276.62298583984, },
				[40] = { 117, statInterpolation = { 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["SupportMetaCastOnCharmUsePlayer"] = {
	name = "SupportMetaCastOnCharmUsePlayer",
	hidden = true,
	fromItem = true,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.SupportedByHourglass, },
	isTrigger = true,
	qualityStats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 0, },
		[3] = { levelRequirement = 0, },
		[4] = { levelRequirement = 0, },
		[5] = { levelRequirement = 0, },
		[6] = { levelRequirement = 0, },
		[7] = { levelRequirement = 0, },
		[8] = { levelRequirement = 0, },
		[9] = { levelRequirement = 0, },
		[10] = { levelRequirement = 0, },
		[11] = { levelRequirement = 0, },
		[12] = { levelRequirement = 0, },
		[13] = { levelRequirement = 0, },
		[14] = { levelRequirement = 0, },
		[15] = { levelRequirement = 0, },
		[16] = { levelRequirement = 0, },
		[17] = { levelRequirement = 0, },
		[18] = { levelRequirement = 0, },
		[19] = { levelRequirement = 0, },
		[20] = { levelRequirement = 0, },
		[21] = { levelRequirement = 0, },
		[22] = { levelRequirement = 0, },
		[23] = { levelRequirement = 0, },
		[24] = { levelRequirement = 0, },
		[25] = { levelRequirement = 0, },
		[26] = { levelRequirement = 0, },
		[27] = { levelRequirement = 0, },
		[28] = { levelRequirement = 0, },
		[29] = { levelRequirement = 0, },
		[30] = { levelRequirement = 0, },
		[31] = { levelRequirement = 0, },
		[32] = { levelRequirement = 0, },
		[33] = { levelRequirement = 0, },
		[34] = { levelRequirement = 0, },
		[35] = { levelRequirement = 0, },
		[36] = { levelRequirement = 0, },
		[37] = { levelRequirement = 0, },
		[38] = { levelRequirement = 0, },
		[39] = { levelRequirement = 0, },
		[40] = { levelRequirement = 0, },
	},
	statSets = {
		[1] = {
			label = "SupportMetaCastOnCharmUsePlayer",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "meta_gem_stat_descriptions",
			baseFlags = {
			},
			constantStats = {
				{ "generic_ongoing_trigger_1_maximum_energy_per_Xms_total_cast_time", 10 },
			},
			stats = {
				"triggered_by_generic_ongoing_trigger",
				"generic_ongoing_trigger_triggers_at_maximum_energy",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["MeleeCrossbowPlayer"] = {
	name = "Crossbow Shot",
	baseTypeName = "Crossbow Shot",
	fromItem = true,
	color = 4,
	description = "Fire a bolt from your crossbow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.CrossbowSkill] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.UsableWhileMoving] = true, [SkillType.NoAttackInPlace] = true, },
	weaponTypes = {
		["Crossbow"] = true,
	},
	castTime = 1,
	qualityStats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { baseMultiplier = 1.1, levelRequirement = 3, },
		[3] = { baseMultiplier = 1.21, levelRequirement = 6, },
		[4] = { baseMultiplier = 1.32, levelRequirement = 10, },
		[5] = { baseMultiplier = 1.43, levelRequirement = 14, },
		[6] = { baseMultiplier = 1.54, levelRequirement = 18, },
		[7] = { baseMultiplier = 1.66, levelRequirement = 22, },
		[8] = { baseMultiplier = 1.77, levelRequirement = 26, },
		[9] = { baseMultiplier = 1.87, levelRequirement = 31, },
		[10] = { baseMultiplier = 1.98, levelRequirement = 36, },
		[11] = { baseMultiplier = 2.09, levelRequirement = 41, },
		[12] = { baseMultiplier = 2.22, levelRequirement = 46, },
		[13] = { baseMultiplier = 2.35, levelRequirement = 52, },
		[14] = { baseMultiplier = 2.49, levelRequirement = 58, },
		[15] = { baseMultiplier = 2.65, levelRequirement = 64, },
		[16] = { baseMultiplier = 2.81, levelRequirement = 66, },
		[17] = { baseMultiplier = 2.99, levelRequirement = 72, },
		[18] = { baseMultiplier = 3.19, levelRequirement = 78, },
		[19] = { baseMultiplier = 3.4, levelRequirement = 84, },
		[20] = { baseMultiplier = 3.62, levelRequirement = 90, },
		[21] = { baseMultiplier = 3.86, levelRequirement = 90, },
		[22] = { baseMultiplier = 4.12, levelRequirement = 90, },
		[23] = { baseMultiplier = 4.4, levelRequirement = 90, },
		[24] = { baseMultiplier = 4.69, levelRequirement = 90, },
		[25] = { baseMultiplier = 5, levelRequirement = 90, },
		[26] = { baseMultiplier = 5.33, levelRequirement = 90, },
		[27] = { baseMultiplier = 5.69, levelRequirement = 90, },
		[28] = { baseMultiplier = 6.07, levelRequirement = 90, },
		[29] = { baseMultiplier = 6.47, levelRequirement = 90, },
		[30] = { baseMultiplier = 6.9, levelRequirement = 90, },
		[31] = { baseMultiplier = 7.36, levelRequirement = 90, },
		[32] = { baseMultiplier = 7.85, levelRequirement = 90, },
		[33] = { baseMultiplier = 8.38, levelRequirement = 90, },
		[34] = { baseMultiplier = 8.93, levelRequirement = 90, },
		[35] = { baseMultiplier = 9.53, levelRequirement = 90, },
		[36] = { baseMultiplier = 10.16, levelRequirement = 90, },
		[37] = { baseMultiplier = 10.84, levelRequirement = 90, },
		[38] = { baseMultiplier = 11.56, levelRequirement = 90, },
		[39] = { baseMultiplier = 12.33, levelRequirement = 90, },
		[40] = { baseMultiplier = 13.16, levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Crossbow Shot",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			baseFlags = {
				attack = true,
				area = true,
				projectile = true,
			},
			constantStats = {
				{ "action_required_target_facing_angle_tolerance_degrees", 90 },
				{ "crossbow_barrage_attack_time_ratio_%", 10 },
				{ "crossbow_barrage_recoil_per_shot", 2 },
				{ "crossbow_barrage_total_recoil_buff_count", 8 },
				{ "crossbow_barrage_debuff_duration_ms", 300 },
				{ "base_knockback_distance", 0 },
				{ "movement_speed_+%_final_while_performing_action", -70 },
				{ "movement_speed_acceleration_+%_per_second_while_performing_action", 160 },
				{ "movement_speed_while_performing_action_locked_duration_%", 50 },
			},
			stats = {
				"base_is_projectile",
				"has_modular_projectiles_enabled",
				"action_requires_aiming_stance",
				"projectile_uses_contact_position",
				"projectile_uses_contact_direction",
				"check_for_targets_between_initiator_and_projectile_source",
				"projectiles_crossbow_barrage",
				"cannot_cancel_skill_before_contact_point",
				"disable_visual_hit_effect",
				"can_perform_skill_while_moving",
				"precise_cursor_targeting_uses_contact_point_height_offset",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["UnloadAmmoPlayer"] = {
	name = "Basic Bolt",
	hidden = true,
	fromItem = true,
	description = "Clear your active Bolt and reload any ammunition.",
	skillTypes = { [SkillType.CrossbowAmmoSkill] = true, [SkillType.Attack] = true, [SkillType.UsableWhileMoving] = true, [SkillType.NoAttackInPlace] = true, },
	weaponTypes = {
		["Crossbow"] = true,
	},
	castTime = 0.5,
	qualityStats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 0, },
		[3] = { levelRequirement = 0, },
		[4] = { levelRequirement = 0, },
		[5] = { levelRequirement = 0, },
		[6] = { levelRequirement = 0, },
		[7] = { levelRequirement = 0, },
		[8] = { levelRequirement = 0, },
		[9] = { levelRequirement = 0, },
		[10] = { levelRequirement = 0, },
		[11] = { levelRequirement = 0, },
		[12] = { levelRequirement = 0, },
		[13] = { levelRequirement = 0, },
		[14] = { levelRequirement = 0, },
		[15] = { levelRequirement = 0, },
		[16] = { levelRequirement = 0, },
		[17] = { levelRequirement = 0, },
		[18] = { levelRequirement = 0, },
		[19] = { levelRequirement = 0, },
		[20] = { levelRequirement = 0, },
		[21] = { levelRequirement = 0, },
		[22] = { levelRequirement = 0, },
		[23] = { levelRequirement = 0, },
		[24] = { levelRequirement = 0, },
		[25] = { levelRequirement = 0, },
		[26] = { levelRequirement = 0, },
		[27] = { levelRequirement = 0, },
		[28] = { levelRequirement = 0, },
		[29] = { levelRequirement = 0, },
		[30] = { levelRequirement = 0, },
		[31] = { levelRequirement = 0, },
		[32] = { levelRequirement = 0, },
		[33] = { levelRequirement = 0, },
		[34] = { levelRequirement = 0, },
		[35] = { levelRequirement = 0, },
		[36] = { levelRequirement = 0, },
		[37] = { levelRequirement = 0, },
		[38] = { levelRequirement = 0, },
		[39] = { levelRequirement = 0, },
		[40] = { levelRequirement = 0, },
	},
	statSets = {
		[1] = {
			label = "Ammunition",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			baseFlags = {
			},
			constantStats = {
				{ "action_allowed_queue_time_override_ms", 1000 },
				{ "base_number_of_crossbow_bolts", 7 },
			},
			stats = {
				"crossbow_ammo_skill_binds_default_attack",
				"action_can_be_used_in_aiming_stance",
				"can_perform_skill_while_moving",
				"base_deal_no_damage",
				"crossbow_ammo_skill_does_not_transition",
				"can_be_used_instantly_in_any_set",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["DemonFormPlayer"] = {
	name = "Demon Form",
	baseTypeName = "Demon Form",
	fromTree = true,
	color = 4,
	description = "Shapeshift into a demon, vastly boosting the power of your Spells. You gain Demonflame every second you remain in demon form, causing your Life to be lost at an ever-increasing rate. Maximum 10 Demonflame. Revert to human form if you reach 1 Life, use a Skill that isn't a Spell, or reactivate this Skill.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Cooldown] = true, [SkillType.Shapeshift] = true, [SkillType.ManualCooldownConsumption] = true, [SkillType.NoAttackInPlace] = true, },
	castTime = 1,
	qualityStats = {
		{ "demon_form_grants_cast_speed_+%", 0.5 },
	},
	levels = {
		[1] = { storedUses = 1, levelRequirement = 0, cooldown = 15, cost = { Mana = 6, }, },
		[2] = { storedUses = 1, levelRequirement = 3, cooldown = 15, cost = { Mana = 7, }, },
		[3] = { storedUses = 1, levelRequirement = 6, cooldown = 15, cost = { Mana = 8, }, },
		[4] = { storedUses = 1, levelRequirement = 10, cooldown = 15, cost = { Mana = 10, }, },
		[5] = { storedUses = 1, levelRequirement = 14, cooldown = 15, cost = { Mana = 11, }, },
		[6] = { storedUses = 1, levelRequirement = 18, cooldown = 15, cost = { Mana = 13, }, },
		[7] = { storedUses = 1, levelRequirement = 22, cooldown = 15, cost = { Mana = 15, }, },
		[8] = { storedUses = 1, levelRequirement = 26, cooldown = 15, cost = { Mana = 17, }, },
		[9] = { storedUses = 1, levelRequirement = 31, cooldown = 15, cost = { Mana = 20, }, },
		[10] = { storedUses = 1, levelRequirement = 36, cooldown = 15, cost = { Mana = 22, }, },
		[11] = { storedUses = 1, levelRequirement = 41, cooldown = 15, cost = { Mana = 25, }, },
		[12] = { storedUses = 1, levelRequirement = 46, cooldown = 15, cost = { Mana = 28, }, },
		[13] = { storedUses = 1, levelRequirement = 52, cooldown = 15, cost = { Mana = 31, }, },
		[14] = { storedUses = 1, levelRequirement = 58, cooldown = 15, cost = { Mana = 35, }, },
		[15] = { storedUses = 1, levelRequirement = 64, cooldown = 15, cost = { Mana = 39, }, },
		[16] = { storedUses = 1, levelRequirement = 66, cooldown = 15, cost = { Mana = 43, }, },
		[17] = { storedUses = 1, levelRequirement = 72, cooldown = 15, cost = { Mana = 48, }, },
		[18] = { storedUses = 1, levelRequirement = 78, cooldown = 15, cost = { Mana = 53, }, },
		[19] = { storedUses = 1, levelRequirement = 84, cooldown = 15, cost = { Mana = 59, }, },
		[20] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 65, }, },
		[21] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 72, }, },
		[22] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 79, }, },
		[23] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 88, }, },
		[24] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 96, }, },
		[25] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 106, }, },
		[26] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 116, }, },
		[27] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 127, }, },
		[28] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 139, }, },
		[29] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 153, }, },
		[30] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 167, }, },
		[31] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 183, }, },
		[32] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 200, }, },
		[33] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 218, }, },
		[34] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 238, }, },
		[35] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 259, }, },
		[36] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 283, }, },
		[37] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 308, }, },
		[38] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 335, }, },
		[39] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 365, }, },
		[40] = { storedUses = 1, levelRequirement = 90, cooldown = 15, cost = { Mana = 397, }, },
	},
	statSets = {
		[1] = {
			label = "Demon Form",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "demon_transformation",
			statMap = {
				["demon_form_spell_damage_+%_final_per_stack"] = {
					mod("Damage", "MORE", nil, 0, KeywordFlag.Spell, { type = "Condition", var = "DemonForm" }, { type = "GlobalEffect", effectType = "Buff", effectName = "Demon Form"}, { type = "Multiplier", var = "DemonFlameStacks", limitVar = "DemonFlameMaximum" } ),
				},
				["demon_form_grants_cast_speed_+%"] = {
					mod("Speed", "INC", nil, ModFlag.Cast, 0, { type = "Condition", var = "DemonForm" }, { type = "GlobalEffect", effectType = "Buff", effectName = "Demon Form" } ),
				},
				["demon_form_life_loss_per_minute_per_stack"] = {
					mod("LifeDegen", "BASE", nil, 0, 0, { type = "Condition", var = "DemonForm" }, { type = "GlobalEffect", effectType = "Buff", effectName = "Demon Form" }, { type = "Multiplier", var = "DemonFlameStacks", limitVar = "DemonFlameMaximum" } ),
					div = 60,
				},
			},
			baseFlags = {
			},
			constantStats = {
				{ "demon_form_spell_damage_+%_final_per_stack", 3 },
			},
			stats = {
				"demon_form_grants_cast_speed_+%",
				"demon_form_life_loss_per_minute_per_stack",
				"base_deal_no_damage",
				"demon_transformation_cooldown_does_not_tick",
			},
			levels = {
				[1] = { 12, 48, statInterpolation = { 1, 1, }, actorLevel = 1, },
				[2] = { 13, 64, statInterpolation = { 1, 1, }, actorLevel = 3.4519999027252, },
				[3] = { 13, 72, statInterpolation = { 1, 1, }, actorLevel = 6.7670001983643, },
				[4] = { 14, 100, statInterpolation = { 1, 1, }, actorLevel = 10.307999610901, },
				[5] = { 15, 128, statInterpolation = { 1, 1, }, actorLevel = 14.074999809265, },
				[6] = { 15, 144, statInterpolation = { 1, 1, }, actorLevel = 18.068000793457, },
				[7] = { 16, 160, statInterpolation = { 1, 1, }, actorLevel = 22.287000656128, },
				[8] = { 17, 180, statInterpolation = { 1, 1, }, actorLevel = 26.732000350952, },
				[9] = { 17, 210, statInterpolation = { 1, 1, }, actorLevel = 31.40299987793, },
				[10] = { 18, 244, statInterpolation = { 1, 1, }, actorLevel = 36.299999237061, },
				[11] = { 19, 308, statInterpolation = { 1, 1, }, actorLevel = 41.423000335693, },
				[12] = { 20, 346, statInterpolation = { 1, 1, }, actorLevel = 46.771999359131, },
				[13] = { 20, 394, statInterpolation = { 1, 1, }, actorLevel = 52.34700012207, },
				[14] = { 21, 454, statInterpolation = { 1, 1, }, actorLevel = 58.147998809814, },
				[15] = { 22, 518, statInterpolation = { 1, 1, }, actorLevel = 64.175003051758, },
				[16] = { 22, 585, statInterpolation = { 1, 1, }, actorLevel = 70.428001403809, },
				[17] = { 23, 780, statInterpolation = { 1, 1, }, actorLevel = 76.906997680664, },
				[18] = { 24, 848, statInterpolation = { 1, 1, }, actorLevel = 83.611999511719, },
				[19] = { 24, 980, statInterpolation = { 1, 1, }, actorLevel = 90.542999267578, },
				[20] = { 25, 1112, statInterpolation = { 1, 1, }, actorLevel = 97.699996948242, },
				[21] = { 26, 1143, statInterpolation = { 1, 1, }, actorLevel = 105.08300018311, },
				[22] = { 26, 1179, statInterpolation = { 1, 1, }, actorLevel = 112.69200134277, },
				[23] = { 27, 1214, statInterpolation = { 1, 1, }, actorLevel = 120.52700042725, },
				[24] = { 28, 1247, statInterpolation = { 1, 1, }, actorLevel = 128.58799743652, },
				[25] = { 28, 1278, statInterpolation = { 1, 1, }, actorLevel = 136.875, },
				[26] = { 29, 1308, statInterpolation = { 1, 1, }, actorLevel = 145.38800048828, },
				[27] = { 30, 1336, statInterpolation = { 1, 1, }, actorLevel = 154.12699890137, },
				[28] = { 30, 1364, statInterpolation = { 1, 1, }, actorLevel = 163.09199523926, },
				[29] = { 31, 1390, statInterpolation = { 1, 1, }, actorLevel = 172.28300476074, },
				[30] = { 32, 1416, statInterpolation = { 1, 1, }, actorLevel = 181.69999694824, },
				[31] = { 32, 1441, statInterpolation = { 1, 1, }, actorLevel = 191.34300231934, },
				[32] = { 33, 1465, statInterpolation = { 1, 1, }, actorLevel = 201.21200561523, },
				[33] = { 33, 1488, statInterpolation = { 1, 1, }, actorLevel = 211.30700683594, },
				[34] = { 33, 1511, statInterpolation = { 1, 1, }, actorLevel = 221.62800598145, },
				[35] = { 34, 1533, statInterpolation = { 1, 1, }, actorLevel = 232.17500305176, },
				[36] = { 34, 1555, statInterpolation = { 1, 1, }, actorLevel = 242.94799804688, },
				[37] = { 34, 1575, statInterpolation = { 1, 1, }, actorLevel = 253.94700622559, },
				[38] = { 35, 1596, statInterpolation = { 1, 1, }, actorLevel = 265.17199707031, },
				[39] = { 35, 1616, statInterpolation = { 1, 1, }, actorLevel = 276.62298583984, },
				[40] = { 35, 1635, statInterpolation = { 1, 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["ElementalExpressionTriggeredPlayer"] = {
	name = "Elemental Expression",
	baseTypeName = "Elemental Expression",
	fromTree = true,
	color = 4,
	description = "Create a fiery explosion, an arcing bolt of lightning, or an icy wave of projectiles. The chance for an explosion is proportional to your Strength, for a bolt proportional to your Dexterity, and for a wave proportional to your Intelligence.",
	skillTypes = { [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Spell] = true, [SkillType.Cooldown] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Lightning] = true, [SkillType.Cold] = true, [SkillType.Fire] = true, [SkillType.Projectile] = true, [SkillType.Area] = true, [SkillType.Chains] = true, },
	castTime = 0,
	qualityStats = {
		{ "base_cooldown_speed_+%", 1 },
	},
	levels = {
		[1] = { storedUses = 1, levelRequirement = 0, cooldown = 0.25, cost = { Mana = 3, }, },
		[2] = { storedUses = 1, levelRequirement = 3, cooldown = 0.25, cost = { Mana = 4, }, },
		[3] = { storedUses = 1, levelRequirement = 6, cooldown = 0.25, cost = { Mana = 5, }, },
		[4] = { storedUses = 1, levelRequirement = 10, cooldown = 0.25, cost = { Mana = 6, }, },
		[5] = { storedUses = 1, levelRequirement = 14, cooldown = 0.25, cost = { Mana = 7, }, },
		[6] = { storedUses = 1, levelRequirement = 18, cooldown = 0.25, cost = { Mana = 8, }, },
		[7] = { storedUses = 1, levelRequirement = 22, cooldown = 0.25, cost = { Mana = 9, }, },
		[8] = { storedUses = 1, levelRequirement = 26, cooldown = 0.25, cost = { Mana = 10, }, },
		[9] = { storedUses = 1, levelRequirement = 31, cooldown = 0.25, cost = { Mana = 12, }, },
		[10] = { storedUses = 1, levelRequirement = 36, cooldown = 0.25, cost = { Mana = 13, }, },
		[11] = { storedUses = 1, levelRequirement = 41, cooldown = 0.25, cost = { Mana = 15, }, },
		[12] = { storedUses = 1, levelRequirement = 46, cooldown = 0.25, cost = { Mana = 17, }, },
		[13] = { storedUses = 1, levelRequirement = 52, cooldown = 0.25, cost = { Mana = 19, }, },
		[14] = { storedUses = 1, levelRequirement = 58, cooldown = 0.25, cost = { Mana = 21, }, },
		[15] = { storedUses = 1, levelRequirement = 64, cooldown = 0.25, cost = { Mana = 23, }, },
		[16] = { storedUses = 1, levelRequirement = 66, cooldown = 0.25, cost = { Mana = 26, }, },
		[17] = { storedUses = 1, levelRequirement = 72, cooldown = 0.25, cost = { Mana = 29, }, },
		[18] = { storedUses = 1, levelRequirement = 78, cooldown = 0.25, cost = { Mana = 32, }, },
		[19] = { storedUses = 1, levelRequirement = 84, cooldown = 0.25, cost = { Mana = 36, }, },
		[20] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 39, }, },
		[21] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 43, }, },
		[22] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 48, }, },
		[23] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 53, }, },
		[24] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 58, }, },
		[25] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 64, }, },
		[26] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 70, }, },
		[27] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 77, }, },
		[28] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 84, }, },
		[29] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 92, }, },
		[30] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 101, }, },
		[31] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 110, }, },
		[32] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 120, }, },
		[33] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 131, }, },
		[34] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 143, }, },
		[35] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 156, }, },
		[36] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 170, }, },
		[37] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 186, }, },
		[38] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 202, }, },
		[39] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 220, }, },
		[40] = { storedUses = 1, levelRequirement = 90, cooldown = 0.25, cost = { Mana = 239, }, },
	},
	statSets = {
		[1] = {
			label = "Elemental Expression",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "elemental_strike_trigger_statset_0",
			baseFlags = {
			},
			constantStats = {
				{ "chance_to_be_trigger_elemental_expression_%", 100 },
			},
			stats = {
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
		[2] = {
			label = "Fiery Explosion",
			baseEffectiveness = 2.625,
			incrementalEffectiveness = 0.12999999523163,
			damageIncrementalEffectiveness = 0.0082000000402331,
			statDescriptionScope = "elemental_strike_trigger_statset_1",
			baseFlags = {
				spell = true,
				area = true,
			},
			constantStats = {
				{ "chance_to_be_trigger_elemental_expression_%", 100 },
				{ "active_skill_base_area_of_effect_radius", 36 },
			},
			stats = {
				"spell_minimum_base_fire_damage",
				"spell_maximum_base_fire_damage",
				"is_area_damage",
			},
			notMinionStat = {
				"spell_minimum_base_fire_damage",
				"spell_maximum_base_fire_damage",
			},
			levels = {
				[1] = { 8, 12, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 1, },
				[2] = { 11, 16, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 3.4519999027252, },
				[3] = { 15, 22, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 6.7670001983643, },
				[4] = { 19, 29, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 10.307999610901, },
				[5] = { 25, 37, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 14.074999809265, },
				[6] = { 30, 45, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 18.068000793457, },
				[7] = { 37, 55, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 22.287000656128, },
				[8] = { 44, 66, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 26.732000350952, },
				[9] = { 52, 78, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 31.40299987793, },
				[10] = { 61, 91, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 36.299999237061, },
				[11] = { 71, 106, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 41.423000335693, },
				[12] = { 82, 124, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 46.771999359131, },
				[13] = { 95, 143, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 52.34700012207, },
				[14] = { 110, 165, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 58.147998809814, },
				[15] = { 126, 189, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 64.175003051758, },
				[16] = { 144, 216, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 70.428001403809, },
				[17] = { 165, 247, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 76.906997680664, },
				[18] = { 188, 282, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 83.611999511719, },
				[19] = { 214, 321, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 90.542999267578, },
				[20] = { 244, 366, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 97.699996948242, },
				[21] = { 277, 416, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 105.08300018311, },
				[22] = { 315, 473, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 112.69200134277, },
				[23] = { 358, 537, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 120.52700042725, },
				[24] = { 407, 610, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 128.58799743652, },
				[25] = { 462, 693, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 136.875, },
				[26] = { 525, 787, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 145.38800048828, },
				[27] = { 596, 894, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 154.12699890137, },
				[28] = { 677, 1015, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 163.09199523926, },
				[29] = { 769, 1153, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 172.28300476074, },
				[30] = { 874, 1311, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 181.69999694824, },
				[31] = { 994, 1491, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 191.34300231934, },
				[32] = { 1131, 1697, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 201.21200561523, },
				[33] = { 1288, 1932, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 211.30700683594, },
				[34] = { 1468, 2201, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 221.62800598145, },
				[35] = { 1674, 2510, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 232.17500305176, },
				[36] = { 1910, 2865, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 242.94799804688, },
				[37] = { 2181, 3272, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 253.94700622559, },
				[38] = { 2494, 3741, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 265.17199707031, },
				[39] = { 2854, 4280, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 276.62298583984, },
				[40] = { 3269, 4903, critChance = 7, statInterpolation = { 1, 1, }, actorLevel = 288.29998779297, },
			},
		},
		[3] = {
			label = "Icy Wave",
			baseEffectiveness = 2.1524999141693,
			incrementalEffectiveness = 0.12999999523163,
			damageIncrementalEffectiveness = 0.0082000000402331,
			statDescriptionScope = "elemental_strike_trigger_statset_2",
			baseFlags = {
				spell = true,
				projectile = true,
			},
			constantStats = {
				{ "chance_to_be_trigger_elemental_expression_%", 100 },
				{ "base_number_of_projectiles", 3 },
				{ "fixed_projectile_height", 15 },
			},
			stats = {
				"spell_minimum_base_cold_damage",
				"spell_maximum_base_cold_damage",
				"always_pierce",
				"show_number_of_projectiles",
				"base_is_projectile",
			},
			notMinionStat = {
				"spell_minimum_base_cold_damage",
				"spell_maximum_base_cold_damage",
			},
			levels = {
				[1] = { 7, 10, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 1, },
				[2] = { 9, 14, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 3.4519999027252, },
				[3] = { 12, 18, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 6.7670001983643, },
				[4] = { 16, 24, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 10.307999610901, },
				[5] = { 20, 30, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 14.074999809265, },
				[6] = { 25, 37, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 18.068000793457, },
				[7] = { 30, 45, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 22.287000656128, },
				[8] = { 36, 54, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 26.732000350952, },
				[9] = { 42, 64, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 31.40299987793, },
				[10] = { 50, 75, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 36.299999237061, },
				[11] = { 58, 87, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 41.423000335693, },
				[12] = { 68, 101, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 46.771999359131, },
				[13] = { 78, 117, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 52.34700012207, },
				[14] = { 90, 135, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 58.147998809814, },
				[15] = { 103, 155, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 64.175003051758, },
				[16] = { 118, 177, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 70.428001403809, },
				[17] = { 135, 203, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 76.906997680664, },
				[18] = { 154, 231, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 83.611999511719, },
				[19] = { 176, 264, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 90.542999267578, },
				[20] = { 200, 300, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 97.699996948242, },
				[21] = { 227, 341, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 105.08300018311, },
				[22] = { 259, 388, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 112.69200134277, },
				[23] = { 294, 441, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 120.52700042725, },
				[24] = { 334, 500, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 128.58799743652, },
				[25] = { 379, 568, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 136.875, },
				[26] = { 430, 645, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 145.38800048828, },
				[27] = { 488, 733, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 154.12699890137, },
				[28] = { 555, 832, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 163.09199523926, },
				[29] = { 630, 946, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 172.28300476074, },
				[30] = { 717, 1075, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 181.69999694824, },
				[31] = { 815, 1223, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 191.34300231934, },
				[32] = { 928, 1391, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 201.21200561523, },
				[33] = { 1056, 1584, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 211.30700683594, },
				[34] = { 1203, 1805, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 221.62800598145, },
				[35] = { 1372, 2058, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 232.17500305176, },
				[36] = { 1566, 2349, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 242.94799804688, },
				[37] = { 1789, 2683, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 253.94700622559, },
				[38] = { 2045, 3067, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 265.17199707031, },
				[39] = { 2340, 3510, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 276.62298583984, },
				[40] = { 2680, 4020, critChance = 12, statInterpolation = { 1, 1, }, actorLevel = 288.29998779297, },
			},
		},
		[4] = {
			label = "Arcing Bolt",
			baseEffectiveness = 2.414999961853,
			incrementalEffectiveness = 0.12999999523163,
			damageIncrementalEffectiveness = 0.0082000000402331,
			statDescriptionScope = "elemental_strike_trigger_statset_3",
			baseFlags = {
				spell = true,
				chaining = true,
			},
			constantStats = {
				{ "chance_to_be_trigger_elemental_expression_%", 100 },
				{ "number_of_chains", 7 },
			},
			stats = {
				"spell_minimum_base_lightning_damage",
				"spell_maximum_base_lightning_damage",
			},
			notMinionStat = {
				"spell_minimum_base_lightning_damage",
				"spell_maximum_base_lightning_damage",
			},
			levels = {
				[1] = { 3, 16, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 1, },
				[2] = { 4, 21, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 3.4519999027252, },
				[3] = { 5, 29, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 6.7670001983643, },
				[4] = { 7, 38, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 10.307999610901, },
				[5] = { 8, 48, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 14.074999809265, },
				[6] = { 10, 59, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 18.068000793457, },
				[7] = { 13, 72, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 22.287000656128, },
				[8] = { 15, 86, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 26.732000350952, },
				[9] = { 18, 101, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 31.40299987793, },
				[10] = { 21, 119, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 36.299999237061, },
				[11] = { 24, 139, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 41.423000335693, },
				[12] = { 28, 161, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 46.771999359131, },
				[13] = { 33, 186, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 52.34700012207, },
				[14] = { 38, 214, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 58.147998809814, },
				[15] = { 43, 246, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 64.175003051758, },
				[16] = { 50, 282, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 70.428001403809, },
				[17] = { 57, 322, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 76.906997680664, },
				[18] = { 65, 368, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 83.611999511719, },
				[19] = { 74, 419, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 90.542999267578, },
				[20] = { 84, 477, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 97.699996948242, },
				[21] = { 96, 542, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 105.08300018311, },
				[22] = { 109, 616, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 112.69200134277, },
				[23] = { 124, 700, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 120.52700042725, },
				[24] = { 140, 795, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 128.58799743652, },
				[25] = { 159, 903, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 136.875, },
				[26] = { 181, 1025, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 145.38800048828, },
				[27] = { 206, 1165, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 154.12699890137, },
				[28] = { 233, 1323, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 163.09199523926, },
				[29] = { 265, 1503, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 172.28300476074, },
				[30] = { 302, 1709, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 181.69999694824, },
				[31] = { 343, 1943, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 191.34300231934, },
				[32] = { 390, 2211, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 201.21200561523, },
				[33] = { 444, 2518, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 211.30700683594, },
				[34] = { 506, 2869, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 221.62800598145, },
				[35] = { 577, 3272, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 232.17500305176, },
				[36] = { 659, 3734, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 242.94799804688, },
				[37] = { 753, 4265, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 253.94700622559, },
				[38] = { 860, 4875, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 265.17199707031, },
				[39] = { 985, 5579, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 276.62298583984, },
				[40] = { 1128, 6390, critChance = 9, statInterpolation = { 1, 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["ElementalStormPlayer"] = {
	name = "Elemental Storm",
	baseTypeName = "Elemental Storm",
	fromTree = true,
	color = 4,
	description = "Create a stationary Fire, Cold or Lightning storm at a target location for a duration, based on the highest Elemental Damage type for the Hit that Triggered the storm. Hits which do not deal Elemental Damage will not Trigger the storm.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Orb] = true, [SkillType.AreaSpell] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Cooldown] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.NoAttackInPlace] = true, },
	castTime = 0,
	qualityStats = {
		{ "base_cooldown_speed_+%", 0.5 },
	},
	levels = {
		[1] = { storedUses = 1, levelRequirement = 0, cooldown = 3, cost = { Mana = 8, }, },
		[2] = { storedUses = 1, levelRequirement = 3, cooldown = 3, cost = { Mana = 9, }, },
		[3] = { storedUses = 1, levelRequirement = 6, cooldown = 3, cost = { Mana = 10, }, },
		[4] = { storedUses = 1, levelRequirement = 10, cooldown = 3, cost = { Mana = 12, }, },
		[5] = { storedUses = 1, levelRequirement = 14, cooldown = 3, cost = { Mana = 13, }, },
		[6] = { storedUses = 1, levelRequirement = 18, cooldown = 3, cost = { Mana = 15, }, },
		[7] = { storedUses = 1, levelRequirement = 22, cooldown = 3, cost = { Mana = 17, }, },
		[8] = { storedUses = 1, levelRequirement = 26, cooldown = 3, cost = { Mana = 19, }, },
		[9] = { storedUses = 1, levelRequirement = 31, cooldown = 3, cost = { Mana = 21, }, },
		[10] = { storedUses = 1, levelRequirement = 36, cooldown = 3, cost = { Mana = 23, }, },
		[11] = { storedUses = 1, levelRequirement = 41, cooldown = 3, cost = { Mana = 26, }, },
		[12] = { storedUses = 1, levelRequirement = 46, cooldown = 3, cost = { Mana = 28, }, },
		[13] = { storedUses = 1, levelRequirement = 52, cooldown = 3, cost = { Mana = 31, }, },
		[14] = { storedUses = 1, levelRequirement = 58, cooldown = 3, cost = { Mana = 34, }, },
		[15] = { storedUses = 1, levelRequirement = 64, cooldown = 3, cost = { Mana = 37, }, },
		[16] = { storedUses = 1, levelRequirement = 66, cooldown = 3, cost = { Mana = 40, }, },
		[17] = { storedUses = 1, levelRequirement = 72, cooldown = 3, cost = { Mana = 43, }, },
		[18] = { storedUses = 1, levelRequirement = 78, cooldown = 3, cost = { Mana = 47, }, },
		[19] = { storedUses = 1, levelRequirement = 84, cooldown = 3, cost = { Mana = 51, }, },
		[20] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 55, }, },
		[21] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 60, }, },
		[22] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 64, }, },
		[23] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 69, }, },
		[24] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 74, }, },
		[25] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 80, }, },
		[26] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 86, }, },
		[27] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 92, }, },
		[28] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 99, }, },
		[29] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 106, }, },
		[30] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 113, }, },
		[31] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 121, }, },
		[32] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 130, }, },
		[33] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 138, }, },
		[34] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 148, }, },
		[35] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 158, }, },
		[36] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 168, }, },
		[37] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 179, }, },
		[38] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 191, }, },
		[39] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 203, }, },
		[40] = { storedUses = 1, levelRequirement = 90, cooldown = 3, cost = { Mana = 216, }, },
	},
	statSets = {
		[1] = {
			label = "Elemental Storm",
			baseEffectiveness = 0.5625,
			incrementalEffectiveness = 0.12999999523163,
			damageIncrementalEffectiveness = 0.0096000004559755,
			statDescriptionScope = "tornado_triggered",
			statMap = {
				["tornado_base_damage_interval_ms"] = {
					skill("hitTimeOverride", nil),
					div = 1000,
				},
			},
			baseFlags = {
				area = true,
				duration = true,
			},
			constantStats = {
				{ "tornado_base_damage_interval_ms", 250 },
				{ "number_of_tornados_allowed", 50 },
				{ "skill_override_pvp_scaling_time_ms", 1000 },
				{ "base_skill_effect_duration", 5000 },
				{ "active_skill_base_area_of_effect_radius", 18 },
			},
			stats = {
				"skill_can_add_multiple_charges_per_action",
				"damage_cannot_be_reflected_or_leech_if_used_by_other_object",
				"is_area_damage",
				"tornado_hinder",
				"is_triggerable_elemental_storm",
				"global_cannot_crit",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
		[2] = {
			label = "Fire",
			baseEffectiveness = 0.55000001192093,
			incrementalEffectiveness = 0.12999999523163,
			damageIncrementalEffectiveness = 0.0096000004559755,
			statDescriptionScope = "tornado_triggered",
			statMap = {
				["tornado_base_damage_interval_ms"] = {
					skill("hitTimeOverride", nil),
					div = 1000,
				},
			},
			baseFlags = {
				spell = true,
				area = true,
				duration = true,
			},
			constantStats = {
				{ "tornado_base_damage_interval_ms", 250 },
				{ "number_of_tornados_allowed", 50 },
				{ "skill_override_pvp_scaling_time_ms", 1000 },
				{ "base_skill_effect_duration", 5000 },
				{ "active_skill_base_area_of_effect_radius", 18 },
			},
			stats = {
				"spell_minimum_base_fire_damage",
				"spell_maximum_base_fire_damage",
				"skill_can_add_multiple_charges_per_action",
				"damage_cannot_be_reflected_or_leech_if_used_by_other_object",
				"is_area_damage",
				"tornado_hinder",
				"is_triggerable_elemental_storm",
				"global_cannot_crit",
			},
			notMinionStat = {
				"spell_minimum_base_fire_damage",
				"spell_maximum_base_fire_damage",
			},
			levels = {
				[1] = { 2, 3, statInterpolation = { 1, 1, }, actorLevel = 1, },
				[2] = { 2, 3, statInterpolation = { 1, 1, }, actorLevel = 3.4519999027252, },
				[3] = { 3, 5, statInterpolation = { 1, 1, }, actorLevel = 6.7670001983643, },
				[4] = { 4, 6, statInterpolation = { 1, 1, }, actorLevel = 10.307999610901, },
				[5] = { 5, 8, statInterpolation = { 1, 1, }, actorLevel = 14.074999809265, },
				[6] = { 6, 10, statInterpolation = { 1, 1, }, actorLevel = 18.068000793457, },
				[7] = { 8, 12, statInterpolation = { 1, 1, }, actorLevel = 22.287000656128, },
				[8] = { 9, 14, statInterpolation = { 1, 1, }, actorLevel = 26.732000350952, },
				[9] = { 11, 17, statInterpolation = { 1, 1, }, actorLevel = 31.40299987793, },
				[10] = { 13, 20, statInterpolation = { 1, 1, }, actorLevel = 36.299999237061, },
				[11] = { 16, 24, statInterpolation = { 1, 1, }, actorLevel = 41.423000335693, },
				[12] = { 18, 28, statInterpolation = { 1, 1, }, actorLevel = 46.771999359131, },
				[13] = { 21, 32, statInterpolation = { 1, 1, }, actorLevel = 52.34700012207, },
				[14] = { 25, 37, statInterpolation = { 1, 1, }, actorLevel = 58.147998809814, },
				[15] = { 29, 43, statInterpolation = { 1, 1, }, actorLevel = 64.175003051758, },
				[16] = { 33, 50, statInterpolation = { 1, 1, }, actorLevel = 70.428001403809, },
				[17] = { 38, 58, statInterpolation = { 1, 1, }, actorLevel = 76.906997680664, },
				[18] = { 44, 66, statInterpolation = { 1, 1, }, actorLevel = 83.611999511719, },
				[19] = { 51, 76, statInterpolation = { 1, 1, }, actorLevel = 90.542999267578, },
				[20] = { 58, 88, statInterpolation = { 1, 1, }, actorLevel = 97.699996948242, },
				[21] = { 67, 101, statInterpolation = { 1, 1, }, actorLevel = 105.08300018311, },
				[22] = { 77, 116, statInterpolation = { 1, 1, }, actorLevel = 112.69200134277, },
				[23] = { 89, 133, statInterpolation = { 1, 1, }, actorLevel = 120.52700042725, },
				[24] = { 102, 153, statInterpolation = { 1, 1, }, actorLevel = 128.58799743652, },
				[25] = { 117, 175, statInterpolation = { 1, 1, }, actorLevel = 136.875, },
				[26] = { 134, 201, statInterpolation = { 1, 1, }, actorLevel = 145.38800048828, },
				[27] = { 154, 232, statInterpolation = { 1, 1, }, actorLevel = 154.12699890137, },
				[28] = { 178, 266, statInterpolation = { 1, 1, }, actorLevel = 163.09199523926, },
				[29] = { 204, 306, statInterpolation = { 1, 1, }, actorLevel = 172.28300476074, },
				[30] = { 235, 353, statInterpolation = { 1, 1, }, actorLevel = 181.69999694824, },
				[31] = { 271, 407, statInterpolation = { 1, 1, }, actorLevel = 191.34300231934, },
				[32] = { 313, 469, statInterpolation = { 1, 1, }, actorLevel = 201.21200561523, },
				[33] = { 361, 542, statInterpolation = { 1, 1, }, actorLevel = 211.30700683594, },
				[34] = { 418, 626, statInterpolation = { 1, 1, }, actorLevel = 221.62800598145, },
				[35] = { 483, 725, statInterpolation = { 1, 1, }, actorLevel = 232.17500305176, },
				[36] = { 560, 840, statInterpolation = { 1, 1, }, actorLevel = 242.94799804688, },
				[37] = { 649, 974, statInterpolation = { 1, 1, }, actorLevel = 253.94700622559, },
				[38] = { 754, 1131, statInterpolation = { 1, 1, }, actorLevel = 265.17199707031, },
				[39] = { 876, 1315, statInterpolation = { 1, 1, }, actorLevel = 276.62298583984, },
				[40] = { 1020, 1530, statInterpolation = { 1, 1, }, actorLevel = 288.29998779297, },
			},
		},
		[3] = {
			label = "Lightning",
			baseEffectiveness = 0.41999998688698,
			incrementalEffectiveness = 0.12999999523163,
			damageIncrementalEffectiveness = 0.0096000004559755,
			statDescriptionScope = "tornado_triggered",
			statMap = {
				["tornado_base_damage_interval_ms"] = {
					skill("hitTimeOverride", nil),
					div = 1000,
				},
			},
			baseFlags = {
				spell = true,
				area = true,
				duration = true,
			},
			constantStats = {
				{ "tornado_base_damage_interval_ms", 250 },
				{ "number_of_tornados_allowed", 50 },
				{ "skill_override_pvp_scaling_time_ms", 1000 },
				{ "base_skill_effect_duration", 5000 },
				{ "active_skill_base_area_of_effect_radius", 18 },
			},
			stats = {
				"spell_minimum_base_lightning_damage",
				"spell_maximum_base_lightning_damage",
				"skill_can_add_multiple_charges_per_action",
				"damage_cannot_be_reflected_or_leech_if_used_by_other_object",
				"is_area_damage",
				"tornado_hinder",
				"is_triggerable_elemental_storm",
				"global_cannot_crit",
			},
			notMinionStat = {
				"spell_minimum_base_lightning_damage",
				"spell_maximum_base_lightning_damage",
			},
			levels = {
				[1] = { 1, 3, statInterpolation = { 1, 1, }, actorLevel = 1, },
				[2] = { 1, 4, statInterpolation = { 1, 1, }, actorLevel = 3.4519999027252, },
				[3] = { 1, 5, statInterpolation = { 1, 1, }, actorLevel = 6.7670001983643, },
				[4] = { 1, 7, statInterpolation = { 1, 1, }, actorLevel = 10.307999610901, },
				[5] = { 1, 8, statInterpolation = { 1, 1, }, actorLevel = 14.074999809265, },
				[6] = { 2, 11, statInterpolation = { 1, 1, }, actorLevel = 18.068000793457, },
				[7] = { 2, 13, statInterpolation = { 1, 1, }, actorLevel = 22.287000656128, },
				[8] = { 3, 15, statInterpolation = { 1, 1, }, actorLevel = 26.732000350952, },
				[9] = { 3, 18, statInterpolation = { 1, 1, }, actorLevel = 31.40299987793, },
				[10] = { 4, 22, statInterpolation = { 1, 1, }, actorLevel = 36.299999237061, },
				[11] = { 5, 26, statInterpolation = { 1, 1, }, actorLevel = 41.423000335693, },
				[12] = { 5, 30, statInterpolation = { 1, 1, }, actorLevel = 46.771999359131, },
				[13] = { 6, 35, statInterpolation = { 1, 1, }, actorLevel = 52.34700012207, },
				[14] = { 7, 40, statInterpolation = { 1, 1, }, actorLevel = 58.147998809814, },
				[15] = { 8, 47, statInterpolation = { 1, 1, }, actorLevel = 64.175003051758, },
				[16] = { 10, 54, statInterpolation = { 1, 1, }, actorLevel = 70.428001403809, },
				[17] = { 11, 62, statInterpolation = { 1, 1, }, actorLevel = 76.906997680664, },
				[18] = { 13, 72, statInterpolation = { 1, 1, }, actorLevel = 83.611999511719, },
				[19] = { 15, 82, statInterpolation = { 1, 1, }, actorLevel = 90.542999267578, },
				[20] = { 17, 95, statInterpolation = { 1, 1, }, actorLevel = 97.699996948242, },
				[21] = { 19, 109, statInterpolation = { 1, 1, }, actorLevel = 105.08300018311, },
				[22] = { 22, 125, statInterpolation = { 1, 1, }, actorLevel = 112.69200134277, },
				[23] = { 25, 144, statInterpolation = { 1, 1, }, actorLevel = 120.52700042725, },
				[24] = { 29, 165, statInterpolation = { 1, 1, }, actorLevel = 128.58799743652, },
				[25] = { 33, 190, statInterpolation = { 1, 1, }, actorLevel = 136.875, },
				[26] = { 38, 218, statInterpolation = { 1, 1, }, actorLevel = 145.38800048828, },
				[27] = { 44, 250, statInterpolation = { 1, 1, }, actorLevel = 154.12699890137, },
				[28] = { 51, 288, statInterpolation = { 1, 1, }, actorLevel = 163.09199523926, },
				[29] = { 59, 332, statInterpolation = { 1, 1, }, actorLevel = 172.28300476074, },
				[30] = { 67, 382, statInterpolation = { 1, 1, }, actorLevel = 181.69999694824, },
				[31] = { 78, 440, statInterpolation = { 1, 1, }, actorLevel = 191.34300231934, },
				[32] = { 90, 508, statInterpolation = { 1, 1, }, actorLevel = 201.21200561523, },
				[33] = { 103, 586, statInterpolation = { 1, 1, }, actorLevel = 211.30700683594, },
				[34] = { 120, 678, statInterpolation = { 1, 1, }, actorLevel = 221.62800598145, },
				[35] = { 138, 784, statInterpolation = { 1, 1, }, actorLevel = 232.17500305176, },
				[36] = { 160, 908, statInterpolation = { 1, 1, }, actorLevel = 242.94799804688, },
				[37] = { 186, 1054, statInterpolation = { 1, 1, }, actorLevel = 253.94700622559, },
				[38] = { 216, 1223, statInterpolation = { 1, 1, }, actorLevel = 265.17199707031, },
				[39] = { 251, 1422, statInterpolation = { 1, 1, }, actorLevel = 276.62298583984, },
				[40] = { 292, 1656, statInterpolation = { 1, 1, }, actorLevel = 288.29998779297, },
			},
		},
		[4] = {
			label = "Cold",
			baseEffectiveness = 0.41999998688698,
			incrementalEffectiveness = 0.12999999523163,
			damageIncrementalEffectiveness = 0.0096000004559755,
			statDescriptionScope = "tornado_triggered",
			statMap = {
				["tornado_base_damage_interval_ms"] = {
					skill("hitTimeOverride", nil),
					div = 1000,
				},
			},
			baseFlags = {
				spell = true,
				area = true,
				duration = true,
			},
			constantStats = {
				{ "tornado_base_damage_interval_ms", 250 },
				{ "number_of_tornados_allowed", 50 },
				{ "skill_override_pvp_scaling_time_ms", 1000 },
				{ "base_skill_effect_duration", 5000 },
				{ "active_skill_base_area_of_effect_radius", 18 },
			},
			stats = {
				"spell_minimum_base_cold_damage",
				"spell_maximum_base_cold_damage",
				"skill_can_add_multiple_charges_per_action",
				"damage_cannot_be_reflected_or_leech_if_used_by_other_object",
				"is_area_damage",
				"tornado_hinder",
				"is_triggerable_elemental_storm",
				"global_cannot_crit",
			},
			notMinionStat = {
				"spell_minimum_base_cold_damage",
				"spell_maximum_base_cold_damage",
			},
			levels = {
				[1] = { 1, 2, statInterpolation = { 1, 1, }, actorLevel = 1, },
				[2] = { 2, 3, statInterpolation = { 1, 1, }, actorLevel = 3.4519999027252, },
				[3] = { 2, 4, statInterpolation = { 1, 1, }, actorLevel = 6.7670001983643, },
				[4] = { 3, 5, statInterpolation = { 1, 1, }, actorLevel = 10.307999610901, },
				[5] = { 4, 6, statInterpolation = { 1, 1, }, actorLevel = 14.074999809265, },
				[6] = { 5, 7, statInterpolation = { 1, 1, }, actorLevel = 18.068000793457, },
				[7] = { 6, 9, statInterpolation = { 1, 1, }, actorLevel = 22.287000656128, },
				[8] = { 7, 11, statInterpolation = { 1, 1, }, actorLevel = 26.732000350952, },
				[9] = { 9, 13, statInterpolation = { 1, 1, }, actorLevel = 31.40299987793, },
				[10] = { 10, 15, statInterpolation = { 1, 1, }, actorLevel = 36.299999237061, },
				[11] = { 12, 18, statInterpolation = { 1, 1, }, actorLevel = 41.423000335693, },
				[12] = { 14, 21, statInterpolation = { 1, 1, }, actorLevel = 46.771999359131, },
				[13] = { 16, 25, statInterpolation = { 1, 1, }, actorLevel = 52.34700012207, },
				[14] = { 19, 28, statInterpolation = { 1, 1, }, actorLevel = 58.147998809814, },
				[15] = { 22, 33, statInterpolation = { 1, 1, }, actorLevel = 64.175003051758, },
				[16] = { 25, 38, statInterpolation = { 1, 1, }, actorLevel = 70.428001403809, },
				[17] = { 29, 44, statInterpolation = { 1, 1, }, actorLevel = 76.906997680664, },
				[18] = { 34, 51, statInterpolation = { 1, 1, }, actorLevel = 83.611999511719, },
				[19] = { 39, 58, statInterpolation = { 1, 1, }, actorLevel = 90.542999267578, },
				[20] = { 45, 67, statInterpolation = { 1, 1, }, actorLevel = 97.699996948242, },
				[21] = { 51, 77, statInterpolation = { 1, 1, }, actorLevel = 105.08300018311, },
				[22] = { 59, 88, statInterpolation = { 1, 1, }, actorLevel = 112.69200134277, },
				[23] = { 68, 101, statInterpolation = { 1, 1, }, actorLevel = 120.52700042725, },
				[24] = { 78, 117, statInterpolation = { 1, 1, }, actorLevel = 128.58799743652, },
				[25] = { 89, 134, statInterpolation = { 1, 1, }, actorLevel = 136.875, },
				[26] = { 103, 154, statInterpolation = { 1, 1, }, actorLevel = 145.38800048828, },
				[27] = { 118, 177, statInterpolation = { 1, 1, }, actorLevel = 154.12699890137, },
				[28] = { 136, 203, statInterpolation = { 1, 1, }, actorLevel = 163.09199523926, },
				[29] = { 156, 234, statInterpolation = { 1, 1, }, actorLevel = 172.28300476074, },
				[30] = { 180, 270, statInterpolation = { 1, 1, }, actorLevel = 181.69999694824, },
				[31] = { 207, 311, statInterpolation = { 1, 1, }, actorLevel = 191.34300231934, },
				[32] = { 239, 358, statInterpolation = { 1, 1, }, actorLevel = 201.21200561523, },
				[33] = { 276, 414, statInterpolation = { 1, 1, }, actorLevel = 211.30700683594, },
				[34] = { 319, 478, statInterpolation = { 1, 1, }, actorLevel = 221.62800598145, },
				[35] = { 369, 554, statInterpolation = { 1, 1, }, actorLevel = 232.17500305176, },
				[36] = { 428, 641, statInterpolation = { 1, 1, }, actorLevel = 242.94799804688, },
				[37] = { 496, 744, statInterpolation = { 1, 1, }, actorLevel = 253.94700622559, },
				[38] = { 576, 864, statInterpolation = { 1, 1, }, actorLevel = 265.17199707031, },
				[39] = { 669, 1004, statInterpolation = { 1, 1, }, actorLevel = 276.62298583984, },
				[40] = { 779, 1169, statInterpolation = { 1, 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["AmazonTriggerElementalSurgePlayer"] = {
	name = "Elemental Surge",
	baseTypeName = "Elemental Surge",
	fromTree = true,
	color = 4,
	description = "Grants your weapon Surges. Non-Melee Projectile Attacks with that weapon Consume Surges to cause the Projectiles fired to explode at the end of their flight.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.Triggered] = true, [SkillType.Triggerable] = true, [SkillType.NoAttackOrCastTime] = true, [SkillType.CannotConsumeCharges] = true, },
	castTime = 1,
	qualityStats = {
		{ "active_skill_base_area_of_effect_radius", 0.15 },
	},
	levels = {
		[1] = { baseMultiplier = 0.5, levelRequirement = 0, },
		[2] = { baseMultiplier = 0.55, levelRequirement = 3, },
		[3] = { baseMultiplier = 0.61, levelRequirement = 6, },
		[4] = { baseMultiplier = 0.66, levelRequirement = 10, },
		[5] = { baseMultiplier = 0.72, levelRequirement = 14, },
		[6] = { baseMultiplier = 0.77, levelRequirement = 18, },
		[7] = { baseMultiplier = 0.83, levelRequirement = 22, },
		[8] = { baseMultiplier = 0.88, levelRequirement = 26, },
		[9] = { baseMultiplier = 0.93, levelRequirement = 31, },
		[10] = { baseMultiplier = 0.99, levelRequirement = 36, },
		[11] = { baseMultiplier = 1.05, levelRequirement = 41, },
		[12] = { baseMultiplier = 1.11, levelRequirement = 46, },
		[13] = { baseMultiplier = 1.17, levelRequirement = 52, },
		[14] = { baseMultiplier = 1.25, levelRequirement = 58, },
		[15] = { baseMultiplier = 1.32, levelRequirement = 64, },
		[16] = { baseMultiplier = 1.41, levelRequirement = 66, },
		[17] = { baseMultiplier = 1.5, levelRequirement = 72, },
		[18] = { baseMultiplier = 1.59, levelRequirement = 78, },
		[19] = { baseMultiplier = 1.7, levelRequirement = 84, },
		[20] = { baseMultiplier = 1.81, levelRequirement = 90, },
		[21] = { baseMultiplier = 1.93, levelRequirement = 90, },
		[22] = { baseMultiplier = 2.06, levelRequirement = 90, },
		[23] = { baseMultiplier = 2.2, levelRequirement = 90, },
		[24] = { baseMultiplier = 2.34, levelRequirement = 90, },
		[25] = { baseMultiplier = 2.5, levelRequirement = 90, },
		[26] = { baseMultiplier = 2.67, levelRequirement = 90, },
		[27] = { baseMultiplier = 2.84, levelRequirement = 90, },
		[28] = { baseMultiplier = 3.03, levelRequirement = 90, },
		[29] = { baseMultiplier = 3.24, levelRequirement = 90, },
		[30] = { baseMultiplier = 3.45, levelRequirement = 90, },
		[31] = { baseMultiplier = 3.68, levelRequirement = 90, },
		[32] = { baseMultiplier = 3.93, levelRequirement = 90, },
		[33] = { baseMultiplier = 4.19, levelRequirement = 90, },
		[34] = { baseMultiplier = 4.47, levelRequirement = 90, },
		[35] = { baseMultiplier = 4.76, levelRequirement = 90, },
		[36] = { baseMultiplier = 5.08, levelRequirement = 90, },
		[37] = { baseMultiplier = 5.42, levelRequirement = 90, },
		[38] = { baseMultiplier = 5.78, levelRequirement = 90, },
		[39] = { baseMultiplier = 6.17, levelRequirement = 90, },
		[40] = { baseMultiplier = 6.58, levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Cold Surge",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "trigger_elemental_infusion",
			baseFlags = {
				attack = true,
				area = true,
			},
			constantStats = {
				{ "chance_to_be_triggered_by_amazon_infusion_%", 100 },
				{ "active_skill_base_area_of_effect_radius", 18 },
				{ "active_skill_base_physical_damage_%_to_convert_to_cold", 100 },
				{ "base_skill_effect_duration", 15000 },
				{ "maximum_number_of_instilling_stacks", 6 },
			},
			stats = {
				"is_area_damage",
				"cannot_consume_power_frenzy_endurance_charges",
				"base_skill_show_average_damage_instead_of_dps",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
		[2] = {
			label = "Fire Surge",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "trigger_elemental_infusion",
			baseFlags = {
				attack = true,
				area = true,
			},
			constantStats = {
				{ "chance_to_be_triggered_by_amazon_infusion_%", 100 },
				{ "active_skill_base_area_of_effect_radius", 18 },
				{ "base_skill_effect_duration", 15000 },
				{ "maximum_number_of_instilling_stacks", 6 },
				{ "active_skill_base_physical_damage_%_to_convert_to_fire", 100 },
			},
			stats = {
				"is_area_damage",
				"cannot_consume_power_frenzy_endurance_charges",
				"base_skill_show_average_damage_instead_of_dps",
			},
			levels = {
				[1] = { baseMultiplier = 0.5, actorLevel = 1, },
				[2] = { baseMultiplier = 0.55, actorLevel = 3.4519999027252, },
				[3] = { baseMultiplier = 0.61, actorLevel = 6.7670001983643, },
				[4] = { baseMultiplier = 0.66, actorLevel = 10.307999610901, },
				[5] = { baseMultiplier = 0.72, actorLevel = 14.074999809265, },
				[6] = { baseMultiplier = 0.77, actorLevel = 18.068000793457, },
				[7] = { baseMultiplier = 0.83, actorLevel = 22.287000656128, },
				[8] = { baseMultiplier = 0.88, actorLevel = 26.732000350952, },
				[9] = { baseMultiplier = 0.93, actorLevel = 31.40299987793, },
				[10] = { baseMultiplier = 0.99, actorLevel = 36.299999237061, },
				[11] = { baseMultiplier = 1.05, actorLevel = 41.423000335693, },
				[12] = { baseMultiplier = 1.11, actorLevel = 46.771999359131, },
				[13] = { baseMultiplier = 1.17, actorLevel = 52.34700012207, },
				[14] = { baseMultiplier = 1.25, actorLevel = 58.147998809814, },
				[15] = { baseMultiplier = 1.32, actorLevel = 64.175003051758, },
				[16] = { baseMultiplier = 1.41, actorLevel = 70.428001403809, },
				[17] = { baseMultiplier = 1.5, actorLevel = 76.906997680664, },
				[18] = { baseMultiplier = 1.59, actorLevel = 83.611999511719, },
				[19] = { baseMultiplier = 1.7, actorLevel = 90.542999267578, },
				[20] = { baseMultiplier = 1.81, actorLevel = 97.699996948242, },
				[21] = { baseMultiplier = 1.93, actorLevel = 105.08300018311, },
				[22] = { baseMultiplier = 2.06, actorLevel = 112.69200134277, },
				[23] = { baseMultiplier = 2.2, actorLevel = 120.52700042725, },
				[24] = { baseMultiplier = 2.34, actorLevel = 128.58799743652, },
				[25] = { baseMultiplier = 2.5, actorLevel = 136.875, },
				[26] = { baseMultiplier = 2.67, actorLevel = 145.38800048828, },
				[27] = { baseMultiplier = 2.84, actorLevel = 154.12699890137, },
				[28] = { baseMultiplier = 3.03, actorLevel = 163.09199523926, },
				[29] = { baseMultiplier = 3.24, actorLevel = 172.28300476074, },
				[30] = { baseMultiplier = 3.45, actorLevel = 181.69999694824, },
				[31] = { baseMultiplier = 3.68, actorLevel = 191.34300231934, },
				[32] = { baseMultiplier = 3.93, actorLevel = 201.21200561523, },
				[33] = { baseMultiplier = 4.19, actorLevel = 211.30700683594, },
				[34] = { baseMultiplier = 4.47, actorLevel = 221.62800598145, },
				[35] = { baseMultiplier = 4.76, actorLevel = 232.17500305176, },
				[36] = { baseMultiplier = 5.08, actorLevel = 242.94799804688, },
				[37] = { baseMultiplier = 5.42, actorLevel = 253.94700622559, },
				[38] = { baseMultiplier = 5.78, actorLevel = 265.17199707031, },
				[39] = { baseMultiplier = 6.17, actorLevel = 276.62298583984, },
				[40] = { baseMultiplier = 6.58, actorLevel = 288.29998779297, },
			},
		},
		[3] = {
			label = "Lightning Surge",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "trigger_elemental_infusion",
			baseFlags = {
				attack = true,
				area = true,
			},
			constantStats = {
				{ "chance_to_be_triggered_by_amazon_infusion_%", 100 },
				{ "active_skill_base_area_of_effect_radius", 18 },
				{ "base_skill_effect_duration", 15000 },
				{ "maximum_number_of_instilling_stacks", 6 },
				{ "active_skill_base_physical_damage_%_to_convert_to_lightning", 100 },
			},
			stats = {
				"is_area_damage",
				"cannot_consume_power_frenzy_endurance_charges",
				"base_skill_show_average_damage_instead_of_dps",
			},
			levels = {
				[1] = { baseMultiplier = 0.5, actorLevel = 1, },
				[2] = { baseMultiplier = 0.55, actorLevel = 3.4519999027252, },
				[3] = { baseMultiplier = 0.61, actorLevel = 6.7670001983643, },
				[4] = { baseMultiplier = 0.66, actorLevel = 10.307999610901, },
				[5] = { baseMultiplier = 0.72, actorLevel = 14.074999809265, },
				[6] = { baseMultiplier = 0.77, actorLevel = 18.068000793457, },
				[7] = { baseMultiplier = 0.83, actorLevel = 22.287000656128, },
				[8] = { baseMultiplier = 0.88, actorLevel = 26.732000350952, },
				[9] = { baseMultiplier = 0.93, actorLevel = 31.40299987793, },
				[10] = { baseMultiplier = 0.99, actorLevel = 36.299999237061, },
				[11] = { baseMultiplier = 1.05, actorLevel = 41.423000335693, },
				[12] = { baseMultiplier = 1.11, actorLevel = 46.771999359131, },
				[13] = { baseMultiplier = 1.17, actorLevel = 52.34700012207, },
				[14] = { baseMultiplier = 1.25, actorLevel = 58.147998809814, },
				[15] = { baseMultiplier = 1.32, actorLevel = 64.175003051758, },
				[16] = { baseMultiplier = 1.41, actorLevel = 70.428001403809, },
				[17] = { baseMultiplier = 1.5, actorLevel = 76.906997680664, },
				[18] = { baseMultiplier = 1.59, actorLevel = 83.611999511719, },
				[19] = { baseMultiplier = 1.7, actorLevel = 90.542999267578, },
				[20] = { baseMultiplier = 1.81, actorLevel = 97.699996948242, },
				[21] = { baseMultiplier = 1.93, actorLevel = 105.08300018311, },
				[22] = { baseMultiplier = 2.06, actorLevel = 112.69200134277, },
				[23] = { baseMultiplier = 2.2, actorLevel = 120.52700042725, },
				[24] = { baseMultiplier = 2.34, actorLevel = 128.58799743652, },
				[25] = { baseMultiplier = 2.5, actorLevel = 136.875, },
				[26] = { baseMultiplier = 2.67, actorLevel = 145.38800048828, },
				[27] = { baseMultiplier = 2.84, actorLevel = 154.12699890137, },
				[28] = { baseMultiplier = 3.03, actorLevel = 163.09199523926, },
				[29] = { baseMultiplier = 3.24, actorLevel = 172.28300476074, },
				[30] = { baseMultiplier = 3.45, actorLevel = 181.69999694824, },
				[31] = { baseMultiplier = 3.68, actorLevel = 191.34300231934, },
				[32] = { baseMultiplier = 3.93, actorLevel = 201.21200561523, },
				[33] = { baseMultiplier = 4.19, actorLevel = 211.30700683594, },
				[34] = { baseMultiplier = 4.47, actorLevel = 221.62800598145, },
				[35] = { baseMultiplier = 4.76, actorLevel = 232.17500305176, },
				[36] = { baseMultiplier = 5.08, actorLevel = 242.94799804688, },
				[37] = { baseMultiplier = 5.42, actorLevel = 253.94700622559, },
				[38] = { baseMultiplier = 5.78, actorLevel = 265.17199707031, },
				[39] = { baseMultiplier = 6.17, actorLevel = 276.62298583984, },
				[40] = { baseMultiplier = 6.58, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["EncaseInJadePlayer"] = {
	name = "Encase in Jade",
	baseTypeName = "Encase in Jade",
	fromTree = true,
	color = 4,
	description = "Consume all stacks of Jade to grant Guard based off your maximum Life for each Jade consumed. You cannot gain Jade stacks while you have Guard.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Guard] = true, [SkillType.Duration] = true, [SkillType.Physical] = true, [SkillType.NoAttackInPlace] = true, },
	castTime = 0.3,
	qualityStats = {
		{ "maximum_life_%_damage_absorbed_per_jade_consumed", 0.05 },
	},
	levels = {
		[1] = { levelRequirement = 0, cost = { Mana = 15, }, },
		[2] = { levelRequirement = 3, cost = { Mana = 15, }, },
		[3] = { levelRequirement = 6, cost = { Mana = 15, }, },
		[4] = { levelRequirement = 10, cost = { Mana = 15, }, },
		[5] = { levelRequirement = 14, cost = { Mana = 15, }, },
		[6] = { levelRequirement = 18, cost = { Mana = 15, }, },
		[7] = { levelRequirement = 22, cost = { Mana = 15, }, },
		[8] = { levelRequirement = 26, cost = { Mana = 15, }, },
		[9] = { levelRequirement = 31, cost = { Mana = 15, }, },
		[10] = { levelRequirement = 36, cost = { Mana = 15, }, },
		[11] = { levelRequirement = 41, cost = { Mana = 15, }, },
		[12] = { levelRequirement = 46, cost = { Mana = 15, }, },
		[13] = { levelRequirement = 52, cost = { Mana = 15, }, },
		[14] = { levelRequirement = 58, cost = { Mana = 15, }, },
		[15] = { levelRequirement = 64, cost = { Mana = 15, }, },
		[16] = { levelRequirement = 66, cost = { Mana = 15, }, },
		[17] = { levelRequirement = 72, cost = { Mana = 15, }, },
		[18] = { levelRequirement = 78, cost = { Mana = 15, }, },
		[19] = { levelRequirement = 84, cost = { Mana = 15, }, },
		[20] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[21] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[22] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[23] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[24] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[25] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[26] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[27] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[28] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[29] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[30] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[31] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[32] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[33] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[34] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[35] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[36] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[37] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[38] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[39] = { levelRequirement = 90, cost = { Mana = 15, }, },
		[40] = { levelRequirement = 90, cost = { Mana = 15, }, },
	},
	statSets = {
		[1] = {
			label = "Encase in Jade",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "encase_in_jade",
			baseFlags = {
				duration = true,
			},
			constantStats = {
				{ "maximum_life_%_damage_absorbed_per_jade_consumed", 6 },
			},
			stats = {
				"base_skill_effect_duration",
				"base_deal_no_damage",
			},
			notMinionStat = {
				"base_skill_effect_duration",
			},
			levels = {
				[1] = { 4000, statInterpolation = { 1, }, actorLevel = 1, },
				[2] = { 4050, statInterpolation = { 1, }, actorLevel = 3.4519999027252, },
				[3] = { 4100, statInterpolation = { 1, }, actorLevel = 6.7670001983643, },
				[4] = { 4150, statInterpolation = { 1, }, actorLevel = 10.307999610901, },
				[5] = { 4200, statInterpolation = { 1, }, actorLevel = 14.074999809265, },
				[6] = { 4250, statInterpolation = { 1, }, actorLevel = 18.068000793457, },
				[7] = { 4300, statInterpolation = { 1, }, actorLevel = 22.287000656128, },
				[8] = { 4350, statInterpolation = { 1, }, actorLevel = 26.732000350952, },
				[9] = { 4400, statInterpolation = { 1, }, actorLevel = 31.40299987793, },
				[10] = { 4450, statInterpolation = { 1, }, actorLevel = 36.299999237061, },
				[11] = { 4500, statInterpolation = { 1, }, actorLevel = 41.423000335693, },
				[12] = { 4550, statInterpolation = { 1, }, actorLevel = 46.771999359131, },
				[13] = { 4600, statInterpolation = { 1, }, actorLevel = 52.34700012207, },
				[14] = { 4650, statInterpolation = { 1, }, actorLevel = 58.147998809814, },
				[15] = { 4700, statInterpolation = { 1, }, actorLevel = 64.175003051758, },
				[16] = { 4750, statInterpolation = { 1, }, actorLevel = 70.428001403809, },
				[17] = { 4800, statInterpolation = { 1, }, actorLevel = 76.906997680664, },
				[18] = { 4850, statInterpolation = { 1, }, actorLevel = 83.611999511719, },
				[19] = { 4900, statInterpolation = { 1, }, actorLevel = 90.542999267578, },
				[20] = { 4950, statInterpolation = { 1, }, actorLevel = 97.699996948242, },
				[21] = { 5000, statInterpolation = { 1, }, actorLevel = 105.08300018311, },
				[22] = { 5050, statInterpolation = { 1, }, actorLevel = 112.69200134277, },
				[23] = { 5100, statInterpolation = { 1, }, actorLevel = 120.52700042725, },
				[24] = { 5150, statInterpolation = { 1, }, actorLevel = 128.58799743652, },
				[25] = { 5200, statInterpolation = { 1, }, actorLevel = 136.875, },
				[26] = { 5250, statInterpolation = { 1, }, actorLevel = 145.38800048828, },
				[27] = { 5300, statInterpolation = { 1, }, actorLevel = 154.12699890137, },
				[28] = { 5350, statInterpolation = { 1, }, actorLevel = 163.09199523926, },
				[29] = { 5400, statInterpolation = { 1, }, actorLevel = 172.28300476074, },
				[30] = { 5450, statInterpolation = { 1, }, actorLevel = 181.69999694824, },
				[31] = { 5475, statInterpolation = { 1, }, actorLevel = 191.34300231934, },
				[32] = { 5500, statInterpolation = { 1, }, actorLevel = 201.21200561523, },
				[33] = { 5525, statInterpolation = { 1, }, actorLevel = 211.30700683594, },
				[34] = { 5550, statInterpolation = { 1, }, actorLevel = 221.62800598145, },
				[35] = { 5575, statInterpolation = { 1, }, actorLevel = 232.17500305176, },
				[36] = { 5600, statInterpolation = { 1, }, actorLevel = 242.94799804688, },
				[37] = { 5625, statInterpolation = { 1, }, actorLevel = 253.94700622559, },
				[38] = { 5650, statInterpolation = { 1, }, actorLevel = 265.17199707031, },
				[39] = { 5675, statInterpolation = { 1, }, actorLevel = 276.62298583984, },
				[40] = { 5700, statInterpolation = { 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["ExplosiveConcoctionPlayer"] = {
	name = "Explosive Concoction",
	baseTypeName = "Explosive Concoction",
	fromTree = true,
	color = 4,
	description = "Consume charges from your Mana Flask to throw a flask that explodes, dealing Fire Attack damage in an area. Additional smaller flasks are thrown at nearby Ignited Enemies.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.Fire] = true, [SkillType.UsableWhileMoving] = true, [SkillType.ProjectileNoCollision] = true, [SkillType.NoAttackInPlace] = true, [SkillType.GroundTargetedProjectile] = true, },
	weaponTypes = {
		["None"] = true,
	},
	castTime = 1,
	qualityStats = {
		{ "explosive_concoction_number_of_secondary_projectiles", 0.1 },
	},
	levels = {
		[1] = { critChance = 5, baseMultiplier = 0.7, levelRequirement = 0, cost = { Mana = 0, }, },
		[2] = { critChance = 5, baseMultiplier = 0.77, levelRequirement = 3, cost = { Mana = 0, }, },
		[3] = { critChance = 5, baseMultiplier = 0.84, levelRequirement = 6, cost = { Mana = 0, }, },
		[4] = { critChance = 5, baseMultiplier = 0.92, levelRequirement = 10, cost = { Mana = 0, }, },
		[5] = { critChance = 5, baseMultiplier = 0.99, levelRequirement = 14, cost = { Mana = 0, }, },
		[6] = { critChance = 5, baseMultiplier = 1.05, levelRequirement = 18, cost = { Mana = 0, }, },
		[7] = { critChance = 5, baseMultiplier = 1.12, levelRequirement = 22, cost = { Mana = 0, }, },
		[8] = { critChance = 5, baseMultiplier = 1.18, levelRequirement = 26, cost = { Mana = 0, }, },
		[9] = { critChance = 5, baseMultiplier = 1.23, levelRequirement = 31, cost = { Mana = 0, }, },
		[10] = { critChance = 5, baseMultiplier = 1.28, levelRequirement = 36, cost = { Mana = 0, }, },
		[11] = { critChance = 5, baseMultiplier = 1.34, levelRequirement = 41, cost = { Mana = 0, }, },
		[12] = { critChance = 5, baseMultiplier = 1.39, levelRequirement = 46, cost = { Mana = 0, }, },
		[13] = { critChance = 5, baseMultiplier = 1.44, levelRequirement = 52, cost = { Mana = 0, }, },
		[14] = { critChance = 5, baseMultiplier = 1.5, levelRequirement = 58, cost = { Mana = 0, }, },
		[15] = { critChance = 5, baseMultiplier = 1.55, levelRequirement = 64, cost = { Mana = 0, }, },
		[16] = { critChance = 5, baseMultiplier = 1.61, levelRequirement = 66, cost = { Mana = 0, }, },
		[17] = { critChance = 5, baseMultiplier = 1.67, levelRequirement = 72, cost = { Mana = 0, }, },
		[18] = { critChance = 5, baseMultiplier = 1.73, levelRequirement = 78, cost = { Mana = 0, }, },
		[19] = { critChance = 5, baseMultiplier = 1.79, levelRequirement = 84, cost = { Mana = 0, }, },
		[20] = { critChance = 5, baseMultiplier = 1.85, levelRequirement = 90, cost = { Mana = 0, }, },
		[21] = { critChance = 5, baseMultiplier = 1.91, levelRequirement = 90, cost = { Mana = 0, }, },
		[22] = { critChance = 5, baseMultiplier = 1.97, levelRequirement = 90, cost = { Mana = 0, }, },
		[23] = { critChance = 5, baseMultiplier = 2.04, levelRequirement = 90, cost = { Mana = 0, }, },
		[24] = { critChance = 5, baseMultiplier = 2.1, levelRequirement = 90, cost = { Mana = 0, }, },
		[25] = { critChance = 5, baseMultiplier = 2.17, levelRequirement = 90, cost = { Mana = 0, }, },
		[26] = { critChance = 5, baseMultiplier = 2.24, levelRequirement = 90, cost = { Mana = 0, }, },
		[27] = { critChance = 5, baseMultiplier = 2.32, levelRequirement = 90, cost = { Mana = 0, }, },
		[28] = { critChance = 5, baseMultiplier = 2.4, levelRequirement = 90, cost = { Mana = 0, }, },
		[29] = { critChance = 5, baseMultiplier = 2.48, levelRequirement = 90, cost = { Mana = 0, }, },
		[30] = { critChance = 5, baseMultiplier = 2.56, levelRequirement = 90, cost = { Mana = 0, }, },
		[31] = { critChance = 5, baseMultiplier = 2.64, levelRequirement = 90, cost = { Mana = 0, }, },
		[32] = { critChance = 5, baseMultiplier = 2.73, levelRequirement = 90, cost = { Mana = 0, }, },
		[33] = { critChance = 5, baseMultiplier = 2.82, levelRequirement = 90, cost = { Mana = 0, }, },
		[34] = { critChance = 5, baseMultiplier = 2.91, levelRequirement = 90, cost = { Mana = 0, }, },
		[35] = { critChance = 5, baseMultiplier = 3.01, levelRequirement = 90, cost = { Mana = 0, }, },
		[36] = { critChance = 5, baseMultiplier = 3.11, levelRequirement = 90, cost = { Mana = 0, }, },
		[37] = { critChance = 5, baseMultiplier = 3.21, levelRequirement = 90, cost = { Mana = 0, }, },
		[38] = { critChance = 5, baseMultiplier = 3.32, levelRequirement = 90, cost = { Mana = 0, }, },
		[39] = { critChance = 5, baseMultiplier = 3.43, levelRequirement = 90, cost = { Mana = 0, }, },
		[40] = { critChance = 5, baseMultiplier = 3.55, levelRequirement = 90, cost = { Mana = 0, }, },
	},
	statSets = {
		[1] = {
			label = "Flask",
			baseEffectiveness = 4.5,
			incrementalEffectiveness = 0.27349999547005,
			statDescriptionScope = "explosive_concoction",
			statMap = {
				["flask_throw_fire_exposure_ms"] = {
					mod("FireExposureChance", "BASE", nil),
					value = 100,
				},
			},
			baseFlags = {
				attack = true,
				projectile = true,
				duration = true,
				unarmed = true,
				area = true,
			},
			constantStats = {
				{ "flask_throw_base_charges_used", 5 },
				{ "base_number_of_projectiles", 1 },
				{ "active_skill_base_area_of_effect_radius", 18 },
				{ "movement_speed_+%_final_while_performing_action", -70 },
				{ "movement_speed_acceleration_+%_per_second_while_performing_action", 160 },
				{ "movement_speed_while_performing_action_locked_duration_%", 50 },
				{ "main_hand_base_weapon_attack_duration_ms", 714 },
				{ "active_skill_ignite_chance_+%_final", 100 },
			},
			stats = {
				"main_hand_weapon_minimum_fire_damage",
				"main_hand_weapon_maximum_fire_damage",
				"base_is_projectile",
				"projectile_behaviour_only_explode",
				"can_perform_skill_while_moving",
				"replace_main_hand_unarmed_attack_stats_with_nothing_type",
				"is_area_damage",
			},
			levels = {
				[1] = { 14, 21, statInterpolation = { 1, 1, }, actorLevel = 1, },
				[2] = { 23, 35, statInterpolation = { 1, 1, }, actorLevel = 3.4519999027252, },
				[3] = { 36, 54, statInterpolation = { 1, 1, }, actorLevel = 6.7670001983643, },
				[4] = { 50, 74, statInterpolation = { 1, 1, }, actorLevel = 10.307999610901, },
				[5] = { 64, 96, statInterpolation = { 1, 1, }, actorLevel = 14.074999809265, },
				[6] = { 79, 119, statInterpolation = { 1, 1, }, actorLevel = 18.068000793457, },
				[7] = { 95, 143, statInterpolation = { 1, 1, }, actorLevel = 22.287000656128, },
				[8] = { 112, 169, statInterpolation = { 1, 1, }, actorLevel = 26.732000350952, },
				[9] = { 130, 195, statInterpolation = { 1, 1, }, actorLevel = 31.40299987793, },
				[10] = { 149, 224, statInterpolation = { 1, 1, }, actorLevel = 36.299999237061, },
				[11] = { 169, 253, statInterpolation = { 1, 1, }, actorLevel = 41.423000335693, },
				[12] = { 189, 284, statInterpolation = { 1, 1, }, actorLevel = 46.771999359131, },
				[13] = { 210, 316, statInterpolation = { 1, 1, }, actorLevel = 52.34700012207, },
				[14] = { 233, 349, statInterpolation = { 1, 1, }, actorLevel = 58.147998809814, },
				[15] = { 256, 383, statInterpolation = { 1, 1, }, actorLevel = 64.175003051758, },
				[16] = { 280, 419, statInterpolation = { 1, 1, }, actorLevel = 70.428001403809, },
				[17] = { 304, 457, statInterpolation = { 1, 1, }, actorLevel = 76.906997680664, },
				[18] = { 330, 495, statInterpolation = { 1, 1, }, actorLevel = 83.611999511719, },
				[19] = { 357, 535, statInterpolation = { 1, 1, }, actorLevel = 90.542999267578, },
				[20] = { 384, 576, statInterpolation = { 1, 1, }, actorLevel = 97.699996948242, },
				[21] = { 412, 618, statInterpolation = { 1, 1, }, actorLevel = 105.08300018311, },
				[22] = { 441, 662, statInterpolation = { 1, 1, }, actorLevel = 112.69200134277, },
				[23] = { 471, 707, statInterpolation = { 1, 1, }, actorLevel = 120.52700042725, },
				[24] = { 502, 753, statInterpolation = { 1, 1, }, actorLevel = 128.58799743652, },
				[25] = { 534, 801, statInterpolation = { 1, 1, }, actorLevel = 136.875, },
				[26] = { 566, 849, statInterpolation = { 1, 1, }, actorLevel = 145.38800048828, },
				[27] = { 600, 900, statInterpolation = { 1, 1, }, actorLevel = 154.12699890137, },
				[28] = { 634, 951, statInterpolation = { 1, 1, }, actorLevel = 163.09199523926, },
				[29] = { 669, 1004, statInterpolation = { 1, 1, }, actorLevel = 172.28300476074, },
				[30] = { 705, 1058, statInterpolation = { 1, 1, }, actorLevel = 181.69999694824, },
				[31] = { 742, 1113, statInterpolation = { 1, 1, }, actorLevel = 191.34300231934, },
				[32] = { 780, 1170, statInterpolation = { 1, 1, }, actorLevel = 201.21200561523, },
				[33] = { 818, 1228, statInterpolation = { 1, 1, }, actorLevel = 211.30700683594, },
				[34] = { 858, 1287, statInterpolation = { 1, 1, }, actorLevel = 221.62800598145, },
				[35] = { 898, 1347, statInterpolation = { 1, 1, }, actorLevel = 232.17500305176, },
				[36] = { 940, 1409, statInterpolation = { 1, 1, }, actorLevel = 242.94799804688, },
				[37] = { 982, 1472, statInterpolation = { 1, 1, }, actorLevel = 253.94700622559, },
				[38] = { 1025, 1537, statInterpolation = { 1, 1, }, actorLevel = 265.17199707031, },
				[39] = { 1068, 1603, statInterpolation = { 1, 1, }, actorLevel = 276.62298583984, },
				[40] = { 1113, 1670, statInterpolation = { 1, 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["MetaCastFireSpellOnHitPlayer"] = {
	name = "Fire Spell on Melee Hit",
	baseTypeName = "Fire Spell on Melee Hit",
	fromTree = true,
	color = 4,
	description = "While active, gains Energy when you Hit enemies with Melee Attacks and triggers socketed Fire spells on reaching maximum Energy.",
	skillTypes = { [SkillType.HasReservation] = true, [SkillType.OngoingSkill] = true, [SkillType.Meta] = true, [SkillType.Persistent] = true, [SkillType.Buff] = true, [SkillType.Fire] = true, [SkillType.CanHaveMultipleOngoingSkillInstances] = true, [SkillType.GeneratesEnergy] = true, [SkillType.Triggers] = true, },
	castTime = 0,
	qualityStats = {
		{ "energy_generated_+%", 0.75 },
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 3, },
		[3] = { levelRequirement = 6, },
		[4] = { levelRequirement = 10, },
		[5] = { levelRequirement = 14, },
		[6] = { levelRequirement = 18, },
		[7] = { levelRequirement = 22, },
		[8] = { levelRequirement = 26, },
		[9] = { levelRequirement = 31, },
		[10] = { levelRequirement = 36, },
		[11] = { levelRequirement = 41, },
		[12] = { levelRequirement = 46, },
		[13] = { levelRequirement = 52, },
		[14] = { levelRequirement = 58, },
		[15] = { levelRequirement = 64, },
		[16] = { levelRequirement = 66, },
		[17] = { levelRequirement = 72, },
		[18] = { levelRequirement = 78, },
		[19] = { levelRequirement = 84, },
		[20] = { levelRequirement = 90, },
		[21] = { levelRequirement = 90, },
		[22] = { levelRequirement = 90, },
		[23] = { levelRequirement = 90, },
		[24] = { levelRequirement = 90, },
		[25] = { levelRequirement = 90, },
		[26] = { levelRequirement = 90, },
		[27] = { levelRequirement = 90, },
		[28] = { levelRequirement = 90, },
		[29] = { levelRequirement = 90, },
		[30] = { levelRequirement = 90, },
		[31] = { levelRequirement = 90, },
		[32] = { levelRequirement = 90, },
		[33] = { levelRequirement = 90, },
		[34] = { levelRequirement = 90, },
		[35] = { levelRequirement = 90, },
		[36] = { levelRequirement = 90, },
		[37] = { levelRequirement = 90, },
		[38] = { levelRequirement = 90, },
		[39] = { levelRequirement = 90, },
		[40] = { levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Fire Spell on Melee Hit",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "cast_fire_spell_on_hit",
			baseFlags = {
			},
			constantStats = {
				{ "cast_fire_spell_on_hit_gain_X_centienergy_per_monster_power_on_hit", 300 },
				{ "skill_desired_amount_override", 1 },
			},
			stats = {
				"energy_generated_+%",
				"generic_ongoing_trigger_triggers_at_maximum_energy",
				"generic_ongoing_trigger_maximum_energy_is_total_of_socketed_skills",
				"base_deal_no_damage",
			},
			levels = {
				[1] = { 0, statInterpolation = { 1, }, actorLevel = 1, },
				[2] = { 3, statInterpolation = { 1, }, actorLevel = 3.4519999027252, },
				[3] = { 6, statInterpolation = { 1, }, actorLevel = 6.7670001983643, },
				[4] = { 9, statInterpolation = { 1, }, actorLevel = 10.307999610901, },
				[5] = { 12, statInterpolation = { 1, }, actorLevel = 14.074999809265, },
				[6] = { 15, statInterpolation = { 1, }, actorLevel = 18.068000793457, },
				[7] = { 18, statInterpolation = { 1, }, actorLevel = 22.287000656128, },
				[8] = { 21, statInterpolation = { 1, }, actorLevel = 26.732000350952, },
				[9] = { 24, statInterpolation = { 1, }, actorLevel = 31.40299987793, },
				[10] = { 27, statInterpolation = { 1, }, actorLevel = 36.299999237061, },
				[11] = { 30, statInterpolation = { 1, }, actorLevel = 41.423000335693, },
				[12] = { 33, statInterpolation = { 1, }, actorLevel = 46.771999359131, },
				[13] = { 36, statInterpolation = { 1, }, actorLevel = 52.34700012207, },
				[14] = { 39, statInterpolation = { 1, }, actorLevel = 58.147998809814, },
				[15] = { 42, statInterpolation = { 1, }, actorLevel = 64.175003051758, },
				[16] = { 45, statInterpolation = { 1, }, actorLevel = 70.428001403809, },
				[17] = { 48, statInterpolation = { 1, }, actorLevel = 76.906997680664, },
				[18] = { 51, statInterpolation = { 1, }, actorLevel = 83.611999511719, },
				[19] = { 54, statInterpolation = { 1, }, actorLevel = 90.542999267578, },
				[20] = { 57, statInterpolation = { 1, }, actorLevel = 97.699996948242, },
				[21] = { 60, statInterpolation = { 1, }, actorLevel = 105.08300018311, },
				[22] = { 63, statInterpolation = { 1, }, actorLevel = 112.69200134277, },
				[23] = { 66, statInterpolation = { 1, }, actorLevel = 120.52700042725, },
				[24] = { 69, statInterpolation = { 1, }, actorLevel = 128.58799743652, },
				[25] = { 72, statInterpolation = { 1, }, actorLevel = 136.875, },
				[26] = { 75, statInterpolation = { 1, }, actorLevel = 145.38800048828, },
				[27] = { 78, statInterpolation = { 1, }, actorLevel = 154.12699890137, },
				[28] = { 81, statInterpolation = { 1, }, actorLevel = 163.09199523926, },
				[29] = { 84, statInterpolation = { 1, }, actorLevel = 172.28300476074, },
				[30] = { 87, statInterpolation = { 1, }, actorLevel = 181.69999694824, },
				[31] = { 90, statInterpolation = { 1, }, actorLevel = 191.34300231934, },
				[32] = { 93, statInterpolation = { 1, }, actorLevel = 201.21200561523, },
				[33] = { 96, statInterpolation = { 1, }, actorLevel = 211.30700683594, },
				[34] = { 99, statInterpolation = { 1, }, actorLevel = 221.62800598145, },
				[35] = { 102, statInterpolation = { 1, }, actorLevel = 232.17500305176, },
				[36] = { 105, statInterpolation = { 1, }, actorLevel = 242.94799804688, },
				[37] = { 108, statInterpolation = { 1, }, actorLevel = 253.94700622559, },
				[38] = { 111, statInterpolation = { 1, }, actorLevel = 265.17199707031, },
				[39] = { 114, statInterpolation = { 1, }, actorLevel = 276.62298583984, },
				[40] = { 117, statInterpolation = { 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["SupportMetaCastFireSpellOnHitPlayer"] = {
	name = "SupportMetaCastFireSpellOnHitPlayer",
	hidden = true,
	fromTree = true,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.Fire, SkillType.AND, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.SupportedByHourglass, },
	isTrigger = true,
	qualityStats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 0, },
		[3] = { levelRequirement = 0, },
		[4] = { levelRequirement = 0, },
		[5] = { levelRequirement = 0, },
		[6] = { levelRequirement = 0, },
		[7] = { levelRequirement = 0, },
		[8] = { levelRequirement = 0, },
		[9] = { levelRequirement = 0, },
		[10] = { levelRequirement = 0, },
		[11] = { levelRequirement = 0, },
		[12] = { levelRequirement = 0, },
		[13] = { levelRequirement = 0, },
		[14] = { levelRequirement = 0, },
		[15] = { levelRequirement = 0, },
		[16] = { levelRequirement = 0, },
		[17] = { levelRequirement = 0, },
		[18] = { levelRequirement = 0, },
		[19] = { levelRequirement = 0, },
		[20] = { levelRequirement = 0, },
		[21] = { levelRequirement = 0, },
		[22] = { levelRequirement = 0, },
		[23] = { levelRequirement = 0, },
		[24] = { levelRequirement = 0, },
		[25] = { levelRequirement = 0, },
		[26] = { levelRequirement = 0, },
		[27] = { levelRequirement = 0, },
		[28] = { levelRequirement = 0, },
		[29] = { levelRequirement = 0, },
		[30] = { levelRequirement = 0, },
		[31] = { levelRequirement = 0, },
		[32] = { levelRequirement = 0, },
		[33] = { levelRequirement = 0, },
		[34] = { levelRequirement = 0, },
		[35] = { levelRequirement = 0, },
		[36] = { levelRequirement = 0, },
		[37] = { levelRequirement = 0, },
		[38] = { levelRequirement = 0, },
		[39] = { levelRequirement = 0, },
		[40] = { levelRequirement = 0, },
	},
	statSets = {
		[1] = {
			label = "SupportMetaCastFireSpellOnHitPlayer",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "meta_gem_stat_descriptions",
			baseFlags = {
			},
			constantStats = {
				{ "generic_ongoing_trigger_1_maximum_energy_per_Xms_total_cast_time", 10 },
			},
			stats = {
				"triggered_by_generic_ongoing_trigger",
				"generic_ongoing_trigger_triggers_at_maximum_energy",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["FulminatingConcoctionPlayer"] = {
	name = "Fulminating Concoction",
	baseTypeName = "Fulminating Concoction",
	fromTree = true,
	color = 4,
	description = "Consume charges from your Mana Flask to throw a flask that explodes, dealing Lightning Attack damage in an area with high chance to Shock.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.Lightning] = true, [SkillType.UsableWhileMoving] = true, [SkillType.ProjectileNoCollision] = true, [SkillType.NoAttackInPlace] = true, [SkillType.GroundTargetedProjectile] = true, },
	weaponTypes = {
		["None"] = true,
	},
	castTime = 1,
	qualityStats = {
		{ "active_skill_shock_chance_+%_final", 2 },
	},
	levels = {
		[1] = { critChance = 8, baseMultiplier = 0.7, levelRequirement = 0, cost = { Mana = 0, }, },
		[2] = { critChance = 8, baseMultiplier = 0.77, levelRequirement = 3, cost = { Mana = 0, }, },
		[3] = { critChance = 8, baseMultiplier = 0.84, levelRequirement = 6, cost = { Mana = 0, }, },
		[4] = { critChance = 8, baseMultiplier = 0.92, levelRequirement = 10, cost = { Mana = 0, }, },
		[5] = { critChance = 8, baseMultiplier = 0.99, levelRequirement = 14, cost = { Mana = 0, }, },
		[6] = { critChance = 8, baseMultiplier = 1.05, levelRequirement = 18, cost = { Mana = 0, }, },
		[7] = { critChance = 8, baseMultiplier = 1.12, levelRequirement = 22, cost = { Mana = 0, }, },
		[8] = { critChance = 8, baseMultiplier = 1.18, levelRequirement = 26, cost = { Mana = 0, }, },
		[9] = { critChance = 8, baseMultiplier = 1.23, levelRequirement = 31, cost = { Mana = 0, }, },
		[10] = { critChance = 8, baseMultiplier = 1.28, levelRequirement = 36, cost = { Mana = 0, }, },
		[11] = { critChance = 8, baseMultiplier = 1.34, levelRequirement = 41, cost = { Mana = 0, }, },
		[12] = { critChance = 8, baseMultiplier = 1.39, levelRequirement = 46, cost = { Mana = 0, }, },
		[13] = { critChance = 8, baseMultiplier = 1.44, levelRequirement = 52, cost = { Mana = 0, }, },
		[14] = { critChance = 8, baseMultiplier = 1.5, levelRequirement = 58, cost = { Mana = 0, }, },
		[15] = { critChance = 8, baseMultiplier = 1.55, levelRequirement = 64, cost = { Mana = 0, }, },
		[16] = { critChance = 8, baseMultiplier = 1.61, levelRequirement = 66, cost = { Mana = 0, }, },
		[17] = { critChance = 8, baseMultiplier = 1.67, levelRequirement = 72, cost = { Mana = 0, }, },
		[18] = { critChance = 8, baseMultiplier = 1.73, levelRequirement = 78, cost = { Mana = 0, }, },
		[19] = { critChance = 8, baseMultiplier = 1.79, levelRequirement = 84, cost = { Mana = 0, }, },
		[20] = { critChance = 8, baseMultiplier = 1.85, levelRequirement = 90, cost = { Mana = 0, }, },
		[21] = { critChance = 8, baseMultiplier = 1.91, levelRequirement = 90, cost = { Mana = 0, }, },
		[22] = { critChance = 8, baseMultiplier = 1.97, levelRequirement = 90, cost = { Mana = 0, }, },
		[23] = { critChance = 8, baseMultiplier = 2.04, levelRequirement = 90, cost = { Mana = 0, }, },
		[24] = { critChance = 8, baseMultiplier = 2.1, levelRequirement = 90, cost = { Mana = 0, }, },
		[25] = { critChance = 8, baseMultiplier = 2.17, levelRequirement = 90, cost = { Mana = 0, }, },
		[26] = { critChance = 8, baseMultiplier = 2.24, levelRequirement = 90, cost = { Mana = 0, }, },
		[27] = { critChance = 8, baseMultiplier = 2.32, levelRequirement = 90, cost = { Mana = 0, }, },
		[28] = { critChance = 8, baseMultiplier = 2.4, levelRequirement = 90, cost = { Mana = 0, }, },
		[29] = { critChance = 8, baseMultiplier = 2.48, levelRequirement = 90, cost = { Mana = 0, }, },
		[30] = { critChance = 8, baseMultiplier = 2.56, levelRequirement = 90, cost = { Mana = 0, }, },
		[31] = { critChance = 8, baseMultiplier = 2.64, levelRequirement = 90, cost = { Mana = 0, }, },
		[32] = { critChance = 8, baseMultiplier = 2.73, levelRequirement = 90, cost = { Mana = 0, }, },
		[33] = { critChance = 8, baseMultiplier = 2.82, levelRequirement = 90, cost = { Mana = 0, }, },
		[34] = { critChance = 8, baseMultiplier = 2.91, levelRequirement = 90, cost = { Mana = 0, }, },
		[35] = { critChance = 8, baseMultiplier = 3.01, levelRequirement = 90, cost = { Mana = 0, }, },
		[36] = { critChance = 8, baseMultiplier = 3.11, levelRequirement = 90, cost = { Mana = 0, }, },
		[37] = { critChance = 8, baseMultiplier = 3.21, levelRequirement = 90, cost = { Mana = 0, }, },
		[38] = { critChance = 8, baseMultiplier = 3.32, levelRequirement = 90, cost = { Mana = 0, }, },
		[39] = { critChance = 8, baseMultiplier = 3.43, levelRequirement = 90, cost = { Mana = 0, }, },
		[40] = { critChance = 8, baseMultiplier = 3.55, levelRequirement = 90, cost = { Mana = 0, }, },
	},
	statSets = {
		[1] = {
			label = "Fulminating Concoction",
			baseEffectiveness = 4.1999998092651,
			incrementalEffectiveness = 0.27349999547005,
			statDescriptionScope = "fulminating_concoction",
			statMap = {
				["flask_throw_lightning_exposure_ms"] = {
					mod("LightningExposureChance", "BASE", nil),
					value = 100,
				},
			},
			baseFlags = {
				attack = true,
				projectile = true,
				duration = true,
				unarmed = true,
				area = true,
			},
			constantStats = {
				{ "flask_throw_base_charges_used", 5 },
				{ "base_number_of_projectiles", 1 },
				{ "active_skill_base_area_of_effect_radius", 18 },
				{ "throw_flask_effects_type", 2 },
				{ "movement_speed_+%_final_while_performing_action", -70 },
				{ "movement_speed_acceleration_+%_per_second_while_performing_action", 160 },
				{ "movement_speed_while_performing_action_locked_duration_%", 50 },
				{ "main_hand_base_weapon_attack_duration_ms", 714 },
				{ "active_skill_shock_chance_+%_final", 200 },
				{ "active_skill_shock_effect_+%_final", 50 },
			},
			stats = {
				"main_hand_weapon_minimum_lightning_damage",
				"main_hand_weapon_maximum_lightning_damage",
				"base_is_projectile",
				"projectile_behaviour_only_explode",
				"can_perform_skill_while_moving",
				"replace_main_hand_unarmed_attack_stats_with_nothing_type",
				"is_area_damage",
			},
			levels = {
				[1] = { 8, 24, statInterpolation = { 1, 1, }, actorLevel = 1, },
				[2] = { 14, 41, statInterpolation = { 1, 1, }, actorLevel = 3.4519999027252, },
				[3] = { 21, 63, statInterpolation = { 1, 1, }, actorLevel = 6.7670001983643, },
				[4] = { 29, 87, statInterpolation = { 1, 1, }, actorLevel = 10.307999610901, },
				[5] = { 37, 112, statInterpolation = { 1, 1, }, actorLevel = 14.074999809265, },
				[6] = { 46, 139, statInterpolation = { 1, 1, }, actorLevel = 18.068000793457, },
				[7] = { 56, 167, statInterpolation = { 1, 1, }, actorLevel = 22.287000656128, },
				[8] = { 66, 197, statInterpolation = { 1, 1, }, actorLevel = 26.732000350952, },
				[9] = { 76, 228, statInterpolation = { 1, 1, }, actorLevel = 31.40299987793, },
				[10] = { 87, 261, statInterpolation = { 1, 1, }, actorLevel = 36.299999237061, },
				[11] = { 98, 295, statInterpolation = { 1, 1, }, actorLevel = 41.423000335693, },
				[12] = { 110, 331, statInterpolation = { 1, 1, }, actorLevel = 46.771999359131, },
				[13] = { 123, 368, statInterpolation = { 1, 1, }, actorLevel = 52.34700012207, },
				[14] = { 136, 407, statInterpolation = { 1, 1, }, actorLevel = 58.147998809814, },
				[15] = { 149, 447, statInterpolation = { 1, 1, }, actorLevel = 64.175003051758, },
				[16] = { 163, 489, statInterpolation = { 1, 1, }, actorLevel = 70.428001403809, },
				[17] = { 178, 533, statInterpolation = { 1, 1, }, actorLevel = 76.906997680664, },
				[18] = { 193, 578, statInterpolation = { 1, 1, }, actorLevel = 83.611999511719, },
				[19] = { 208, 624, statInterpolation = { 1, 1, }, actorLevel = 90.542999267578, },
				[20] = { 224, 672, statInterpolation = { 1, 1, }, actorLevel = 97.699996948242, },
				[21] = { 240, 721, statInterpolation = { 1, 1, }, actorLevel = 105.08300018311, },
				[22] = { 257, 772, statInterpolation = { 1, 1, }, actorLevel = 112.69200134277, },
				[23] = { 275, 825, statInterpolation = { 1, 1, }, actorLevel = 120.52700042725, },
				[24] = { 293, 879, statInterpolation = { 1, 1, }, actorLevel = 128.58799743652, },
				[25] = { 311, 934, statInterpolation = { 1, 1, }, actorLevel = 136.875, },
				[26] = { 330, 991, statInterpolation = { 1, 1, }, actorLevel = 145.38800048828, },
				[27] = { 350, 1050, statInterpolation = { 1, 1, }, actorLevel = 154.12699890137, },
				[28] = { 370, 1110, statInterpolation = { 1, 1, }, actorLevel = 163.09199523926, },
				[29] = { 390, 1171, statInterpolation = { 1, 1, }, actorLevel = 172.28300476074, },
				[30] = { 411, 1234, statInterpolation = { 1, 1, }, actorLevel = 181.69999694824, },
				[31] = { 433, 1299, statInterpolation = { 1, 1, }, actorLevel = 191.34300231934, },
				[32] = { 455, 1365, statInterpolation = { 1, 1, }, actorLevel = 201.21200561523, },
				[33] = { 477, 1432, statInterpolation = { 1, 1, }, actorLevel = 211.30700683594, },
				[34] = { 500, 1501, statInterpolation = { 1, 1, }, actorLevel = 221.62800598145, },
				[35] = { 524, 1572, statInterpolation = { 1, 1, }, actorLevel = 232.17500305176, },
				[36] = { 548, 1644, statInterpolation = { 1, 1, }, actorLevel = 242.94799804688, },
				[37] = { 573, 1718, statInterpolation = { 1, 1, }, actorLevel = 253.94700622559, },
				[38] = { 598, 1793, statInterpolation = { 1, 1, }, actorLevel = 265.17199707031, },
				[39] = { 623, 1870, statInterpolation = { 1, 1, }, actorLevel = 276.62298583984, },
				[40] = { 649, 1948, statInterpolation = { 1, 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["FuturePastPlayer"] = {
	name = "Future-Past",
	baseTypeName = "Future-Past",
	fromItem = true,
	color = 4,
	description = "Hinekora observes your Future-Past granting you the opportunity to subvert a lesser fate. After a period of Hindsight, she will grant you her Foresight, which prevents you from avoiding Hits while Dodge Rolling. When you are Hit while Dodge Rolling, Hinekora restores you to full Life immediately before taking damage from the Hit, and grants you Sight Beyond Sight, which prevents you from dying.",
	skillTypes = { [SkillType.HasReservation] = true, [SkillType.OngoingSkill] = true, [SkillType.Persistent] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, },
	castTime = 0,
	qualityStats = {
		{ "base_secondary_skill_effect_duration", 15 },
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 3, },
		[3] = { levelRequirement = 6, },
		[4] = { levelRequirement = 10, },
		[5] = { levelRequirement = 14, },
		[6] = { levelRequirement = 18, },
		[7] = { levelRequirement = 22, },
		[8] = { levelRequirement = 26, },
		[9] = { levelRequirement = 31, },
		[10] = { levelRequirement = 36, },
		[11] = { levelRequirement = 41, },
		[12] = { levelRequirement = 46, },
		[13] = { levelRequirement = 52, },
		[14] = { levelRequirement = 58, },
		[15] = { levelRequirement = 64, },
		[16] = { levelRequirement = 66, },
		[17] = { levelRequirement = 72, },
		[18] = { levelRequirement = 78, },
		[19] = { levelRequirement = 84, },
		[20] = { levelRequirement = 90, },
		[21] = { levelRequirement = 90, },
		[22] = { levelRequirement = 90, },
		[23] = { levelRequirement = 90, },
		[24] = { levelRequirement = 90, },
		[25] = { levelRequirement = 90, },
		[26] = { levelRequirement = 90, },
		[27] = { levelRequirement = 90, },
		[28] = { levelRequirement = 90, },
		[29] = { levelRequirement = 90, },
		[30] = { levelRequirement = 90, },
		[31] = { levelRequirement = 90, },
		[32] = { levelRequirement = 90, },
		[33] = { levelRequirement = 90, },
		[34] = { levelRequirement = 90, },
		[35] = { levelRequirement = 90, },
		[36] = { levelRequirement = 90, },
		[37] = { levelRequirement = 90, },
		[38] = { levelRequirement = 90, },
		[39] = { levelRequirement = 90, },
		[40] = { levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Future-Past",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "foresight",
			baseFlags = {
			},
			constantStats = {
				{ "foresight_clone_duration_ms", 2000 },
				{ "skill_desired_amount_override", 1 },
				{ "base_secondary_skill_effect_duration", 1500 },
			},
			stats = {
				"base_skill_effect_duration",
				"base_deal_no_damage",
			},
			notMinionStat = {
				"base_skill_effect_duration",
			},
			levels = {
				[1] = { 25500, statInterpolation = { 1, }, actorLevel = 1, },
				[2] = { 25000, statInterpolation = { 1, }, actorLevel = 3.4519999027252, },
				[3] = { 24500, statInterpolation = { 1, }, actorLevel = 6.7670001983643, },
				[4] = { 24000, statInterpolation = { 1, }, actorLevel = 10.307999610901, },
				[5] = { 23500, statInterpolation = { 1, }, actorLevel = 14.074999809265, },
				[6] = { 23000, statInterpolation = { 1, }, actorLevel = 18.068000793457, },
				[7] = { 22500, statInterpolation = { 1, }, actorLevel = 22.287000656128, },
				[8] = { 22000, statInterpolation = { 1, }, actorLevel = 26.732000350952, },
				[9] = { 21500, statInterpolation = { 1, }, actorLevel = 31.40299987793, },
				[10] = { 21000, statInterpolation = { 1, }, actorLevel = 36.299999237061, },
				[11] = { 20500, statInterpolation = { 1, }, actorLevel = 41.423000335693, },
				[12] = { 20000, statInterpolation = { 1, }, actorLevel = 46.771999359131, },
				[13] = { 19500, statInterpolation = { 1, }, actorLevel = 52.34700012207, },
				[14] = { 19000, statInterpolation = { 1, }, actorLevel = 58.147998809814, },
				[15] = { 18500, statInterpolation = { 1, }, actorLevel = 64.175003051758, },
				[16] = { 18000, statInterpolation = { 1, }, actorLevel = 70.428001403809, },
				[17] = { 17500, statInterpolation = { 1, }, actorLevel = 76.906997680664, },
				[18] = { 17000, statInterpolation = { 1, }, actorLevel = 83.611999511719, },
				[19] = { 16500, statInterpolation = { 1, }, actorLevel = 90.542999267578, },
				[20] = { 16000, statInterpolation = { 1, }, actorLevel = 97.699996948242, },
				[21] = { 15500, statInterpolation = { 1, }, actorLevel = 105.08300018311, },
				[22] = { 15000, statInterpolation = { 1, }, actorLevel = 112.69200134277, },
				[23] = { 14500, statInterpolation = { 1, }, actorLevel = 120.52700042725, },
				[24] = { 14000, statInterpolation = { 1, }, actorLevel = 128.58799743652, },
				[25] = { 13750, statInterpolation = { 1, }, actorLevel = 136.875, },
				[26] = { 13500, statInterpolation = { 1, }, actorLevel = 145.38800048828, },
				[27] = { 13250, statInterpolation = { 1, }, actorLevel = 154.12699890137, },
				[28] = { 13000, statInterpolation = { 1, }, actorLevel = 163.09199523926, },
				[29] = { 12750, statInterpolation = { 1, }, actorLevel = 172.28300476074, },
				[30] = { 12500, statInterpolation = { 1, }, actorLevel = 181.69999694824, },
				[31] = { 12375, statInterpolation = { 1, }, actorLevel = 191.34300231934, },
				[32] = { 12250, statInterpolation = { 1, }, actorLevel = 201.21200561523, },
				[33] = { 12125, statInterpolation = { 1, }, actorLevel = 211.30700683594, },
				[34] = { 12000, statInterpolation = { 1, }, actorLevel = 221.62800598145, },
				[35] = { 11875, statInterpolation = { 1, }, actorLevel = 232.17500305176, },
				[36] = { 11750, statInterpolation = { 1, }, actorLevel = 242.94799804688, },
				[37] = { 11625, statInterpolation = { 1, }, actorLevel = 253.94700622559, },
				[38] = { 11500, statInterpolation = { 1, }, actorLevel = 265.17199707031, },
				[39] = { 11375, statInterpolation = { 1, }, actorLevel = 276.62298583984, },
				[40] = { 11250, statInterpolation = { 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["InevitableAgonyPlayer"] = {
	name = "Inevitable Agony",
	baseTypeName = "Inevitable Agony",
	fromTree = true,
	color = 4,
	description = "Curse all targets in an area after a short delay, causing a portion of Damage they take from Hits to be tracked by the Curse debuff. When the debuff's duration expires, they take that tracked damage again, all at once.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.Unleashable] = true, [SkillType.AreaSpell] = true, [SkillType.UsableWhileMoving] = true, [SkillType.NoAttackInPlace] = true, },
	castTime = 0.7,
	qualityStats = {
		{ "base_curse_delay_+%", -0.5 },
	},
	levels = {
		[1] = { levelRequirement = 0, cost = { Mana = 41, }, },
		[2] = { levelRequirement = 3, cost = { Mana = 46, }, },
		[3] = { levelRequirement = 6, cost = { Mana = 52, }, },
		[4] = { levelRequirement = 10, cost = { Mana = 57, }, },
		[5] = { levelRequirement = 14, cost = { Mana = 63, }, },
		[6] = { levelRequirement = 18, cost = { Mana = 69, }, },
		[7] = { levelRequirement = 22, cost = { Mana = 76, }, },
		[8] = { levelRequirement = 26, cost = { Mana = 82, }, },
		[9] = { levelRequirement = 31, cost = { Mana = 89, }, },
		[10] = { levelRequirement = 36, cost = { Mana = 96, }, },
		[11] = { levelRequirement = 41, cost = { Mana = 103, }, },
		[12] = { levelRequirement = 46, cost = { Mana = 110, }, },
		[13] = { levelRequirement = 52, cost = { Mana = 118, }, },
		[14] = { levelRequirement = 58, cost = { Mana = 126, }, },
		[15] = { levelRequirement = 64, cost = { Mana = 134, }, },
		[16] = { levelRequirement = 66, cost = { Mana = 142, }, },
		[17] = { levelRequirement = 72, cost = { Mana = 151, }, },
		[18] = { levelRequirement = 78, cost = { Mana = 160, }, },
		[19] = { levelRequirement = 84, cost = { Mana = 169, }, },
		[20] = { levelRequirement = 90, cost = { Mana = 178, }, },
		[21] = { levelRequirement = 90, cost = { Mana = 188, }, },
		[22] = { levelRequirement = 90, cost = { Mana = 198, }, },
		[23] = { levelRequirement = 90, cost = { Mana = 208, }, },
		[24] = { levelRequirement = 90, cost = { Mana = 219, }, },
		[25] = { levelRequirement = 90, cost = { Mana = 230, }, },
		[26] = { levelRequirement = 90, cost = { Mana = 241, }, },
		[27] = { levelRequirement = 90, cost = { Mana = 253, }, },
		[28] = { levelRequirement = 90, cost = { Mana = 265, }, },
		[29] = { levelRequirement = 90, cost = { Mana = 277, }, },
		[30] = { levelRequirement = 90, cost = { Mana = 289, }, },
		[31] = { levelRequirement = 90, cost = { Mana = 302, }, },
		[32] = { levelRequirement = 90, cost = { Mana = 316, }, },
		[33] = { levelRequirement = 90, cost = { Mana = 329, }, },
		[34] = { levelRequirement = 90, cost = { Mana = 344, }, },
		[35] = { levelRequirement = 90, cost = { Mana = 358, }, },
		[36] = { levelRequirement = 90, cost = { Mana = 373, }, },
		[37] = { levelRequirement = 90, cost = { Mana = 388, }, },
		[38] = { levelRequirement = 90, cost = { Mana = 404, }, },
		[39] = { levelRequirement = 90, cost = { Mana = 420, }, },
		[40] = { levelRequirement = 90, cost = { Mana = 437, }, },
	},
	statSets = {
		[1] = {
			label = "Inevitable Agony",
			incrementalEffectiveness = 0.092720001935959,
			statDescriptionScope = "synchronisation_of_pain",
			baseFlags = {
			},
			constantStats = {
				{ "curse_delay_duration_ms", 1500 },
				{ "movement_speed_+%_final_while_performing_action", -70 },
				{ "movement_speed_acceleration_+%_per_second_while_performing_action", 160 },
				{ "movement_speed_while_performing_action_locked_duration_%", 50 },
			},
			stats = {
				"base_skill_effect_duration",
				"active_skill_base_area_of_effect_radius",
				"curse_pain_synchronisation_base_recorded_damage_%_to_apply",
				"can_perform_skill_while_moving",
			},
			notMinionStat = {
				"base_skill_effect_duration",
			},
			levels = {
				[1] = { 6000, 15, 20, statInterpolation = { 1, 1, 1, }, actorLevel = 1, },
				[2] = { 6200, 16, 21, statInterpolation = { 1, 1, 1, }, actorLevel = 3.4519999027252, },
				[3] = { 6200, 17, 21, statInterpolation = { 1, 1, 1, }, actorLevel = 6.7670001983643, },
				[4] = { 6200, 18, 22, statInterpolation = { 1, 1, 1, }, actorLevel = 10.307999610901, },
				[5] = { 6400, 18, 23, statInterpolation = { 1, 1, 1, }, actorLevel = 14.074999809265, },
				[6] = { 6400, 19, 24, statInterpolation = { 1, 1, 1, }, actorLevel = 18.068000793457, },
				[7] = { 6400, 20, 24, statInterpolation = { 1, 1, 1, }, actorLevel = 22.287000656128, },
				[8] = { 6600, 21, 25, statInterpolation = { 1, 1, 1, }, actorLevel = 26.732000350952, },
				[9] = { 6600, 22, 26, statInterpolation = { 1, 1, 1, }, actorLevel = 31.40299987793, },
				[10] = { 6600, 23, 27, statInterpolation = { 1, 1, 1, }, actorLevel = 36.299999237061, },
				[11] = { 6800, 23, 27, statInterpolation = { 1, 1, 1, }, actorLevel = 41.423000335693, },
				[12] = { 6800, 24, 28, statInterpolation = { 1, 1, 1, }, actorLevel = 46.771999359131, },
				[13] = { 6800, 25, 29, statInterpolation = { 1, 1, 1, }, actorLevel = 52.34700012207, },
				[14] = { 7000, 26, 29, statInterpolation = { 1, 1, 1, }, actorLevel = 58.147998809814, },
				[15] = { 7000, 27, 30, statInterpolation = { 1, 1, 1, }, actorLevel = 64.175003051758, },
				[16] = { 7000, 28, 31, statInterpolation = { 1, 1, 1, }, actorLevel = 70.428001403809, },
				[17] = { 7200, 28, 32, statInterpolation = { 1, 1, 1, }, actorLevel = 76.906997680664, },
				[18] = { 7200, 29, 32, statInterpolation = { 1, 1, 1, }, actorLevel = 83.611999511719, },
				[19] = { 7200, 30, 33, statInterpolation = { 1, 1, 1, }, actorLevel = 90.542999267578, },
				[20] = { 7400, 31, 33, statInterpolation = { 1, 1, 1, }, actorLevel = 97.699996948242, },
				[21] = { 7400, 32, 34, statInterpolation = { 1, 1, 1, }, actorLevel = 105.08300018311, },
				[22] = { 7400, 33, 34, statInterpolation = { 1, 1, 1, }, actorLevel = 112.69200134277, },
				[23] = { 7600, 34, 35, statInterpolation = { 1, 1, 1, }, actorLevel = 120.52700042725, },
				[24] = { 7600, 34, 36, statInterpolation = { 1, 1, 1, }, actorLevel = 128.58799743652, },
				[25] = { 7600, 35, 37, statInterpolation = { 1, 1, 1, }, actorLevel = 136.875, },
				[26] = { 7800, 36, 37, statInterpolation = { 1, 1, 1, }, actorLevel = 145.38800048828, },
				[27] = { 7800, 37, 38, statInterpolation = { 1, 1, 1, }, actorLevel = 154.12699890137, },
				[28] = { 7800, 38, 39, statInterpolation = { 1, 1, 1, }, actorLevel = 163.09199523926, },
				[29] = { 8000, 39, 40, statInterpolation = { 1, 1, 1, }, actorLevel = 172.28300476074, },
				[30] = { 8000, 39, 40, statInterpolation = { 1, 1, 1, }, actorLevel = 181.69999694824, },
				[31] = { 8000, 40, 41, statInterpolation = { 1, 1, 1, }, actorLevel = 191.34300231934, },
				[32] = { 8200, 40, 42, statInterpolation = { 1, 1, 1, }, actorLevel = 201.21200561523, },
				[33] = { 8200, 41, 42, statInterpolation = { 1, 1, 1, }, actorLevel = 211.30700683594, },
				[34] = { 8200, 41, 43, statInterpolation = { 1, 1, 1, }, actorLevel = 221.62800598145, },
				[35] = { 8400, 42, 44, statInterpolation = { 1, 1, 1, }, actorLevel = 232.17500305176, },
				[36] = { 8400, 42, 45, statInterpolation = { 1, 1, 1, }, actorLevel = 242.94799804688, },
				[37] = { 8400, 42, 45, statInterpolation = { 1, 1, 1, }, actorLevel = 253.94700622559, },
				[38] = { 8600, 43, 46, statInterpolation = { 1, 1, 1, }, actorLevel = 265.17199707031, },
				[39] = { 8600, 43, 47, statInterpolation = { 1, 1, 1, }, actorLevel = 276.62298583984, },
				[40] = { 8600, 44, 47, statInterpolation = { 1, 1, 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["IntoTheBreachPlayer"] = {
	name = "Into the Breach",
	baseTypeName = "Into the Breach",
	fromTree = true,
	color = 4,
	description = "Create a Breach around you, allowing you to see nearby Flames of Chayula. You are considered to be in a Breach while this skill is active.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Persistent] = true, [SkillType.OngoingSkill] = true, [SkillType.HasReservation] = true, [SkillType.GeneratesRemnants] = true, },
	castTime = 0,
	qualityStats = {
		{ "remnant_effect_+%", 0.75 },
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 3, },
		[3] = { levelRequirement = 6, },
		[4] = { levelRequirement = 10, },
		[5] = { levelRequirement = 14, },
		[6] = { levelRequirement = 18, },
		[7] = { levelRequirement = 22, },
		[8] = { levelRequirement = 26, },
		[9] = { levelRequirement = 31, },
		[10] = { levelRequirement = 36, },
		[11] = { levelRequirement = 41, },
		[12] = { levelRequirement = 46, },
		[13] = { levelRequirement = 52, },
		[14] = { levelRequirement = 58, },
		[15] = { levelRequirement = 64, },
		[16] = { levelRequirement = 66, },
		[17] = { levelRequirement = 72, },
		[18] = { levelRequirement = 78, },
		[19] = { levelRequirement = 84, },
		[20] = { levelRequirement = 90, },
		[21] = { levelRequirement = 90, },
		[22] = { levelRequirement = 90, },
		[23] = { levelRequirement = 90, },
		[24] = { levelRequirement = 90, },
		[25] = { levelRequirement = 90, },
		[26] = { levelRequirement = 90, },
		[27] = { levelRequirement = 90, },
		[28] = { levelRequirement = 90, },
		[29] = { levelRequirement = 90, },
		[30] = { levelRequirement = 90, },
		[31] = { levelRequirement = 90, },
		[32] = { levelRequirement = 90, },
		[33] = { levelRequirement = 90, },
		[34] = { levelRequirement = 90, },
		[35] = { levelRequirement = 90, },
		[36] = { levelRequirement = 90, },
		[37] = { levelRequirement = 90, },
		[38] = { levelRequirement = 90, },
		[39] = { levelRequirement = 90, },
		[40] = { levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Into the Breach",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "breach_walk",
			baseFlags = {
			},
			constantStats = {
				{ "skill_desired_amount_override", 1 },
				{ "breach_flame_mana_leech_%", 7 },
				{ "breach_flame_life_leech_%", 7 },
				{ "breach_flame_chaos_addition_%", 7 },
				{ "breach_flame_spawn_radius", 50 },
				{ "base_remnant_duration_ms", 25000 },
			},
			stats = {
				"breach_flame_spawn_rate_ms",
				"remnant_effect_+%",
			},
			levels = {
				[1] = { 1400, 0, statInterpolation = { 1, 1, }, actorLevel = 1, },
				[2] = { 1390, 3, statInterpolation = { 1, 1, }, actorLevel = 3.4519999027252, },
				[3] = { 1380, 5, statInterpolation = { 1, 1, }, actorLevel = 6.7670001983643, },
				[4] = { 1370, 8, statInterpolation = { 1, 1, }, actorLevel = 10.307999610901, },
				[5] = { 1360, 10, statInterpolation = { 1, 1, }, actorLevel = 14.074999809265, },
				[6] = { 1350, 13, statInterpolation = { 1, 1, }, actorLevel = 18.068000793457, },
				[7] = { 1340, 16, statInterpolation = { 1, 1, }, actorLevel = 22.287000656128, },
				[8] = { 1330, 18, statInterpolation = { 1, 1, }, actorLevel = 26.732000350952, },
				[9] = { 1320, 21, statInterpolation = { 1, 1, }, actorLevel = 31.40299987793, },
				[10] = { 1310, 23, statInterpolation = { 1, 1, }, actorLevel = 36.299999237061, },
				[11] = { 1300, 26, statInterpolation = { 1, 1, }, actorLevel = 41.423000335693, },
				[12] = { 1290, 29, statInterpolation = { 1, 1, }, actorLevel = 46.771999359131, },
				[13] = { 1280, 31, statInterpolation = { 1, 1, }, actorLevel = 52.34700012207, },
				[14] = { 1270, 34, statInterpolation = { 1, 1, }, actorLevel = 58.147998809814, },
				[15] = { 1260, 36, statInterpolation = { 1, 1, }, actorLevel = 64.175003051758, },
				[16] = { 1250, 39, statInterpolation = { 1, 1, }, actorLevel = 70.428001403809, },
				[17] = { 1240, 42, statInterpolation = { 1, 1, }, actorLevel = 76.906997680664, },
				[18] = { 1230, 44, statInterpolation = { 1, 1, }, actorLevel = 83.611999511719, },
				[19] = { 1220, 47, statInterpolation = { 1, 1, }, actorLevel = 90.542999267578, },
				[20] = { 1210, 50, statInterpolation = { 1, 1, }, actorLevel = 97.699996948242, },
				[21] = { 1200, 52, statInterpolation = { 1, 1, }, actorLevel = 105.08300018311, },
				[22] = { 1190, 54, statInterpolation = { 1, 1, }, actorLevel = 112.69200134277, },
				[23] = { 1180, 56, statInterpolation = { 1, 1, }, actorLevel = 120.52700042725, },
				[24] = { 1170, 58, statInterpolation = { 1, 1, }, actorLevel = 128.58799743652, },
				[25] = { 1160, 60, statInterpolation = { 1, 1, }, actorLevel = 136.875, },
				[26] = { 1150, 62, statInterpolation = { 1, 1, }, actorLevel = 145.38800048828, },
				[27] = { 1140, 64, statInterpolation = { 1, 1, }, actorLevel = 154.12699890137, },
				[28] = { 1130, 66, statInterpolation = { 1, 1, }, actorLevel = 163.09199523926, },
				[29] = { 1120, 68, statInterpolation = { 1, 1, }, actorLevel = 172.28300476074, },
				[30] = { 1110, 70, statInterpolation = { 1, 1, }, actorLevel = 181.69999694824, },
				[31] = { 1105, 72, statInterpolation = { 1, 1, }, actorLevel = 191.34300231934, },
				[32] = { 1100, 74, statInterpolation = { 1, 1, }, actorLevel = 201.21200561523, },
				[33] = { 1095, 76, statInterpolation = { 1, 1, }, actorLevel = 211.30700683594, },
				[34] = { 1090, 78, statInterpolation = { 1, 1, }, actorLevel = 221.62800598145, },
				[35] = { 1085, 80, statInterpolation = { 1, 1, }, actorLevel = 232.17500305176, },
				[36] = { 1080, 82, statInterpolation = { 1, 1, }, actorLevel = 242.94799804688, },
				[37] = { 1075, 84, statInterpolation = { 1, 1, }, actorLevel = 253.94700622559, },
				[38] = { 1070, 86, statInterpolation = { 1, 1, }, actorLevel = 265.17199707031, },
				[39] = { 1065, 88, statInterpolation = { 1, 1, }, actorLevel = 276.62298583984, },
				[40] = { 1060, 90, statInterpolation = { 1, 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["LifeRemnantsPlayer"] = {
	name = "Life Remnants",
	baseTypeName = "Life Remnants",
	fromTree = true,
	color = 4,
	description = "Drink the blood of your enemies to restore your Life. While active, enemies you kill have a chance to spawn a Life Remnant, and Hitting a target spawns a Life Remnant every few seconds. Picking up a Life Remnant grants you Life which can Overflow maximum Life.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.OngoingSkill] = true, [SkillType.Persistent] = true, [SkillType.GeneratesRemnants] = true, },
	castTime = 0,
	qualityStats = {
		{ "life_remnants_chance_to_spawn_orb_on_killing_enemy_%", 0.5 },
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 3, },
		[3] = { levelRequirement = 6, },
		[4] = { levelRequirement = 10, },
		[5] = { levelRequirement = 14, },
		[6] = { levelRequirement = 18, },
		[7] = { levelRequirement = 22, },
		[8] = { levelRequirement = 26, },
		[9] = { levelRequirement = 31, },
		[10] = { levelRequirement = 36, },
		[11] = { levelRequirement = 41, },
		[12] = { levelRequirement = 46, },
		[13] = { levelRequirement = 52, },
		[14] = { levelRequirement = 58, },
		[15] = { levelRequirement = 64, },
		[16] = { levelRequirement = 66, },
		[17] = { levelRequirement = 72, },
		[18] = { levelRequirement = 78, },
		[19] = { levelRequirement = 84, },
		[20] = { levelRequirement = 90, },
		[21] = { levelRequirement = 90, },
		[22] = { levelRequirement = 90, },
		[23] = { levelRequirement = 90, },
		[24] = { levelRequirement = 90, },
		[25] = { levelRequirement = 90, },
		[26] = { levelRequirement = 90, },
		[27] = { levelRequirement = 90, },
		[28] = { levelRequirement = 90, },
		[29] = { levelRequirement = 90, },
		[30] = { levelRequirement = 90, },
		[31] = { levelRequirement = 90, },
		[32] = { levelRequirement = 90, },
		[33] = { levelRequirement = 90, },
		[34] = { levelRequirement = 90, },
		[35] = { levelRequirement = 90, },
		[36] = { levelRequirement = 90, },
		[37] = { levelRequirement = 90, },
		[38] = { levelRequirement = 90, },
		[39] = { levelRequirement = 90, },
		[40] = { levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Life Remnants",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "life_remnants",
			baseFlags = {
			},
			constantStats = {
				{ "life_remnants_chance_to_spawn_orb_on_killing_enemy_%", 25 },
				{ "life_remnants_spawn_remnant_on_hit_vs_enemy_every_X_ms", 3000 },
				{ "skill_desired_amount_override", 1 },
				{ "base_remnant_duration_ms", 8000 },
			},
			stats = {
				"life_remnants_gain_per_globe",
				"base_deal_no_damage_over_time",
			},
			levels = {
				[1] = { 11, statInterpolation = { 1, }, actorLevel = 1, },
				[2] = { 14, statInterpolation = { 1, }, actorLevel = 3.4519999027252, },
				[3] = { 23, statInterpolation = { 1, }, actorLevel = 6.7670001983643, },
				[4] = { 31, statInterpolation = { 1, }, actorLevel = 10.307999610901, },
				[5] = { 41, statInterpolation = { 1, }, actorLevel = 14.074999809265, },
				[6] = { 52, statInterpolation = { 1, }, actorLevel = 18.068000793457, },
				[7] = { 65, statInterpolation = { 1, }, actorLevel = 22.287000656128, },
				[8] = { 81, statInterpolation = { 1, }, actorLevel = 26.732000350952, },
				[9] = { 95, statInterpolation = { 1, }, actorLevel = 31.40299987793, },
				[10] = { 112, statInterpolation = { 1, }, actorLevel = 36.299999237061, },
				[11] = { 131, statInterpolation = { 1, }, actorLevel = 41.423000335693, },
				[12] = { 157, statInterpolation = { 1, }, actorLevel = 46.771999359131, },
				[13] = { 176, statInterpolation = { 1, }, actorLevel = 52.34700012207, },
				[14] = { 205, statInterpolation = { 1, }, actorLevel = 58.147998809814, },
				[15] = { 232, statInterpolation = { 1, }, actorLevel = 64.175003051758, },
				[16] = { 263, statInterpolation = { 1, }, actorLevel = 70.428001403809, },
				[17] = { 301, statInterpolation = { 1, }, actorLevel = 76.906997680664, },
				[18] = { 337, statInterpolation = { 1, }, actorLevel = 83.611999511719, },
				[19] = { 374, statInterpolation = { 1, }, actorLevel = 90.542999267578, },
				[20] = { 410, statInterpolation = { 1, }, actorLevel = 97.699996948242, },
				[21] = { 448, statInterpolation = { 1, }, actorLevel = 105.08300018311, },
				[22] = { 490, statInterpolation = { 1, }, actorLevel = 112.69200134277, },
				[23] = { 531, statInterpolation = { 1, }, actorLevel = 120.52700042725, },
				[24] = { 574, statInterpolation = { 1, }, actorLevel = 128.58799743652, },
				[25] = { 616, statInterpolation = { 1, }, actorLevel = 136.875, },
				[26] = { 657, statInterpolation = { 1, }, actorLevel = 145.38800048828, },
				[27] = { 706, statInterpolation = { 1, }, actorLevel = 154.12699890137, },
				[28] = { 752, statInterpolation = { 1, }, actorLevel = 163.09199523926, },
				[29] = { 799, statInterpolation = { 1, }, actorLevel = 172.28300476074, },
				[30] = { 851, statInterpolation = { 1, }, actorLevel = 181.69999694824, },
				[31] = { 900, statInterpolation = { 1, }, actorLevel = 191.34300231934, },
				[32] = { 952, statInterpolation = { 1, }, actorLevel = 201.21200561523, },
				[33] = { 1004, statInterpolation = { 1, }, actorLevel = 211.30700683594, },
				[34] = { 1062, statInterpolation = { 1, }, actorLevel = 221.62800598145, },
				[35] = { 1114, statInterpolation = { 1, }, actorLevel = 232.17500305176, },
				[36] = { 1172, statInterpolation = { 1, }, actorLevel = 242.94799804688, },
				[37] = { 1229, statInterpolation = { 1, }, actorLevel = 253.94700622559, },
				[38] = { 1287, statInterpolation = { 1, }, actorLevel = 265.17199707031, },
				[39] = { 1350, statInterpolation = { 1, }, actorLevel = 276.62298583984, },
				[40] = { 1408, statInterpolation = { 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["Melee1HMacePlayer"] = {
	name = "Mace Strike",
	baseTypeName = "Mace Strike",
	fromItem = true,
	color = 4,
	description = "Strike with your Mace.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Melee] = true, [SkillType.Area] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
	},
	castTime = 1,
	qualityStats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { baseMultiplier = 1.1, levelRequirement = 3, },
		[3] = { baseMultiplier = 1.21, levelRequirement = 6, },
		[4] = { baseMultiplier = 1.32, levelRequirement = 10, },
		[5] = { baseMultiplier = 1.42, levelRequirement = 14, },
		[6] = { baseMultiplier = 1.53, levelRequirement = 18, },
		[7] = { baseMultiplier = 1.64, levelRequirement = 22, },
		[8] = { baseMultiplier = 1.74, levelRequirement = 26, },
		[9] = { baseMultiplier = 1.82, levelRequirement = 31, },
		[10] = { baseMultiplier = 1.91, levelRequirement = 36, },
		[11] = { baseMultiplier = 2.01, levelRequirement = 41, },
		[12] = { baseMultiplier = 2.11, levelRequirement = 46, },
		[13] = { baseMultiplier = 2.22, levelRequirement = 52, },
		[14] = { baseMultiplier = 2.33, levelRequirement = 58, },
		[15] = { baseMultiplier = 2.44, levelRequirement = 64, },
		[16] = { baseMultiplier = 2.57, levelRequirement = 66, },
		[17] = { baseMultiplier = 2.69, levelRequirement = 72, },
		[18] = { baseMultiplier = 2.83, levelRequirement = 78, },
		[19] = { baseMultiplier = 2.97, levelRequirement = 84, },
		[20] = { baseMultiplier = 3.12, levelRequirement = 90, },
		[21] = { baseMultiplier = 3.27, levelRequirement = 90, },
		[22] = { baseMultiplier = 3.44, levelRequirement = 90, },
		[23] = { baseMultiplier = 3.61, levelRequirement = 90, },
		[24] = { baseMultiplier = 3.79, levelRequirement = 90, },
		[25] = { baseMultiplier = 3.98, levelRequirement = 90, },
		[26] = { baseMultiplier = 4.18, levelRequirement = 90, },
		[27] = { baseMultiplier = 4.39, levelRequirement = 90, },
		[28] = { baseMultiplier = 4.61, levelRequirement = 90, },
		[29] = { baseMultiplier = 4.84, levelRequirement = 90, },
		[30] = { baseMultiplier = 5.08, levelRequirement = 90, },
		[31] = { baseMultiplier = 5.33, levelRequirement = 90, },
		[32] = { baseMultiplier = 5.6, levelRequirement = 90, },
		[33] = { baseMultiplier = 5.88, levelRequirement = 90, },
		[34] = { baseMultiplier = 6.18, levelRequirement = 90, },
		[35] = { baseMultiplier = 6.48, levelRequirement = 90, },
		[36] = { baseMultiplier = 6.81, levelRequirement = 90, },
		[37] = { baseMultiplier = 7.15, levelRequirement = 90, },
		[38] = { baseMultiplier = 7.51, levelRequirement = 90, },
		[39] = { baseMultiplier = 7.88, levelRequirement = 90, },
		[40] = { baseMultiplier = 8.28, levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Mace Strike",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			baseFlags = {
				attack = true,
				area = true,
				melee = true,
			},
			constantStats = {
				{ "melee_conditional_step_distance", 10 },
			},
			stats = {
				"is_area_damage",
				"precise_cursor_targeting_uses_contact_point_height_offset",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["Melee2HMacePlayer"] = {
	name = "Mace Strike",
	baseTypeName = "Mace Strike",
	fromItem = true,
	color = 4,
	description = "Strike with your Mace.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Melee] = true, [SkillType.Area] = true, },
	weaponTypes = {
		["Two Handed Mace"] = true,
	},
	castTime = 1,
	qualityStats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { baseMultiplier = 1.1, levelRequirement = 3, },
		[3] = { baseMultiplier = 1.21, levelRequirement = 6, },
		[4] = { baseMultiplier = 1.32, levelRequirement = 10, },
		[5] = { baseMultiplier = 1.42, levelRequirement = 14, },
		[6] = { baseMultiplier = 1.53, levelRequirement = 18, },
		[7] = { baseMultiplier = 1.64, levelRequirement = 22, },
		[8] = { baseMultiplier = 1.74, levelRequirement = 26, },
		[9] = { baseMultiplier = 1.82, levelRequirement = 31, },
		[10] = { baseMultiplier = 1.91, levelRequirement = 36, },
		[11] = { baseMultiplier = 2.01, levelRequirement = 41, },
		[12] = { baseMultiplier = 2.11, levelRequirement = 46, },
		[13] = { baseMultiplier = 2.22, levelRequirement = 52, },
		[14] = { baseMultiplier = 2.33, levelRequirement = 58, },
		[15] = { baseMultiplier = 2.44, levelRequirement = 64, },
		[16] = { baseMultiplier = 2.57, levelRequirement = 66, },
		[17] = { baseMultiplier = 2.69, levelRequirement = 72, },
		[18] = { baseMultiplier = 2.83, levelRequirement = 78, },
		[19] = { baseMultiplier = 2.97, levelRequirement = 84, },
		[20] = { baseMultiplier = 3.12, levelRequirement = 90, },
		[21] = { baseMultiplier = 3.27, levelRequirement = 90, },
		[22] = { baseMultiplier = 3.44, levelRequirement = 90, },
		[23] = { baseMultiplier = 3.61, levelRequirement = 90, },
		[24] = { baseMultiplier = 3.79, levelRequirement = 90, },
		[25] = { baseMultiplier = 3.98, levelRequirement = 90, },
		[26] = { baseMultiplier = 4.18, levelRequirement = 90, },
		[27] = { baseMultiplier = 4.39, levelRequirement = 90, },
		[28] = { baseMultiplier = 4.61, levelRequirement = 90, },
		[29] = { baseMultiplier = 4.84, levelRequirement = 90, },
		[30] = { baseMultiplier = 5.08, levelRequirement = 90, },
		[31] = { baseMultiplier = 5.33, levelRequirement = 90, },
		[32] = { baseMultiplier = 5.6, levelRequirement = 90, },
		[33] = { baseMultiplier = 5.88, levelRequirement = 90, },
		[34] = { baseMultiplier = 6.18, levelRequirement = 90, },
		[35] = { baseMultiplier = 6.48, levelRequirement = 90, },
		[36] = { baseMultiplier = 6.81, levelRequirement = 90, },
		[37] = { baseMultiplier = 7.15, levelRequirement = 90, },
		[38] = { baseMultiplier = 7.51, levelRequirement = 90, },
		[39] = { baseMultiplier = 7.88, levelRequirement = 90, },
		[40] = { baseMultiplier = 8.28, levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Mace Strike",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			baseFlags = {
				attack = true,
				area = true,
				melee = true,
			},
			constantStats = {
				{ "melee_conditional_step_distance", 10 },
			},
			stats = {
				"is_area_damage",
				"precise_cursor_targeting_uses_contact_point_height_offset",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["MeleeMaceMacePlayer"] = {
	name = "Mace Strike",
	baseTypeName = "Mace Strike",
	fromItem = true,
	color = 4,
	description = "Strike with your Maces.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.DualWieldOnly] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Two Handed Mace"] = true,
	},
	castTime = 1,
	qualityStats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { baseMultiplier = 1.1, levelRequirement = 3, },
		[3] = { baseMultiplier = 1.21, levelRequirement = 6, },
		[4] = { baseMultiplier = 1.32, levelRequirement = 10, },
		[5] = { baseMultiplier = 1.42, levelRequirement = 14, },
		[6] = { baseMultiplier = 1.53, levelRequirement = 18, },
		[7] = { baseMultiplier = 1.64, levelRequirement = 22, },
		[8] = { baseMultiplier = 1.74, levelRequirement = 26, },
		[9] = { baseMultiplier = 1.82, levelRequirement = 31, },
		[10] = { baseMultiplier = 1.91, levelRequirement = 36, },
		[11] = { baseMultiplier = 2.01, levelRequirement = 41, },
		[12] = { baseMultiplier = 2.11, levelRequirement = 46, },
		[13] = { baseMultiplier = 2.22, levelRequirement = 52, },
		[14] = { baseMultiplier = 2.33, levelRequirement = 58, },
		[15] = { baseMultiplier = 2.44, levelRequirement = 64, },
		[16] = { baseMultiplier = 2.57, levelRequirement = 66, },
		[17] = { baseMultiplier = 2.69, levelRequirement = 72, },
		[18] = { baseMultiplier = 2.83, levelRequirement = 78, },
		[19] = { baseMultiplier = 2.97, levelRequirement = 84, },
		[20] = { baseMultiplier = 3.12, levelRequirement = 90, },
		[21] = { baseMultiplier = 3.27, levelRequirement = 90, },
		[22] = { baseMultiplier = 3.44, levelRequirement = 90, },
		[23] = { baseMultiplier = 3.61, levelRequirement = 90, },
		[24] = { baseMultiplier = 3.79, levelRequirement = 90, },
		[25] = { baseMultiplier = 3.98, levelRequirement = 90, },
		[26] = { baseMultiplier = 4.18, levelRequirement = 90, },
		[27] = { baseMultiplier = 4.39, levelRequirement = 90, },
		[28] = { baseMultiplier = 4.61, levelRequirement = 90, },
		[29] = { baseMultiplier = 4.84, levelRequirement = 90, },
		[30] = { baseMultiplier = 5.08, levelRequirement = 90, },
		[31] = { baseMultiplier = 5.33, levelRequirement = 90, },
		[32] = { baseMultiplier = 5.6, levelRequirement = 90, },
		[33] = { baseMultiplier = 5.88, levelRequirement = 90, },
		[34] = { baseMultiplier = 6.18, levelRequirement = 90, },
		[35] = { baseMultiplier = 6.48, levelRequirement = 90, },
		[36] = { baseMultiplier = 6.81, levelRequirement = 90, },
		[37] = { baseMultiplier = 7.15, levelRequirement = 90, },
		[38] = { baseMultiplier = 7.51, levelRequirement = 90, },
		[39] = { baseMultiplier = 7.88, levelRequirement = 90, },
		[40] = { baseMultiplier = 8.28, levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Mace Strike",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			baseFlags = {
				attack = true,
				area = true,
				melee = true,
			},
			constantStats = {
				{ "melee_conditional_step_distance", 10 },
				{ "active_skill_attack_speed_+%_final_while_dual_wielding", -30 },
			},
			stats = {
				"is_area_damage",
				"skill_double_hits_when_dual_wielding",
				"precise_cursor_targeting_uses_contact_point_height_offset",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["ManifestWeaponPlayer"] = {
	name = "Manifest Weapon",
	baseTypeName = "Manifest Weapon",
	fromTree = true,
	minionList = {
		"ManifestWeapon",
	},
	color = 4,
	description = "Manifest a copy of your main hand Melee Martial Weapon as an immortal Companion to fight by your side. In addition to its standard Strikes, the Manifested Weapon gains an additional Attack depending on its weapon type.",
	skillTypes = { [SkillType.Minion] = true, [SkillType.CreatesMinion] = true, [SkillType.Persistent] = true, [SkillType.HasReservation] = true, [SkillType.Companion] = true, [SkillType.MinionsAreUndamagable] = true, [SkillType.CreatesCompanion] = true, [SkillType.NoAttackInPlace] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Area] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Flail"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Claw"] = true,
		["Spear"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Staff"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 0,
	qualityStats = {
		{ "minion_attack_speed_+%", 1 },
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 3, },
		[3] = { levelRequirement = 6, },
		[4] = { levelRequirement = 10, },
		[5] = { levelRequirement = 14, },
		[6] = { levelRequirement = 18, },
		[7] = { levelRequirement = 22, },
		[8] = { levelRequirement = 26, },
		[9] = { levelRequirement = 31, },
		[10] = { levelRequirement = 36, },
		[11] = { levelRequirement = 41, },
		[12] = { levelRequirement = 46, },
		[13] = { levelRequirement = 52, },
		[14] = { levelRequirement = 58, },
		[15] = { levelRequirement = 64, },
		[16] = { levelRequirement = 66, },
		[17] = { levelRequirement = 72, },
		[18] = { levelRequirement = 78, },
		[19] = { levelRequirement = 84, },
		[20] = { levelRequirement = 90, },
		[21] = { levelRequirement = 90, },
		[22] = { levelRequirement = 90, },
		[23] = { levelRequirement = 90, },
		[24] = { levelRequirement = 90, },
		[25] = { levelRequirement = 90, },
		[26] = { levelRequirement = 90, },
		[27] = { levelRequirement = 90, },
		[28] = { levelRequirement = 90, },
		[29] = { levelRequirement = 90, },
		[30] = { levelRequirement = 90, },
		[31] = { levelRequirement = 90, },
		[32] = { levelRequirement = 90, },
		[33] = { levelRequirement = 90, },
		[34] = { levelRequirement = 90, },
		[35] = { levelRequirement = 90, },
		[36] = { levelRequirement = 90, },
		[37] = { levelRequirement = 90, },
		[38] = { levelRequirement = 90, },
		[39] = { levelRequirement = 90, },
		[40] = { levelRequirement = 90, },
	},
			minionHasItemSet = true,
			minionUses = {
				["Weapon 1"] = true,
			},
	statSets = {
		[1] = {
			label = "Manifest Weapon",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			statMap = {
				["minion_1%_damage_+%_per_X_player_strength"] = {
					mod("MinionModifier", "LIST", { mod = mod("Damage", "INC", nil, 0, 0, { type = "PerStat", stat = "Str", actor = "parent" }) }),
				},
				["minion_1%_attack_speed_+%_per_X_player_dexterity"] = {
					mod("MinionModifier", "LIST", { mod = mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "PerStat", stat = "Dex", actor = "parent", div = 3 }) }),
					div = 3,
				},
			},
			baseFlags = {
				spell = true,
				minion = true,
				duration = true,
			},
			constantStats = {
				{ "skill_desired_initial_amount", 1 },
				{ "minion_1%_damage_+%_per_X_player_strength", 1 },
				{ "minion_1%_attack_speed_+%_per_X_player_dexterity", 3 },
			},
			stats = {
				"is_resummoning_minion",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["MeditatePlayer"] = {
	name = "Meditate",
	baseTypeName = "Meditate",
	fromTree = true,
	color = 4,
	description = "Channel to Recharge Energy Shield and allow that Recharge to Overflow. Channelling ends when you take damage or your Energy Shield is fully Overflowed.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Channel] = true, [SkillType.Cooldown] = true, [SkillType.NoAttackInPlace] = true, },
	castTime = 1,
	qualityStats = {
		{ "meditate_energy_shield_recharge_rate_+%_final", 0.5 },
	},
	levels = {
		[1] = { storedUses = 1, levelRequirement = 0, cooldown = 7, },
		[2] = { storedUses = 1, levelRequirement = 3, cooldown = 6.9, },
		[3] = { storedUses = 1, levelRequirement = 6, cooldown = 6.8, },
		[4] = { storedUses = 1, levelRequirement = 10, cooldown = 6.7, },
		[5] = { storedUses = 1, levelRequirement = 14, cooldown = 6.6, },
		[6] = { storedUses = 1, levelRequirement = 18, cooldown = 6.5, },
		[7] = { storedUses = 1, levelRequirement = 22, cooldown = 6.4, },
		[8] = { storedUses = 1, levelRequirement = 26, cooldown = 6.3, },
		[9] = { storedUses = 1, levelRequirement = 31, cooldown = 6.2, },
		[10] = { storedUses = 1, levelRequirement = 36, cooldown = 6.1, },
		[11] = { storedUses = 1, levelRequirement = 41, cooldown = 6, },
		[12] = { storedUses = 1, levelRequirement = 46, cooldown = 5.9, },
		[13] = { storedUses = 1, levelRequirement = 52, cooldown = 5.8, },
		[14] = { storedUses = 1, levelRequirement = 58, cooldown = 5.7, },
		[15] = { storedUses = 1, levelRequirement = 64, cooldown = 5.6, },
		[16] = { storedUses = 1, levelRequirement = 66, cooldown = 5.5, },
		[17] = { storedUses = 1, levelRequirement = 72, cooldown = 5.4, },
		[18] = { storedUses = 1, levelRequirement = 78, cooldown = 5.3, },
		[19] = { storedUses = 1, levelRequirement = 84, cooldown = 5.2, },
		[20] = { storedUses = 1, levelRequirement = 90, cooldown = 5.1, },
		[21] = { storedUses = 1, levelRequirement = 90, cooldown = 5, },
		[22] = { storedUses = 1, levelRequirement = 90, cooldown = 4.9, },
		[23] = { storedUses = 1, levelRequirement = 90, cooldown = 4.8, },
		[24] = { storedUses = 1, levelRequirement = 90, cooldown = 4.7, },
		[25] = { storedUses = 1, levelRequirement = 90, cooldown = 4.6, },
		[26] = { storedUses = 1, levelRequirement = 90, cooldown = 4.5, },
		[27] = { storedUses = 1, levelRequirement = 90, cooldown = 4.4, },
		[28] = { storedUses = 1, levelRequirement = 90, cooldown = 4.3, },
		[29] = { storedUses = 1, levelRequirement = 90, cooldown = 4.2, },
		[30] = { storedUses = 1, levelRequirement = 90, cooldown = 4.1, },
		[31] = { storedUses = 1, levelRequirement = 90, cooldown = 4.05, },
		[32] = { storedUses = 1, levelRequirement = 90, cooldown = 4, },
		[33] = { storedUses = 1, levelRequirement = 90, cooldown = 3.95, },
		[34] = { storedUses = 1, levelRequirement = 90, cooldown = 3.9, },
		[35] = { storedUses = 1, levelRequirement = 90, cooldown = 3.85, },
		[36] = { storedUses = 1, levelRequirement = 90, cooldown = 3.8, },
		[37] = { storedUses = 1, levelRequirement = 90, cooldown = 3.75, },
		[38] = { storedUses = 1, levelRequirement = 90, cooldown = 3.7, },
		[39] = { storedUses = 1, levelRequirement = 90, cooldown = 3.65, },
		[40] = { storedUses = 1, levelRequirement = 90, cooldown = 3.6, },
	},
	statSets = {
		[1] = {
			label = "Meditate",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			baseFlags = {
			},
			constantStats = {
				{ "movement_speed_+%_final_while_performing_action", -70 },
				{ "movement_speed_acceleration_+%_per_second_while_performing_action", 160 },
				{ "movement_speed_while_performing_action_locked_duration_%", 50 },
			},
			stats = {
				"meditate_energy_shield_recharge_rate_+%_final",
				"can_perform_skill_while_moving",
				"base_deal_no_damage",
			},
			levels = {
				[1] = { 24, statInterpolation = { 1, }, actorLevel = 1, },
				[2] = { 28, statInterpolation = { 1, }, actorLevel = 3.4519999027252, },
				[3] = { 32, statInterpolation = { 1, }, actorLevel = 6.7670001983643, },
				[4] = { 36, statInterpolation = { 1, }, actorLevel = 10.307999610901, },
				[5] = { 40, statInterpolation = { 1, }, actorLevel = 14.074999809265, },
				[6] = { 44, statInterpolation = { 1, }, actorLevel = 18.068000793457, },
				[7] = { 48, statInterpolation = { 1, }, actorLevel = 22.287000656128, },
				[8] = { 52, statInterpolation = { 1, }, actorLevel = 26.732000350952, },
				[9] = { 56, statInterpolation = { 1, }, actorLevel = 31.40299987793, },
				[10] = { 60, statInterpolation = { 1, }, actorLevel = 36.299999237061, },
				[11] = { 64, statInterpolation = { 1, }, actorLevel = 41.423000335693, },
				[12] = { 68, statInterpolation = { 1, }, actorLevel = 46.771999359131, },
				[13] = { 72, statInterpolation = { 1, }, actorLevel = 52.34700012207, },
				[14] = { 76, statInterpolation = { 1, }, actorLevel = 58.147998809814, },
				[15] = { 80, statInterpolation = { 1, }, actorLevel = 64.175003051758, },
				[16] = { 84, statInterpolation = { 1, }, actorLevel = 70.428001403809, },
				[17] = { 88, statInterpolation = { 1, }, actorLevel = 76.906997680664, },
				[18] = { 92, statInterpolation = { 1, }, actorLevel = 83.611999511719, },
				[19] = { 96, statInterpolation = { 1, }, actorLevel = 90.542999267578, },
				[20] = { 100, statInterpolation = { 1, }, actorLevel = 97.699996948242, },
				[21] = { 104, statInterpolation = { 1, }, actorLevel = 105.08300018311, },
				[22] = { 108, statInterpolation = { 1, }, actorLevel = 112.69200134277, },
				[23] = { 112, statInterpolation = { 1, }, actorLevel = 120.52700042725, },
				[24] = { 116, statInterpolation = { 1, }, actorLevel = 128.58799743652, },
				[25] = { 120, statInterpolation = { 1, }, actorLevel = 136.875, },
				[26] = { 124, statInterpolation = { 1, }, actorLevel = 145.38800048828, },
				[27] = { 128, statInterpolation = { 1, }, actorLevel = 154.12699890137, },
				[28] = { 132, statInterpolation = { 1, }, actorLevel = 163.09199523926, },
				[29] = { 136, statInterpolation = { 1, }, actorLevel = 172.28300476074, },
				[30] = { 140, statInterpolation = { 1, }, actorLevel = 181.69999694824, },
				[31] = { 144, statInterpolation = { 1, }, actorLevel = 191.34300231934, },
				[32] = { 148, statInterpolation = { 1, }, actorLevel = 201.21200561523, },
				[33] = { 152, statInterpolation = { 1, }, actorLevel = 211.30700683594, },
				[34] = { 156, statInterpolation = { 1, }, actorLevel = 221.62800598145, },
				[35] = { 160, statInterpolation = { 1, }, actorLevel = 232.17500305176, },
				[36] = { 164, statInterpolation = { 1, }, actorLevel = 242.94799804688, },
				[37] = { 168, statInterpolation = { 1, }, actorLevel = 253.94700622559, },
				[38] = { 172, statInterpolation = { 1, }, actorLevel = 265.17199707031, },
				[39] = { 176, statInterpolation = { 1, }, actorLevel = 276.62298583984, },
				[40] = { 180, statInterpolation = { 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["ParryPlayer"] = {
	name = "Parry",
	baseTypeName = "Parry",
	fromTree = true,
	color = 4,
	description = "Ready your Buckler to parry the next Strike or Projectile that would Hit you, Blocking the Hit and retaliating with a quick sweep that leaves enemies off balance, causing them to take massively increased Attack damage for a short duration. Parrying causes you to accumulate Heavy Stun buildup. You cannot Evade a Hit you could parry, but Evasion instead grants an equal chance to avoid this Heavy Stun buildup.",
	skillTypes = { [SkillType.RequiresBuckler] = true, [SkillType.UsableWhileMoving] = true, [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Physical] = true, [SkillType.Channel] = true, [SkillType.Duration] = true, [SkillType.NoAttackInPlace] = true, },
	castTime = 1,
	qualityStats = {
	},
	levels = {
		[1] = { attackTime = 750, baseMultiplier = 0.65, critChance = 5, levelRequirement = 0, },
	},
	statSets = {
		[1] = {
			label = "Parry",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "parry",
			statMap = {
				["base_parry_buff_damage_taken_+%_final_to_apply"] = {
					mod("DamageTaken", "MORE", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Debuff", effectName = "Parry" }, { type = "Condition", var = "ParryActive" }),
				},
			},
			baseFlags = {
				attack = true,
				melee = true,
				duration = true,
				shieldAttack = true,
			},
			constantStats = {
				{ "movement_speed_+%_final_while_performing_action", -50 },
				{ "movement_speed_acceleration_+%_per_second_while_performing_action", 160 },
				{ "movement_speed_while_performing_action_locked_duration_%", 50 },
				{ "base_maximum_active_block_distance", 10 },
				{ "base_parry_buff_damage_taken_+%_final_to_apply", 50 },
				{ "base_skill_effect_duration", 2000 },
				{ "active_skill_hit_damage_stun_multiplier_+%_final", 400 },
				{ "active_skill_heavy_stun_decay_after_action_delay_ms", 2000 },
				{ "stun_threshold_+%_final_while_performing_action", -60 },
				{ "active_skill_override_turn_duration_ms", 100 },
			},
			stats = {
				"off_hand_minimum_added_physical_damage_per_5_shield_evasion_rating",
				"off_hand_maximum_added_physical_damage_per_5_shield_evasion_rating",
				"can_perform_skill_while_moving",
				"skill_is_not_considered_a_skill",
				"global_always_hit",
				"active_skill_does_not_decay_heavy_stun_during_action",
				"always_light_stun",
				"quality_display_base_skill_effect_duration_is_gem",
				"base_skill_show_average_damage_instead_of_dps",
				"replace_off_hand_unarmed_attack_stats_with_shield_type",
				"precise_cursor_targeting_uses_contact_point_height_offset",
			},
			levels = {
				[1] = { 0.80000001192093, 1, statInterpolation = { 3, 3, }, actorLevel = 1, },
			},
		},
	}
}
skills["PinnacleOfPowerPlayer"] = {
	name = "Pinnacle of Power",
	baseTypeName = "Pinnacle of Power",
	fromItem = true,
	color = 4,
	description = "Consume all Power Charges to master the elements, gaining Elemental Damage and the ability to apply Elemental Ailments with other damage types. Can only be used while you have maximum Power Charges.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.ConsumesCharges] = true, [SkillType.SkillConsumesPowerChargesOnUse] = true, [SkillType.Instant] = true, [SkillType.Cooldown] = true, [SkillType.Buff] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.HasUsageCondition] = true, [SkillType.NoAttackInPlace] = true, },
	castTime = 0,
	qualityStats = {
		{ "elemental_power_elemental_damage_+%_final_per_power_charge", 0.1 },
	},
	levels = {
		[20] = { storedUses = 1, levelRequirement = 0, cooldown = 4, cost = { Mana = 93, }, },
	},
	statSets = {
		[1] = {
			label = "Pinnacle of Power",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "elemental_power",
			baseFlags = {
				buff = true,
				duration = true,
			},
			constantStats = {
				{ "elemental_power_buff_duration_per_power_charge_ms", 5000 },
				{ "elemental_power_elemental_damage_+%_final_per_power_charge", 8 },
			},
			stats = {
				"base_skill_is_instant",
				"base_deal_no_damage",
				"quality_stat_elemental_power_elemental_damage_+%_final_per_power_charge_is_gem",
			},
			levels = {
				[20] = { actorLevel = 60, },
			},
		},
	}
}
skills["MeleeUnarmedPlayer"] = {
	name = "Punch",
	hidden = true,
	color = 4,
	description = "Perform an Unarmed Strike.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Melee] = true, [SkillType.Area] = true, },
	castTime = 1,
	qualityStats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { baseMultiplier = 1.1, levelRequirement = 3, },
		[3] = { baseMultiplier = 1.21, levelRequirement = 6, },
		[4] = { baseMultiplier = 1.32, levelRequirement = 10, },
		[5] = { baseMultiplier = 1.42, levelRequirement = 14, },
		[6] = { baseMultiplier = 1.53, levelRequirement = 18, },
		[7] = { baseMultiplier = 1.64, levelRequirement = 22, },
		[8] = { baseMultiplier = 1.74, levelRequirement = 26, },
		[9] = { baseMultiplier = 1.82, levelRequirement = 31, },
		[10] = { baseMultiplier = 1.91, levelRequirement = 36, },
		[11] = { baseMultiplier = 2.01, levelRequirement = 41, },
		[12] = { baseMultiplier = 2.11, levelRequirement = 46, },
		[13] = { baseMultiplier = 2.22, levelRequirement = 52, },
		[14] = { baseMultiplier = 2.33, levelRequirement = 58, },
		[15] = { baseMultiplier = 2.44, levelRequirement = 64, },
		[16] = { baseMultiplier = 2.57, levelRequirement = 66, },
		[17] = { baseMultiplier = 2.69, levelRequirement = 72, },
		[18] = { baseMultiplier = 2.83, levelRequirement = 78, },
		[19] = { baseMultiplier = 2.97, levelRequirement = 84, },
		[20] = { baseMultiplier = 3.12, levelRequirement = 90, },
		[21] = { baseMultiplier = 3.27, levelRequirement = 90, },
		[22] = { baseMultiplier = 3.44, levelRequirement = 90, },
		[23] = { baseMultiplier = 3.61, levelRequirement = 90, },
		[24] = { baseMultiplier = 3.79, levelRequirement = 90, },
		[25] = { baseMultiplier = 3.98, levelRequirement = 90, },
		[26] = { baseMultiplier = 4.18, levelRequirement = 90, },
		[27] = { baseMultiplier = 4.39, levelRequirement = 90, },
		[28] = { baseMultiplier = 4.61, levelRequirement = 90, },
		[29] = { baseMultiplier = 4.84, levelRequirement = 90, },
		[30] = { baseMultiplier = 5.08, levelRequirement = 90, },
		[31] = { baseMultiplier = 5.33, levelRequirement = 90, },
		[32] = { baseMultiplier = 5.6, levelRequirement = 90, },
		[33] = { baseMultiplier = 5.88, levelRequirement = 90, },
		[34] = { baseMultiplier = 6.18, levelRequirement = 90, },
		[35] = { baseMultiplier = 6.48, levelRequirement = 90, },
		[36] = { baseMultiplier = 6.81, levelRequirement = 90, },
		[37] = { baseMultiplier = 7.15, levelRequirement = 90, },
		[38] = { baseMultiplier = 7.51, levelRequirement = 90, },
		[39] = { baseMultiplier = 7.88, levelRequirement = 90, },
		[40] = { baseMultiplier = 8.28, levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Punch",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			baseFlags = {
				attack = true,
				area = true,
				melee = true,
			},
			constantStats = {
				{ "melee_conditional_step_distance", 10 },
			},
			stats = {
				"is_area_damage",
				"precise_cursor_targeting_uses_contact_point_height_offset",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["MeleeQuarterstaffPlayer"] = {
	name = "Quarterstaff Strike",
	baseTypeName = "Quarterstaff Strike",
	fromItem = true,
	color = 4,
	description = "Strike with your Quarterstaff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.QuarterstaffSkill] = true, },
	weaponTypes = {
		["Staff"] = true,
	},
	castTime = 1,
	qualityStats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { baseMultiplier = 1.1, levelRequirement = 3, },
		[3] = { baseMultiplier = 1.21, levelRequirement = 6, },
		[4] = { baseMultiplier = 1.32, levelRequirement = 10, },
		[5] = { baseMultiplier = 1.42, levelRequirement = 14, },
		[6] = { baseMultiplier = 1.53, levelRequirement = 18, },
		[7] = { baseMultiplier = 1.64, levelRequirement = 22, },
		[8] = { baseMultiplier = 1.74, levelRequirement = 26, },
		[9] = { baseMultiplier = 1.82, levelRequirement = 31, },
		[10] = { baseMultiplier = 1.91, levelRequirement = 36, },
		[11] = { baseMultiplier = 2.01, levelRequirement = 41, },
		[12] = { baseMultiplier = 2.11, levelRequirement = 46, },
		[13] = { baseMultiplier = 2.22, levelRequirement = 52, },
		[14] = { baseMultiplier = 2.33, levelRequirement = 58, },
		[15] = { baseMultiplier = 2.44, levelRequirement = 64, },
		[16] = { baseMultiplier = 2.57, levelRequirement = 66, },
		[17] = { baseMultiplier = 2.69, levelRequirement = 72, },
		[18] = { baseMultiplier = 2.83, levelRequirement = 78, },
		[19] = { baseMultiplier = 2.97, levelRequirement = 84, },
		[20] = { baseMultiplier = 3.12, levelRequirement = 90, },
		[21] = { baseMultiplier = 3.27, levelRequirement = 90, },
		[22] = { baseMultiplier = 3.44, levelRequirement = 90, },
		[23] = { baseMultiplier = 3.61, levelRequirement = 90, },
		[24] = { baseMultiplier = 3.79, levelRequirement = 90, },
		[25] = { baseMultiplier = 3.98, levelRequirement = 90, },
		[26] = { baseMultiplier = 4.18, levelRequirement = 90, },
		[27] = { baseMultiplier = 4.39, levelRequirement = 90, },
		[28] = { baseMultiplier = 4.61, levelRequirement = 90, },
		[29] = { baseMultiplier = 4.84, levelRequirement = 90, },
		[30] = { baseMultiplier = 5.08, levelRequirement = 90, },
		[31] = { baseMultiplier = 5.33, levelRequirement = 90, },
		[32] = { baseMultiplier = 5.6, levelRequirement = 90, },
		[33] = { baseMultiplier = 5.88, levelRequirement = 90, },
		[34] = { baseMultiplier = 6.18, levelRequirement = 90, },
		[35] = { baseMultiplier = 6.48, levelRequirement = 90, },
		[36] = { baseMultiplier = 6.81, levelRequirement = 90, },
		[37] = { baseMultiplier = 7.15, levelRequirement = 90, },
		[38] = { baseMultiplier = 7.51, levelRequirement = 90, },
		[39] = { baseMultiplier = 7.88, levelRequirement = 90, },
		[40] = { baseMultiplier = 8.28, levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Quarterstaff Strike",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			baseFlags = {
				attack = true,
				melee = true,
				area = true,
			},
			constantStats = {
				{ "melee_conditional_step_distance", 10 },
			},
			stats = {
				"is_area_damage",
				"precise_cursor_targeting_uses_contact_point_height_offset",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["ShieldBlockPlayer"] = {
	name = "Raise Shield",
	baseTypeName = "Raise Shield",
	fromItem = true,
	color = 4,
	description = "Raise your Shield to Block all incoming Blockable hits. Release immediately after Blocking when an enemy is close to perform a Shield Bash, damaging and Stunning enemies. While your Shield is raised you cannot be Light Stunned by hits you Block, but Blocking too much damage may Heavy Stun you. You cannot Evade while your Shield is raised, but Evasion instead grants an equal chance to avoid this Heavy Stun buildup.",
	skillTypes = { [SkillType.Channel] = true, [SkillType.RequiresShield] = true, [SkillType.UsableWhileMoving] = true, [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Physical] = true, [SkillType.Melee] = true, [SkillType.NoAttackInPlace] = true, [SkillType.NoAttackInPlace] = true, },
	castTime = 1,
	qualityStats = {
	},
	levels = {
		[1] = { attackTime = 550, baseMultiplier = 0.8, critChance = 5, levelRequirement = 0, },
	},
	statSets = {
		[1] = {
			label = "Raise Shield",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "shield_block",
			baseFlags = {
				attack = true,
				area = true,
				shieldAttack = true,
				melee = true,
			},
			constantStats = {
				{ "movement_speed_+%_final_while_performing_action", -50 },
				{ "movement_speed_acceleration_+%_per_second_while_performing_action", 160 },
				{ "movement_speed_while_performing_action_locked_duration_%", 50 },
				{ "channel_skill_end_animation_duration_override_ms", 35 },
				{ "active_block_light_stun_threshold_+%_final", 50 },
				{ "active_skill_heavy_stun_decay_after_action_delay_ms", 2000 },
				{ "skill_animation_duration_multiplier_override", 4 },
				{ "base_minimum_channel_time_ms", 250 },
				{ "raise_shield_base_retaliation_duration_ms", 1000 },
				{ "active_skill_hit_damage_stun_multiplier_+%_final", 600 },
				{ "melee_strike_bonus_attack_distance", 14 },
				{ "off_hand_minimum_added_physical_damage_per_5_shield_armour", 3 },
				{ "off_hand_maximum_added_physical_damage_per_5_shield_armour", 4 },
				{ "active_skill_override_turn_duration_ms", 100 },
			},
			stats = {
				"can_perform_skill_while_moving",
				"global_always_hit",
				"active_skill_does_not_decay_heavy_stun_during_action",
				"skill_is_not_considered_a_skill",
				"always_light_stun",
				"base_skill_show_average_damage_instead_of_dps",
				"replace_off_hand_unarmed_attack_stats_with_shield_type",
				"is_area_damage",
				"precise_cursor_targeting_uses_contact_point_height_offset",
			},
			levels = {
				[1] = { actorLevel = 1, },
			},
		},
	}
}
skills["RitualSacrificePlayer"] = {
	name = "Ritual Sacrifice",
	baseTypeName = "Ritual Sacrifice",
	fromTree = true,
	color = 4,
	description = "Sacrifice the Corpse of a Rare Monster to grant you its Modifiers for a duration.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Cooldown] = true, [SkillType.TargetsDestructibleRareCorpses] = true, [SkillType.NoAttackInPlace] = true, },
	castTime = 5,
	qualityStats = {
		{ "base_skill_effect_duration", 100 },
	},
	levels = {
		[1] = { levelRequirement = 0, cost = { Mana = 20, }, },
		[2] = { levelRequirement = 3, cost = { Mana = 20, }, },
		[3] = { levelRequirement = 6, cost = { Mana = 20, }, },
		[4] = { levelRequirement = 10, cost = { Mana = 20, }, },
		[5] = { levelRequirement = 14, cost = { Mana = 20, }, },
		[6] = { levelRequirement = 18, cost = { Mana = 20, }, },
		[7] = { levelRequirement = 22, cost = { Mana = 20, }, },
		[8] = { levelRequirement = 26, cost = { Mana = 20, }, },
		[9] = { levelRequirement = 31, cost = { Mana = 20, }, },
		[10] = { levelRequirement = 36, cost = { Mana = 20, }, },
		[11] = { levelRequirement = 41, cost = { Mana = 20, }, },
		[12] = { levelRequirement = 46, cost = { Mana = 20, }, },
		[13] = { levelRequirement = 52, cost = { Mana = 20, }, },
		[14] = { levelRequirement = 58, cost = { Mana = 20, }, },
		[15] = { levelRequirement = 64, cost = { Mana = 20, }, },
		[16] = { levelRequirement = 66, cost = { Mana = 20, }, },
		[17] = { levelRequirement = 72, cost = { Mana = 20, }, },
		[18] = { levelRequirement = 78, cost = { Mana = 20, }, },
		[19] = { levelRequirement = 84, cost = { Mana = 20, }, },
		[20] = { storedUses = 1, levelRequirement = 90, cooldown = 8, cost = { Mana = 20, }, },
		[21] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[22] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[23] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[24] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[25] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[26] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[27] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[28] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[29] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[30] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[31] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[32] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[33] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[34] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[35] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[36] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[37] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[38] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[39] = { levelRequirement = 90, cost = { Mana = 20, }, },
		[40] = { levelRequirement = 90, cost = { Mana = 20, }, },
	},
	statSets = {
		[1] = {
			label = "Ritual Sacrifice",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "ritual_sacrifice",
			baseFlags = {
				attack = true,
				area = true,
			},
			constantStats = {
				{ "head_hunt_%_life_to_remove_on_self_stab", 20 },
				{ "movement_speed_+%_final_while_performing_action", -70 },
				{ "movement_speed_acceleration_+%_per_second_while_performing_action", 160 },
				{ "movement_speed_while_performing_action_locked_duration_%", 50 },
			},
			stats = {
				"base_skill_effect_duration",
				"can_perform_skill_while_moving",
				"quality_display_base_skill_effect_duration_is_gem",
			},
			notMinionStat = {
				"base_skill_effect_duration",
			},
			levels = {
				[1] = { 15000, statInterpolation = { 1, }, actorLevel = 1, },
				[2] = { 15250, statInterpolation = { 1, }, actorLevel = 3.4519999027252, },
				[3] = { 15500, statInterpolation = { 1, }, actorLevel = 6.7670001983643, },
				[4] = { 15750, statInterpolation = { 1, }, actorLevel = 10.307999610901, },
				[5] = { 16000, statInterpolation = { 1, }, actorLevel = 14.074999809265, },
				[6] = { 16250, statInterpolation = { 1, }, actorLevel = 18.068000793457, },
				[7] = { 16500, statInterpolation = { 1, }, actorLevel = 22.287000656128, },
				[8] = { 16750, statInterpolation = { 1, }, actorLevel = 26.732000350952, },
				[9] = { 17000, statInterpolation = { 1, }, actorLevel = 31.40299987793, },
				[10] = { 17250, statInterpolation = { 1, }, actorLevel = 36.299999237061, },
				[11] = { 17500, statInterpolation = { 1, }, actorLevel = 41.423000335693, },
				[12] = { 17750, statInterpolation = { 1, }, actorLevel = 46.771999359131, },
				[13] = { 18000, statInterpolation = { 1, }, actorLevel = 52.34700012207, },
				[14] = { 18250, statInterpolation = { 1, }, actorLevel = 58.147998809814, },
				[15] = { 18500, statInterpolation = { 1, }, actorLevel = 64.175003051758, },
				[16] = { 18750, statInterpolation = { 1, }, actorLevel = 70.428001403809, },
				[17] = { 19000, statInterpolation = { 1, }, actorLevel = 76.906997680664, },
				[18] = { 19250, statInterpolation = { 1, }, actorLevel = 83.611999511719, },
				[19] = { 19500, statInterpolation = { 1, }, actorLevel = 90.542999267578, },
				[20] = { 19750, statInterpolation = { 1, }, actorLevel = 97.699996948242, },
				[21] = { 20000, statInterpolation = { 1, }, actorLevel = 105.08300018311, },
				[22] = { 20250, statInterpolation = { 1, }, actorLevel = 112.69200134277, },
				[23] = { 20500, statInterpolation = { 1, }, actorLevel = 120.52700042725, },
				[24] = { 20750, statInterpolation = { 1, }, actorLevel = 128.58799743652, },
				[25] = { 21000, statInterpolation = { 1, }, actorLevel = 136.875, },
				[26] = { 21250, statInterpolation = { 1, }, actorLevel = 145.38800048828, },
				[27] = { 21500, statInterpolation = { 1, }, actorLevel = 154.12699890137, },
				[28] = { 21750, statInterpolation = { 1, }, actorLevel = 163.09199523926, },
				[29] = { 22000, statInterpolation = { 1, }, actorLevel = 172.28300476074, },
				[30] = { 22250, statInterpolation = { 1, }, actorLevel = 181.69999694824, },
				[31] = { 22375, statInterpolation = { 1, }, actorLevel = 191.34300231934, },
				[32] = { 22500, statInterpolation = { 1, }, actorLevel = 201.21200561523, },
				[33] = { 22625, statInterpolation = { 1, }, actorLevel = 211.30700683594, },
				[34] = { 22750, statInterpolation = { 1, }, actorLevel = 221.62800598145, },
				[35] = { 22875, statInterpolation = { 1, }, actorLevel = 232.17500305176, },
				[36] = { 23000, statInterpolation = { 1, }, actorLevel = 242.94799804688, },
				[37] = { 23125, statInterpolation = { 1, }, actorLevel = 253.94700622559, },
				[38] = { 23250, statInterpolation = { 1, }, actorLevel = 265.17199707031, },
				[39] = { 23375, statInterpolation = { 1, }, actorLevel = 276.62298583984, },
				[40] = { 23500, statInterpolation = { 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["ShatteringConcoctionPlayer"] = {
	name = "Shattering Concoction",
	baseTypeName = "Shattering Concoction",
	fromTree = true,
	color = 4,
	description = "Consume charges from your Mana Flask to throw a flask that explodes, dealing Cold Attack damage in an area and inflicting Exposure.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.Cold] = true, [SkillType.UsableWhileMoving] = true, [SkillType.ProjectileNoCollision] = true, [SkillType.NoAttackInPlace] = true, [SkillType.GroundTargetedProjectile] = true, },
	weaponTypes = {
		["None"] = true,
	},
	castTime = 1,
	qualityStats = {
		{ "freeze_duration_+%", 1 },
	},
	levels = {
		[1] = { critChance = 11, baseMultiplier = 0.7, levelRequirement = 0, cost = { Mana = 0, }, },
		[2] = { critChance = 11, baseMultiplier = 0.77, levelRequirement = 3, cost = { Mana = 0, }, },
		[3] = { critChance = 11, baseMultiplier = 0.84, levelRequirement = 6, cost = { Mana = 0, }, },
		[4] = { critChance = 11, baseMultiplier = 0.92, levelRequirement = 10, cost = { Mana = 0, }, },
		[5] = { critChance = 11, baseMultiplier = 0.99, levelRequirement = 14, cost = { Mana = 0, }, },
		[6] = { critChance = 11, baseMultiplier = 1.05, levelRequirement = 18, cost = { Mana = 0, }, },
		[7] = { critChance = 11, baseMultiplier = 1.12, levelRequirement = 22, cost = { Mana = 0, }, },
		[8] = { critChance = 11, baseMultiplier = 1.18, levelRequirement = 26, cost = { Mana = 0, }, },
		[9] = { critChance = 11, baseMultiplier = 1.23, levelRequirement = 31, cost = { Mana = 0, }, },
		[10] = { critChance = 11, baseMultiplier = 1.28, levelRequirement = 36, cost = { Mana = 0, }, },
		[11] = { critChance = 11, baseMultiplier = 1.34, levelRequirement = 41, cost = { Mana = 0, }, },
		[12] = { critChance = 11, baseMultiplier = 1.39, levelRequirement = 46, cost = { Mana = 0, }, },
		[13] = { critChance = 11, baseMultiplier = 1.44, levelRequirement = 52, cost = { Mana = 0, }, },
		[14] = { critChance = 11, baseMultiplier = 1.5, levelRequirement = 58, cost = { Mana = 0, }, },
		[15] = { critChance = 11, baseMultiplier = 1.55, levelRequirement = 64, cost = { Mana = 0, }, },
		[16] = { critChance = 11, baseMultiplier = 1.61, levelRequirement = 66, cost = { Mana = 0, }, },
		[17] = { critChance = 11, baseMultiplier = 1.67, levelRequirement = 72, cost = { Mana = 0, }, },
		[18] = { critChance = 11, baseMultiplier = 1.73, levelRequirement = 78, cost = { Mana = 0, }, },
		[19] = { critChance = 11, baseMultiplier = 1.79, levelRequirement = 84, cost = { Mana = 0, }, },
		[20] = { critChance = 11, baseMultiplier = 1.85, levelRequirement = 90, cost = { Mana = 0, }, },
		[21] = { critChance = 11, baseMultiplier = 1.91, levelRequirement = 90, cost = { Mana = 0, }, },
		[22] = { critChance = 11, baseMultiplier = 1.97, levelRequirement = 90, cost = { Mana = 0, }, },
		[23] = { critChance = 11, baseMultiplier = 2.04, levelRequirement = 90, cost = { Mana = 0, }, },
		[24] = { critChance = 11, baseMultiplier = 2.1, levelRequirement = 90, cost = { Mana = 0, }, },
		[25] = { critChance = 11, baseMultiplier = 2.17, levelRequirement = 90, cost = { Mana = 0, }, },
		[26] = { critChance = 11, baseMultiplier = 2.24, levelRequirement = 90, cost = { Mana = 0, }, },
		[27] = { critChance = 11, baseMultiplier = 2.32, levelRequirement = 90, cost = { Mana = 0, }, },
		[28] = { critChance = 11, baseMultiplier = 2.4, levelRequirement = 90, cost = { Mana = 0, }, },
		[29] = { critChance = 11, baseMultiplier = 2.48, levelRequirement = 90, cost = { Mana = 0, }, },
		[30] = { critChance = 11, baseMultiplier = 2.56, levelRequirement = 90, cost = { Mana = 0, }, },
		[31] = { critChance = 11, baseMultiplier = 2.64, levelRequirement = 90, cost = { Mana = 0, }, },
		[32] = { critChance = 11, baseMultiplier = 2.73, levelRequirement = 90, cost = { Mana = 0, }, },
		[33] = { critChance = 11, baseMultiplier = 2.82, levelRequirement = 90, cost = { Mana = 0, }, },
		[34] = { critChance = 11, baseMultiplier = 2.91, levelRequirement = 90, cost = { Mana = 0, }, },
		[35] = { critChance = 11, baseMultiplier = 3.01, levelRequirement = 90, cost = { Mana = 0, }, },
		[36] = { critChance = 11, baseMultiplier = 3.11, levelRequirement = 90, cost = { Mana = 0, }, },
		[37] = { critChance = 11, baseMultiplier = 3.21, levelRequirement = 90, cost = { Mana = 0, }, },
		[38] = { critChance = 11, baseMultiplier = 3.32, levelRequirement = 90, cost = { Mana = 0, }, },
		[39] = { critChance = 11, baseMultiplier = 3.43, levelRequirement = 90, cost = { Mana = 0, }, },
		[40] = { critChance = 11, baseMultiplier = 3.55, levelRequirement = 90, cost = { Mana = 0, }, },
	},
	statSets = {
		[1] = {
			label = "Shattering Concoction",
			baseEffectiveness = 3.9000000953674,
			incrementalEffectiveness = 0.27349999547005,
			statDescriptionScope = "shattering_concoction",
			statMap = {
				["flask_throw_cold_exposure_ms"] = {
					mod("ColdExposureChance", "BASE", nil),
					value = 100,
				},
			},
			baseFlags = {
				attack = true,
				projectile = true,
				duration = true,
				unarmed = true,
				area = true,
			},
			constantStats = {
				{ "flask_throw_base_charges_used", 5 },
				{ "base_number_of_projectiles", 1 },
				{ "active_skill_base_area_of_effect_radius", 18 },
				{ "throw_flask_effects_type", 1 },
				{ "movement_speed_+%_final_while_performing_action", -70 },
				{ "movement_speed_acceleration_+%_per_second_while_performing_action", 160 },
				{ "movement_speed_while_performing_action_locked_duration_%", 50 },
				{ "main_hand_base_weapon_attack_duration_ms", 714 },
			},
			stats = {
				"main_hand_weapon_minimum_cold_damage",
				"main_hand_weapon_maximum_cold_damage",
				"base_is_projectile",
				"projectile_behaviour_only_explode",
				"can_perform_skill_while_moving",
				"replace_main_hand_unarmed_attack_stats_with_nothing_type",
				"is_area_damage",
				"has_freeze_cull",
				"inflict_all_exposure_on_hit",
				"active_skill_show_freeze_range",
			},
			levels = {
				[1] = { 12, 18, statInterpolation = { 1, 1, }, actorLevel = 1, },
				[2] = { 20, 30, statInterpolation = { 1, 1, }, actorLevel = 3.4519999027252, },
				[3] = { 31, 47, statInterpolation = { 1, 1, }, actorLevel = 6.7670001983643, },
				[4] = { 43, 64, statInterpolation = { 1, 1, }, actorLevel = 10.307999610901, },
				[5] = { 55, 83, statInterpolation = { 1, 1, }, actorLevel = 14.074999809265, },
				[6] = { 69, 103, statInterpolation = { 1, 1, }, actorLevel = 18.068000793457, },
				[7] = { 83, 124, statInterpolation = { 1, 1, }, actorLevel = 22.287000656128, },
				[8] = { 97, 146, statInterpolation = { 1, 1, }, actorLevel = 26.732000350952, },
				[9] = { 113, 169, statInterpolation = { 1, 1, }, actorLevel = 31.40299987793, },
				[10] = { 129, 194, statInterpolation = { 1, 1, }, actorLevel = 36.299999237061, },
				[11] = { 146, 219, statInterpolation = { 1, 1, }, actorLevel = 41.423000335693, },
				[12] = { 164, 246, statInterpolation = { 1, 1, }, actorLevel = 46.771999359131, },
				[13] = { 182, 274, statInterpolation = { 1, 1, }, actorLevel = 52.34700012207, },
				[14] = { 202, 302, statInterpolation = { 1, 1, }, actorLevel = 58.147998809814, },
				[15] = { 222, 332, statInterpolation = { 1, 1, }, actorLevel = 64.175003051758, },
				[16] = { 242, 363, statInterpolation = { 1, 1, }, actorLevel = 70.428001403809, },
				[17] = { 264, 396, statInterpolation = { 1, 1, }, actorLevel = 76.906997680664, },
				[18] = { 286, 429, statInterpolation = { 1, 1, }, actorLevel = 83.611999511719, },
				[19] = { 309, 463, statInterpolation = { 1, 1, }, actorLevel = 90.542999267578, },
				[20] = { 333, 499, statInterpolation = { 1, 1, }, actorLevel = 97.699996948242, },
				[21] = { 357, 536, statInterpolation = { 1, 1, }, actorLevel = 105.08300018311, },
				[22] = { 382, 574, statInterpolation = { 1, 1, }, actorLevel = 112.69200134277, },
				[23] = { 408, 613, statInterpolation = { 1, 1, }, actorLevel = 120.52700042725, },
				[24] = { 435, 653, statInterpolation = { 1, 1, }, actorLevel = 128.58799743652, },
				[25] = { 463, 694, statInterpolation = { 1, 1, }, actorLevel = 136.875, },
				[26] = { 491, 736, statInterpolation = { 1, 1, }, actorLevel = 145.38800048828, },
				[27] = { 520, 780, statInterpolation = { 1, 1, }, actorLevel = 154.12699890137, },
				[28] = { 550, 824, statInterpolation = { 1, 1, }, actorLevel = 163.09199523926, },
				[29] = { 580, 870, statInterpolation = { 1, 1, }, actorLevel = 172.28300476074, },
				[30] = { 611, 917, statInterpolation = { 1, 1, }, actorLevel = 181.69999694824, },
				[31] = { 643, 965, statInterpolation = { 1, 1, }, actorLevel = 191.34300231934, },
				[32] = { 676, 1014, statInterpolation = { 1, 1, }, actorLevel = 201.21200561523, },
				[33] = { 709, 1064, statInterpolation = { 1, 1, }, actorLevel = 211.30700683594, },
				[34] = { 744, 1115, statInterpolation = { 1, 1, }, actorLevel = 221.62800598145, },
				[35] = { 779, 1168, statInterpolation = { 1, 1, }, actorLevel = 232.17500305176, },
				[36] = { 814, 1221, statInterpolation = { 1, 1, }, actorLevel = 242.94799804688, },
				[37] = { 851, 1276, statInterpolation = { 1, 1, }, actorLevel = 253.94700622559, },
				[38] = { 888, 1332, statInterpolation = { 1, 1, }, actorLevel = 265.17199707031, },
				[39] = { 926, 1389, statInterpolation = { 1, 1, }, actorLevel = 276.62298583984, },
				[40] = { 965, 1447, statInterpolation = { 1, 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["SorceryWardPlayer"] = {
	name = "Sorcery Ward",
	baseTypeName = "Sorcery Ward",
	fromTree = true,
	color = 4,
	description = "Passively manifests a protective barrier which takes Elemental Damage from Hits for you until depleted. The barrier instantly recharges to its full value a short time after it stops taking damage or is fully depleted.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Aegis] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.Buff] = true, [SkillType.OngoingSkill] = true, [SkillType.Persistent] = true, [SkillType.HasReservation] = true, },
	castTime = 1,
	qualityStats = {
		{ "aegis_unique_shield_max_value_from_%_armour_evasion", 0.25 },
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 3, },
		[3] = { levelRequirement = 6, },
		[4] = { levelRequirement = 10, },
		[5] = { levelRequirement = 14, },
		[6] = { levelRequirement = 18, },
		[7] = { levelRequirement = 22, },
		[8] = { levelRequirement = 26, },
		[9] = { levelRequirement = 31, },
		[10] = { levelRequirement = 36, },
		[11] = { levelRequirement = 41, },
		[12] = { levelRequirement = 46, },
		[13] = { levelRequirement = 52, },
		[14] = { levelRequirement = 58, },
		[15] = { levelRequirement = 64, },
		[16] = { levelRequirement = 66, },
		[17] = { levelRequirement = 72, },
		[18] = { levelRequirement = 78, },
		[19] = { levelRequirement = 84, },
		[20] = { levelRequirement = 90, },
		[21] = { levelRequirement = 90, },
		[22] = { levelRequirement = 90, },
		[23] = { levelRequirement = 90, },
		[24] = { levelRequirement = 90, },
		[25] = { levelRequirement = 90, },
		[26] = { levelRequirement = 90, },
		[27] = { levelRequirement = 90, },
		[28] = { levelRequirement = 90, },
		[29] = { levelRequirement = 90, },
		[30] = { levelRequirement = 90, },
		[31] = { levelRequirement = 90, },
		[32] = { levelRequirement = 90, },
		[33] = { levelRequirement = 90, },
		[34] = { levelRequirement = 90, },
		[35] = { levelRequirement = 90, },
		[36] = { levelRequirement = 90, },
		[37] = { levelRequirement = 90, },
		[38] = { levelRequirement = 90, },
		[39] = { levelRequirement = 90, },
		[40] = { levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Sorcery Ward",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "sorcery_ward",
			baseFlags = {
			},
			constantStats = {
				{ "skill_desired_amount_override", 1 },
				{ "active_skill_display_aegis_variation", 4 },
				{ "aegis_unique_shield_max_value_from_%_armour_evasion", 30 },
			},
			stats = {
				"aegis_recharge_delay_ms",
				"base_deal_no_damage",
				"display_statset_hide_usage_stats",
			},
			levels = {
				[1] = { 8000, statInterpolation = { 1, }, actorLevel = 1, },
				[2] = { 7900, statInterpolation = { 1, }, actorLevel = 3.4519999027252, },
				[3] = { 7800, statInterpolation = { 1, }, actorLevel = 6.7670001983643, },
				[4] = { 7700, statInterpolation = { 1, }, actorLevel = 10.307999610901, },
				[5] = { 7600, statInterpolation = { 1, }, actorLevel = 14.074999809265, },
				[6] = { 7500, statInterpolation = { 1, }, actorLevel = 18.068000793457, },
				[7] = { 7400, statInterpolation = { 1, }, actorLevel = 22.287000656128, },
				[8] = { 7300, statInterpolation = { 1, }, actorLevel = 26.732000350952, },
				[9] = { 7200, statInterpolation = { 1, }, actorLevel = 31.40299987793, },
				[10] = { 7100, statInterpolation = { 1, }, actorLevel = 36.299999237061, },
				[11] = { 7000, statInterpolation = { 1, }, actorLevel = 41.423000335693, },
				[12] = { 6900, statInterpolation = { 1, }, actorLevel = 46.771999359131, },
				[13] = { 6800, statInterpolation = { 1, }, actorLevel = 52.34700012207, },
				[14] = { 6700, statInterpolation = { 1, }, actorLevel = 58.147998809814, },
				[15] = { 6600, statInterpolation = { 1, }, actorLevel = 64.175003051758, },
				[16] = { 6500, statInterpolation = { 1, }, actorLevel = 70.428001403809, },
				[17] = { 6400, statInterpolation = { 1, }, actorLevel = 76.906997680664, },
				[18] = { 6300, statInterpolation = { 1, }, actorLevel = 83.611999511719, },
				[19] = { 6200, statInterpolation = { 1, }, actorLevel = 90.542999267578, },
				[20] = { 6100, statInterpolation = { 1, }, actorLevel = 97.699996948242, },
				[21] = { 6000, statInterpolation = { 1, }, actorLevel = 105.08300018311, },
				[22] = { 5900, statInterpolation = { 1, }, actorLevel = 112.69200134277, },
				[23] = { 5800, statInterpolation = { 1, }, actorLevel = 120.52700042725, },
				[24] = { 5700, statInterpolation = { 1, }, actorLevel = 128.58799743652, },
				[25] = { 5600, statInterpolation = { 1, }, actorLevel = 136.875, },
				[26] = { 5500, statInterpolation = { 1, }, actorLevel = 145.38800048828, },
				[27] = { 5400, statInterpolation = { 1, }, actorLevel = 154.12699890137, },
				[28] = { 5300, statInterpolation = { 1, }, actorLevel = 163.09199523926, },
				[29] = { 5200, statInterpolation = { 1, }, actorLevel = 172.28300476074, },
				[30] = { 5100, statInterpolation = { 1, }, actorLevel = 181.69999694824, },
				[31] = { 5050, statInterpolation = { 1, }, actorLevel = 191.34300231934, },
				[32] = { 5000, statInterpolation = { 1, }, actorLevel = 201.21200561523, },
				[33] = { 4950, statInterpolation = { 1, }, actorLevel = 211.30700683594, },
				[34] = { 4900, statInterpolation = { 1, }, actorLevel = 221.62800598145, },
				[35] = { 4850, statInterpolation = { 1, }, actorLevel = 232.17500305176, },
				[36] = { 4800, statInterpolation = { 1, }, actorLevel = 242.94799804688, },
				[37] = { 4750, statInterpolation = { 1, }, actorLevel = 253.94700622559, },
				[38] = { 4700, statInterpolation = { 1, }, actorLevel = 265.17199707031, },
				[39] = { 4650, statInterpolation = { 1, }, actorLevel = 276.62298583984, },
				[40] = { 4600, statInterpolation = { 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["MeleeSpearOffHandPlayer"] = {
	name = "Spear Stab",
	baseTypeName = "Spear Stab",
	fromItem = true,
	color = 4,
	description = "Strike with your Spear.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Spear] = true, },
	weaponTypes = {
		["Spear"] = true,
	},
	castTime = 1,
	qualityStats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { baseMultiplier = 1.1, levelRequirement = 3, },
		[3] = { baseMultiplier = 1.21, levelRequirement = 6, },
		[4] = { baseMultiplier = 1.32, levelRequirement = 10, },
		[5] = { baseMultiplier = 1.42, levelRequirement = 14, },
		[6] = { baseMultiplier = 1.53, levelRequirement = 18, },
		[7] = { baseMultiplier = 1.64, levelRequirement = 22, },
		[8] = { baseMultiplier = 1.74, levelRequirement = 26, },
		[9] = { baseMultiplier = 1.82, levelRequirement = 31, },
		[10] = { baseMultiplier = 1.91, levelRequirement = 36, },
		[11] = { baseMultiplier = 2.01, levelRequirement = 41, },
		[12] = { baseMultiplier = 2.11, levelRequirement = 46, },
		[13] = { baseMultiplier = 2.22, levelRequirement = 52, },
		[14] = { baseMultiplier = 2.33, levelRequirement = 58, },
		[15] = { baseMultiplier = 2.44, levelRequirement = 64, },
		[16] = { baseMultiplier = 2.57, levelRequirement = 66, },
		[17] = { baseMultiplier = 2.69, levelRequirement = 72, },
		[18] = { baseMultiplier = 2.83, levelRequirement = 78, },
		[19] = { baseMultiplier = 2.97, levelRequirement = 84, },
		[20] = { baseMultiplier = 3.12, levelRequirement = 90, },
		[21] = { baseMultiplier = 3.27, levelRequirement = 90, },
		[22] = { baseMultiplier = 3.44, levelRequirement = 90, },
		[23] = { baseMultiplier = 3.61, levelRequirement = 90, },
		[24] = { baseMultiplier = 3.79, levelRequirement = 90, },
		[25] = { baseMultiplier = 3.98, levelRequirement = 90, },
		[26] = { baseMultiplier = 4.18, levelRequirement = 90, },
		[27] = { baseMultiplier = 4.39, levelRequirement = 90, },
		[28] = { baseMultiplier = 4.61, levelRequirement = 90, },
		[29] = { baseMultiplier = 4.84, levelRequirement = 90, },
		[30] = { baseMultiplier = 5.08, levelRequirement = 90, },
		[31] = { baseMultiplier = 5.33, levelRequirement = 90, },
		[32] = { baseMultiplier = 5.6, levelRequirement = 90, },
		[33] = { baseMultiplier = 5.88, levelRequirement = 90, },
		[34] = { baseMultiplier = 6.18, levelRequirement = 90, },
		[35] = { baseMultiplier = 6.48, levelRequirement = 90, },
		[36] = { baseMultiplier = 6.81, levelRequirement = 90, },
		[37] = { baseMultiplier = 7.15, levelRequirement = 90, },
		[38] = { baseMultiplier = 7.51, levelRequirement = 90, },
		[39] = { baseMultiplier = 7.88, levelRequirement = 90, },
		[40] = { baseMultiplier = 8.28, levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Spear Stab",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			baseFlags = {
				attack = true,
				melee = true,
				area = true,
			},
			constantStats = {
				{ "melee_conditional_step_distance", 15 },
			},
			stats = {
				"is_area_damage",
				"precise_cursor_targeting_uses_contact_point_height_offset",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["MeleeSpearPlayer"] = {
	name = "Spear Stab",
	baseTypeName = "Spear Stab",
	fromItem = true,
	color = 4,
	description = "Strike with your Spear.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Spear] = true, },
	weaponTypes = {
		["Spear"] = true,
	},
	castTime = 1,
	qualityStats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { baseMultiplier = 1.1, levelRequirement = 3, },
		[3] = { baseMultiplier = 1.21, levelRequirement = 6, },
		[4] = { baseMultiplier = 1.32, levelRequirement = 10, },
		[5] = { baseMultiplier = 1.42, levelRequirement = 14, },
		[6] = { baseMultiplier = 1.53, levelRequirement = 18, },
		[7] = { baseMultiplier = 1.64, levelRequirement = 22, },
		[8] = { baseMultiplier = 1.74, levelRequirement = 26, },
		[9] = { baseMultiplier = 1.82, levelRequirement = 31, },
		[10] = { baseMultiplier = 1.91, levelRequirement = 36, },
		[11] = { baseMultiplier = 2.01, levelRequirement = 41, },
		[12] = { baseMultiplier = 2.11, levelRequirement = 46, },
		[13] = { baseMultiplier = 2.22, levelRequirement = 52, },
		[14] = { baseMultiplier = 2.33, levelRequirement = 58, },
		[15] = { baseMultiplier = 2.44, levelRequirement = 64, },
		[16] = { baseMultiplier = 2.57, levelRequirement = 66, },
		[17] = { baseMultiplier = 2.69, levelRequirement = 72, },
		[18] = { baseMultiplier = 2.83, levelRequirement = 78, },
		[19] = { baseMultiplier = 2.97, levelRequirement = 84, },
		[20] = { baseMultiplier = 3.12, levelRequirement = 90, },
		[21] = { baseMultiplier = 3.27, levelRequirement = 90, },
		[22] = { baseMultiplier = 3.44, levelRequirement = 90, },
		[23] = { baseMultiplier = 3.61, levelRequirement = 90, },
		[24] = { baseMultiplier = 3.79, levelRequirement = 90, },
		[25] = { baseMultiplier = 3.98, levelRequirement = 90, },
		[26] = { baseMultiplier = 4.18, levelRequirement = 90, },
		[27] = { baseMultiplier = 4.39, levelRequirement = 90, },
		[28] = { baseMultiplier = 4.61, levelRequirement = 90, },
		[29] = { baseMultiplier = 4.84, levelRequirement = 90, },
		[30] = { baseMultiplier = 5.08, levelRequirement = 90, },
		[31] = { baseMultiplier = 5.33, levelRequirement = 90, },
		[32] = { baseMultiplier = 5.6, levelRequirement = 90, },
		[33] = { baseMultiplier = 5.88, levelRequirement = 90, },
		[34] = { baseMultiplier = 6.18, levelRequirement = 90, },
		[35] = { baseMultiplier = 6.48, levelRequirement = 90, },
		[36] = { baseMultiplier = 6.81, levelRequirement = 90, },
		[37] = { baseMultiplier = 7.15, levelRequirement = 90, },
		[38] = { baseMultiplier = 7.51, levelRequirement = 90, },
		[39] = { baseMultiplier = 7.88, levelRequirement = 90, },
		[40] = { baseMultiplier = 8.28, levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Spear Stab",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			baseFlags = {
				attack = true,
				melee = true,
				area = true,
			},
			constantStats = {
				{ "melee_conditional_step_distance", 15 },
				{ "melee_range_+", 4 },
			},
			stats = {
				"is_area_damage",
				"precise_cursor_targeting_uses_contact_point_height_offset",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["SpearThrowPlayer"] = {
	name = "Spear Throw",
	baseTypeName = "Spear Throw",
	fromItem = true,
	color = 4,
	description = "Hurl your Spear with force. Consumes a Frenzy Charge if you have one to cause the Spear to explode at the end of its flight.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.ProjectileSpeed] = true, [SkillType.RangedAttack] = true, [SkillType.UsableWhileMoving] = true, [SkillType.Barrageable] = true, [SkillType.Spear] = true, [SkillType.UsableWhileMounted] = true, [SkillType.ConsumesCharges] = true, [SkillType.SkillConsumesFrenzyChargesOnUse] = true, [SkillType.Area] = true, [SkillType.NoAttackInPlace] = true, },
	weaponTypes = {
		["Spear"] = true,
	},
	castTime = 1,
	qualityStats = {
	},
	levels = {
		[1] = { attackSpeedMultiplier = -30, baseMultiplier = 1.25, levelRequirement = 0, },
		[2] = { attackSpeedMultiplier = -30, baseMultiplier = 1.38, levelRequirement = 3, },
		[3] = { attackSpeedMultiplier = -30, baseMultiplier = 1.51, levelRequirement = 6, },
		[4] = { attackSpeedMultiplier = -30, baseMultiplier = 1.65, levelRequirement = 10, },
		[5] = { attackSpeedMultiplier = -30, baseMultiplier = 1.78, levelRequirement = 14, },
		[6] = { attackSpeedMultiplier = -30, baseMultiplier = 1.91, levelRequirement = 18, },
		[7] = { attackSpeedMultiplier = -30, baseMultiplier = 2.05, levelRequirement = 22, },
		[8] = { attackSpeedMultiplier = -30, baseMultiplier = 2.17, levelRequirement = 26, },
		[9] = { attackSpeedMultiplier = -30, baseMultiplier = 2.28, levelRequirement = 31, },
		[10] = { attackSpeedMultiplier = -30, baseMultiplier = 2.39, levelRequirement = 36, },
		[11] = { attackSpeedMultiplier = -30, baseMultiplier = 2.51, levelRequirement = 41, },
		[12] = { attackSpeedMultiplier = -30, baseMultiplier = 2.64, levelRequirement = 46, },
		[13] = { attackSpeedMultiplier = -30, baseMultiplier = 2.77, levelRequirement = 52, },
		[14] = { attackSpeedMultiplier = -30, baseMultiplier = 2.91, levelRequirement = 58, },
		[15] = { attackSpeedMultiplier = -30, baseMultiplier = 3.05, levelRequirement = 64, },
		[16] = { attackSpeedMultiplier = -30, baseMultiplier = 3.21, levelRequirement = 66, },
		[17] = { attackSpeedMultiplier = -30, baseMultiplier = 3.37, levelRequirement = 72, },
		[18] = { attackSpeedMultiplier = -30, baseMultiplier = 3.54, levelRequirement = 78, },
		[19] = { attackSpeedMultiplier = -30, baseMultiplier = 3.71, levelRequirement = 84, },
		[20] = { attackSpeedMultiplier = -30, baseMultiplier = 3.9, levelRequirement = 90, },
		[21] = { attackSpeedMultiplier = -30, baseMultiplier = 4.09, levelRequirement = 90, },
		[22] = { attackSpeedMultiplier = -30, baseMultiplier = 4.3, levelRequirement = 90, },
		[23] = { attackSpeedMultiplier = -30, baseMultiplier = 4.51, levelRequirement = 90, },
		[24] = { attackSpeedMultiplier = -30, baseMultiplier = 4.74, levelRequirement = 90, },
		[25] = { attackSpeedMultiplier = -30, baseMultiplier = 4.98, levelRequirement = 90, },
		[26] = { attackSpeedMultiplier = -30, baseMultiplier = 5.22, levelRequirement = 90, },
		[27] = { attackSpeedMultiplier = -30, baseMultiplier = 5.49, levelRequirement = 90, },
		[28] = { attackSpeedMultiplier = -30, baseMultiplier = 5.76, levelRequirement = 90, },
		[29] = { attackSpeedMultiplier = -30, baseMultiplier = 6.05, levelRequirement = 90, },
		[30] = { attackSpeedMultiplier = -30, baseMultiplier = 6.35, levelRequirement = 90, },
		[31] = { attackSpeedMultiplier = -30, baseMultiplier = 6.67, levelRequirement = 90, },
		[32] = { attackSpeedMultiplier = -30, baseMultiplier = 7, levelRequirement = 90, },
		[33] = { attackSpeedMultiplier = -30, baseMultiplier = 7.35, levelRequirement = 90, },
		[34] = { attackSpeedMultiplier = -30, baseMultiplier = 7.72, levelRequirement = 90, },
		[35] = { attackSpeedMultiplier = -30, baseMultiplier = 8.11, levelRequirement = 90, },
		[36] = { attackSpeedMultiplier = -30, baseMultiplier = 8.51, levelRequirement = 90, },
		[37] = { attackSpeedMultiplier = -30, baseMultiplier = 8.94, levelRequirement = 90, },
		[38] = { attackSpeedMultiplier = -30, baseMultiplier = 9.38, levelRequirement = 90, },
		[39] = { attackSpeedMultiplier = -30, baseMultiplier = 9.85, levelRequirement = 90, },
		[40] = { attackSpeedMultiplier = -30, baseMultiplier = 10.34, levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Spear Throw",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "player_ranged_spear",
			baseFlags = {
				attack = true,
				projectile = true,
			},
			constantStats = {
				{ "movement_speed_+%_final_while_performing_action", -70 },
				{ "movement_speed_acceleration_+%_per_second_while_performing_action", 160 },
				{ "movement_speed_while_performing_action_locked_duration_%", 50 },
				{ "main_hand_weapon_range_+", 105 },
			},
			stats = {
				"base_is_projectile",
				"projectile_uses_contact_position",
				"projectile_uses_contact_direction",
				"check_for_targets_between_initiator_and_projectile_source",
				"can_perform_skill_while_moving",
				"has_modular_projectiles_enabled",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
		[2] = {
			label = "Explosion",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "player_ranged_spear",
			baseFlags = {
				attack = true,
				projectile = true,
				area = true,
			},
			constantStats = {
				{ "movement_speed_+%_final_while_performing_action", -70 },
				{ "movement_speed_acceleration_+%_per_second_while_performing_action", 160 },
				{ "movement_speed_while_performing_action_locked_duration_%", 50 },
				{ "main_hand_weapon_range_+", 105 },
				{ "active_skill_base_area_of_effect_radius", 20 },
			},
			stats = {
				"base_is_projectile",
				"projectile_uses_contact_position",
				"projectile_uses_contact_direction",
				"check_for_targets_between_initiator_and_projectile_source",
				"can_perform_skill_while_moving",
				"has_modular_projectiles_enabled",
				"is_area_damage",
				"display_statset_hide_usage_stats",
			},
			levels = {
				[1] = { baseMultiplier = 2.32, actorLevel = 1, },
				[2] = { baseMultiplier = 2.55, actorLevel = 3.4519999027252, },
				[3] = { baseMultiplier = 2.81, actorLevel = 6.7670001983643, },
				[4] = { baseMultiplier = 3.06, actorLevel = 10.307999610901, },
				[5] = { baseMultiplier = 3.3, actorLevel = 14.074999809265, },
				[6] = { baseMultiplier = 3.55, actorLevel = 18.068000793457, },
				[7] = { baseMultiplier = 3.8, actorLevel = 22.287000656128, },
				[8] = { baseMultiplier = 4.03, actorLevel = 26.732000350952, },
				[9] = { baseMultiplier = 4.23, actorLevel = 31.40299987793, },
				[10] = { baseMultiplier = 4.44, actorLevel = 36.299999237061, },
				[11] = { baseMultiplier = 4.66, actorLevel = 41.423000335693, },
				[12] = { baseMultiplier = 4.9, actorLevel = 46.771999359131, },
				[13] = { baseMultiplier = 5.14, actorLevel = 52.34700012207, },
				[14] = { baseMultiplier = 5.4, actorLevel = 58.147998809814, },
				[15] = { baseMultiplier = 5.67, actorLevel = 64.175003051758, },
				[16] = { baseMultiplier = 5.95, actorLevel = 70.428001403809, },
				[17] = { baseMultiplier = 6.25, actorLevel = 76.906997680664, },
				[18] = { baseMultiplier = 6.56, actorLevel = 83.611999511719, },
				[19] = { baseMultiplier = 6.89, actorLevel = 90.542999267578, },
				[20] = { baseMultiplier = 7.24, actorLevel = 97.699996948242, },
				[21] = { baseMultiplier = 7.6, actorLevel = 105.08300018311, },
				[22] = { baseMultiplier = 7.98, actorLevel = 112.69200134277, },
				[23] = { baseMultiplier = 8.38, actorLevel = 120.52700042725, },
				[24] = { baseMultiplier = 8.8, actorLevel = 128.58799743652, },
				[25] = { baseMultiplier = 9.23, actorLevel = 136.875, },
				[26] = { baseMultiplier = 9.7, actorLevel = 145.38800048828, },
				[27] = { baseMultiplier = 10.18, actorLevel = 154.12699890137, },
				[28] = { baseMultiplier = 10.69, actorLevel = 163.09199523926, },
				[29] = { baseMultiplier = 11.23, actorLevel = 172.28300476074, },
				[30] = { baseMultiplier = 11.79, actorLevel = 181.69999694824, },
				[31] = { baseMultiplier = 12.38, actorLevel = 191.34300231934, },
				[32] = { baseMultiplier = 12.99, actorLevel = 201.21200561523, },
				[33] = { baseMultiplier = 13.64, actorLevel = 211.30700683594, },
				[34] = { baseMultiplier = 14.33, actorLevel = 221.62800598145, },
				[35] = { baseMultiplier = 15.04, actorLevel = 232.17500305176, },
				[36] = { baseMultiplier = 15.8, actorLevel = 242.94799804688, },
				[37] = { baseMultiplier = 16.58, actorLevel = 253.94700622559, },
				[38] = { baseMultiplier = 17.41, actorLevel = 265.17199707031, },
				[39] = { baseMultiplier = 18.28, actorLevel = 276.62298583984, },
				[40] = { baseMultiplier = 19.2, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["SummonInfernalHoundPlayer"] = {
	name = "Summon Infernal Hound",
	baseTypeName = "Summon Infernal Hound",
	fromTree = true,
	minionList = {
		"SummonedHellhound",
	},
	color = 4,
	description = "Activate to summon a Reviving Infernal Hound which Ignites enemies near it.",
	skillTypes = { [SkillType.Minion] = true, [SkillType.CreatesMinion] = true, [SkillType.Persistent] = true, [SkillType.Fire] = true, [SkillType.CreatesDemonMinion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.HasReservation] = true, [SkillType.Companion] = true, [SkillType.CreatesCompanion] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Area] = true, },
	castTime = 0,
	qualityStats = {
		{ "active_skill_minion_life_+%_final", 1 },
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 3, },
		[3] = { levelRequirement = 6, },
		[4] = { levelRequirement = 10, },
		[5] = { levelRequirement = 14, },
		[6] = { levelRequirement = 18, },
		[7] = { levelRequirement = 22, },
		[8] = { levelRequirement = 26, },
		[9] = { levelRequirement = 31, },
		[10] = { levelRequirement = 36, },
		[11] = { levelRequirement = 41, },
		[12] = { levelRequirement = 46, },
		[13] = { levelRequirement = 52, },
		[14] = { levelRequirement = 58, },
		[15] = { levelRequirement = 64, },
		[16] = { levelRequirement = 66, },
		[17] = { levelRequirement = 72, },
		[18] = { levelRequirement = 78, },
		[19] = { levelRequirement = 84, },
		[20] = { levelRequirement = 90, },
		[21] = { levelRequirement = 90, },
		[22] = { levelRequirement = 90, },
		[23] = { levelRequirement = 90, },
		[24] = { levelRequirement = 90, },
		[25] = { levelRequirement = 90, },
		[26] = { levelRequirement = 90, },
		[27] = { levelRequirement = 90, },
		[28] = { levelRequirement = 90, },
		[29] = { levelRequirement = 90, },
		[30] = { levelRequirement = 90, },
		[31] = { levelRequirement = 90, },
		[32] = { levelRequirement = 90, },
		[33] = { levelRequirement = 90, },
		[34] = { levelRequirement = 90, },
		[35] = { levelRequirement = 90, },
		[36] = { levelRequirement = 90, },
		[37] = { levelRequirement = 90, },
		[38] = { levelRequirement = 90, },
		[39] = { levelRequirement = 90, },
		[40] = { levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Summon Infernal Hound",
			incrementalEffectiveness = 0.092720001935959,
			statDescriptionScope = "summon_infernal_familiar",
			baseFlags = {
				spell = true,
				minion = true,
				permanentMinion = true,
			},
			constantStats = {
				{ "display_minion_monster_type", 8 },
				{ "infernal_familiar_minion_burns_for_%_max_life", 20 },
				{ "infernal_familiar_minion_burn_radius", 25 },
				{ "skill_desired_initial_amount", 1 },
			},
			stats = {
				"is_resummoning_minion",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["SupportingFirePlayer"] = {
	name = "Supporting Fire",
	baseTypeName = "Supporting Fire",
	fromTree = true,
	minionList = {
		"TacticianMinion",
	},
	color = 4,
	description = "Recruit artillery Minions that takes up positions behind you. They will lay in wait for your Command then fire volleys of arrows at the target location.",
	skillTypes = { [SkillType.Minion] = true, [SkillType.CreatesMinion] = true, [SkillType.HasReservation] = true, [SkillType.Persistent] = true, [SkillType.CommandableMinion] = true, [SkillType.MinionsAreUndamagable] = true, [SkillType.NoAttackInPlace] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Rain] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesNumberModifiersNotApplied] = true, [SkillType.Cooldown] = true, [SkillType.CannotChain] = true, [SkillType.GroundTargetedProjectile] = true, [SkillType.ProjectileNoCollision] = true, },
	castTime = 0,
	qualityStats = {
		{ "active_skill_minion_damage_+%_final", 1 },
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 3, },
		[3] = { levelRequirement = 6, },
		[4] = { levelRequirement = 10, },
		[5] = { levelRequirement = 14, },
		[6] = { levelRequirement = 18, },
		[7] = { levelRequirement = 22, },
		[8] = { levelRequirement = 26, },
		[9] = { levelRequirement = 31, },
		[10] = { levelRequirement = 36, },
		[11] = { levelRequirement = 41, },
		[12] = { levelRequirement = 46, },
		[13] = { levelRequirement = 52, },
		[14] = { levelRequirement = 58, },
		[15] = { levelRequirement = 64, },
		[16] = { levelRequirement = 66, },
		[17] = { levelRequirement = 72, },
		[18] = { levelRequirement = 78, },
		[19] = { levelRequirement = 84, },
		[20] = { levelRequirement = 90, },
		[21] = { levelRequirement = 90, },
		[22] = { levelRequirement = 90, },
		[23] = { levelRequirement = 90, },
		[24] = { levelRequirement = 90, },
		[25] = { levelRequirement = 90, },
		[26] = { levelRequirement = 90, },
		[27] = { levelRequirement = 90, },
		[28] = { levelRequirement = 90, },
		[29] = { levelRequirement = 90, },
		[30] = { levelRequirement = 90, },
		[31] = { levelRequirement = 90, },
		[32] = { levelRequirement = 90, },
		[33] = { levelRequirement = 90, },
		[34] = { levelRequirement = 90, },
		[35] = { levelRequirement = 90, },
		[36] = { levelRequirement = 90, },
		[37] = { levelRequirement = 90, },
		[38] = { levelRequirement = 90, },
		[39] = { levelRequirement = 90, },
		[40] = { levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Minion Info",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			statMap = {
				["minion_1%_damage_+%_per_X_player_strength"] = {
					mod("MinionModifier", "LIST", { mod = mod("Damage", "INC", nil, 0, 0, { type = "PerStat", stat = "Str", actor = "parent" }) }),
				},
				["minion_1%_area_of_effect_+%_per_X_player_dexterity"] = {
					mod("MinionModifier", "LIST", { mod = mod("AreaOfEffect", "INC", nil, 0, 0, { type = "PerStat", stat = "Dex", actor = "parent", div = 3 }) }),
					div = 3,
				},
			},
			baseFlags = {
				minion = true,
				permanentMinion = true,
			},
			constantStats = {
				{ "minion_1%_damage_+%_per_X_player_strength", 1 },
				{ "minion_1%_area_of_effect_+%_per_X_player_dexterity", 3 },
				{ "skill_desired_amount_override", 1 },
			},
			stats = {
				"display_statset_no_hit_damage",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["TemperWeaponPlayer"] = {
	name = "Temper Weapon",
	baseTypeName = "Temper Weapon",
	fromTree = true,
	color = 4,
	description = "Channel to temper your main hand Melee Martial Weapon. Each hit of the hammer against the anvil Empowers subsequent Attacks to Combust when Hitting enemies.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.EmpowersOtherSkill] = true, [SkillType.Channel] = true, [SkillType.Cooldown] = true, [SkillType.NoAttackInPlace] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Flail"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Claw"] = true,
		["Spear"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Staff"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1.125,
	qualityStats = {
		{ "skill_speed_+%", 1 },
	},
	levels = {
		[1] = { storedUses = 1, levelRequirement = 0, cooldown = 5, cost = { ManaPerMinute = 174, }, },
		[2] = { storedUses = 1, levelRequirement = 3, cooldown = 5, cost = { ManaPerMinute = 201, }, },
		[3] = { storedUses = 1, levelRequirement = 6, cooldown = 5, cost = { ManaPerMinute = 231, }, },
		[4] = { storedUses = 1, levelRequirement = 10, cooldown = 5, cost = { ManaPerMinute = 262, }, },
		[5] = { storedUses = 1, levelRequirement = 14, cooldown = 5, cost = { ManaPerMinute = 296, }, },
		[6] = { storedUses = 1, levelRequirement = 18, cooldown = 5, cost = { ManaPerMinute = 332, }, },
		[7] = { storedUses = 1, levelRequirement = 22, cooldown = 5, cost = { ManaPerMinute = 371, }, },
		[8] = { storedUses = 1, levelRequirement = 26, cooldown = 5, cost = { ManaPerMinute = 412, }, },
		[9] = { storedUses = 1, levelRequirement = 31, cooldown = 5, cost = { ManaPerMinute = 456, }, },
		[10] = { storedUses = 1, levelRequirement = 36, cooldown = 5, cost = { ManaPerMinute = 503, }, },
		[11] = { storedUses = 1, levelRequirement = 41, cooldown = 5, cost = { ManaPerMinute = 553, }, },
		[12] = { storedUses = 1, levelRequirement = 46, cooldown = 5, cost = { ManaPerMinute = 606, }, },
		[13] = { storedUses = 1, levelRequirement = 52, cooldown = 5, cost = { ManaPerMinute = 663, }, },
		[14] = { storedUses = 1, levelRequirement = 58, cooldown = 5, cost = { ManaPerMinute = 724, }, },
		[15] = { storedUses = 1, levelRequirement = 64, cooldown = 5, cost = { ManaPerMinute = 789, }, },
		[16] = { storedUses = 1, levelRequirement = 66, cooldown = 5, cost = { ManaPerMinute = 857, }, },
		[17] = { storedUses = 1, levelRequirement = 72, cooldown = 5, cost = { ManaPerMinute = 930, }, },
		[18] = { storedUses = 1, levelRequirement = 78, cooldown = 5, cost = { ManaPerMinute = 1008, }, },
		[19] = { storedUses = 1, levelRequirement = 84, cooldown = 5, cost = { ManaPerMinute = 1091, }, },
		[20] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 1179, }, },
		[21] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 1272, }, },
		[22] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 1371, }, },
		[23] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 1476, }, },
		[24] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 1588, }, },
		[25] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 1706, }, },
		[26] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 1831, }, },
		[27] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 1964, }, },
		[28] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 2105, }, },
		[29] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 2254, }, },
		[30] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 2412, }, },
		[31] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 2580, }, },
		[32] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 2757, }, },
		[33] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 2944, }, },
		[34] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 3143, }, },
		[35] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 3352, }, },
		[36] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 3574, }, },
		[37] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 3809, }, },
		[38] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 4057, }, },
		[39] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 4319, }, },
		[40] = { storedUses = 1, levelRequirement = 90, cooldown = 5, cost = { ManaPerMinute = 4596, }, },
	},
			preDamageFunc = function(activeSkill, output)
				activeSkill.skillData.channelTimeMultiplier = activeSkill.skillModList:Sum("BASE", activeSkill.skillCfg, "Multiplier:TemperWeaponStage")
			end,
	statSets = {
		[1] = {
			label = "Temper Weapon",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			statMap = {
				["imbue_weapon_max_exerts"] = {
					mod("Multiplier:TemperWeaponMaxStages", "BASE", nil),
					div = 3,
				},
			},
			baseFlags = {
				channelRelease = true,
			},
			constantStats = {
				{ "imbue_weapon_max_exerts", 12 },
				{ "channel_skill_end_animation_duration_override_ms", 83 },
				{ "temper_weapon_empowers_per_strike", 3 },
			},
			stats = {
				"base_deal_no_damage",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["TemperWeaponCombustionPlayer"] = {
	name = "Combust",
	hidden = true,
	fromTree = true,
	description = "Explode, dealing Fire damage in an area.",
	skillTypes = { [SkillType.Fire] = true, [SkillType.Triggered] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.NoAttackOrCastTime] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Flail"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Claw"] = true,
		["Spear"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Staff"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 0,
	qualityStats = {
	},
	levels = {
		[1] = { baseMultiplier = 0.8, levelRequirement = 0, },
		[2] = { baseMultiplier = 0.88, levelRequirement = 0, },
		[3] = { baseMultiplier = 0.97, levelRequirement = 0, },
		[4] = { baseMultiplier = 1.06, levelRequirement = 0, },
		[5] = { baseMultiplier = 1.15, levelRequirement = 0, },
		[6] = { baseMultiplier = 1.24, levelRequirement = 0, },
		[7] = { baseMultiplier = 1.33, levelRequirement = 0, },
		[8] = { baseMultiplier = 1.42, levelRequirement = 0, },
		[9] = { baseMultiplier = 1.5, levelRequirement = 0, },
		[10] = { baseMultiplier = 1.58, levelRequirement = 0, },
		[11] = { baseMultiplier = 1.67, levelRequirement = 0, },
		[12] = { baseMultiplier = 1.77, levelRequirement = 0, },
		[13] = { baseMultiplier = 1.88, levelRequirement = 0, },
		[14] = { baseMultiplier = 1.99, levelRequirement = 0, },
		[15] = { baseMultiplier = 2.12, levelRequirement = 0, },
		[16] = { baseMultiplier = 2.25, levelRequirement = 0, },
		[17] = { baseMultiplier = 2.39, levelRequirement = 0, },
		[18] = { baseMultiplier = 2.55, levelRequirement = 0, },
		[19] = { baseMultiplier = 2.72, levelRequirement = 0, },
		[20] = { baseMultiplier = 2.9, levelRequirement = 0, },
		[21] = { baseMultiplier = 3.09, levelRequirement = 0, },
		[22] = { baseMultiplier = 3.3, levelRequirement = 0, },
		[23] = { baseMultiplier = 3.52, levelRequirement = 0, },
		[24] = { baseMultiplier = 3.75, levelRequirement = 0, },
		[25] = { baseMultiplier = 4, levelRequirement = 0, },
		[26] = { baseMultiplier = 4.27, levelRequirement = 0, },
		[27] = { baseMultiplier = 4.55, levelRequirement = 0, },
		[28] = { baseMultiplier = 4.85, levelRequirement = 0, },
		[29] = { baseMultiplier = 5.18, levelRequirement = 0, },
		[30] = { baseMultiplier = 5.52, levelRequirement = 0, },
		[31] = { baseMultiplier = 5.89, levelRequirement = 0, },
		[32] = { baseMultiplier = 6.28, levelRequirement = 0, },
		[33] = { baseMultiplier = 6.7, levelRequirement = 0, },
		[34] = { baseMultiplier = 7.15, levelRequirement = 0, },
		[35] = { baseMultiplier = 7.62, levelRequirement = 0, },
		[36] = { baseMultiplier = 8.13, levelRequirement = 0, },
		[37] = { baseMultiplier = 8.67, levelRequirement = 0, },
		[38] = { baseMultiplier = 9.25, levelRequirement = 0, },
		[39] = { baseMultiplier = 9.87, levelRequirement = 0, },
		[40] = { baseMultiplier = 10.52, levelRequirement = 0, },
	},
	statSets = {
		[1] = {
			label = "Combust",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "temper_weapon_combustion",
			baseFlags = {
				attack = true,
				area = true,
			},
			constantStats = {
				{ "imbue_weapon_combust_trigger_chance_%", 100 },
				{ "active_skill_base_area_of_effect_radius", 25 },
				{ "active_skill_base_physical_damage_%_to_convert_to_fire", 100 },
			},
			stats = {
				"is_area_damage",
				"base_skill_show_average_damage_instead_of_dps",
				"global_always_hit",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["TemporalRiftPlayer"] = {
	name = "Temporal Rift",
	baseTypeName = "Temporal Rift",
	fromTree = true,
	color = 4,
	description = "While active, passively leaves afterimages of your recent past. Cast the Spell to return to the oldest afterimage, teleporting to that location and resetting your Life, Mana and Energy Shield to the values they had at the time.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Cooldown] = true, [SkillType.HasReservation] = true, [SkillType.Buff] = true, [SkillType.Persistent] = true, [SkillType.OngoingSkill] = true, [SkillType.PersistentShowsCastTime] = true, [SkillType.FixedCastTime] = true, },
	castTime = 0.5,
	qualityStats = {
		{ "base_cooldown_speed_+%", 0.5 },
	},
	levels = {
		[1] = { storedUses = 1, levelRequirement = 0, cooldown = 7, },
		[2] = { storedUses = 1, levelRequirement = 3, cooldown = 6.9, },
		[3] = { storedUses = 1, levelRequirement = 6, cooldown = 6.8, },
		[4] = { storedUses = 1, levelRequirement = 10, cooldown = 6.7, },
		[5] = { storedUses = 1, levelRequirement = 14, cooldown = 6.6, },
		[6] = { storedUses = 1, levelRequirement = 18, cooldown = 6.5, },
		[7] = { storedUses = 1, levelRequirement = 22, cooldown = 6.4, },
		[8] = { storedUses = 1, levelRequirement = 26, cooldown = 6.3, },
		[9] = { storedUses = 1, levelRequirement = 31, cooldown = 6.2, },
		[10] = { storedUses = 1, levelRequirement = 36, cooldown = 6.1, },
		[11] = { storedUses = 1, levelRequirement = 41, cooldown = 6, },
		[12] = { storedUses = 1, levelRequirement = 46, cooldown = 5.9, },
		[13] = { storedUses = 1, levelRequirement = 52, cooldown = 5.8, },
		[14] = { storedUses = 1, levelRequirement = 58, cooldown = 5.7, },
		[15] = { storedUses = 1, levelRequirement = 64, cooldown = 5.6, },
		[16] = { storedUses = 1, levelRequirement = 66, cooldown = 5.5, },
		[17] = { storedUses = 1, levelRequirement = 72, cooldown = 5.4, },
		[18] = { storedUses = 1, levelRequirement = 78, cooldown = 5.3, },
		[19] = { storedUses = 1, levelRequirement = 84, cooldown = 5.2, },
		[20] = { storedUses = 1, levelRequirement = 90, cooldown = 5.1, },
		[21] = { storedUses = 1, levelRequirement = 90, cooldown = 5, },
		[22] = { storedUses = 1, levelRequirement = 90, cooldown = 4.9, },
		[23] = { storedUses = 1, levelRequirement = 90, cooldown = 4.8, },
		[24] = { storedUses = 1, levelRequirement = 90, cooldown = 4.7, },
		[25] = { storedUses = 1, levelRequirement = 90, cooldown = 4.6, },
		[26] = { storedUses = 1, levelRequirement = 90, cooldown = 4.5, },
		[27] = { storedUses = 1, levelRequirement = 90, cooldown = 4.4, },
		[28] = { storedUses = 1, levelRequirement = 90, cooldown = 4.3, },
		[29] = { storedUses = 1, levelRequirement = 90, cooldown = 4.2, },
		[30] = { storedUses = 1, levelRequirement = 90, cooldown = 4.1, },
		[31] = { storedUses = 1, levelRequirement = 90, cooldown = 4.05, },
		[32] = { storedUses = 1, levelRequirement = 90, cooldown = 4, },
		[33] = { storedUses = 1, levelRequirement = 90, cooldown = 3.95, },
		[34] = { storedUses = 1, levelRequirement = 90, cooldown = 3.9, },
		[35] = { storedUses = 1, levelRequirement = 90, cooldown = 3.85, },
		[36] = { storedUses = 1, levelRequirement = 90, cooldown = 3.8, },
		[37] = { storedUses = 1, levelRequirement = 90, cooldown = 3.75, },
		[38] = { storedUses = 1, levelRequirement = 90, cooldown = 3.7, },
		[39] = { storedUses = 1, levelRequirement = 90, cooldown = 3.65, },
		[40] = { storedUses = 1, levelRequirement = 90, cooldown = 3.6, },
	},
	statSets = {
		[1] = {
			label = "Temporal Rift",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "temporal_rift",
			baseFlags = {
			},
			constantStats = {
				{ "skill_desired_amount_override", 1 },
				{ "temporal_rift_snapshot_interval", 250 },
				{ "temporal_rift_maximum_snapshots", 16 },
			},
			stats = {
				"spell_cast_time_cannot_be_modified",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["TimeFreezePlayer"] = {
	name = "Time Freeze",
	baseTypeName = "Time Freeze",
	fromTree = true,
	color = 4,
	description = "Release a large wave that stops time for all affected enemies for a duration. Duration is lower the more times the enemy has had time stopped for them.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Cooldown] = true, [SkillType.Area] = true, [SkillType.Duration] = true, },
	castTime = 0.7,
	qualityStats = {
		{ "base_cooldown_speed_+%", 0.5 },
	},
	levels = {
		[1] = { storedUses = 1, levelRequirement = 0, cooldown = 65, cost = { Mana = 20, }, },
		[2] = { storedUses = 1, levelRequirement = 3, cooldown = 64.5, cost = { Mana = 20, }, },
		[3] = { storedUses = 1, levelRequirement = 6, cooldown = 64, cost = { Mana = 20, }, },
		[4] = { storedUses = 1, levelRequirement = 10, cooldown = 63.5, cost = { Mana = 20, }, },
		[5] = { storedUses = 1, levelRequirement = 14, cooldown = 63, cost = { Mana = 20, }, },
		[6] = { storedUses = 1, levelRequirement = 18, cooldown = 62.5, cost = { Mana = 20, }, },
		[7] = { storedUses = 1, levelRequirement = 22, cooldown = 62, cost = { Mana = 20, }, },
		[8] = { storedUses = 1, levelRequirement = 26, cooldown = 61.5, cost = { Mana = 20, }, },
		[9] = { storedUses = 1, levelRequirement = 31, cooldown = 61, cost = { Mana = 20, }, },
		[10] = { storedUses = 1, levelRequirement = 36, cooldown = 60.5, cost = { Mana = 20, }, },
		[11] = { storedUses = 1, levelRequirement = 41, cooldown = 60, cost = { Mana = 20, }, },
		[12] = { storedUses = 1, levelRequirement = 46, cooldown = 59.5, cost = { Mana = 20, }, },
		[13] = { storedUses = 1, levelRequirement = 52, cooldown = 59, cost = { Mana = 20, }, },
		[14] = { storedUses = 1, levelRequirement = 58, cooldown = 58.5, cost = { Mana = 20, }, },
		[15] = { storedUses = 1, levelRequirement = 64, cooldown = 58, cost = { Mana = 20, }, },
		[16] = { storedUses = 1, levelRequirement = 66, cooldown = 57.5, cost = { Mana = 20, }, },
		[17] = { storedUses = 1, levelRequirement = 72, cooldown = 57, cost = { Mana = 20, }, },
		[18] = { storedUses = 1, levelRequirement = 78, cooldown = 56.5, cost = { Mana = 20, }, },
		[19] = { storedUses = 1, levelRequirement = 84, cooldown = 56, cost = { Mana = 20, }, },
		[20] = { storedUses = 1, levelRequirement = 90, cooldown = 55.5, cost = { Mana = 20, }, },
		[21] = { storedUses = 1, levelRequirement = 90, cooldown = 55, cost = { Mana = 20, }, },
		[22] = { storedUses = 1, levelRequirement = 90, cooldown = 54.5, cost = { Mana = 20, }, },
		[23] = { storedUses = 1, levelRequirement = 90, cooldown = 54, cost = { Mana = 20, }, },
		[24] = { storedUses = 1, levelRequirement = 90, cooldown = 53.5, cost = { Mana = 20, }, },
		[25] = { storedUses = 1, levelRequirement = 90, cooldown = 53, cost = { Mana = 20, }, },
		[26] = { storedUses = 1, levelRequirement = 90, cooldown = 52.5, cost = { Mana = 20, }, },
		[27] = { storedUses = 1, levelRequirement = 90, cooldown = 52, cost = { Mana = 20, }, },
		[28] = { storedUses = 1, levelRequirement = 90, cooldown = 51.5, cost = { Mana = 20, }, },
		[29] = { storedUses = 1, levelRequirement = 90, cooldown = 51, cost = { Mana = 20, }, },
		[30] = { storedUses = 1, levelRequirement = 90, cooldown = 50.5, cost = { Mana = 20, }, },
		[31] = { storedUses = 1, levelRequirement = 90, cooldown = 50.25, cost = { Mana = 20, }, },
		[32] = { storedUses = 1, levelRequirement = 90, cooldown = 50, cost = { Mana = 20, }, },
		[33] = { storedUses = 1, levelRequirement = 90, cooldown = 49.75, cost = { Mana = 20, }, },
		[34] = { storedUses = 1, levelRequirement = 90, cooldown = 49.5, cost = { Mana = 20, }, },
		[35] = { storedUses = 1, levelRequirement = 90, cooldown = 49.25, cost = { Mana = 20, }, },
		[36] = { storedUses = 1, levelRequirement = 90, cooldown = 49, cost = { Mana = 20, }, },
		[37] = { storedUses = 1, levelRequirement = 90, cooldown = 48.75, cost = { Mana = 20, }, },
		[38] = { storedUses = 1, levelRequirement = 90, cooldown = 48.5, cost = { Mana = 20, }, },
		[39] = { storedUses = 1, levelRequirement = 90, cooldown = 48.25, cost = { Mana = 20, }, },
		[40] = { storedUses = 1, levelRequirement = 90, cooldown = 48, cost = { Mana = 20, }, },
	},
	statSets = {
		[1] = {
			label = "Time Freeze",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "time_stop",
			baseFlags = {
				area = true,
				duration = true,
			},
			constantStats = {
				{ "base_skill_effect_duration", 3000 },
				{ "active_skill_base_area_of_effect_radius", 100 },
				{ "time_freeze_resistance_duration_ms", 30000 },
			},
			stats = {
				"cannot_cancel_skill_before_contact_point",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["TimeSnapPlayer"] = {
	name = "Time Snap",
	baseTypeName = "Time Snap",
	fromTree = true,
	color = 4,
	description = "Manipulate time, resetting the cooldowns of your other Skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Cooldown] = true, },
	castTime = 0.6,
	qualityStats = {
		{ "base_cooldown_speed_+%", 0.5 },
	},
	levels = {
		[1] = { storedUses = 1, levelRequirement = 0, cooldown = 40, cost = { Mana = 20, }, },
		[2] = { storedUses = 1, levelRequirement = 3, cooldown = 39.6, cost = { Mana = 20, }, },
		[3] = { storedUses = 1, levelRequirement = 6, cooldown = 39.2, cost = { Mana = 20, }, },
		[4] = { storedUses = 1, levelRequirement = 10, cooldown = 38.8, cost = { Mana = 20, }, },
		[5] = { storedUses = 1, levelRequirement = 14, cooldown = 38.4, cost = { Mana = 20, }, },
		[6] = { storedUses = 1, levelRequirement = 18, cooldown = 38, cost = { Mana = 20, }, },
		[7] = { storedUses = 1, levelRequirement = 22, cooldown = 37.6, cost = { Mana = 20, }, },
		[8] = { storedUses = 1, levelRequirement = 26, cooldown = 37.2, cost = { Mana = 20, }, },
		[9] = { storedUses = 1, levelRequirement = 31, cooldown = 36.8, cost = { Mana = 20, }, },
		[10] = { storedUses = 1, levelRequirement = 36, cooldown = 36.4, cost = { Mana = 20, }, },
		[11] = { storedUses = 1, levelRequirement = 41, cooldown = 36, cost = { Mana = 20, }, },
		[12] = { storedUses = 1, levelRequirement = 46, cooldown = 35.6, cost = { Mana = 20, }, },
		[13] = { storedUses = 1, levelRequirement = 52, cooldown = 35.2, cost = { Mana = 20, }, },
		[14] = { storedUses = 1, levelRequirement = 58, cooldown = 34.8, cost = { Mana = 20, }, },
		[15] = { storedUses = 1, levelRequirement = 64, cooldown = 34.4, cost = { Mana = 20, }, },
		[16] = { storedUses = 1, levelRequirement = 66, cooldown = 34, cost = { Mana = 20, }, },
		[17] = { storedUses = 1, levelRequirement = 72, cooldown = 33.6, cost = { Mana = 20, }, },
		[18] = { storedUses = 1, levelRequirement = 78, cooldown = 33.2, cost = { Mana = 20, }, },
		[19] = { storedUses = 1, levelRequirement = 84, cooldown = 32.8, cost = { Mana = 20, }, },
		[20] = { storedUses = 1, levelRequirement = 90, cooldown = 32.4, cost = { Mana = 20, }, },
		[21] = { storedUses = 1, levelRequirement = 90, cooldown = 32, cost = { Mana = 20, }, },
		[22] = { storedUses = 1, levelRequirement = 90, cooldown = 31.6, cost = { Mana = 20, }, },
		[23] = { storedUses = 1, levelRequirement = 90, cooldown = 31.2, cost = { Mana = 20, }, },
		[24] = { storedUses = 1, levelRequirement = 90, cooldown = 30.8, cost = { Mana = 20, }, },
		[25] = { storedUses = 1, levelRequirement = 90, cooldown = 30.4, cost = { Mana = 20, }, },
		[26] = { storedUses = 1, levelRequirement = 90, cooldown = 30, cost = { Mana = 20, }, },
		[27] = { storedUses = 1, levelRequirement = 90, cooldown = 29.6, cost = { Mana = 20, }, },
		[28] = { storedUses = 1, levelRequirement = 90, cooldown = 29.2, cost = { Mana = 20, }, },
		[29] = { storedUses = 1, levelRequirement = 90, cooldown = 28.8, cost = { Mana = 20, }, },
		[30] = { storedUses = 1, levelRequirement = 90, cooldown = 28.4, cost = { Mana = 20, }, },
		[31] = { storedUses = 1, levelRequirement = 90, cooldown = 28.2, cost = { Mana = 20, }, },
		[32] = { storedUses = 1, levelRequirement = 90, cooldown = 28, cost = { Mana = 20, }, },
		[33] = { storedUses = 1, levelRequirement = 90, cooldown = 27.8, cost = { Mana = 20, }, },
		[34] = { storedUses = 1, levelRequirement = 90, cooldown = 27.6, cost = { Mana = 20, }, },
		[35] = { storedUses = 1, levelRequirement = 90, cooldown = 27.4, cost = { Mana = 20, }, },
		[36] = { storedUses = 1, levelRequirement = 90, cooldown = 27.2, cost = { Mana = 20, }, },
		[37] = { storedUses = 1, levelRequirement = 90, cooldown = 27, cost = { Mana = 20, }, },
		[38] = { storedUses = 1, levelRequirement = 90, cooldown = 26.8, cost = { Mana = 20, }, },
		[39] = { storedUses = 1, levelRequirement = 90, cooldown = 26.6, cost = { Mana = 20, }, },
		[40] = { storedUses = 1, levelRequirement = 90, cooldown = 26.4, cost = { Mana = 20, }, },
	},
	statSets = {
		[1] = {
			label = "Time Snap",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			baseFlags = {
			},
			stats = {
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["UnboundAvatarPlayer"] = {
	name = "Unbound Avatar",
	baseTypeName = "Unbound Avatar",
	fromTree = true,
	color = 4,
	description = "Gain Unbound Fury by inflicting Elemental Ailments with Hits on enemies. Once you reach maximum Unbound Fury, consume it to become Unbound for a duration, vastly augmenting your Elemental prowess.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Cooldown] = true, [SkillType.Instant] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Duration] = true, [SkillType.HasUsageCondition] = true, [SkillType.NoAttackInPlace] = true, },
	castTime = 0,
	qualityStats = {
		{ "base_skill_effect_duration", 50 },
	},
	levels = {
		[1] = { storedUses = 1, levelRequirement = 0, cooldown = 0.5, },
		[2] = { storedUses = 1, levelRequirement = 3, cooldown = 0.5, },
		[3] = { storedUses = 1, levelRequirement = 6, cooldown = 0.5, },
		[4] = { storedUses = 1, levelRequirement = 10, cooldown = 0.5, },
		[5] = { storedUses = 1, levelRequirement = 14, cooldown = 0.5, },
		[6] = { storedUses = 1, levelRequirement = 18, cooldown = 0.5, },
		[7] = { storedUses = 1, levelRequirement = 22, cooldown = 0.5, },
		[8] = { storedUses = 1, levelRequirement = 26, cooldown = 0.5, },
		[9] = { storedUses = 1, levelRequirement = 31, cooldown = 0.5, },
		[10] = { storedUses = 1, levelRequirement = 36, cooldown = 0.5, },
		[11] = { storedUses = 1, levelRequirement = 41, cooldown = 0.5, },
		[12] = { storedUses = 1, levelRequirement = 46, cooldown = 0.5, },
		[13] = { storedUses = 1, levelRequirement = 52, cooldown = 0.5, },
		[14] = { storedUses = 1, levelRequirement = 58, cooldown = 0.5, },
		[15] = { storedUses = 1, levelRequirement = 64, cooldown = 0.5, },
		[16] = { storedUses = 1, levelRequirement = 66, cooldown = 0.5, },
		[17] = { storedUses = 1, levelRequirement = 72, cooldown = 0.5, },
		[18] = { storedUses = 1, levelRequirement = 78, cooldown = 0.5, },
		[19] = { storedUses = 1, levelRequirement = 84, cooldown = 0.5, },
		[20] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[21] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[22] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[23] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[24] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[25] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[26] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[27] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[28] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[29] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[30] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[31] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[32] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[33] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[34] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[35] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[36] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[37] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[38] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[39] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
		[40] = { storedUses = 1, levelRequirement = 90, cooldown = 0.5, },
	},
	statSets = {
		[1] = {
			label = "Unbound Avatar",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "ailment_bearer",
			baseFlags = {
			},
			constantStats = {
				{ "display_max_ailment_bearer_charges", 100 },
				{ "display_ailment_bearer_charge_interval", 1 },
				{ "ailment_bearer_elemental_damage_+%_final", 40 },
				{ "unbound_ailment_elemental_ailment_chance_+%_final", 80 },
				{ "unbound_ailment_hit_damage_elemental_immobilisation_multiplier_+%_final", 40 },
				{ "ailment_bearer_required_stacks_to_use", 100 },
			},
			stats = {
				"base_skill_effect_duration",
				"base_deal_no_damage",
			},
			notMinionStat = {
				"base_skill_effect_duration",
			},
			levels = {
				[1] = { 8000, statInterpolation = { 1, }, actorLevel = 1, },
				[2] = { 8100, statInterpolation = { 1, }, actorLevel = 3.4519999027252, },
				[3] = { 8200, statInterpolation = { 1, }, actorLevel = 6.7670001983643, },
				[4] = { 8300, statInterpolation = { 1, }, actorLevel = 10.307999610901, },
				[5] = { 8400, statInterpolation = { 1, }, actorLevel = 14.074999809265, },
				[6] = { 8500, statInterpolation = { 1, }, actorLevel = 18.068000793457, },
				[7] = { 8600, statInterpolation = { 1, }, actorLevel = 22.287000656128, },
				[8] = { 8700, statInterpolation = { 1, }, actorLevel = 26.732000350952, },
				[9] = { 8800, statInterpolation = { 1, }, actorLevel = 31.40299987793, },
				[10] = { 8900, statInterpolation = { 1, }, actorLevel = 36.299999237061, },
				[11] = { 9000, statInterpolation = { 1, }, actorLevel = 41.423000335693, },
				[12] = { 9100, statInterpolation = { 1, }, actorLevel = 46.771999359131, },
				[13] = { 9200, statInterpolation = { 1, }, actorLevel = 52.34700012207, },
				[14] = { 9300, statInterpolation = { 1, }, actorLevel = 58.147998809814, },
				[15] = { 9400, statInterpolation = { 1, }, actorLevel = 64.175003051758, },
				[16] = { 9500, statInterpolation = { 1, }, actorLevel = 70.428001403809, },
				[17] = { 9600, statInterpolation = { 1, }, actorLevel = 76.906997680664, },
				[18] = { 9700, statInterpolation = { 1, }, actorLevel = 83.611999511719, },
				[19] = { 9800, statInterpolation = { 1, }, actorLevel = 90.542999267578, },
				[20] = { 9900, statInterpolation = { 1, }, actorLevel = 97.699996948242, },
				[21] = { 10000, statInterpolation = { 1, }, actorLevel = 105.08300018311, },
				[22] = { 10100, statInterpolation = { 1, }, actorLevel = 112.69200134277, },
				[23] = { 10200, statInterpolation = { 1, }, actorLevel = 120.52700042725, },
				[24] = { 10300, statInterpolation = { 1, }, actorLevel = 128.58799743652, },
				[25] = { 10400, statInterpolation = { 1, }, actorLevel = 136.875, },
				[26] = { 10500, statInterpolation = { 1, }, actorLevel = 145.38800048828, },
				[27] = { 10600, statInterpolation = { 1, }, actorLevel = 154.12699890137, },
				[28] = { 10700, statInterpolation = { 1, }, actorLevel = 163.09199523926, },
				[29] = { 10800, statInterpolation = { 1, }, actorLevel = 172.28300476074, },
				[30] = { 10900, statInterpolation = { 1, }, actorLevel = 181.69999694824, },
				[31] = { 10950, statInterpolation = { 1, }, actorLevel = 191.34300231934, },
				[32] = { 11000, statInterpolation = { 1, }, actorLevel = 201.21200561523, },
				[33] = { 11050, statInterpolation = { 1, }, actorLevel = 211.30700683594, },
				[34] = { 11100, statInterpolation = { 1, }, actorLevel = 221.62800598145, },
				[35] = { 11150, statInterpolation = { 1, }, actorLevel = 232.17500305176, },
				[36] = { 11200, statInterpolation = { 1, }, actorLevel = 242.94799804688, },
				[37] = { 11250, statInterpolation = { 1, }, actorLevel = 253.94700622559, },
				[38] = { 11300, statInterpolation = { 1, }, actorLevel = 265.17199707031, },
				[39] = { 11350, statInterpolation = { 1, }, actorLevel = 276.62298583984, },
				[40] = { 11400, statInterpolation = { 1, }, actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["VoidIllusionPlayer"] = {
	name = "Void Illusion",
	baseTypeName = "Void Illusion",
	fromTree = true,
	color = 4,
	description = "While active, creates a short-lived illusory copy of yourself whenever you dodge roll. The copy can be damaged by enemies, and copies that are destroyed by an enemy will cause damaging explosions. Copies created this way have 1 Life.",
	skillTypes = { [SkillType.HasReservation] = true, [SkillType.OngoingSkill] = true, [SkillType.Persistent] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.NoAttackInPlace] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Flail"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Claw"] = true,
		["Crossbow"] = true,
		["Bow"] = true,
		["Spear"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Staff"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 0,
	qualityStats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
		[2] = { levelRequirement = 3, },
		[3] = { levelRequirement = 6, },
		[4] = { levelRequirement = 10, },
		[5] = { levelRequirement = 14, },
		[6] = { levelRequirement = 18, },
		[7] = { levelRequirement = 22, },
		[8] = { levelRequirement = 26, },
		[9] = { levelRequirement = 31, },
		[10] = { levelRequirement = 36, },
		[11] = { levelRequirement = 41, },
		[12] = { levelRequirement = 46, },
		[13] = { levelRequirement = 52, },
		[14] = { levelRequirement = 58, },
		[15] = { levelRequirement = 64, },
		[16] = { levelRequirement = 66, },
		[17] = { levelRequirement = 72, },
		[18] = { levelRequirement = 78, },
		[19] = { levelRequirement = 84, },
		[20] = { levelRequirement = 90, },
		[21] = { levelRequirement = 90, },
		[22] = { levelRequirement = 90, },
		[23] = { levelRequirement = 90, },
		[24] = { levelRequirement = 90, },
		[25] = { levelRequirement = 90, },
		[26] = { levelRequirement = 90, },
		[27] = { levelRequirement = 90, },
		[28] = { levelRequirement = 90, },
		[29] = { levelRequirement = 90, },
		[30] = { levelRequirement = 90, },
		[31] = { levelRequirement = 90, },
		[32] = { levelRequirement = 90, },
		[33] = { levelRequirement = 90, },
		[34] = { levelRequirement = 90, },
		[35] = { levelRequirement = 90, },
		[36] = { levelRequirement = 90, },
		[37] = { levelRequirement = 90, },
		[38] = { levelRequirement = 90, },
		[39] = { levelRequirement = 90, },
		[40] = { levelRequirement = 90, },
	},
	statSets = {
		[1] = {
			label = "Buff",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "skill_stat_descriptions",
			baseFlags = {
			},
			stats = {
				"base_deal_no_damage",
				"quality_display_active_skill_base_area_of_effect_radius_is_gem",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
skills["VoidIllusionSpawnPlayer"] = {
	name = "Void Illusion",
	hidden = true,
	fromTree = true,
	skillTypes = { [SkillType.OngoingSkill] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Triggered] = true, [SkillType.Triggerable] = true, [SkillType.Cooldown] = true, },
	castTime = 1,
	qualityStats = {
		{ "active_skill_base_area_of_effect_radius", 0.2 },
	},
	levels = {
		[1] = { baseMultiplier = 1.85, storedUses = 1, levelRequirement = 0, cooldown = 5.9, },
		[2] = { baseMultiplier = 2.04, storedUses = 1, levelRequirement = 0, cooldown = 5.8, },
		[3] = { baseMultiplier = 2.24, storedUses = 1, levelRequirement = 0, cooldown = 5.7, },
		[4] = { baseMultiplier = 2.45, storedUses = 1, levelRequirement = 0, cooldown = 5.6, },
		[5] = { baseMultiplier = 2.65, storedUses = 1, levelRequirement = 0, cooldown = 5.5, },
		[6] = { baseMultiplier = 2.86, storedUses = 1, levelRequirement = 0, cooldown = 5.4, },
		[7] = { baseMultiplier = 3.07, storedUses = 1, levelRequirement = 0, cooldown = 5.3, },
		[8] = { baseMultiplier = 3.27, storedUses = 1, levelRequirement = 0, cooldown = 5.2, },
		[9] = { baseMultiplier = 3.46, storedUses = 1, levelRequirement = 0, cooldown = 5.1, },
		[10] = { baseMultiplier = 3.66, storedUses = 1, levelRequirement = 0, cooldown = 5, },
		[11] = { baseMultiplier = 3.87, storedUses = 1, levelRequirement = 0, cooldown = 4.9, },
		[12] = { baseMultiplier = 4.1, storedUses = 1, levelRequirement = 0, cooldown = 4.8, },
		[13] = { baseMultiplier = 4.34, storedUses = 1, levelRequirement = 0, cooldown = 4.7, },
		[14] = { baseMultiplier = 4.61, storedUses = 1, levelRequirement = 0, cooldown = 4.6, },
		[15] = { baseMultiplier = 4.9, storedUses = 1, levelRequirement = 0, cooldown = 4.5, },
		[16] = { baseMultiplier = 5.2, storedUses = 1, levelRequirement = 0, cooldown = 4.4, },
		[17] = { baseMultiplier = 5.54, storedUses = 1, levelRequirement = 0, cooldown = 4.3, },
		[18] = { baseMultiplier = 5.9, storedUses = 1, levelRequirement = 0, cooldown = 4.2, },
		[19] = { baseMultiplier = 6.28, storedUses = 1, levelRequirement = 0, cooldown = 4.1, },
		[20] = { baseMultiplier = 6.7, storedUses = 1, levelRequirement = 0, cooldown = 4, },
		[21] = { baseMultiplier = 7.15, storedUses = 1, levelRequirement = 0, cooldown = 3.9, },
		[22] = { baseMultiplier = 7.62, storedUses = 1, levelRequirement = 0, cooldown = 3.8, },
		[23] = { baseMultiplier = 8.13, storedUses = 1, levelRequirement = 0, cooldown = 3.7, },
		[24] = { baseMultiplier = 8.67, storedUses = 1, levelRequirement = 0, cooldown = 3.6, },
		[25] = { baseMultiplier = 9.25, storedUses = 1, levelRequirement = 0, cooldown = 3.5, },
		[26] = { baseMultiplier = 9.87, storedUses = 1, levelRequirement = 0, cooldown = 3.4, },
		[27] = { baseMultiplier = 10.52, storedUses = 1, levelRequirement = 0, cooldown = 3.3, },
		[28] = { baseMultiplier = 11.23, storedUses = 1, levelRequirement = 0, cooldown = 3.2, },
		[29] = { baseMultiplier = 11.97, storedUses = 1, levelRequirement = 0, cooldown = 3.1, },
		[30] = { baseMultiplier = 12.77, storedUses = 1, levelRequirement = 0, cooldown = 3, },
		[31] = { baseMultiplier = 13.62, storedUses = 1, levelRequirement = 0, cooldown = 2.95, },
		[32] = { baseMultiplier = 14.53, storedUses = 1, levelRequirement = 0, cooldown = 2.9, },
		[33] = { baseMultiplier = 15.5, storedUses = 1, levelRequirement = 0, cooldown = 2.85, },
		[34] = { baseMultiplier = 16.53, storedUses = 1, levelRequirement = 0, cooldown = 2.8, },
		[35] = { baseMultiplier = 17.63, storedUses = 1, levelRequirement = 0, cooldown = 2.75, },
		[36] = { baseMultiplier = 18.8, storedUses = 1, levelRequirement = 0, cooldown = 2.7, },
		[37] = { baseMultiplier = 20.06, storedUses = 1, levelRequirement = 0, cooldown = 2.65, },
		[38] = { baseMultiplier = 21.39, storedUses = 1, levelRequirement = 0, cooldown = 2.6, },
		[39] = { baseMultiplier = 22.82, storedUses = 1, levelRequirement = 0, cooldown = 2.55, },
		[40] = { baseMultiplier = 24.34, storedUses = 1, levelRequirement = 0, cooldown = 2.5, },
	},
	statSets = {
		[1] = {
			label = "Void Illusion",
			incrementalEffectiveness = 0.054999999701977,
			statDescriptionScope = "create_void_illusion",
			baseFlags = {
				attack = true,
			},
			constantStats = {
				{ "base_skill_effect_duration", 2000 },
				{ "active_skill_base_area_of_effect_radius", 30 },
			},
			stats = {
				"hide_minion_frame",
				"triggered_by_void_illusion",
				"quality_display_active_skill_base_area_of_effect_radius_is_gem",
			},
			levels = {
				[1] = { actorLevel = 1, },
				[2] = { actorLevel = 3.4519999027252, },
				[3] = { actorLevel = 6.7670001983643, },
				[4] = { actorLevel = 10.307999610901, },
				[5] = { actorLevel = 14.074999809265, },
				[6] = { actorLevel = 18.068000793457, },
				[7] = { actorLevel = 22.287000656128, },
				[8] = { actorLevel = 26.732000350952, },
				[9] = { actorLevel = 31.40299987793, },
				[10] = { actorLevel = 36.299999237061, },
				[11] = { actorLevel = 41.423000335693, },
				[12] = { actorLevel = 46.771999359131, },
				[13] = { actorLevel = 52.34700012207, },
				[14] = { actorLevel = 58.147998809814, },
				[15] = { actorLevel = 64.175003051758, },
				[16] = { actorLevel = 70.428001403809, },
				[17] = { actorLevel = 76.906997680664, },
				[18] = { actorLevel = 83.611999511719, },
				[19] = { actorLevel = 90.542999267578, },
				[20] = { actorLevel = 97.699996948242, },
				[21] = { actorLevel = 105.08300018311, },
				[22] = { actorLevel = 112.69200134277, },
				[23] = { actorLevel = 120.52700042725, },
				[24] = { actorLevel = 128.58799743652, },
				[25] = { actorLevel = 136.875, },
				[26] = { actorLevel = 145.38800048828, },
				[27] = { actorLevel = 154.12699890137, },
				[28] = { actorLevel = 163.09199523926, },
				[29] = { actorLevel = 172.28300476074, },
				[30] = { actorLevel = 181.69999694824, },
				[31] = { actorLevel = 191.34300231934, },
				[32] = { actorLevel = 201.21200561523, },
				[33] = { actorLevel = 211.30700683594, },
				[34] = { actorLevel = 221.62800598145, },
				[35] = { actorLevel = 232.17500305176, },
				[36] = { actorLevel = 242.94799804688, },
				[37] = { actorLevel = 253.94700622559, },
				[38] = { actorLevel = 265.17199707031, },
				[39] = { actorLevel = 276.62298583984, },
				[40] = { actorLevel = 288.29998779297, },
			},
		},
	}
}
			skills["EnemyExplode"] = {
				name = "On Kill Monster Explosion",
				hidden = true,
				color = 4,
				skillTypes = { [SkillType.Damage] = true, [SkillType.Area] = true, },
				castTime = 0,
				levels = {
					[1] = { damageEffectiveness = 0, baseMultiplier = 1, levelRequirement = 1, }
				},
				preDamageFunc = function(activeSkill, output)
					output.ExplodeChance = 0
					local statSet = activeSkill.activeEffect.statSet or activeSkill.activeEffect.statSetCalcs
					if statSet.index ~= 3 then
						local allExplodeMods = activeSkill.skillModList:Tabulate("LIST", activeSkill.skillCfg, "ExplodeMod")
						for _, explodeMod in ipairs(allExplodeMods) do
							local activeEffectSource = activeSkill.activeEffect.srcInstance.explodeSource.modSource or "Tree:"..activeSkill.activeEffect.srcInstance.explodeSource.id
							if explodeMod.mod.source == activeEffectSource then
								local explodeMod = explodeMod.value
								if explodeMod.type == "RandomElement" then
									activeSkill.skillData["FireEffectiveExplodePercentage"] = explodeMod.amount / 3
									activeSkill.skillData["ColdEffectiveExplodePercentage"] = explodeMod.amount / 3
									activeSkill.skillData["LightningEffectiveExplodePercentage"] = explodeMod.amount / 3
								else
									activeSkill.skillData[explodeMod.type.."EffectiveExplodePercentage"] = explodeMod.amount
								end
								output.ExplodeChance = statSet.index == 2 and 1 or explodeMod.chance
							end
						end
					else
						local typeAmountChances = { }
						local explodeModList = activeSkill.skillModList:List(activeSkill.skillCfg, "ExplodeMod")
						for _, explodeMod in ipairs(explodeModList) do
							local amountChance = typeAmountChances[explodeMod.type] or { }
							amountChance[explodeMod.amount] = (amountChance[explodeMod.amount] or 0) + explodeMod.chance
							typeAmountChances[explodeMod.type] = amountChance
						end
						for type, amountChance in pairs(typeAmountChances) do
							local physExplodeChance = 0
							for amount, chance in pairs(amountChance) do
								local amountXChance = amount * chance
								if type == "RandomElement" then
									activeSkill.skillData["FireEffectiveExplodePercentage"] = (activeSkill.skillData["FireEffectiveExplodePercentage"] or 0) + amountXChance / 3
									activeSkill.skillData["ColdEffectiveExplodePercentage"] = (activeSkill.skillData["ColdEffectiveExplodePercentage"] or 0) + amountXChance / 3
									activeSkill.skillData["LightningEffectiveExplodePercentage"] = (activeSkill.skillData["LightningEffectiveExplodePercentage"] or 0) + amountXChance / 3
								else
									activeSkill.skillData[type.."EffectiveExplodePercentage"] = (activeSkill.skillData[type.."EffectiveExplodePercentage"] or 0) + amountXChance
								end
								if type == "Physical" then
									physExplodeChance = 1 - ((1 - physExplodeChance) * (1 - chance))
								end
								output.ExplodeChance = 1 - ((1 - output.ExplodeChance) * (1 - chance))
							end
							if type == "Physical" and physExplodeChance ~= 0 then
								activeSkill.skillModList:NewMod("CalcArmourAsThoughDealing", "MORE", 100 / math.min(physExplodeChance, 1) - 100)
							end
						end
					end
					output.ExplodeChance = math.min(output.ExplodeChance * 100, 100)
				end,
				statSets = {
					[1] = {
						label = "This Source Only",
						baseFlags = {
							area = true,
							monsterExplode = true,
						},
						baseMods = {
							skill("radius", 22),
							skill("showAverage", true),
							skill("corpseExplosionLifeMultiplier", 0),
							skill("explodeCorpse", true),
							skill("hitChanceIsExplodeChance", true),
						},
						stats = {
							"is_area_damage",
							"base_skill_show_average_damage_instead_of_dps",
							"display_skill_deals_secondary_damage",
							"damage_cannot_be_reflected",
							"skill_can_add_multiple_charges_per_action",
						},
						levels = {
							[1] = { },
						},
					},
					[2] = {
						label = "This Source Only, Ignoring Chance",
						baseFlags = {
							area = true,
							monsterExplode = true,
						},
						baseMods = {
							skill("radius", 22),
							skill("showAverage", true),
							skill("corpseExplosionLifeMultiplier", 0),
							skill("explodeCorpse", true),
						},
						stats = {
							"is_area_damage",
							"base_skill_show_average_damage_instead_of_dps",
							"display_skill_deals_secondary_damage",
							"damage_cannot_be_reflected",
							"skill_can_add_multiple_charges_per_action",
						},
						levels = {
							[1] = { },
						},
					},
					[3] = {
						label = "Average of All Sources",
						baseFlags = {
							area = true,
							monsterExplode = true,
						},
						baseMods = {
							skill("radius", 22),
							skill("showAverage", true),
							skill("corpseExplosionLifeMultiplier", 0),
							skill("explodeCorpse", true),
						},
						stats = {
							"is_area_damage",
							"base_skill_show_average_damage_instead_of_dps",
							"display_skill_deals_secondary_damage",
							"damage_cannot_be_reflected",
							"skill_can_add_multiple_charges_per_action",
						},
						levels = {
							[1] = { },
						},
					},
				}
			}
