**Description**
Through the portals rupturing reality in the Cataclysm, you were sucked into a world yet untouched by humans. Here you encounter massive animals that seem almost out of place, but eerily familiar at the same time. You know this megafauna went extinct just around the time your ancestors first set foot on this land some 10.000 years ago. Distant memories of these Pleistocenic animals rest deep in your conscious. 

Adds 17 lorefriendly megafauna species especially suited for innawood playthroughs. Features all-time favorites like Woolly Mammoths, Mastodons and Sabre-toothed Cats. Hunt them ruthlessly like our ancestors did, or befriend and try to domesticate them. But beware you don't get eaten or trampled before.

At the same time, species introduced in modern times are removed! E.g.: wild boars, cows, cats, dogs, ... 


**Goals and Scope**
The goal of the mod is to add extinct megafauna of the late Pleistocene and early Holocene (about 30.000-8.000 BCE), that the first humans setting foot on the area CDDA mostly uses as a real world counterpart, New England, have encountered.

The mod aims to provide a more realistic fauna for wilderness/stone age playthroughs, especially together with the innawood mod, or as a more mammal-focused addition together with the DinoMod (seems to work together, but might need tweaking). Part of that goal is that some species encountered in New England today which are quite new additions to the biosphere (like the wild boar) will be replaced by species more fitting to the time frame. These animals can fill niches for human use, not only regarding meat, but also wool and milk, that are currently only covered by modern day farm animals.

Geographically, species from modern day New England are the focus, again for a more coherent, realistic feel. If evidence is found not too far away in not too different climates (e.g., Great Lakes) that's alright too. If remains of a species have only been found in, e.g., New Mexico and Texas, they probably won't feature here.

**NOTE**
This mod is still work-in-progress, but a basic set of 21 new Pleistocene-era animals is available, should spawn in new games and be generally useful especially for innawood players.

**full list of new animals**
- woolly mammoths
- mastodons
- sabre toothed cat
- dire wolf
- american cave lion
- giant short faced bear
- flat headed peccary (a distant cousin of wild boars)
- long nosed peccary (a distant cousin of wild boars)
- stag moose (aka Giant Moose)
- giant beaver
- large claw sloth
- shrub-ox
- wood-ox
- ancient bison 
- scott's horse
- camelops (giant American camel species)
- giant horse
- glyptotherium
- great auk
- Mayfield's goat
- American zebra

**domesticated replacements**
*Usage* (modern analogue): MEGAFAUNA replacement

*meat/leather production* (pigs) = flat headed peccaries (slightly smaller, but otherwise sameish use).

*wool* (sheep) = mammoths, if you are brave enough. otherwise bison, camelops, oxen, giant sloth, mayfields goat, and muskox [WIP].

*milk* (cow, goat) = bison, oxen, horse, Mayfield's goat and camelops are milkable, but with varying efficiency.

*transport* (horse, cow) = long nose peccary, scotts horse, giant horse, mammoth/Mastodon, bison/ox, American zebra, camelops are rideable.

*eggs* (chicken, ducks, geese) = Auks; ducks and geese are still in.

*pet* (dogs, cats) = bobcats, dire wolves and sabre cats are tamable pets, a few other tameable creatures can be petted as well.


**Development Notes/ToDo**

**ToDo**
*potential candidates for addition with dubious range, or more research needed, or just more time*
- [done]Soergelia mayfeldis, goatlike; https://en.wikipedia.org/wiki/Soergelia;
- [done]Great Auk (Pinguinus impennis), much later extinction but everything else fits, so indeed: why not?
- [done]Glyptotherium, possibly (https://en.wikipedia.org/wiki/Glyptotherium)
- Horses:
    - Equus Lambei (https://en.wikipedia.org/wiki/Equus_lambei)
    - [done]Hagerman Horse (American Zebra) https://en.wikipedia.org/wiki/Hagerman_horse 
    - [done]Giant Horse (equus giganteus) https://en.wikipedia.org/wiki/Equus_giganteus 
    - Haringtonhippus https://de.wikipedia.org/wiki/Haringtonhippus 
- Homotherium (scimitar-toothed cat) (https://en.wikipedia.org/wiki/Homotherium)
- American Cheetah (https://en.wikipedia.org/wiki/American_cheetah)
- Tapir veroensis https://en.wikipedia.org/wiki/Tapirus_veroensis 
- Harbor Seal https://en.wikipedia.org/wiki/Harbor_seal (mainline?)
- arctic fox https://en.wikipedia.org/wiki/Arctic_fox 
- more ground sloth
    - https://en.wikipedia.org/wiki/Nothrotheriops (smaller, 1/3 approx.; social life unclear, but lets say these are herds)
    - https://en.wikipedia.org/wiki/Paramylodon (very big as well, solitary)


Possibly also some birds (Titanis/Paracrax/Aiolornis, Auk), if evidence exists and they are cool.

Add new monsters to monster groups/implement spawn:
- tweak spawn rates [done]
- consider if spawns should occur in specific types of region (meaning, custom monster groups apart from "forest") [done]
- extra: make "family" monstergroups that spawn adults and juveniles together in the appropriate season


*tests and tweaks*
- revamp descriptions (goal is immersive description, not wiki info or strategies how to deal with them) [done]
- introduce factions[done]
    -introduce more finegrained, species based factions
- tweak speed and sizes: 
    -> f.e., panthera atrox apparently bigger than smilodon?
    -> giant short faced bear might have been quite fast due to characteristically long limbs
    -> dire wolf might have been slower than modern wolves due to shorter limbs(theorized that scavenger more than hunter)
- tweak reproduction data (gestation times, grow-up-times etc)
- add weakpoints
- flesh out behaviour (like scent_tracked)

*Additional/Future*
Think of cool stuff to do with animal products, like sabrecat teeth or mammoth tusks (i.e., adjust/make new harvest groups)
In any case, think about if recipes need to be adjusted for anything.
[done]Think about how some of these could fill gaps for farming, like peccaries as substitute for pig/boars, or anything woolly for... wool.
[done]Maybe some flavourful special attacks

Think of specials that could fit:
    - mammoth graveyard
    - special sabrecat and cave lion caves
    - watering holes with lots of animals-
    - giant sloth burrows
    - rocky islands for auks
    - tar pits

Mutations/Mutagen line fitting the setting:
    - Mammoth (look at mastodon in Aftershock?)
    - Sabre Cat
    - Glyptodon/Armadillo
    - Ground sloth

*Items*
- weapons made from mammoth tusk
- armor/cover made from glyptotherium shell
- unique equipment for tameables (Sloth saddles, special saddle bags, armor)


*Unlikely, but not unthinkable future additions*
More widespread scope both timeframe and geographically (e.g., from coast to coast + 0.2ma range "when modern humans existed")
Late Pleistocene Flora
Touch mapgen to create more realistic Pleistocene biomes

*Issues*
- Scotts horse too flimsy to ride (either increase stats a little, or circumvent by introducing giant horses) [done]
- bobcats not tamable/no kittens [solved]
- 