#### BOA HANCOCK ####

## Customized girl events: These events are designed to work together with a custom girl init file.
## It doesn't really matter what this file is called or where within the 'game' folder or subfolders it is dropped.
## However, for reducing cluttering, it is recommended you name this file '_events.rpy' and drop it in the relevant girl folder.
## Important: Please choose unique label names to avoid labelling conflicts with the main game files and other girl packs (i.e. 'label boa_hancock_start', not 'label start').
## You could also use local labels (from newer Ren'py versions).

# Image declaration - You may use this syntax to declare an image using the relative path to the girl pack (not all users with install girlpacks in the 'Girls/' folder)
image bg boa_const = ProportionalScale(get_current_folder() + "profile dancer constitution (0)_126.webp", config.screen_width, config.screen_height)

init -2 python:

    def my_dumb_function(girl):
        pass

label boa_custom_dialogue(girl, topic): # Use this example to understand the correct use of custom_dialogue

    ## This label handles exceptions to normal dialogue for specific topics of your choosing

    # Chance of a special event happening when training constitution
    if topic == "slave train constitution" and dice(6) > 5:
        show bg boa_const at top onlayer screens with dissolve # Using the screens layer is necessary to display image on top of the interact UI

        play sound s_clash
        with vpunch

        girl.char "Ha! Defeat will not be tolerated!"

        $ girl.change_mood(1)

        hide bg boa_const onlayer screens with dissolve

    # Uses normal dialogue otherwise
    else:
        $ girl.say(topic, custom_label=False) # custom_label MUST be disabled or the label will loop indefinitely

    return

label boa_hancock_city(girl):

    if not girl.MC_interact: # This plays if the MC and the girl haven't met

        # Hides the player notebook for the first interaction
        $ choice_menu_girl_interact = False

        $ loc = selected_location.name.lower() # This recovers the location name in lowercase

        "Strolling past a large avenue near the [loc], you see a strikingly beautiful woman making her way through the crowd. There's something imperial about her."

        "Her revealing dress does little to hide her ample assets that bounce with every step. Men and women alike stop in their tracks to admire her perfect figure, and angel-like face."

        "Whispers erupt in her wake, and a group of lecherous men standing in her path start making catcalls and lewd jokes as she approaches. Putting her hands on her curved hips, she stares them down with one steely-eyed look, and they quickly move back."

        girl.char "Hmpf! Who dared put that along my path? Out of my way, maggots!"

        "Shoving the idlers aside, she keeps going, heading straight toward you."

        menu:

            "Offer to help":
                you "Hi, let me introduce myself, I am [MC.name]... Do you require an escort, my Lady? The streets aren't safe these days..."

                "She gives you a furious look, spitting her next words."

                girl.char "Uh? Did you hear me request the help of a lowly poodle? Get the fuck out of my way!"

                "She passes you by ragingly, shoving you to the side."

                girl.char "Hey, all you losers out there! Next time, remember not to bother [girl.fullname], the pirate queen, or DIE!"

            "Hassle her":
                "Paying no heed to her furious stare, you whistle loudly in her direction."

                if MC.god:
                    $ text1 = "By " + MC.god + ", "
                else:
                    $ text1 = ""

                you "What a hot babe! [text1]I'm going to enjoy playing with those enormous boobs..."

                "The woman becomes white with fury."

                play sound s_surprise

                girl.char "H... How DARE you!!! I'm so mad, I... I'm going to scream!" with vpunch

                you "Oh, don't you worry, doll... You will..."

                "Sticking her face an inch from your face, the woman stares you right in the eye with a murderous stance."

                "Instead of backing off, you grin. She is puzzled by your attitude."

                girl.char "I don't believe this!!! You really have some guts, to talk to me like that... Don't you know who I am? I'm [girl.fullname], the pirate queen!"

                you "Well, you do have queen-sized tits... I'm [MC.name]."

                girl.char "Don't test my patience! Hmpf... I'll let it slide this one time. But I don't know what I'll do if I run into you again!"

                "She storms off."

                you "Hehe... I think she's into me."

                $ girl.change_love(1)

            "Ignore her":
                "Making no effort to move out of her way, you pay absolutely no attention to her."

                "Indignant, she stops right before you, giving you a furious look."

                girl.char "You! Didn't you hear me??? I said, OUT OF MY WAY!"

                you "Uh? I'm sorry, lady, you were saying something? I didn't notice you."

                play sound s_surprise

                girl.char "I SAID, uh... What? What do you mean, you DIDN'T notice me?"

                you "Why, I just didn't. Lasses come and go in this town all the time, am I supposed to go and gawk at every last one of them?"

                girl.char "Last one of... LAST ONE OF THEM!!! I'm [girl.fullname], pirate queen and MOST BEAUTIFUL WOMAN in the world!!! How can you NOT notice me???" with vpunch

                you "And I'm [MC.name]. Well, now that I take a better look at you, I suppose you're not too shabby..."

                girl.char "NOT TOO SHABBY!!!" with vpunch

                you "Listen, dear, I'd love to stay, chat and all, but I'm a busy man. If you'll excuse me..."

                girl.char "You! [MC.name]! Hey, wait..."

                $ girl.change_love(2)

        $ girl.meet_MC() # Tracks that MC and girl met for the first time
        $ MC.interactions -= 1 # Causes the MC to spend one AP

    else: # Defaults to normal city dialog by using 'call free_girl_talk(girl)' if girl and MC have already met (Note: Do NOT use the 'from ...' clause)
        call free_girl_talk(girl)

    return

label boa_hancock_interact(girl):

    # The player is limited to one visit per day

    if girl.flags["boa_has_visited"]:
        "You have already visited [girl.fullname]'s room today."
        return

    $ MC.interactions -= 1
    $ girl.flags["boa_has_visited"] = True

    "You decide to pay a visit to [girl.fullname]'s bedroom."

    play sound s_knocks

    show expression brothel.bedroom_type.pic_path
    with dissolve

    ## Visits go through three stages. Each stage after the first one has a 33% chance of happening

    # First stage

    if not girl.flags["boa_visit_stage"]:
        $ girl.flags["boa_visit_stage"] = 1

        play sound s_door

        "[girl.fullname] is doing her make up, sitting on some kind of strange white and pink exotic chair."

        show screen show_event(girl.profile, x=1024, y=768, bg=None)

        you "Hi, [girl.name]."

        girl.char "[MC.name]? What are you doing here?"

        you "Hmm, I was just checking on you, wondering if everything's all right with your room..."

        if brothel.get_mood_modifier(girl.rank) < 0:
            girl.char "Hmpf! This place is a dump! Completely unfit for a queen!!!"

            menu:
                girl.char "Hmpf! This place is a dump! Completely unfit for a queen!!!"
                "Apologize":
                    you "I'm sorry, I am going to improve the facilities as soon as I can..."

                    girl.char "You do that!"

                    $ girl.change_fear(-1)

                "Scold her":
                    you "Right now, you're just the queen of bitching. Get ready for work, and stop complaining."

                    girl.char "How... How dare you..."

                    $ girl.change_love(-1)

    # Second stage

    elif girl.flags["boa_visit_stage"] == 1 and dice(6) >= 5:
        $ girl.flags["boa_visit_stage"] = 2

        "As you approach [girl.name]'s door, you hear some muffled voices coming from the inside."

        you "Is there someone in there?"

        play sound s_door

        show screen show_event(girl.profile, x=1024, y=768, bg=None)

        girl.char "Uh?"

        play sound s_surprise

        girl.char "Wh... Who's there?"

        "[girl.name] is surprised to see you. She rushed back to her seat by the make-up table, sitting uneasily in her empty room."

        you "Weren't you talking just now? I thought I heard some conversation..."

        girl.char "Me? Talking? No, not at all, ha, ha, haha..."

        girl.char "Don't you see there's no one here?"

        "You glance around. The room is empty, except for [girl.name], squirming on her strange bouncy chair."

        you "I guess so... See you later, [girl.name]."

        girl.char "S... Sure."

        "As you turn around to leave, you hear some strange hissing sound coming from behind you. Flipping around, you see nothing. But somehow, it feels like [girl.name]'s seat changed shape somehow."

        you "I should lay down the bottle a bit tonight, I think."

    # Third stage

    elif girl.flags["boa_visit_stage"] == 2 and dice(6) >= 5:

        "Leaning against [girl.name]'s door, you hear some hissing sounds, followed by an animated conversation."

        "Bursting in, you hope to surprise [girl.name] with her mysterious confidant."

        play sound s_door

        you "Haha!!!" with vpunch

        # Activating 'naked_filter' tells the game to choose either a naked or non-naked picture depending on the girl's naked status

        show screen show_event(girl.get_pic("profile", naked_filter=True), x=1024, y=768, bg=None)

        with dissolve

        play sound s_surprise

        girl.char "Oh!!!"

        you "What the..."

        "You are shocked to see [girl.fullname], seemingly engaged in a conversation with a 30-foot snake, complete with a horned skull on its head and a hank of blue hair."

        play sound s_sheath

        you "[girl.name]!!! Behind me, quick!" with vpunch

        "The snakes hisses and you reach for your weapon, but [girl.name] gets between you and the beast, spreading her arms wide."

        play sound s_surprise

        girl.char "No, [MC.name]!!! Don't hurt Salome!!!" with vpunch

        you "Wh... What? Why? What is that thing!!!"

        girl.char "Please, Master, lay down your weapon. I can explain. Salome is my pet snake."

        you "A... Pet snake??? This thing is gigantic!"

        girl.char "Salome is one of the snake weapons of my people. We have a sacred bond. It is here to defend me."

        you "B-But... You can't keep that thing in the brothel... If a customer sees this..."

        girl.char "Oh, please, Master! We have been together forever. Please allow me to keep Salome."

        menu:
            girl.char "Oh, please, Master! We have been together forever. Please allow me to keep Salome."

            "Fine":

                $ MC.good += 1
                $ girl.change_love(5)
                $ girl.change_fear(-15)
                $ girl.flags["boa_visit_stage"] = 3

                you "Ok, you can keep it. But promise me it won't make a mess or annoy any customer."

                girl.char "It won't, it won't!"

                you "Fine."

                girl.char "I mean, the respectful ones, anyway..."

                $ girl.acquire_perk(Perk("Snake-Weapon", "story", effects=[Effect("change", "defense", 3)], base_description = "She is protected by a guardian snake."), forced=True)

                hide screen show_event
                scene black with fade

                "[girl.fullname] has acquired a snake weapon. Her defense has increased."

            "No way":

                $ MC.evil += 1
                $ girl.change_love(-15)
                $ girl.change_fear(5)
                $ girl.flags["boa_visit_stage"] = 4

                you "Get rid of this snake, right now. If it's still here tomorrow, I'll call a monster hunter."

                girl.char "Oh nooooo... Please, no..."

                "[girl.fullname] starts sobbing helplessly. It isn't like her."

                you "Say your goodbyes, and drop this thing in the sewers or something."

                hide screen show_event
                scene black with fade

                "[girl.fullname] has lost her snake weapon."

    # Fourth stage / Kept the snake

    elif girl.flags["boa_visit_stage"] == 3 and dice(6) >= 5:

        "Reaching for [girl.name]'s room, you hear some muffled sounds. Almost like... Moans?"

        play sound s_door

        you "What is going on here..."

        if girl.get_stat("libido") < 100:

            play sound s_crash

            "The door slams right back in your face."

            girl.char "No!!! Don't come in!!! I'm... I'm busy!!!"

            you "Stop it, [girl.name]! I am your Master, you must let me in."

            girl.char "..."

            girl.char "Just a moment."

            play sound s_door

            show screen show_event(girl.profile, x=1024, y=768, bg=None)

            "[girl.fullname] opens the door to her room and lets you in begrudgingly."

            "Her skin is glistening with sweat, and her bedsheets undone."

            "Slithering under the sheets, you see the long, thick shape of Salome, her pet snake."

            you "What the hell is going on here? Why are you so out of breath? Why are your clothes ruffled?"

            girl.char "Ah, hmm, me and Salome were just... Training!!! Training... for fighting!"

            you "You were, uh..."

            girl.char "Y-Yes, haha..."

            you "I see. Well, there's no fighting right now, but service is about to start. Clean up this mess, and get ready."

            girl.char "S-Sure..."

        else:

            show screen show_event(girl.get_pic("beast"), x=1024, y=768, bg=None)

            with dissolve

            "As you open the door, you cannot believe your eyes."

            play sound s_moans

            "[girl.fullname] is being fucked by her own pet snake. Judging by her wild moans, she is enjoying it too."

            you "[girl.name]?"

            girl.char "Aaah, oohh... Master, you... You saw me..."

            play sound2 s_scream

            "The snake wraps around its owner, rubbing every sensitive part as it contracts itself."

            girl.char "Aaaaah... S-So... good..."

            "Being watched seems to be too much for her. Letting herself go, [girl.fullname] climaxes loudly."

            play sound s_orgasm_fast

            girl.char "AAAAAAAAAHHH" with flash

            you "Wow..."

        $ girl.change_stat("sensitivity", 1)
        $ girl.change_stat("libido", 1)

    # Fourth stage / Lost the snake

    elif girl.flags["boa_visit_stage"] == 4 and dice(6) >= 5:

        play sound s_door

        show screen show_event(girl.get_pic("rest", naked_filter=True), x=1024, y=768, bg=None)

        with dissolve

        "You find [girl.name] alone in her room, crying over her lost pet."

        girl.char "I... I hate you... *sob*"

        $ girl.change_love(-1)

    # In case the random check fails

    else:
        "You find no one in [girl.fullname]'s room. It seems like she is out on an errand."

    return

label boa_hancock_night_check(girl):

#    "Running night check for [girl.fullname]."

    # Resets visited flag

    $ girl.flags["boa_has_visited"] = False

#    "Boa Hancock's flag has been reset."

    return
