﻿namespace Veldrid
{
    /// <summary>
    /// The data type of a shader constant.
    /// </summary>
    public enum ShaderConstantType
    {
        /// <summary>
        /// A boolean.
        /// </summary>
        Bool,
        /// <summary>
        /// A 16-bit unsigned integer.
        /// </summary>
        UInt16,
        /// <summary>
        /// A 16-bit signed integer.
        /// </summary>
        Int16,
        /// <summary>
        /// A 32-bit unsigned integer.
        /// </summary>
        UInt32,
        /// <summary>
        /// A 32-bit signed integer.
        /// </summary>
        Int32,
        /// <summary>
        /// A 64-bit unsigned integer.
        /// </summary>
        UInt64,
        /// <summary>
        /// A 64-bit signed integer.
        /// </summary>
        Int64,
        /// <summary>
        /// A 32-bit floating-point value.
        /// </summary>
        Float,
        /// <summary>
        /// A 64-bit floating-point value.
        /// </summary>
        Double,
    }
}
