// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
// ------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Runtime.CompilerServices;
using System.Runtime.InteropServices;
using HexaGen.Runtime;
using System.Numerics;

namespace Hexa.NET.ImGui
{
	/// <summary>
	/// Helper: Manually clip large list of items.<br/>
	/// If you have lots evenly spaced items and you have random access to the list, you can perform coarse<br/>
	/// clipping based on visibility to only submit items that are in view.<br/>
	/// The clipper calculates the range of visible items and advance the cursor to compensate for the non-visible items we have skipped.<br/>
	/// (Dear ImGui already clip items based on their bounds but: it needs to first layout the item to do so, and generally<br/>
	/// fetchingsubmitting your own data incurs additional cost. Coarse clipping using ImGuiListClipper allows you to easily<br/>
	/// scale using lists with tens of thousands of items without a problem)<br/>
	/// Usage:<br/>
	/// ImGuiListClipper clipper;<br/>
	/// clipper.Begin(1000);          We have 1000 elements, evenly spaced.<br/>
	/// while (clipper.Step())<br/>
	/// for (int i = clipper.DisplayStart; i &lt; clipper.DisplayEnd; i++)<br/>
	/// ImGui::Text("line number %d", i);<br/>
	/// Generally what happens is:<br/>
	/// - Clipper lets you process the first element (DisplayStart = 0, DisplayEnd = 1) regardless of it being visible or not.<br/>
	/// - User code submit that one element.<br/>
	/// - Clipper can measure the height of the first element<br/>
	/// - Clipper calculate the actual range of elements to display based on the current clipping rectangle, position the cursor before the first visible element.<br/>
	/// - User code submit visible elements.<br/>
	/// - The clipper also handles various subtleties related to keyboardgamepad navigation, wrapping etc.<br/>
	/// </summary>
	[StructLayout(LayoutKind.Sequential)]
	public partial struct ImGuiListClipper
	{
		/// <summary>
		/// To be documented.
		/// </summary>
		public unsafe ImGuiContext* Ctx;

		/// <summary>
		/// To be documented.
		/// </summary>
		public int DisplayStart;

		/// <summary>
		/// To be documented.
		/// </summary>
		public int DisplayEnd;

		/// <summary>
		/// To be documented.
		/// </summary>
		public int ItemsCount;

		/// <summary>
		/// To be documented.
		/// </summary>
		public float ItemsHeight;

		/// <summary>
		/// To be documented.
		/// </summary>
		public float StartPosY;

		/// <summary>
		/// To be documented.
		/// </summary>
		public double StartSeekOffsetY;

		/// <summary>
		/// To be documented.
		/// </summary>
		public unsafe void* TempData;


		/// <summary>
		/// To be documented.
		/// </summary>
		public unsafe ImGuiListClipper(ImGuiContextPtr ctx = default, int displayStart = default, int displayEnd = default, int itemsCount = default, float itemsHeight = default, float startPosY = default, double startSeekOffsetY = default, void* tempData = default)
		{
			Ctx = ctx;
			DisplayStart = displayStart;
			DisplayEnd = displayEnd;
			ItemsCount = itemsCount;
			ItemsHeight = itemsHeight;
			StartPosY = startPosY;
			StartSeekOffsetY = startSeekOffsetY;
			TempData = tempData;
		}


		/// <summary>
		/// To be documented.
		/// </summary>
		public unsafe void Begin(int itemsCount, float itemsHeight)
		{
			fixed (ImGuiListClipper* @this = &this)
			{
				ImGui.BeginNative(@this, itemsCount, itemsHeight);
			}
		}

		/// <summary>
		/// To be documented.
		/// </summary>
		public unsafe void Begin(int itemsCount)
		{
			fixed (ImGuiListClipper* @this = &this)
			{
				ImGui.BeginNative(@this, itemsCount, (float)(-1.0f));
			}
		}

		/// <summary>
		/// To be documented.
		/// </summary>
		public unsafe void Destroy()
		{
			fixed (ImGuiListClipper* @this = &this)
			{
				ImGui.DestroyNative(@this);
			}
		}

		/// <summary>
		/// Automatically called on the last call of Step() that returns false.<br/>
		/// </summary>
		public unsafe void End()
		{
			fixed (ImGuiListClipper* @this = &this)
			{
				ImGui.EndNative(@this);
			}
		}

		/// <summary>
		/// To be documented.
		/// </summary>
		public unsafe void IncludeItemByIndex(int itemIndex)
		{
			fixed (ImGuiListClipper* @this = &this)
			{
				ImGui.IncludeItemByIndexNative(@this, itemIndex);
			}
		}

		/// <summary>
		/// item_end is exclusive e.g. use (42, 42+1) to make item 42 never clipped.<br/>
		/// </summary>
		public unsafe void IncludeItemsByIndex(int itemBegin, int itemEnd)
		{
			fixed (ImGuiListClipper* @this = &this)
			{
				ImGui.IncludeItemsByIndexNative(@this, itemBegin, itemEnd);
			}
		}

		/// <summary>
		/// To be documented.
		/// </summary>
		public unsafe void SeekCursorForItem(int itemIndex)
		{
			fixed (ImGuiListClipper* @this = &this)
			{
				ImGui.SeekCursorForItemNative(@this, itemIndex);
			}
		}

		/// <summary>
		/// Call until it returns false. The DisplayStartDisplayEnd fields will be set and you can processdraw those items.<br/>
		/// </summary>
		public unsafe bool Step()
		{
			fixed (ImGuiListClipper* @this = &this)
			{
				byte ret = ImGui.StepNative(@this);
				return ret != 0;
			}
		}

	}

	/// <summary>
	/// To be documented.
	/// </summary>
	#if NET5_0_OR_GREATER
	[DebuggerDisplay("{DebuggerDisplay,nq}")]
	#endif
	public unsafe struct ImGuiListClipperPtr : IEquatable<ImGuiListClipperPtr>
	{
		public ImGuiListClipperPtr(ImGuiListClipper* handle) { Handle = handle; }

		public ImGuiListClipper* Handle;

		public bool IsNull => Handle == null;

		public static ImGuiListClipperPtr Null => new ImGuiListClipperPtr(null);

		public ImGuiListClipper this[int index] { get => Handle[index]; set => Handle[index] = value; }

		public static implicit operator ImGuiListClipperPtr(ImGuiListClipper* handle) => new ImGuiListClipperPtr(handle);

		public static implicit operator ImGuiListClipper*(ImGuiListClipperPtr handle) => handle.Handle;

		public static bool operator ==(ImGuiListClipperPtr left, ImGuiListClipperPtr right) => left.Handle == right.Handle;

		public static bool operator !=(ImGuiListClipperPtr left, ImGuiListClipperPtr right) => left.Handle != right.Handle;

		public static bool operator ==(ImGuiListClipperPtr left, ImGuiListClipper* right) => left.Handle == right;

		public static bool operator !=(ImGuiListClipperPtr left, ImGuiListClipper* right) => left.Handle != right;

		public bool Equals(ImGuiListClipperPtr other) => Handle == other.Handle;

		/// <inheritdoc/>
		public override bool Equals(object obj) => obj is ImGuiListClipperPtr handle && Equals(handle);

		/// <inheritdoc/>
		public override int GetHashCode() => ((nuint)Handle).GetHashCode();

		#if NET5_0_OR_GREATER
		private string DebuggerDisplay => string.Format("ImGuiListClipperPtr [0x{0}]", ((nuint)Handle).ToString("X"));
		#endif
		/// <summary>
		/// To be documented.
		/// </summary>
		public ref ImGuiContextPtr Ctx => ref Unsafe.AsRef<ImGuiContextPtr>(&Handle->Ctx);
		/// <summary>
		/// To be documented.
		/// </summary>
		public ref int DisplayStart => ref Unsafe.AsRef<int>(&Handle->DisplayStart);
		/// <summary>
		/// To be documented.
		/// </summary>
		public ref int DisplayEnd => ref Unsafe.AsRef<int>(&Handle->DisplayEnd);
		/// <summary>
		/// To be documented.
		/// </summary>
		public ref int ItemsCount => ref Unsafe.AsRef<int>(&Handle->ItemsCount);
		/// <summary>
		/// To be documented.
		/// </summary>
		public ref float ItemsHeight => ref Unsafe.AsRef<float>(&Handle->ItemsHeight);
		/// <summary>
		/// To be documented.
		/// </summary>
		public ref float StartPosY => ref Unsafe.AsRef<float>(&Handle->StartPosY);
		/// <summary>
		/// To be documented.
		/// </summary>
		public ref double StartSeekOffsetY => ref Unsafe.AsRef<double>(&Handle->StartSeekOffsetY);
		/// <summary>
		/// To be documented.
		/// </summary>
		public void* TempData { get => Handle->TempData; set => Handle->TempData = value; }
		/// <summary>
		/// To be documented.
		/// </summary>
		public unsafe void Begin(int itemsCount, float itemsHeight)
		{
			ImGui.BeginNative(Handle, itemsCount, itemsHeight);
		}

		/// <summary>
		/// To be documented.
		/// </summary>
		public unsafe void Begin(int itemsCount)
		{
			ImGui.BeginNative(Handle, itemsCount, (float)(-1.0f));
		}

		/// <summary>
		/// To be documented.
		/// </summary>
		public unsafe void Destroy()
		{
			ImGui.DestroyNative(Handle);
		}

		/// <summary>
		/// Automatically called on the last call of Step() that returns false.<br/>
		/// </summary>
		public unsafe void End()
		{
			ImGui.EndNative(Handle);
		}

		/// <summary>
		/// To be documented.
		/// </summary>
		public unsafe void IncludeItemByIndex(int itemIndex)
		{
			ImGui.IncludeItemByIndexNative(Handle, itemIndex);
		}

		/// <summary>
		/// item_end is exclusive e.g. use (42, 42+1) to make item 42 never clipped.<br/>
		/// </summary>
		public unsafe void IncludeItemsByIndex(int itemBegin, int itemEnd)
		{
			ImGui.IncludeItemsByIndexNative(Handle, itemBegin, itemEnd);
		}

		/// <summary>
		/// To be documented.
		/// </summary>
		public unsafe void SeekCursorForItem(int itemIndex)
		{
			ImGui.SeekCursorForItemNative(Handle, itemIndex);
		}

		/// <summary>
		/// Call until it returns false. The DisplayStartDisplayEnd fields will be set and you can processdraw those items.<br/>
		/// </summary>
		public unsafe bool Step()
		{
			byte ret = ImGui.StepNative(Handle);
			return ret != 0;
		}

	}

}
