using SoulsFormats;
using System.Collections.Generic;
using System.Numerics;

namespace HKX2
{
    public partial class hkpBreakableBodyController : hkReferencedObject
    {
        public override uint Signature { get => 2210474037; }
        
        public float m_breakingImpulse;
        
        public override void Read(PackFileDeserializer des, BinaryReaderEx br)
        {
            base.Read(des, br);
            m_breakingImpulse = br.ReadSingle();
            br.ReadUInt32();
        }
        
        public override void Write(PackFileSerializer s, BinaryWriterEx bw)
        {
            base.Write(s, bw);
            bw.WriteSingle(m_breakingImpulse);
            bw.WriteUInt32(0);
        }
    }
}
